/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.jruby;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.glassfish.jruby.ui.JRubyServerCustomizer;
import org.netbeans.modules.glassfish.spi.CustomizerCookie;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.ServerUtilities;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.ruby.platform.execution.DirectoryFileLocator;
import org.netbeans.modules.ruby.platform.execution.RubyLineConvertorFactory;
import org.netbeans.modules.ruby.railsprojects.server.spi.RubyInstance;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputListener;

public class JRubyServerModule
implements RubyInstance,
CustomizerCookie,
RecognizerCookie {
    public static final String USE_ROOT_CONTEXT_ATTR = "jruby.useRootContext";
    private Lookup lookup;
    private static final String PREFIX = "(?:\\s+|(?:[^:\\s\\d]{1,20}:\\s*))?";
    private static final String DRIVE = "(?:\\S{1}:)";
    private static final String FILE_CHAR = "[^\\s\\[\\]\\:\\\"]";
    private static final String FILE = "(?:[^\\s\\[\\]\\:\\\"]*)";
    private static final String LINE = "([1-9][0-9]*)";
    private static final String ROL = ".*\\s?";
    private static final String FILE_SEP = "[\\\\/]";
    private static final String LINE_SEP = "\\:";
    private static final Pattern PATH_RECOGNIZER = Pattern.compile("(?:\\s+|(?:[^:\\s\\d]{1,20}:\\s*))?(?:\\S{1}:)?([\\\\/](?:[^\\s\\[\\]\\:\\\"]*))+\\:([1-9][0-9]*).*\\s?");

    JRubyServerModule(Lookup instanceLookup) {
        this.lookup = instanceLookup;
    }

    public String toString() {
        return "GlassFish v3 Prelude / JRuby Support";
    }

    public String getServerUri() {
        String serverUri = null;
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            serverUri = (String)commonModule.getInstanceProperties().get("url");
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.INFO, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return serverUri;
    }

    public String getDisplayName() {
        String displayName = null;
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            displayName = (String)commonModule.getInstanceProperties().get("displayName");
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.INFO, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return displayName;
    }

    public RubyInstance.ServerState getServerState() {
        RubyInstance.ServerState state = null;
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            state = JRubyServerModule.translateServerState(commonModule.getServerState());
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.INFO, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return state;
    }

    public Future<RubyInstance.OperationState> startServer(RubyPlatform platform) {
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            commonModule.setEnvironmentProperty("jruby.home", platform.getHome().getAbsolutePath(), false);
            return JRubyServerModule.wrapTask(commonModule.startServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINEST, "startServer V3/JRuby: " + newState + " - " + message);
                }
            }));
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> runApplication(RubyPlatform platform, String applicationName, File applicationDir) {
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            String currentPlatformDir;
            String requestedPlatformDir = platform.getHome().getAbsolutePath();
            if (!requestedPlatformDir.equals(currentPlatformDir = commonModule.setEnvironmentProperty("jruby.home", requestedPlatformDir, false))) {
                Logger.getLogger("glassfish-jruby").log(Level.WARNING, "Running project with current V3 Rails platform " + currentPlatformDir + " rather than requested platform " + requestedPlatformDir);
            }
            RubyPlatform.Info info = platform.getInfo();
            commonModule.setEnvironmentProperty("GEM_HOME", info.getGemHome(), false);
            commonModule.setEnvironmentProperty("GEM_PATH", info.getGemPath(), false);
            GlassfishModule.ServerState state = commonModule.getServerState();
            if (state == GlassfishModule.ServerState.STOPPED || state == GlassfishModule.ServerState.RUNNING) {
                FutureTask<RubyInstance.OperationState> task = new FutureTask<RubyInstance.OperationState>(new RunAppTask(commonModule, applicationName, applicationDir, state == GlassfishModule.ServerState.STOPPED));
                RequestProcessor.getDefault().post(task);
                return task;
            }
            return JRubyServerModule.failedOperation();
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> stopServer() {
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            return JRubyServerModule.wrapTask(commonModule.stopServer(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINEST, "stopServer V3/JRuby: " + newState + " - " + message);
                }
            }));
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> deploy(String applicationName, File applicationDir) {
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            FutureTask<RubyInstance.OperationState> task = new FutureTask<RubyInstance.OperationState>(new RunAppTask(commonModule, applicationName, applicationDir, false));
            RequestProcessor.getDefault().post(task);
            return task;
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public Future<RubyInstance.OperationState> stop(String applicationName) {
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            return JRubyServerModule.wrapTask(commonModule.undeploy(new OperationStateListener(){

                public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINEST, "undeploy V3/JRuby: " + newState + " - " + message);
                }
            }, applicationName.replaceAll("[ \t]", "_")));
        }
        throw new IllegalStateException("No V3 Common Server support found for V3/Ruby server instance");
    }

    public boolean isPlatformSupported(RubyPlatform platform) {
        return platform.isJRuby();
    }

    public void addChangeListener(ChangeListener listener) {
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            commonModule.addChangeListener(listener);
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            commonModule.removeChangeListener(listener);
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
    }

    public String getContextRoot(String applicationName) {
        String result = applicationName;
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            result = JRubyServerModule.calculateContextRoot(commonModule, applicationName);
        }
        return result;
    }

    public int getRailsPort() {
        int httpPort = 8080;
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            try {
                String httpPortStr = (String)commonModule.getInstanceProperties().get("httpportnumber");
                httpPort = Integer.parseInt(httpPortStr);
            }
            catch (NumberFormatException ex) {
                Logger.getLogger("glassfish-jruby").log(Level.WARNING, "Server's HTTP port value is not a valid integer.");
            }
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return httpPort;
    }

    public String getServerCommand(RubyPlatform platform, String classpath, File applicationDir, int httpPort, boolean debug) {
        Integer grizzlyVMDebugPort;
        StringBuilder builder = new StringBuilder(1000);
        builder.append("-cp ");
        List<String> serverJars = this.getServerJars();
        for (String jarPath : serverJars) {
            builder.append(jarPath);
            builder.append(File.pathSeparatorChar);
        }
        String jrubyJar = platform.getHome().getAbsolutePath() + File.separatorChar + "lib" + File.separatorChar + "jruby.jar";
        builder.append(ServerUtilities.quote((String)jrubyJar));
        if (classpath != null && classpath.length() > 0) {
            String[] subpaths;
            for (String subpath : subpaths = classpath.split(File.pathSeparator)) {
                builder.append(File.pathSeparatorChar);
                builder.append(ServerUtilities.quote((String)subpath));
            }
        }
        builder.append(" -client");
        builder.append(" -Djruby.home=");
        builder.append(ServerUtilities.quote((String)platform.getHome().getAbsolutePath()));
        builder.append(" -Djruby.runtime.max=1");
        String grizzlyVMParams = System.getProperty("grizzly.jruby.vm.params");
        if (grizzlyVMParams != null) {
            builder.append(' ');
            builder.append(grizzlyVMParams);
        }
        if ((grizzlyVMDebugPort = Integer.getInteger("grizzly.jruby.vm.debugport")) != null) {
            builder.append(" -Xdebug -Xrunjdwp:transport=dt_socket,address=" + grizzlyVMDebugPort + ",server=y,suspend=y");
        }
        if (debug) {
            builder.append(" -Djruby.reflection=true -Djruby.compile.mode=OFF -Djruby.debug.fullTrace=true");
            builder.append(" -Dglassfish.rdebug=${rdebug.path} -Dglassfish.rdebug.port=${rdebug.port} -Dglassfish.rdebug.version=${rdebug.version} -Dglassfish.rdebug.iosynch=${rdebug.iosynch}");
            if ("true".equals(System.getProperty("glassfish.rdebug.verbose"))) {
                builder.append(" -Dglassfish.rdebug.verbose=true");
            }
        }
        builder.append(" com.sun.grizzly.standalone.JRuby");
        if (debug) {
            builder.append(" --debug");
        }
        builder.append(" -p ");
        builder.append(httpPort);
        builder.append(" -n 1 ");
        builder.append(ServerUtilities.quote((String)applicationDir.getAbsolutePath()));
        return builder.toString();
    }

    private List<String> getServerJars() {
        ArrayList<String> serverJars = new ArrayList<String>();
        GlassfishModule commonModule = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
        if (commonModule != null) {
            String glassfishRoot = (String)commonModule.getInstanceProperties().get("homefolder");
            File modulesDir = new File(glassfishRoot, "modules");
            File[] grizzlyJars = modulesDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    return name.startsWith("grizzly") && name.endsWith(".jar");
                }
            });
            if (grizzlyJars != null) {
                for (File jar : grizzlyJars) {
                    Logger.getLogger("glassfish-jruby").log(Level.FINER, "Found jar for grizzly path: " + jar.getAbsolutePath());
                    serverJars.add(ServerUtilities.quote((String)jar.getAbsolutePath()));
                }
            } else {
                Logger.getLogger("glassfish-jruby").log(Level.WARNING, "Problem accessing " + modulesDir.getAbsolutePath() + " when searching for Grizzly Jars.");
            }
        } else {
            Logger.getLogger("glassfish-jruby").log(Level.WARNING, "No V3 Common Server support found for V3/Ruby server instance");
        }
        return serverJars;
    }

    private static String calculateContextRoot(GlassfishModule commonModule, String applicationName) {
        boolean useRootContext = Boolean.valueOf((String)commonModule.getInstanceProperties().get(USE_ROOT_CONTEXT_ATTR));
        return useRootContext ? "" : "/" + applicationName.replaceAll("[ \t]", "_");
    }

    private static Future<RubyInstance.OperationState> failedOperation() {
        return new Future<RubyInstance.OperationState>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return true;
            }

            @Override
            public RubyInstance.OperationState get() throws InterruptedException, ExecutionException {
                return RubyInstance.OperationState.FAILED;
            }

            @Override
            public RubyInstance.OperationState get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return RubyInstance.OperationState.FAILED;
            }
        };
    }

    private static Future<RubyInstance.OperationState> wrapTask(final Future<GlassfishModule.OperationState> task) {
        return new Future<RubyInstance.OperationState>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return task.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return task.isCancelled();
            }

            @Override
            public boolean isDone() {
                return task.isDone();
            }

            @Override
            public RubyInstance.OperationState get() throws InterruptedException, ExecutionException {
                GlassfishModule.OperationState state = (GlassfishModule.OperationState)task.get();
                return JRubyServerModule.translateOperationState(state);
            }

            @Override
            public RubyInstance.OperationState get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                GlassfishModule.OperationState state = (GlassfishModule.OperationState)task.get(timeout, unit);
                return JRubyServerModule.translateOperationState(state);
            }
        };
    }

    private static RubyInstance.ServerState translateServerState(GlassfishModule.ServerState state) {
        switch (state) {
            case STARTING: {
                return RubyInstance.ServerState.STARTING;
            }
            case RUNNING: 
            case RUNNING_JVM_DEBUG: {
                return RubyInstance.ServerState.RUNNING;
            }
            case STOPPING: {
                return RubyInstance.ServerState.STOPPING;
            }
            case STOPPED: 
            case STOPPED_JVM_BP: {
                return RubyInstance.ServerState.STOPPED;
            }
        }
        Logger.getLogger("glassfish-jruby").log(Level.INFO, "Invalid server state: " + state);
        return RubyInstance.ServerState.STOPPED;
    }

    private static RubyInstance.OperationState translateOperationState(GlassfishModule.OperationState state) {
        switch (state) {
            case RUNNING: {
                return RubyInstance.OperationState.RUNNING;
            }
            case COMPLETED: {
                return RubyInstance.OperationState.COMPLETED;
            }
            case FAILED: {
                return RubyInstance.OperationState.FAILED;
            }
        }
        Logger.getLogger("glassfish-jruby").log(Level.INFO, "Invalid operation state: " + state);
        return RubyInstance.OperationState.FAILED;
    }

    public Collection<JPanel> getCustomizerPages() {
        LinkedList<JPanel> result = new LinkedList<JPanel>();
        result.add(new JRubyServerCustomizer((GlassfishModule)this.lookup.lookup(GlassfishModule.class)));
        return result;
    }

    public Collection<? extends Recognizer> getRecognizers() {
        DirectoryFileLocator locator = new DirectoryFileLocator(FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File("/"))));
        LineConvertor convertor = LineConvertors.filePattern((LineConvertors.FileLocator)locator, (Pattern)PATH_RECOGNIZER, (Pattern)RubyLineConvertorFactory.EXT_RE, (int)1, (int)2);
        return Collections.singleton(this.wrapRubyRecognizer(convertor));
    }

    private Recognizer wrapRubyRecognizer(final LineConvertor convertor) {
        return new Recognizer(){

            public OutputListener processLine(String text) {
                OutputListener result = null;
                List match = convertor.convert(text);
                if (match != null && !match.isEmpty()) {
                    result = ((ConvertedLine)match.get(0)).getListener();
                }
                return result;
            }
        };
    }

    private static class RunAppTask
    implements Callable<RubyInstance.OperationState>,
    OperationStateListener {
        private final GlassfishModule commonModule;
        private final String applicationName;
        private final File applicationDir;
        private final boolean doStart;
        private String contextRoot;
        private String step;

        public RunAppTask(GlassfishModule module, String appname, File appdir, boolean startRequired) {
            this.commonModule = module;
            this.applicationName = appname.replaceAll("[ \t]", "_");
            this.applicationDir = appdir;
            this.contextRoot = JRubyServerModule.calculateContextRoot(module, appname);
            if ("".equals(this.contextRoot)) {
                this.contextRoot = "/";
            }
            this.doStart = startRequired;
            this.step = "start";
        }

        @Override
        public RubyInstance.OperationState call() throws Exception {
            GlassfishModule.OperationState result = GlassfishModule.OperationState.COMPLETED;
            if (this.doStart) {
                Future startFuture = this.commonModule.startServer((OperationStateListener)this);
                result = (GlassfishModule.OperationState)startFuture.get();
            }
            if (result == GlassfishModule.OperationState.COMPLETED) {
                if (this.isDeployed()) {
                    result = GlassfishModule.OperationState.COMPLETED;
                } else {
                    this.step = "deploy";
                    HashMap<String, String> m = new HashMap<String, String>();
                    String jrubyHome = (String)this.commonModule.getInstanceProperties().get("jruby.home");
                    if (null == jrubyHome || jrubyHome.length() <= 0) {
                        throw new RuntimeException();
                    }
                    m.put("jruby.home", Utils.escapePath((String)jrubyHome).replace(":", JRubyServerModule.LINE_SEP));
                    Future deployFuture = this.commonModule.deploy((OperationStateListener)this, this.applicationDir, this.applicationName, this.contextRoot, m);
                    result = (GlassfishModule.OperationState)deployFuture.get();
                }
            }
            return JRubyServerModule.translateOperationState(result);
        }

        public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
            Logger.getLogger("glassfish-jruby").log(Level.FINEST, "runApplication/" + this.step + " V3/JRuby: " + newState + " - " + message);
        }

        private boolean isDeployed() {
            this.step = "checkdeployed";
            String propertyBase = "applications.application." + this.applicationName;
            ServerCommand.GetPropertyCommand getCmd = new ServerCommand.GetPropertyCommand(propertyBase);
            Future cmdOp = this.commonModule.execute((ServerCommand)getCmd);
            try {
                ServerCommand.SetPropertyCommand setCmd;
                GlassfishModule.OperationState result = (GlassfishModule.OperationState)cmdOp.get(15000L, TimeUnit.MILLISECONDS);
                if (result != GlassfishModule.OperationState.COMPLETED) {
                    return false;
                }
                Map properties = getCmd.getData();
                String name = (String)properties.get(propertyBase + ".name");
                if (name == null || !name.equals(this.applicationName)) {
                    return false;
                }
                String location = (String)properties.get(propertyBase + ".location");
                if (location == null || !location.startsWith("file:") || !this.match(this.applicationDir, location.substring(5))) {
                    return false;
                }
                String contextRootProperty = propertyBase + ".context-root";
                String deployedContextRoot = (String)properties.get(contextRootProperty);
                if (deployedContextRoot == null) {
                    return false;
                }
                if (!deployedContextRoot.equals(this.contextRoot) && (result = (GlassfishModule.OperationState)this.commonModule.execute((ServerCommand)(setCmd = this.commonModule.getCommandFactory().getSetPropertyCommand(contextRootProperty, this.contextRoot))).get(15000L, TimeUnit.MILLISECONDS)) != GlassfishModule.OperationState.COMPLETED) {
                    return false;
                }
            }
            catch (Exception ex) {
                Logger.getLogger("glassfish-jruby").log(Level.FINE, ex.getLocalizedMessage(), ex);
                return false;
            }
            return true;
        }

        private boolean match(File dir, String path) {
            String dirpath = dir.getAbsolutePath().replaceAll("[ \t]", "%20");
            if (!dirpath.endsWith("/")) {
                dirpath = dirpath + "/";
            }
            if (!path.endsWith("/")) {
                path = path + "/";
            }
            return dirpath.equals(path);
        }
    }
}

