/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CndTokenUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.TokenItem;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.ValuePresenter;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        GdbDebugger debugger = GdbDebugger.getGdbDebugger();
        if (debugger == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        this.lp = lp;
        this.ec = ec;
        GdbUtils.getGdbRequestProcessor().post((Runnable)this);
        return null;
    }

    @Override
    public void run() {
        StyledDocument doc;
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            doc = this.ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (ep == null) {
            return;
        }
        final int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn();
        final AtomicBoolean skip = new AtomicBoolean(false);
        doc.render(new Runnable(){

            @Override
            public void run() {
                TokenItem token = CndTokenUtilities.getToken((Document)doc, (int)offset, (boolean)true);
                String category = ((CppTokenId)token.id()).primaryCategory();
                if ("whitespace".equals(category) || "comment".equals(category) || "separator".equals(category) || "string".equals(category) || "number".equals(category) || "operator".equals(category)) {
                    skip.set(true);
                }
            }
        });
        if (skip.get()) {
            return;
        }
        String expression = ToolTipAnnotation.getIdentifier(doc, ep, offset);
        if (expression == null) {
            return;
        }
        GdbDebugger debugger = GdbDebugger.getGdbDebugger();
        if (debugger == null) {
            return;
        }
        if (!debugger.isStopped()) {
            return;
        }
        if ((expression = GdbWatchVariable.expandMacro(debugger, expression)) == null || expression.length() == 0) {
            return;
        }
        String type = debugger.requestWhatis(expression);
        String value = debugger.evaluate(expression);
        String res = ValuePresenter.getValue(type, value);
        this.firePropertyChange("shortDescription", null, res);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            int identStart = col;
            while (identStart > 0) {
                char prevToken;
                char token = t.charAt(identStart - 1);
                if (identStart > 1 && ((prevToken = t.charAt(identStart - 2)) == '-' && token == '>' || prevToken == ':' && token == ':')) {
                    identStart -= 2;
                    continue;
                }
                if (!Character.isJavaIdentifierPart(token) && token != '.') break;
                --identStart;
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            String ident = t.substring(identStart, identEnd);
            if (CndLexerUtilities.isKeyword((String)ident)) {
                return null;
            }
            return ident;
        }
        catch (BadLocationException e) {
            return null;
        }
    }
}

