/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.masterfs.providers.InterceptionListener;
import org.netbeans.modules.versioning.FilesystemInterceptor;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningAnnotationProvider;
import org.netbeans.modules.versioning.diff.DiffSidebarManager;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;

public class VersioningManager
implements PropertyChangeListener,
LookupListener,
PreferenceChangeListener {
    public static final String EVENT_VERSIONED_ROOTS = "null VCS.VersionedFilesChanged";
    public static final String EVENT_STATUS_CHANGED = "Set<File> VCS.StatusChanged";
    public static final String EVENT_ANNOTATIONS_CHANGED = "Set<File> VCS.AnnotationsChanged";
    static final String PROP_PRIORITY = "Integer VCS.Priority";
    private static VersioningManager instance;
    private final FilesystemInterceptor filesystemInterceptor;
    private final Lookup.Result<VersioningSystem> systemsLookupResult;
    private final List<VersioningSystem> versioningSystems = new ArrayList<VersioningSystem>(5);
    private final Map<File, VersioningSystem> folderOwners = new HashMap<File, VersioningSystem>(200);
    private VersioningSystem localHistory;
    static final Logger LOG;
    private final Map<File, Boolean> localHistoryFiles = new LinkedHashMap<File, Boolean>(200);
    private Map<String, Set<String>> interceptedMethods = new HashMap<String, Set<String>>();
    private final VersioningSystem NULL_OWNER = new VersioningSystem(){};
    private int refreshSerial;

    public static synchronized VersioningManager getInstance() {
        if (instance == null) {
            instance = new VersioningManager();
            instance.init();
        }
        return instance;
    }

    private VersioningManager() {
        this.systemsLookupResult = Lookup.getDefault().lookup(new Lookup.Template(VersioningSystem.class));
        this.filesystemInterceptor = new FilesystemInterceptor();
    }

    private void init() {
        this.systemsLookupResult.addLookupListener((LookupListener)this);
        this.refreshVersioningSystems();
        this.filesystemInterceptor.init(this);
        VersioningSupport.getPreferences().addPreferenceChangeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshVersioningSystems() {
        int rs = ++this.refreshSerial;
        Collection systems = this.systemsLookupResult.allInstances();
        if (rs != this.refreshSerial) {
            return;
        }
        List<VersioningSystem> list = this.versioningSystems;
        synchronized (list) {
            for (VersioningSystem system : this.versioningSystems) {
                system.removePropertyChangeListener(this);
            }
            this.versioningSystems.clear();
            this.localHistory = null;
            this.versioningSystems.addAll(systems);
            Collections.sort(this.versioningSystems, new ByPriorityComparator());
            Collections.reverse(this.versioningSystems);
            for (VersioningSystem system : this.versioningSystems) {
                if (this.localHistory == null && Utils.isLocalHistory(system)) {
                    this.localHistory = system;
                }
                system.addPropertyChangeListener(this);
            }
        }
        this.flushFileOwnerCache();
        this.refreshDiffSidebars(null);
        VersioningAnnotationProvider.refreshAllAnnotations();
    }

    InterceptionListener getInterceptionListener() {
        return this.filesystemInterceptor;
    }

    private void refreshDiffSidebars(Set<File> files) {
        DiffSidebarManager.getInstance().refreshSidebars(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushFileOwnerCache() {
        Map<File, VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            this.folderOwners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersioningSystem[] getVersioningSystems() {
        List<VersioningSystem> list = this.versioningSystems;
        synchronized (list) {
            return this.versioningSystems.toArray(new VersioningSystem[this.versioningSystems.size()]);
        }
    }

    VersioningSystem[] getOwners(VCSContext ctx) {
        Set<File> files = ctx.getRootFiles();
        HashSet<VersioningSystem> owners = new HashSet<VersioningSystem>();
        for (File file : files) {
            VersioningSystem vs = this.getOwner(file);
            if (vs == null) continue;
            owners.add(vs);
        }
        return owners.toArray(new VersioningSystem[owners.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersioningSystem getOwner(File file) {
        VersioningSystem[] vs;
        LOG.log(Level.FINE, "looking for owner of " + file);
        VersioningSystem owner = null;
        Map<File, VersioningSystem> map = this.folderOwners;
        synchronized (map) {
            owner = this.folderOwners.get(file);
        }
        if (owner == this.NULL_OWNER) {
            LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{file});
            return null;
        }
        if (owner != null) {
            LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{owner.getClass().getName(), file});
            return owner;
        }
        File folder = file;
        if (Utils.isFile(file)) {
            folder = file.getParentFile();
            if (folder == null) {
                LOG.log(Level.FINE, " null parent");
                return null;
            }
            Map<File, VersioningSystem> map2 = this.folderOwners;
            synchronized (map2) {
                owner = this.folderOwners.get(folder);
            }
        }
        if (owner == this.NULL_OWNER) {
            LOG.log(Level.FINE, " cached NULL_OWNER of {0}", new Object[]{folder});
            return null;
        }
        if (owner != null) {
            LOG.log(Level.FINE, " cached owner {0} of {1}", new Object[]{owner.getClass().getName(), folder});
            return owner;
        }
        File closestParent = null;
        for (VersioningSystem system : vs = this.getVersioningSystems()) {
            if (system == this.localHistory) continue;
            File topmost = system.getTopmostManagedAncestor(folder);
            LOG.log(Level.FINE, " {0} returns {1} ", new Object[]{system.getClass().getName(), topmost});
            if (topmost == null || closestParent != null && !Utils.isAncestorOrEqual(closestParent, topmost)) continue;
            LOG.log(Level.FINE, " owner = {0}", new Object[]{system.getClass().getName()});
            owner = system;
            closestParent = topmost;
        }
        Map<File, VersioningSystem> map3 = this.folderOwners;
        synchronized (map3) {
            if (owner != null) {
                LOG.log(Level.FINE, " caching owner {0} of {1}", new Object[]{owner != null ? owner.getClass().getName() : null, folder});
                this.folderOwners.put(folder, owner);
            } else {
                while (folder != null) {
                    LOG.log(Level.FINE, " caching unversioned folder {0}", new Object[]{folder});
                    this.folderOwners.put(folder, this.NULL_OWNER);
                    folder = folder.getParentFile();
                }
            }
        }
        LOG.log(Level.FINE, "owner = {0}", new Object[]{owner != null ? owner.getClass().getName() : null});
        return owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    VersioningSystem getLocalHistory(File file) {
        boolean isManaged;
        Object isManagedByLocalHistory;
        if (this.localHistory == null) {
            return null;
        }
        Map<File, Boolean> map = this.localHistoryFiles;
        synchronized (map) {
            isManagedByLocalHistory = this.localHistoryFiles.get(file);
            if (isManagedByLocalHistory != null && ((Boolean)isManagedByLocalHistory).booleanValue()) {
                return this.localHistory;
            }
        }
        File folder = file;
        if (Utils.isFile(file) && (folder = file.getParentFile()) == null) {
            return null;
        }
        isManagedByLocalHistory = this.localHistoryFiles;
        synchronized (isManagedByLocalHistory) {
            Boolean isManagedByLocalHistory2 = this.localHistoryFiles.get(folder);
            if (isManagedByLocalHistory2 != null) {
                return isManagedByLocalHistory2 != false ? this.localHistory : null;
            }
        }
        boolean bl = isManaged = this.localHistory.getTopmostManagedAncestor(folder) != null;
        if (isManaged) {
            this.putLocalHistoryFile(Boolean.TRUE, folder);
            return this.localHistory;
        }
        isManaged = this.localHistory.getTopmostManagedAncestor(file) != null;
        this.putLocalHistoryFile(isManaged, file, folder);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putLocalHistoryFile(Boolean b, File ... files) {
        Map<File, Boolean> map = this.localHistoryFiles;
        synchronized (map) {
            if (this.localHistoryFiles.size() > 1500) {
                Iterator<File> it = this.localHistoryFiles.keySet().iterator();
                for (int i = 0; i < 150; ++i) {
                    it.next();
                    it.remove();
                }
            }
            for (File file : files) {
                this.localHistoryFiles.put(file, b);
            }
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshVersioningSystems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (EVENT_STATUS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(files);
            this.refreshDiffSidebars(files);
        } else if (EVENT_ANNOTATIONS_CHANGED.equals(evt.getPropertyName())) {
            Set files = (Set)evt.getNewValue();
            VersioningAnnotationProvider.instance.refreshAnnotations(files);
        } else if (EVENT_VERSIONED_ROOTS.equals(evt.getPropertyName())) {
            if (evt.getSource() == this.localHistory) {
                Map<File, Boolean> map = this.localHistoryFiles;
                synchronized (map) {
                    this.localHistoryFiles.clear();
                }
            } else {
                this.flushFileOwnerCache();
                this.refreshDiffSidebars(null);
            }
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        VersioningAnnotationProvider.instance.refreshAnnotations(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean needsLocalHistory(String methodName) {
        boolean bl;
        boolean ret;
        block5: {
            ret = false;
            if (this.localHistory != null) break block5;
            boolean bl2 = ret;
            LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
            return bl2;
        }
        try {
            Set<String> s = this.interceptedMethods.get(this.localHistory.getClass().getName());
            if (s == null) {
                Method[] m;
                s = new HashSet<String>();
                for (Method method : m = this.localHistory.getVCSInterceptor().getClass().getDeclaredMethods()) {
                    if ((method.getModifiers() & 1) == 0) continue;
                    s.add(method.getName());
                }
                this.interceptedMethods.put(this.localHistory.getClass().getName(), s);
            }
            bl = ret = s.contains(methodName);
        }
        catch (Throwable throwable) {
            LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
            throw throwable;
        }
        LOG.log(Level.FINE, "needsLocalHistory method [{0}] returns {1}", new Object[]{methodName, ret});
        return bl;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.versioning");
    }

    private static final class ByPriorityComparator
    implements Comparator<VersioningSystem> {
        private ByPriorityComparator() {
        }

        @Override
        public int compare(VersioningSystem o1, VersioningSystem o2) {
            return Utils.getPriority(o1).compareTo(Utils.getPriority(o2));
        }
    }
}

