/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.search.MatchingObject;
import org.netbeans.modules.search.ResultModel;
import org.openide.nodes.Node;

final class ResultTreeModel
implements TreeModel {
    final ResultModel resultModel;
    private final TreePath rootPath;
    private String rootDisplayName;
    private boolean selected = true;
    private int objectsCount;
    private int selectedObjectsCount;
    private List<TreeModelListener> treeModelListeners;
    private final Task UPDATE_NAME_TASK = new Task();

    ResultTreeModel(ResultModel resultModel) {
        this.resultModel = resultModel;
        this.rootPath = new TreePath(this);
        if (resultModel != null) {
            resultModel.setObserver(this);
        }
    }

    @Override
    public Object getRoot() {
        return this;
    }

    @Override
    public Object getChild(Object parent, int index) {
        MatchingObject ret;
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null || index < 0) {
            return null;
        }
        if (parent == this.getRoot()) {
            if (index >= this.objectsCount) {
                ret = null;
            } else {
                try {
                    ret = this.resultModel.getMatchingObjects().get(index);
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    assert (false);
                    ret = null;
                }
            }
        } else if (parent.getClass() == MatchingObject.class) {
            if (this.resultModel.canHaveDetails() == Boolean.FALSE) {
                ret = null;
            } else {
                Node[] detailNodes;
                MatchingObject mo = (MatchingObject)parent;
                Node[] nodeArray = detailNodes = this.resultModel.searchAndReplace ? this.resultModel.basicCriteria.getDetails(mo.object) : this.resultModel.getDetails(mo);
                ret = detailNodes == null || index >= detailNodes.length ? null : detailNodes[index];
            }
        } else {
            ret = null;
        }
        return ret;
    }

    @Override
    public int getChildCount(Object parent) {
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null) {
            return 0;
        }
        int ret = parent == this.getRoot() ? this.objectsCount : (parent.getClass() == MatchingObject.class ? (this.resultModel.searchAndReplace ? this.resultModel.basicCriteria.getDetailsCount(((MatchingObject)parent).object) : (this.resultModel.canHaveDetails() == Boolean.FALSE ? 0 : this.resultModel.getDetailsCount((MatchingObject)parent))) : 0);
        return ret;
    }

    @Override
    public boolean isLeaf(Object node) {
        Boolean hasDetails;
        boolean ret = node == this.getRoot() ? false : (node.getClass() == MatchingObject.class ? ((hasDetails = this.resultModel.canHaveDetails()) != null ? hasDetails == false : this.resultModel.getDetails((MatchingObject)node) == null) : true);
        return ret;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        assert (EventQueue.isDispatchThread());
        assert (false);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int ret;
        assert (EventQueue.isDispatchThread());
        if (this.resultModel == null || parent == null || child == null) {
            return -1;
        }
        if (parent == this.getRoot()) {
            ret = child.getClass() == MatchingObject.class ? this.resultModel.getMatchingObjects().indexOf(child) : -1;
        } else {
            ret = -1;
            if (parent.getClass() == MatchingObject.class && this.resultModel.canHaveDetails().booleanValue() && child instanceof Node) {
                Node[] detailNodes;
                MatchingObject matchingObject = (MatchingObject)parent;
                Node[] nodeArray = detailNodes = this.resultModel.searchAndReplace ? this.resultModel.basicCriteria.getDetails(matchingObject.object) : this.resultModel.getDetails(matchingObject);
                if (detailNodes != null) {
                    for (int i = 0; i < detailNodes.length; ++i) {
                        if (!detailNodes[i].equals(child)) continue;
                        ret = i;
                        break;
                    }
                }
            }
        }
        return ret;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        if (l == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.treeModelListeners == null) {
            this.treeModelListeners = new ArrayList<TreeModelListener>(4);
        }
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        assert (EventQueue.isDispatchThread());
        if (l == null) {
            throw new IllegalArgumentException("null");
        }
        if (this.treeModelListeners != null) {
            this.treeModelListeners.remove(l);
        }
    }

    void objectFound(MatchingObject object, int objectIndex) {
        if (this.resultModel == null) {
            throw new IllegalStateException("resultModel is null");
        }
        new Task(object, objectIndex).run();
    }

    void objectBecameInvalid(MatchingObject object) {
        if (this.resultModel == null) {
            throw new IllegalStateException("resultModel is null");
        }
        new Task(object).run();
    }

    String getRootDisplayName() {
        assert (EventQueue.isDispatchThread());
        return this.rootDisplayName;
    }

    void setRootDisplayName(String displayName) {
        assert (EventQueue.isDispatchThread());
        this.rootDisplayName = displayName;
        this.UPDATE_NAME_TASK.run();
    }

    boolean isSelected() {
        return this.selected;
    }

    private boolean setSelected(boolean selected) {
        if (selected == this.selected) {
            return false;
        }
        this.selected = selected;
        return true;
    }

    void setRootNodeSelected(boolean selected) {
        this.selectedObjectsCount = selected ? this.objectsCount : 0;
        this.updateRootNodeSelection();
    }

    void fileNodeSelectionChanged(MatchingObject matchingObj, boolean includingChildren) {
        assert (EventQueue.isDispatchThread());
        this.fireFileNodeSelectionChanged(matchingObj, includingChildren);
        this.updateRootNodeSelection(matchingObj.isSelected());
    }

    private void updateRootNodeSelection(boolean selectionAdded) {
        this.selectedObjectsCount = selectionAdded ? ++this.selectedObjectsCount : --this.selectedObjectsCount;
        this.updateRootNodeSelection();
    }

    private void updateRootNodeSelection() {
        assert (this.selectedObjectsCount >= 0 && this.selectedObjectsCount <= this.objectsCount);
        if (this.setSelected(this.selectedObjectsCount != 0)) {
            this.fireRootNodeChanged();
        }
    }

    private void fireNodeAdded(int index, MatchingObject object) {
        assert (EventQueue.isDispatchThread());
        assert (object != null);
        assert (index >= 0);
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, this.rootPath);
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeStructureChanged(event);
        }
    }

    private void fireNodeChanged(MatchingObject object) {
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreePath path = this.rootPath.pathByAddingChild(object);
        TreeModelEvent event = new TreeModelEvent((Object)this, path);
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeStructureChanged(event);
        }
    }

    void fireRootNodeChanged() {
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, this.rootPath, null, null);
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeNodesChanged(event);
        }
    }

    void fireFileNodesSelectionChanged(int[] indices, MatchingObject[] matchingObjects) {
        assert (EventQueue.isDispatchThread());
        assert (matchingObjects != null);
        assert (indices != null);
        assert (matchingObjects.length == indices.length);
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, this.rootPath, indices, (Object[])matchingObjects);
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeNodesChanged(event);
        }
    }

    private void fireFileNodeSelectionChanged(MatchingObject matchingObj, boolean includingChildren) {
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        int index = this.resultModel.getMatchingObjects().indexOf(matchingObj);
        TreeModelEvent event = new TreeModelEvent((Object)this, this.rootPath, new int[]{index}, new Object[]{matchingObj});
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeNodesChanged(event);
        }
        if (includingChildren) {
            if (matchingObj.isExpanded()) {
                this.fireFileNodeChildrenSelectionChanged(matchingObj);
            } else {
                matchingObj.markChildrenSelectionDirty();
            }
        }
    }

    void fireFileNodeChildrenSelectionChanged(MatchingObject matchingObj) {
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        Object[] children = this.resultModel.basicCriteria.getDetails(matchingObj.object);
        int[] indices = new int[children.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = i;
        }
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.getRoot(), matchingObj}, indices, children);
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeNodesChanged(event);
        }
    }

    void fireDetailNodeSelectionChanged(MatchingObject matchingObj, int index) {
        Object[] objectArray;
        assert (EventQueue.isDispatchThread());
        if (this.treeModelListeners == null || this.treeModelListeners.isEmpty()) {
            return;
        }
        int[] changedIndices = new int[]{index};
        Object[] detailNodes = this.resultModel.basicCriteria.getDetails(matchingObj.object);
        if (detailNodes.length == 1) {
            objectArray = detailNodes;
        } else {
            Node[] nodeArray = new Node[1];
            objectArray = nodeArray;
            nodeArray[0] = detailNodes[index];
        }
        Object[] changedNodes = objectArray;
        TreeModelEvent event = new TreeModelEvent((Object)this, new Object[]{this.getRoot(), matchingObj}, changedIndices, changedNodes);
        for (TreeModelListener l : this.treeModelListeners) {
            l.treeNodesChanged(event);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.rootDisplayName + "]";
    }

    private final class Task
    implements Runnable {
        private final MatchingObject foundObject;
        private final int foundObjectIndex;

        private Task() {
            this.foundObject = null;
            this.foundObjectIndex = -1;
        }

        private Task(MatchingObject object) {
            this.foundObject = object;
            this.foundObjectIndex = -1;
        }

        private Task(MatchingObject foundObject, int foundObjectIndex) {
            assert (foundObject != null && foundObjectIndex >= 0);
            this.foundObject = foundObject;
            this.foundObjectIndex = foundObjectIndex;
        }

        @Override
        public void run() {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(this);
                return;
            }
            assert (EventQueue.isDispatchThread());
            if (this.foundObject != null) {
                if (this.foundObjectIndex != -1) {
                    ResultTreeModel.this.objectsCount++;
                    ResultTreeModel.this.fireNodeAdded(this.foundObjectIndex, this.foundObject);
                    ResultTreeModel.this.updateRootNodeSelection(true);
                } else {
                    assert (!this.foundObject.isObjectValid());
                    boolean wasSelected = this.foundObject.isSelected();
                    this.foundObject.setSelected(false);
                    ResultTreeModel.this.fireNodeChanged(this.foundObject);
                    if (wasSelected) {
                        ResultTreeModel.this.updateRootNodeSelection(false);
                    }
                }
            } else {
                ResultTreeModel.this.fireRootNodeChanged();
            }
        }
    }
}

