/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.search;

import java.util.regex.Pattern;

final class RegexpMaker {
    private static final String wordCharsExpr = "[\\p{javaLetterOrDigit}_]";
    private static final String checkNotAfterWordChar = "(?<![\\p{javaLetterOrDigit}_])";
    private static final String checkNotBeforeWordChar = "(?![\\p{javaLetterOrDigit}_])";

    private RegexpMaker() {
    }

    static String makeRegexp(String simplePattern) {
        return RegexpMaker.makeRegexp(simplePattern, false);
    }

    static String makeRegexp(String simplePattern, boolean wholeWords) {
        if (simplePattern.length() == 0) {
            return simplePattern;
        }
        if (!wholeWords && Pattern.matches("[a-zA-Z0-9 ]*", simplePattern)) {
            return simplePattern;
        }
        StringBuilder buf = new StringBuilder(simplePattern.length() + 16);
        boolean quoted = false;
        boolean starPresent = false;
        int minCount = 0;
        boolean bufIsEmpty = true;
        char lastInputChar = '*';
        for (char c : simplePattern.toCharArray()) {
            if (quoted) {
                assert (!starPresent && minCount == 0);
                if (wholeWords && bufIsEmpty && RegexpMaker.isWordChar(c)) {
                    buf.append(checkNotAfterWordChar);
                }
                if (c == 'n' || RegexpMaker.isSpecialCharacter(c)) {
                    buf.append('\\');
                }
                buf.append(c);
                lastInputChar = c;
                bufIsEmpty = false;
                quoted = false;
                continue;
            }
            if (c == '?') {
                ++minCount;
                continue;
            }
            if (c == '*') {
                starPresent = true;
                continue;
            }
            if (starPresent || minCount != 0) {
                if (wholeWords && bufIsEmpty && !starPresent) {
                    buf.append(checkNotAfterWordChar);
                }
                bufIsEmpty &= !RegexpMaker.addMetachars(buf, starPresent, minCount, wholeWords, !bufIsEmpty);
                starPresent = false;
                minCount = 0;
            }
            if (c == '\\') {
                quoted = true;
                continue;
            }
            if (wholeWords && bufIsEmpty && RegexpMaker.isWordChar(c)) {
                buf.append(checkNotAfterWordChar);
            }
            if (RegexpMaker.isSpecialCharacter(c)) {
                buf.append('\\');
            }
            buf.append(c);
            lastInputChar = c;
            bufIsEmpty = false;
        }
        if (quoted) {
            assert (!starPresent && minCount == 0);
            buf.append('\\').append('\\');
            lastInputChar = '\\';
            bufIsEmpty = false;
            quoted = false;
        } else if (starPresent || minCount != 0) {
            if (wholeWords && !starPresent && bufIsEmpty) {
                buf.append(checkNotAfterWordChar);
            }
            bufIsEmpty &= !RegexpMaker.addMetachars(buf, starPresent, minCount, wholeWords, false);
            if (wholeWords && !starPresent) {
                buf.append(checkNotBeforeWordChar);
            }
            lastInputChar = '*';
            starPresent = false;
            minCount = 0;
        }
        if (wholeWords && RegexpMaker.isWordChar(lastInputChar)) {
            buf.append(checkNotBeforeWordChar);
        }
        return buf.toString();
    }

    private static boolean isWordChar(char c) {
        if (c == '*' || c == '\\') {
            return false;
        }
        return c == '_' || Character.isLetterOrDigit(c);
    }

    private static boolean addMetachars(StringBuilder buf, boolean starPresent, int minCount, boolean wholeWords, boolean middle) {
        assert (starPresent || minCount != 0);
        if (starPresent && !wholeWords && !middle) {
            starPresent = false;
        }
        if (minCount == 0 && !starPresent) {
            return false;
        }
        if (wholeWords) {
            buf.append(wordCharsExpr);
        } else {
            buf.append('.');
        }
        switch (minCount) {
            case 0: {
                assert (starPresent);
                buf.append('*');
                break;
            }
            case 1: {
                if (!starPresent) break;
                buf.append('+');
                break;
            }
            default: {
                if (wholeWords) {
                    buf.append('{').append(minCount);
                    if (starPresent) {
                        buf.append(',');
                    }
                    buf.append('}');
                    break;
                }
                for (int i = 1; i < minCount; ++i) {
                    buf.append('.');
                }
                if (!starPresent) break;
                buf.append('+');
            }
        }
        if (starPresent && middle) {
            buf.append('?');
        }
        return true;
    }

    static String makeMultiRegexp(String simplePatternList) {
        if (simplePatternList.length() == 0) {
            return simplePatternList;
        }
        if (Pattern.matches("[a-zA-Z0-9]*", simplePatternList)) {
            return simplePatternList;
        }
        StringBuilder buf = new StringBuilder(simplePatternList.length() + 16);
        boolean lastWasSeparator = false;
        boolean quoted = false;
        boolean starPresent = false;
        for (char c : simplePatternList.toCharArray()) {
            if (quoted) {
                if (c == 'n' || RegexpMaker.isSpecialCharacter(c)) {
                    buf.append('\\');
                }
                buf.append(c);
                quoted = false;
                continue;
            }
            if (c == ',' || c == ' ') {
                if (starPresent) {
                    buf.append('.').append('*');
                    starPresent = false;
                }
                lastWasSeparator = true;
                continue;
            }
            if (lastWasSeparator && buf.length() != 0) {
                buf.append('|');
            }
            if (c == '?') {
                buf.append('.');
            } else if (c == '*') {
                starPresent = true;
            } else {
                if (starPresent) {
                    buf.append('.').append('*');
                    starPresent = false;
                }
                if (c == '\\') {
                    quoted = true;
                } else {
                    if (RegexpMaker.isSpecialCharacter(c)) {
                        buf.append('\\');
                    }
                    buf.append(c);
                }
            }
            lastWasSeparator = false;
        }
        if (quoted) {
            buf.append('\\').append('\\');
            quoted = false;
        } else if (starPresent) {
            buf.append('.').append('*');
            starPresent = false;
        }
        return buf.toString();
    }

    private static boolean isSpecialCharacter(char c) {
        return c > ' ' && c < '\u0080' && !RegexpMaker.isAlnum(c);
    }

    private static boolean isAlnum(char c) {
        return RegexpMaker.isAlpha(c) || RegexpMaker.isDigit(c);
    }

    private static boolean isAlpha(char c) {
        return (c = (char)(c | 0x20)) >= 'a' && c <= 'z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

