/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync.download;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.download.FileDownloadInfo;
import org.netbeans.modules.cnd.remote.sync.download.HostUpdatesPersistence;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class HostUpdatesRequestPanel
extends JPanel {
    private final List<RowData> model;
    private JPanel bottomPanel;
    private JCheckBox cbRememberChoice;
    private JTable fileTable;
    private final HostUpdatesPersistence persistence;

    static Set<FileDownloadInfo> request(Collection<FileDownloadInfo> infos, ExecutionEnvironment env, HostUpdatesPersistence persistence) {
        HostUpdatesRequestPanel panel = new HostUpdatesRequestPanel(infos, env, persistence);
        String envString = RemoteUtil.getDisplayName(env);
        String caption = NbBundle.getMessage(HostUpdatesRequestPanel.class, (String)"HostUpdatesRequestPanel.TITLE", (Object)envString);
        panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        DialogDescriptor dd = new DialogDescriptor((Object)panel, caption, true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Dialog dlg = DialogDisplayer.getDefault().createDialog(dd);
        dlg.pack();
        dlg.setVisible(true);
        if (dd.getValue() == DialogDescriptor.OK_OPTION) {
            panel.apply();
            return panel.getConfirmed();
        }
        return null;
    }

    HostUpdatesRequestPanel(Collection<FileDownloadInfo> fileInfos, ExecutionEnvironment env, HostUpdatesPersistence persistence) {
        super(new BorderLayout());
        this.persistence = persistence;
        this.model = new ArrayList<RowData>(fileInfos.size());
        for (FileDownloadInfo info : fileInfos) {
            boolean selected = persistence.getFileSelected(info.getLocalFile(), true);
            this.model.add(new RowData(info, selected));
        }
        Collections.sort(this.model);
        this.fileTable = new JTable(new FileTableModel());
        this.fileTable.setAutoResizeMode(3);
        this.fileTable.getColumnModel().getColumn(0).setPreferredWidth(24);
        for (int c = 1; c < this.fileTable.getColumnCount(); ++c) {
            HostUpdatesRequestPanel.setColumnWidth(this.fileTable, c, 2);
        }
        Dimension pref = this.fileTable.getPreferredSize();
        pref.width = Math.min(pref.width, this.fileTable.getPreferredScrollableViewportSize().width);
        pref.height = Math.max(Math.min(pref.height + 3, 480), 48);
        this.fileTable.setPreferredScrollableViewportSize(pref);
        JScrollPane scroller = new JScrollPane(this.fileTable);
        this.add((Component)scroller, "Center");
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BoxLayout(this.bottomPanel, 0));
        this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 0, 0));
        this.cbRememberChoice = new JCheckBox(NbBundle.getMessage(this.getClass(), (String)"HostUpdatesRequestPanel.remember.text"), false);
        this.bottomPanel.add(this.cbRememberChoice);
        this.add((Component)this.bottomPanel, "South");
        this.setPopup();
    }

    private void setPopup() {
        AbstractAction checkSelected = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACTION_CheckSelected")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = HostUpdatesRequestPanel.this.fileTable.getSelectedRows();
                if (rows.length > 0) {
                    for (int i = 0; i < rows.length; ++i) {
                        ((RowData)((HostUpdatesRequestPanel)HostUpdatesRequestPanel.this).model.get((int)rows[i])).selected = true;
                    }
                }
                HostUpdatesRequestPanel.this.fileTable.repaint();
            }
        };
        AbstractAction uncheckSelected = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACTION_UncheckSelected")){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] rows = HostUpdatesRequestPanel.this.fileTable.getSelectedRows();
                if (rows.length > 0) {
                    for (int i = 0; i < rows.length; ++i) {
                        ((RowData)((HostUpdatesRequestPanel)HostUpdatesRequestPanel.this).model.get((int)rows[i])).selected = false;
                    }
                }
                HostUpdatesRequestPanel.this.fileTable.repaint();
            }
        };
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(checkSelected));
        menu.add(new JMenuItem(uncheckSelected));
        MenuListener menuListener = new MenuListener(this.fileTable, menu);
        this.fileTable.addMouseListener(menuListener);
    }

    private void apply() {
        this.persistence.setRememberChoice(this.cbRememberChoice.isSelected());
        for (RowData data : this.model) {
            this.persistence.setFileSelected(data.fileInfo.getLocalFile(), data.selected);
        }
        this.persistence.store();
    }

    private static void setColumnWidth(JTable table, int vColIndex, int margin) {
        DefaultTableColumnModel colModel = (DefaultTableColumnModel)table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        Dimension pref = comp.getPreferredSize();
        width = pref.width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            pref = comp.getPreferredSize();
            width = Math.max(width, pref.width);
        }
        col.setPreferredWidth(width += 2 * margin);
    }

    private Set<FileDownloadInfo> getConfirmed() {
        HashSet<FileDownloadInfo> result = new HashSet<FileDownloadInfo>();
        for (RowData data : this.model) {
            if (!data.selected) continue;
            result.add(data.fileInfo);
        }
        return result;
    }

    private class FileTableModel
    extends AbstractTableModel {
        private FileTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return HostUpdatesRequestPanel.this.model.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            RowData data = rowIndex < HostUpdatesRequestPanel.this.model.size() ? (RowData)HostUpdatesRequestPanel.this.model.get(rowIndex) : null;
            switch (columnIndex) {
                case 0: {
                    return data == null ? false : data.selected;
                }
                case 1: {
                    return data.fileInfo.getLocalFile().getName();
                }
                case 2: {
                    return data.fileInfo.getLocalFile().getParent();
                }
            }
            throw new IllegalArgumentException("Illegal column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            RowData data;
            RowData rowData = data = rowIndex < HostUpdatesRequestPanel.this.model.size() ? (RowData)HostUpdatesRequestPanel.this.model.get(rowIndex) : null;
            if (columnIndex != 0) {
                throw new IllegalArgumentException("Illegal column index: " + columnIndex);
            }
            if (value instanceof Boolean) {
                if (data != null) {
                    data.selected = (Boolean)value;
                }
            } else {
                throw new IllegalArgumentException("Illegal value to set: " + value);
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException("Illegal column index: " + columnIndex);
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(HostUpdatesRequestPanel.class, (String)"HostUpdatesRequestPanel.column_check");
                }
                case 1: {
                    return NbBundle.getMessage(HostUpdatesRequestPanel.class, (String)"HostUpdatesRequestPanel.column_name");
                }
                case 2: {
                    return NbBundle.getMessage(HostUpdatesRequestPanel.class, (String)"HostUpdatesRequestPanel.column_dir");
                }
            }
            throw new IllegalArgumentException("Illegal column index: " + columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    }

    private static class RowData
    implements Comparable<RowData> {
        public final FileDownloadInfo fileInfo;
        public boolean selected;

        public RowData(FileDownloadInfo fileInfo, boolean selected) {
            this.fileInfo = fileInfo;
            this.selected = selected;
        }

        @Override
        public int compareTo(RowData o) {
            if (o == null) {
                return -1;
            }
            return this.fileInfo.getLocalFile().getAbsolutePath().compareTo(o.fileInfo.getLocalFile().getAbsolutePath());
        }
    }

    private static class MenuListener
    extends MouseAdapter {
        private final JTable table;
        private final JPopupMenu menu;

        public MenuListener(JTable tblPathMappings, JPopupMenu menu) {
            this.table = tblPathMappings;
            this.menu = menu;
        }

        private void showMenu(MouseEvent evt) {
            if (evt != null) {
                int row = this.table.rowAtPoint(evt.getPoint());
                if (row >= 0 && this.table.getSelectionModel().isSelectionEmpty()) {
                    this.table.getSelectionModel().setSelectionInterval(row, row);
                }
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showMenu(evt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.showMenu(evt);
            }
        }
    }
}

