/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.fs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.StringTokenizer;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.cnd.remote.fs.RemoteFileObjectBase;
import org.netbeans.modules.cnd.remote.fs.RemoteFileSystem;
import org.netbeans.modules.cnd.remote.fs.RemotePlainFile;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.filesystems.FileObject;

public class RemoteDirectory
extends RemoteFileObjectBase {
    public RemoteDirectory(RemoteFileSystem fileSystem, ExecutionEnvironment execEnv, FileObject parent, String remotePath, File cache) {
        super(fileSystem, execEnv, parent, remotePath, cache);
    }

    public boolean isFolder() {
        return true;
    }

    public boolean isData() {
        return false;
    }

    public FileObject getFileObject(String name, String ext) {
        return this.getFileObject(name + '.' + ext);
    }

    @Override
    public FileObject getFileObject(String relativePath) {
        if (relativePath != null && relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            relativePath = relativePath.substring(1);
        }
        try {
            File file = new File(this.cache, relativePath);
            if (!file.exists()) {
                File parentFile;
                String parentRemotePath;
                int slashPos = relativePath.lastIndexOf(47);
                if (slashPos == -1) {
                    parentRemotePath = this.remotePath.length() == 0 ? "/" : this.remotePath;
                    parentFile = this.cache;
                } else {
                    parentFile = file.getParentFile();
                    parentRemotePath = this.remotePath + '/' + relativePath.substring(0, slashPos);
                }
                this.getRemoteFileSupport().ensureDirSync(parentFile, parentRemotePath);
                if (!file.exists()) {
                    return null;
                }
            }
            boolean resultIsDirectory = file.isDirectory();
            StringBuilder remoteAbsPath = new StringBuilder(this.remotePath);
            File cacheFile = this.remotePath.isEmpty() ? this.cache : new File(this.cache.getPath() + '/' + this.remotePath);
            RemoteFileObjectBase resultFileObject = this;
            StringTokenizer pathTokenizer = new StringTokenizer(relativePath, "/");
            while (pathTokenizer.hasMoreTokens()) {
                String pathComponent = pathTokenizer.nextToken();
                remoteAbsPath.append('/').append(pathComponent);
                cacheFile = new File(cacheFile.getPath() + '/' + pathComponent);
                if (pathTokenizer.hasMoreElements() || resultIsDirectory) {
                    resultFileObject = new RemoteDirectory(this.fileSystem, this.execEnv, resultFileObject, remoteAbsPath.toString(), cacheFile);
                    continue;
                }
                resultFileObject = new RemotePlainFile(this.fileSystem, this.execEnv, resultFileObject, remoteAbsPath.toString(), cacheFile);
            }
            return resultFileObject;
        }
        catch (CancellationException ex) {
            return null;
        }
        catch (ConnectException ex) {
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public FileObject[] getChildren() {
        try {
            this.getRemoteFileSupport().ensureDirSync(this.cache, this.remotePath);
            File[] childrenFiles = this.cache.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !".rfs".equals(name);
                }
            });
            FileObject[] childrenFO = new FileObject[childrenFiles.length];
            for (int i = 0; i < childrenFiles.length; ++i) {
                String childPath = this.remotePath + '/' + childrenFiles[i].getName();
                childrenFO[i] = childrenFiles[i].isDirectory() ? new RemoteDirectory(this.fileSystem, this.execEnv, this, childPath, childrenFiles[i]) : new RemotePlainFile(this.fileSystem, this.execEnv, this, childPath, childrenFiles[i]);
            }
            return childrenFO;
        }
        catch (ConnectException ex) {
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        return new FileObject[0];
    }

    public InputStream getInputStream() throws FileNotFoundException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

