/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.netbeans.modules.vmd.componentssupport.ui.UIUtils;
import org.netbeans.modules.vmd.componentssupport.ui.helpers.CustomComponentHelper;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.ComponentFinalWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class ComponentFinalVisualPanel
extends JPanel {
    private JLabel createdFiles;
    private JTextArea createdFilesValue;
    private JScrollPane createdFilesValueS;
    private JLabel modifiedFiles;
    private JTextArea modifiedFilesValue;
    private JScrollPane modifiedFilesValueS;
    private JLabel projectName;
    private JTextField projectNameValue;
    private WizardDescriptor mySettings;
    private ComponentFinalWizardPanel myPanel;

    ComponentFinalVisualPanel(ComponentFinalWizardPanel panel) {
        this.myPanel = panel;
        this.initComponents();
    }

    void storeData(WizardDescriptor descriptor) {
    }

    void readData(WizardDescriptor descriptor) {
        this.mySettings = descriptor;
        this.projectNameValue.setText(this.getProjectName());
        this.setFilesInfoIntoTextAreas();
    }

    private String getProjectName() {
        return this.getHelper().getProjectName();
    }

    private CustomComponentHelper getHelper() {
        return (CustomComponentHelper)this.mySettings.getProperty("custCompHelper");
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(ComponentFinalVisualPanel.class);
    }

    private String getCodeNameBase() {
        return this.getHelper().getCodeNameBase();
    }

    private String getCDClassName() {
        return (String)this.mySettings.getProperty("compDescrClassName");
    }

    private String getProducerClassName() {
        return (String)this.mySettings.getProperty("compProdClassName");
    }

    private String getSmallIconPath() {
        String path = (String)this.mySettings.getProperty("compProdSmallIcon");
        if (path == null || path.length() == 0) {
            return null;
        }
        return path;
    }

    private String getLargeIconPath() {
        String path = (String)this.mySettings.getProperty("compProdLargeIcon");
        if (path == null || path.length() == 0) {
            return null;
        }
        return path;
    }

    private void setFilesInfoIntoTextAreas() {
        ArrayList<String> created = new ArrayList<String>();
        ArrayList<String> modified = new ArrayList<String>();
        this.addCDToList(created, modified);
        this.addProducerToList(created, modified);
        this.addLayerXmlToList(created, modified);
        this.addBundleToList(created, modified);
        this.addIconsToList(created, modified);
        this.createdFilesValue.setText(UIUtils.generateTextAreaContent(created.toArray(new String[0])));
        this.modifiedFilesValue.setText(UIUtils.generateTextAreaContent(modified.toArray(new String[0])));
    }

    private void addCDToList(List<String> created, List<String> modified) {
        String dotCodeNameBase = this.getCodeNameBase();
        String name = this.getCDClassName();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        created.add(codeNameBase + "/" + "descriptors" + "/" + name + ".java");
    }

    private void addProducerToList(List<String> created, List<String> modified) {
        String dotCodeNameBase = this.getCodeNameBase();
        String name = this.getProducerClassName();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        created.add(codeNameBase + "/" + "producers" + "/" + name + ".java");
    }

    private void addLayerXmlToList(List<String> created, List<String> modified) {
        String dotCodeNameBase = this.getCodeNameBase();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        modified.add(codeNameBase + "/" + "layer.xml");
    }

    private void addBundleToList(List<String> created, List<String> modified) {
        String dotCodeNameBase = this.getCodeNameBase();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        String bundle = codeNameBase + "/" + "Bundle.properties";
        modified.add(bundle);
    }

    private void addIconsToList(List<String> created, List<String> modified) {
        String large;
        String small = this.getSmallIconPath();
        if (small != null) {
            created.add(this.getFinalIconPath(small));
        }
        if ((large = this.getLargeIconPath()) != null) {
            created.add(this.getFinalIconPath(large));
        }
    }

    private String getFinalIconPath(String iconPath) {
        String dotCodeNameBase = this.getCodeNameBase();
        String codeNameBase = dotCodeNameBase.replace('.', '/');
        File icon = new File(iconPath);
        String name = icon.getName();
        return codeNameBase + "/" + "resources" + "/" + name;
    }

    private static String getMessage(String key, Object ... args) {
        return NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)key, (Object[])args);
    }

    private void initComponents() {
        this.createdFiles = new JLabel();
        this.modifiedFiles = new JLabel();
        this.createdFilesValueS = new JScrollPane();
        this.createdFilesValue = new JTextArea();
        this.modifiedFilesValueS = new JScrollPane();
        this.modifiedFilesValue = new JTextArea();
        this.projectName = new JLabel();
        this.projectNameValue = new JTextField();
        this.setLayout(new GridBagLayout());
        this.createdFiles.setLabelFor(this.createdFilesValue);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/vmd/componentssupport/ui/wizard/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.createdFiles, (String)bundle.getString("LBL_F_CreatedFiles"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(36, 0, 6, 12);
        this.add((Component)this.createdFiles, gridBagConstraints);
        this.createdFiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSN_F_CreatedFiles"));
        this.createdFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_CreatedFiles"));
        this.modifiedFiles.setLabelFor(this.modifiedFilesValue);
        Mnemonics.setLocalizedText((JLabel)this.modifiedFiles, (String)bundle.getString("LBL_F_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.modifiedFiles, gridBagConstraints);
        this.modifiedFiles.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSN_F_ModifiedFiles"));
        this.modifiedFiles.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_ModifiedFiles"));
        this.createdFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.createdFilesValue.setColumns(20);
        this.createdFilesValue.setEditable(false);
        this.createdFilesValue.setRows(5);
        this.createdFilesValue.setToolTipText(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_CreatedFiles"));
        this.createdFilesValue.setBorder(null);
        this.createdFilesValueS.setViewportView(this.createdFilesValue);
        this.createdFilesValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSN_F_CreatedFiles"));
        this.createdFilesValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_CreatedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(36, 0, 6, 0);
        this.add((Component)this.createdFilesValueS, gridBagConstraints);
        this.modifiedFilesValue.setBackground(UIManager.getDefaults().getColor("Label.background"));
        this.modifiedFilesValue.setColumns(20);
        this.modifiedFilesValue.setEditable(false);
        this.modifiedFilesValue.setRows(5);
        this.modifiedFilesValue.setToolTipText(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_ModifiedFiles"));
        this.modifiedFilesValue.setBorder(null);
        this.modifiedFilesValueS.setViewportView(this.modifiedFilesValue);
        this.modifiedFilesValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSN_F_ModifiedFiles"));
        this.modifiedFilesValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_ModifiedFiles"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.modifiedFilesValueS, gridBagConstraints);
        this.projectName.setLabelFor(this.projectNameValue);
        Mnemonics.setLocalizedText((JLabel)this.projectName, (String)bundle.getString("LBL_F_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 6, 12);
        this.add((Component)this.projectName, gridBagConstraints);
        this.projectName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSN_F_ProjectName"));
        this.projectName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_ProjectName"));
        this.projectNameValue.setEditable(false);
        this.projectNameValue.setToolTipText(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_F_ProjectName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.projectNameValue, gridBagConstraints);
        this.projectNameValue.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSN_ProjectName"));
        this.projectNameValue.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ComponentFinalVisualPanel.class, (String)"ACSD_ProjectName"));
    }
}

