/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class SetConfigurationAction
extends AbstractAction
implements Presenter.Menu,
Presenter.Popup {
    private static final String PROJECT_KEY = "org.netbeans.modules.cnd.makeproject.ui.ConfigurationItem";
    private JMenu subMenu;
    private Project project;

    public SetConfigurationAction(Project project) {
        super(NbBundle.getMessage(SetConfigurationAction.class, (String)"LBL_SetConfigurationAction_Name"), null);
        this.project = project;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
    }

    public JMenuItem getPopupPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    public JMenuItem getMenuPresenter() {
        this.createSubMenu();
        return this.subMenu;
    }

    private void createSubMenu() {
        if (this.subMenu == null) {
            String label = NbBundle.getMessage(SetConfigurationAction.class, (String)"LBL_SetConfigurationAction_Name");
            this.subMenu = new JMenu(label);
        }
        this.subMenu.removeAll();
        MenuItemActionListener jmiActionListener = new MenuItemActionListener();
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null) {
            return;
        }
        MakeConfigurationDescriptor projectDescriptor = pdp.getConfigurationDescriptor();
        Configuration[] confs = null;
        if (projectDescriptor != null && projectDescriptor.getState() != ConfigurationDescriptor.State.READING) {
            confs = projectDescriptor.getConfs().toArray();
            for (int i = 0; i < confs.length; ++i) {
                JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(confs[i].getName(), confs[i].isDefault());
                this.subMenu.add(jmi);
                jmi.putClientProperty(PROJECT_KEY, projectDescriptor);
                jmi.addActionListener(jmiActionListener);
            }
            this.subMenu.add(new JSeparator());
            JMenuItem profilesMenuItem = new JMenuItem(NbBundle.getMessage(SetConfigurationAction.class, (String)"LBL_ConfigurationsAction_Name"));
            this.subMenu.add(profilesMenuItem);
            profilesMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    CommonProjectActions.customizeProjectAction().actionPerformed(new ActionEvent(this, -1, null));
                }
            });
        }
        this.subMenu.setEnabled(confs != null && confs.length > 0);
    }

    private static class MenuItemActionListener
    implements ActionListener {
        private MenuItemActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JMenuItem jmi;
            ConfigurationDescriptor projectDescriptor;
            if (e.getSource() instanceof JMenuItem && (projectDescriptor = (ConfigurationDescriptor)(jmi = (JMenuItem)e.getSource()).getClientProperty(SetConfigurationAction.PROJECT_KEY)) != null) {
                projectDescriptor.getConfs().setActive(jmi.getText());
            }
        }
    }
}

