/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.awt.Image;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class TableEditorPanel
extends ListEditorPanel<LibraryItem> {
    private static Image brokenProjectBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif");
    private String baseDir;
    private JTable targetList;
    private MyTableCellRenderer myTableCellRenderer = new MyTableCellRenderer();
    private static ResourceBundle bundle;

    public char getDownButtonMnemonics() {
        return TableEditorPanel.getString("DOWN_OPTION_BUTTON_MN").charAt(0);
    }

    public TableEditorPanel(List<LibraryItem> objects, JButton[] extraButtons, String baseDir) {
        super(objects, extraButtons);
        this.baseDir = baseDir;
    }

    public int getSelectedIndex() {
        int index = this.getTargetList().getSelectedRow();
        if (index >= 0 && index < this.listData.size()) {
            return index;
        }
        return 0;
    }

    protected void setSelectedIndex(int i) {
        this.getTargetList().getSelectionModel().setSelectionInterval(i, i);
    }

    protected void setData(Vector data) {
        this.getTargetList().setModel(new MyTableModel());
        this.getTargetList().getColumnModel().getColumn(1).setPreferredWidth(100);
        this.getTargetList().getColumnModel().getColumn(1).setMaxWidth(200);
        this.getTargetList().getColumnModel().getColumn(2).setPreferredWidth(40);
        this.getTargetList().getColumnModel().getColumn(2).setMaxWidth(100);
        this.getTargetList().getSelectionModel().setSelectionMode(0);
        this.getTargetList().getSelectionModel().addListSelectionListener(new TargetSelectionListener());
        ((DefaultTableCellRenderer)this.getTargetList().getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
    }

    protected void ensureIndexIsVisible(int selectedIndex) {
    }

    protected Component getViewComponent() {
        return this.getTargetList();
    }

    private JTable getTargetList() {
        if (this.targetList == null) {
            this.targetList = new MyTable();
            this.setData(null);
        }
        return this.targetList;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(TableEditorPanel.class);
        }
        return bundle.getString(s);
    }

    private class MyTableModel
    extends DefaultTableModel {
        private String[] columnNames = new String[]{TableEditorPanel.access$1100("ITEM"), TableEditorPanel.access$1100("CONFIGURATION"), TableEditorPanel.access$1100("BUILD")};

        private MyTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return TableEditorPanel.this.listData.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            return TableEditorPanel.this.listData.elementAt(row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Object element = TableEditorPanel.this.listData.elementAt(row);
            LibraryItem libraryItem = (LibraryItem)element;
            if (col == 0) {
                return libraryItem.canEdit();
            }
            if (col == 1) {
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    return ((LibraryItem.ProjectItem)libraryItem).getProject(TableEditorPanel.this.baseDir) != null;
                }
                return false;
            }
            return libraryItem instanceof LibraryItem.ProjectItem;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            LibraryItem libraryItem = (LibraryItem)TableEditorPanel.this.listData.elementAt(row);
            if (col == 0) {
                libraryItem.setValue((String)value);
                this.fireTableCellUpdated(row, col);
            } else if (col == 1) {
                MakeArtifact oldMakeArtifact = ((LibraryItem.ProjectItem)libraryItem).getMakeArtifact();
                boolean abs = CndPathUtilitities.isPathAbsolute((String)oldMakeArtifact.getProjectLocation());
                TableEditorPanel.this.listData.removeElementAt(row);
                MakeArtifact makeArtifact = ((MakeArtifactWrapper)value).getMakeArtifact();
                String projectLocation = makeArtifact.getProjectLocation();
                String workingDirectory = makeArtifact.getWorkingDirectory();
                if (!abs) {
                    projectLocation = CndPathUtilitities.toRelativePath((String)TableEditorPanel.this.baseDir, (String)projectLocation);
                    workingDirectory = CndPathUtilitities.toRelativePath((String)TableEditorPanel.this.baseDir, (String)workingDirectory);
                }
                makeArtifact.setProjectLocation(CndPathUtilitities.normalize((String)projectLocation));
                makeArtifact.setWorkingDirectory(CndPathUtilitities.normalize((String)workingDirectory));
                TableEditorPanel.this.listData.add(row, new LibraryItem.ProjectItem(makeArtifact));
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            } else {
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    MakeArtifact newMakeArtifact;
                    newMakeArtifact.setBuild(!(newMakeArtifact = ((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().clone()).getBuild());
                    TableEditorPanel.this.listData.removeElementAt(row);
                    TableEditorPanel.this.listData.add(row, new LibraryItem.ProjectItem(newMakeArtifact));
                }
                this.fireTableCellUpdated(row, 0);
                this.fireTableCellUpdated(row, 1);
                this.fireTableCellUpdated(row, 2);
            }
        }
    }

    private class MyTableCellRenderer
    extends DefaultTableCellRenderer {
        private MyTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int col) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, color, isSelected, hasFocus, row, col);
            Object element = TableEditorPanel.this.listData.elementAt(row);
            if (!(element instanceof LibraryItem)) {
                label.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/resources/blank.gif", (boolean)false));
                label.setToolTipText("unknown");
                return label;
            }
            LibraryItem libraryItem = (LibraryItem)element;
            if (col == 0) {
                Image iconImage = ImageUtilities.loadImage((String)libraryItem.getIconName());
                label.setToolTipText(libraryItem.getToolTip());
                if (libraryItem instanceof LibraryItem.ProjectItem && ((LibraryItem.ProjectItem)libraryItem).getProject(TableEditorPanel.this.baseDir) == null) {
                    iconImage = ImageUtilities.mergeImages((Image)iconImage, (Image)brokenProjectBadge, (int)8, (int)0);
                    label.setToolTipText(TableEditorPanel.getString("BROKEN") + label.getToolTipText());
                }
                label.setIcon(new ImageIcon(iconImage));
            } else if (col == 1) {
                label.setText("");
                label.setIcon(null);
                label.setToolTipText(null);
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    label.setText(((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().getConfigurationName());
                    label.setToolTipText(TableEditorPanel.getString("CLICK_TO_CHANGE"));
                    if (((LibraryItem.ProjectItem)libraryItem).getProject(TableEditorPanel.this.baseDir) == null) {
                        label.setToolTipText("");
                    }
                }
            } else {
                if (libraryItem instanceof LibraryItem.ProjectItem) {
                    JCheckBox checkBox = new JCheckBox();
                    checkBox.setSelected(((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().getBuild());
                    checkBox.setBackground(label.getBackground());
                    return checkBox;
                }
                label.setText("");
                label.setIcon(null);
                label.setToolTipText(null);
            }
            return label;
        }
    }

    private static class MakeArtifactWrapper {
        private MakeArtifact makeArtifact;

        public MakeArtifactWrapper(MakeArtifact makeArtifact) {
            this.makeArtifact = makeArtifact;
        }

        public MakeArtifact getMakeArtifact() {
            return this.makeArtifact;
        }

        public String toString() {
            return this.getMakeArtifact().getConfigurationName();
        }
    }

    private class MyTable
    extends JTable {
        public MyTable() {
            if (this.getRowHeight() < 19) {
                this.setRowHeight(19);
            }
            this.getAccessibleContext().setAccessibleDescription("");
            this.getAccessibleContext().setAccessibleName("");
        }

        @Override
        public boolean getShowHorizontalLines() {
            return false;
        }

        @Override
        public boolean getShowVerticalLines() {
            return false;
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int column) {
            return TableEditorPanel.this.myTableCellRenderer;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (col == 0) {
                return super.getCellEditor(row, col);
            }
            if (col == 1) {
                LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)TableEditorPanel.this.listData.elementAt(row);
                Project project = projectItem.getProject(TableEditorPanel.this.baseDir);
                if (project == null) {
                    return super.getCellEditor(row, col);
                }
                MakeArtifact[] artifacts = MakeArtifact.getMakeArtifacts(project);
                JComboBox<MakeArtifactWrapper> comboBox = new JComboBox<MakeArtifactWrapper>();
                for (int i = 0; i < artifacts.length; ++i) {
                    comboBox.addItem(new MakeArtifactWrapper(artifacts[i]));
                }
                return new DefaultCellEditor(comboBox);
            }
            LibraryItem libraryItem = (LibraryItem)TableEditorPanel.this.listData.elementAt(row);
            if (libraryItem instanceof LibraryItem.ProjectItem) {
                LibraryItem.ProjectItem projectItem = (LibraryItem.ProjectItem)TableEditorPanel.this.listData.elementAt(row);
                JCheckBox checkBox = new JCheckBox();
                checkBox.setSelected(((LibraryItem.ProjectItem)libraryItem).getMakeArtifact().getBuild());
                return new DefaultCellEditor(checkBox);
            }
            return super.getCellEditor(row, col);
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            TableEditorPanel.this.checkSelection();
        }
    }
}

