/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.DefaultMakefileWriter;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationWarningPanel;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.QmakeProjectWriter;
import org.netbeans.modules.cnd.makeproject.packaging.DummyPackager;
import org.netbeans.modules.cnd.makeproject.platform.Platform;
import org.netbeans.modules.cnd.makeproject.platform.Platforms;
import org.netbeans.modules.cnd.makeproject.spi.configurations.MakefileWriter;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ConfigurationMakefileWriter {
    private MakeConfigurationDescriptor projectDescriptor;

    public ConfigurationMakefileWriter(MakeConfigurationDescriptor projectDescriptor) {
        this.projectDescriptor = projectDescriptor;
    }

    public void write() {
        Collection<MakeConfiguration> okConfs = this.getOKConfigurations(true);
        this.cleanup(okConfs);
        this.writeMakefileImpl();
        for (MakeConfiguration conf : okConfs) {
            this.writeMakefileConf(conf);
            this.writePackagingScript(conf);
        }
        this.writeMakefileVariables(this.projectDescriptor);
    }

    public void writeMissingMakefiles() {
        Collection<MakeConfiguration> okConfs = this.getOKConfigurations(false);
        long xmlFileTimeStamp = new File(new File(this.projectDescriptor.getBaseDir(), "nbproject"), "configurations.xml").lastModified();
        for (MakeConfiguration conf : okConfs) {
            File file = new File(this.getMakefilePath(conf));
            if (!file.exists() || file.lastModified() < xmlFileTimeStamp) {
                this.writeMakefileConf(conf);
            }
            if ((file = new File(this.getPackageScriptPath(conf))).exists() && file.lastModified() >= xmlFileTimeStamp) continue;
            this.writePackagingScript(conf);
        }
    }

    private String getMakefilePath(MakeConfiguration conf) {
        return this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-" + conf.getName() + ".mk";
    }

    private String getPackageScriptPath(MakeConfiguration conf) {
        return this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Package-" + conf.getName() + ".bash";
    }

    private Collection<MakeConfiguration> getOKConfigurations(boolean showWarning) {
        ArrayList<MakeConfiguration> ok = new ArrayList<MakeConfiguration>();
        ArrayList<MakeConfiguration> noCompilerSet = new ArrayList<MakeConfiguration>();
        ArrayList<MakeConfiguration> wrongPlatform = new ArrayList<MakeConfiguration>();
        Configuration[] confs = this.projectDescriptor.getConfs().toArray();
        for (int i = 0; i < confs.length; ++i) {
            MakeConfiguration conf = (MakeConfiguration)confs[i];
            if (conf.getDevelopmentHost().isLocalhost() && CompilerSetManager.get((ExecutionEnvironment)conf.getDevelopmentHost().getExecutionEnvironment()).getPlatform() != conf.getDevelopmentHost().getBuildPlatformConfiguration().getValue()) {
                wrongPlatform.add(conf);
                continue;
            }
            if (conf.getCompilerSet().getCompilerSet() == null) {
                noCompilerSet.add(conf);
                continue;
            }
            ok.add(conf);
        }
        if (!wrongPlatform.isEmpty() && showWarning && MakeOptions.getInstance().getShowConfigurationWarning()) {
            ExecutionEnvironment execEnv = ExecutionEnvironmentFactory.fromUniqueID((String)"localhost");
            int platformID = CompilerSetManager.get((ExecutionEnvironment)execEnv).getPlatform();
            Platform platform = Platforms.getPlatform(platformID);
            StringBuilder list = new StringBuilder();
            for (MakeConfiguration c : wrongPlatform) {
                list.append(ConfigurationMakefileWriter.getString("CONF", c.getName(), c.getDevelopmentHost().getBuildPlatformConfiguration().getName())).append("\n");
            }
            final String msg = ConfigurationMakefileWriter.getString("TARGET_MISMATCH_TXT", platform.getDisplayName(), list.toString());
            final String title = ConfigurationMakefileWriter.getString("TARGET_MISMATCH_DIALOG_TITLE.TXT");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Object[] options = new Object[]{NotifyDescriptor.OK_OPTION};
                    DialogDescriptor nd = new DialogDescriptor((Object)new ConfigurationWarningPanel(msg), title, true, options, NotifyDescriptor.OK_OPTION, 0, null, null);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                }
            });
        }
        return ok;
    }

    private void cleanup(Collection<MakeConfiguration> okConfs) {
        ArrayList<MakeConfiguration> protectedConfs = new ArrayList<MakeConfiguration>();
        Configuration[] confs = this.projectDescriptor.getConfs().toArray();
        for (Configuration c : this.projectDescriptor.getConfs().toArray()) {
            MakeConfiguration conf = (MakeConfiguration)c;
            if (okConfs.contains(conf)) continue;
            protectedConfs.add(conf);
        }
        File folder = new File(this.projectDescriptor.getBaseDir(), "nbproject");
        File[] children = folder.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                String filename = children[i].getName();
                if (!filename.startsWith("Makefile-") && !filename.startsWith("Package-")) continue;
                boolean protect = false;
                for (MakeConfiguration conf : protectedConfs) {
                    if (!filename.equals("Makefile-" + conf.getName() + ".mk") && !filename.equals("Package-" + conf.getName() + ".bash")) continue;
                    protect = true;
                    break;
                }
                if (protect) continue;
                children[i].delete();
            }
        }
    }

    private void writeMakefileImpl() {
        String resource = "/org/netbeans/modules/cnd/makeproject/resources/MasterMakefile-impl.mk";
        InputStream is = null;
        FileOutputStream os = null;
        try {
            URL url = new URL("nbresloc:" + resource);
            is = url.openStream();
        }
        catch (Exception e) {
            is = MakeConfigurationDescriptor.class.getResourceAsStream(resource);
        }
        String outputFileName = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-impl.mk";
        try {
            os = new FileOutputStream(outputFileName);
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        if (is == null || os == null) {
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        String projectName = CndPathUtilitities.getBaseName((String)this.projectDescriptor.getBaseDir());
        StringBuilder configurations = new StringBuilder();
        for (int i = 0; i < this.projectDescriptor.getConfs().toArray().length; ++i) {
            configurations.append(this.projectDescriptor.getConfs().toArray()[i].getName());
            configurations.append(" ");
        }
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.indexOf("<PN>") >= 0) {
                    line = line.replaceFirst("<PN>", projectName);
                } else if (line.indexOf("<CNS>") >= 0) {
                    line = line.replaceFirst("<CNS>", configurations.toString());
                } else if (line.indexOf("<CN>") >= 0) {
                    line = line.replaceFirst("<CN>", this.projectDescriptor.getConfs().getConf(0).getName());
                }
                bw.write(line + "\n");
            }
            br.close();
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void writeMakefileConf(MakeConfiguration conf) {
        String makefileWriterClassName;
        String outputFileName = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-" + conf.getName() + ".mk";
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(outputFileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        MakefileWriter makefileWriter = null;
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet != null && (makefileWriterClassName = compilerSet.getCompilerFlavor().getToolchainDescriptor().getMakefileWriter()) != null) {
            Collection mwc = Lookup.getDefault().lookupAll(MakefileWriter.class);
            for (MakefileWriter instance : mwc) {
                if (!makefileWriterClassName.equals(instance.getClass().getName())) continue;
                makefileWriter = instance;
                break;
            }
            if (makefileWriter == null) {
                System.err.println("ERROR: class" + makefileWriterClassName + " is not found or is not instance of MakefileWriter");
            }
        }
        if (makefileWriter == null) {
            makefileWriter = new DefaultMakefileWriter();
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        try {
            makefileWriter.writePrelude(this.projectDescriptor, conf, bw);
            this.writeBuildTargets(makefileWriter, this.projectDescriptor, conf, bw);
            this.writeBuildTestTargets(makefileWriter, this.projectDescriptor, conf, bw);
            makefileWriter.writeRunTestTarget(this.projectDescriptor, conf, bw);
            makefileWriter.writeCleanTarget(this.projectDescriptor, conf, bw);
            makefileWriter.writeDependencyChecking(this.projectDescriptor, conf, bw);
            bw.flush();
            bw.close();
            if (conf.isQmakeConfiguration()) {
                new QmakeProjectWriter(this.projectDescriptor, conf).write();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private static boolean isDMake(CompilerSet compilerSet) {
        boolean dMakeSyntax = false;
        Tool makeTool = compilerSet.getTool((ToolKind)PredefinedToolKind.MakeTool);
        if (makeTool != null && makeTool.getFlavor().isSunStudioCompiler()) {
            dMakeSyntax = true;
        }
        return dMakeSyntax;
    }

    public static String getCompilerName(MakeConfiguration conf, PredefinedToolKind tool) {
        Tool compiler;
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet != null && (compiler = compilerSet.getTool((ToolKind)tool)) != null) {
            BasicCompilerConfiguration compilerConf = null;
            switch (tool) {
                case CCompiler: {
                    compilerConf = conf.getCCompilerConfiguration();
                    break;
                }
                case CCCompiler: {
                    compilerConf = conf.getCCCompilerConfiguration();
                    break;
                }
                case FortranCompiler: {
                    compilerConf = conf.getFortranCompilerConfiguration();
                    break;
                }
                case Assembler: {
                    compilerConf = conf.getAssemblerConfiguration();
                }
            }
            if (compilerConf != null && compilerConf.getTool().getModified()) {
                return compilerConf.getTool().getValue();
            }
            if (0 < compiler.getName().length()) {
                return compiler.getName();
            }
            if (compilerSet.isUrlPointer()) {
                return compiler.getDescriptor().getNames()[0];
            }
        }
        return "";
    }

    public static void writePrelude(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            return;
        }
        AbstractCompiler cCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
        AbstractCompiler ccCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
        AbstractCompiler fortranCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.FortranCompiler);
        AbstractCompiler assemblerCompiler = (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.Assembler);
        bw.write("#\n");
        bw.write("# Generated Makefile - do not edit!\n");
        bw.write("#\n");
        bw.write("# Edit the Makefile in the project folder instead (../Makefile). Each target\n");
        bw.write("# has a -pre and a -post target defined where you can add customized code.\n");
        bw.write("#\n");
        bw.write("# This makefile implements configuration specific macros and targets.\n");
        bw.write("\n");
        bw.write("\n");
        bw.write("# Environment\n");
        bw.write("MKDIR=mkdir\n");
        bw.write("CP=cp\n");
        bw.write("GREP=grep\n");
        bw.write("NM=nm\n");
        bw.write("CCADMIN=CCadmin\n");
        bw.write("RANLIB=" + conf.getArchiverConfiguration().getRanlibTool().getValue() + "\n");
        bw.write("CC=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.CCompiler) + "\n");
        bw.write("CCC=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.CCCompiler) + "\n");
        bw.write("CXX=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.CCCompiler) + "\n");
        bw.write("FC=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.FortranCompiler) + "\n");
        bw.write("AS=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.Assembler) + "\n");
        if (conf.getArchiverConfiguration().getTool().getModified()) {
            bw.write("AR=" + conf.getArchiverConfiguration().getTool().getValue() + "\n");
        }
        if (conf.isQmakeConfiguration()) {
            bw.write("QMAKE=" + ConfigurationMakefileWriter.getCompilerName(conf, PredefinedToolKind.QMakeTool) + "\n");
        }
        bw.write("\n");
        bw.write("# Macros\n");
        bw.write("CND_PLATFORM=" + conf.getVariant() + "\n");
        bw.write("CND_CONF=" + conf.getName() + "\n");
        bw.write("CND_DISTDIR=dist\n");
        bw.write("\n");
        bw.write("# Include project Makefile\n");
        bw.write("include " + projectDescriptor.getProjectMakefileName() + "\n");
        bw.write("\n");
        bw.write("# Object Directory\n");
        bw.write("OBJECTDIR=" + ConfigurationMakefileWriter.getObjectDir(conf) + "\n");
        bw.write("\n");
        bw.write("# Object Files\n");
        bw.write("OBJECTFILES=" + ConfigurationMakefileWriter.getObjectFiles(projectDescriptor, conf) + "\n");
        bw.write("\n");
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            bw.write("# Test Directory\n");
            bw.write("TESTDIR=" + ConfigurationMakefileWriter.getObjectDir(conf) + "/tests\n");
            bw.write("\n");
            bw.write("# Test Files\n");
            bw.write("TESTFILES=" + ConfigurationMakefileWriter.getTestTargetFiles(projectDescriptor, conf) + "\n");
        }
        bw.write("\n");
        if (cCompiler != null) {
            bw.write("# C Compiler Flags\n");
            bw.write("CFLAGS=" + conf.getCCompilerConfiguration().getCFlags(cCompiler) + "\n");
            bw.write("\n");
        }
        if (ccCompiler != null) {
            bw.write("# CC Compiler Flags\n");
            bw.write("CCFLAGS=" + conf.getCCCompilerConfiguration().getCCFlags(ccCompiler) + "\n");
            bw.write("CXXFLAGS=" + conf.getCCCompilerConfiguration().getCCFlags(ccCompiler) + "\n");
            bw.write("\n");
        }
        if (fortranCompiler != null) {
            bw.write("# Fortran Compiler Flags\n");
            bw.write("FFLAGS=" + conf.getFortranCompilerConfiguration().getFFlags(fortranCompiler) + "\n");
            bw.write("\n");
        }
        if (assemblerCompiler != null) {
            bw.write("# Assembler Flags\n");
            bw.write("ASFLAGS=" + conf.getAssemblerConfiguration().getAsFlags(assemblerCompiler) + "\n");
            bw.write("\n");
        }
        bw.write("# Link Libraries and Options\n");
        bw.write("LDLIBSOPTIONS=" + conf.getLinkerConfiguration().getLibraryItems() + "\n");
        bw.write("\n");
        if (conf.isQmakeConfiguration()) {
            String qmakeSpec = conf.getQmakeConfiguration().getQmakeSpec().getValue();
            if (qmakeSpec.length() == 0 && conf.getDevelopmentHost().getBuildPlatform() == 4) {
                qmakeSpec = CppUtils.getQmakeSpec(compilerSet, conf.getDevelopmentHost().getBuildPlatform());
            }
            if (!qmakeSpec.isEmpty()) {
                qmakeSpec = "-spec " + qmakeSpec + " ";
            }
            bw.write("nbproject/qt-${CND_CONF}.mk: nbproject/qt-${CND_CONF}.pro FORCE\n");
            bw.write("\t${QMAKE} VPATH=. " + qmakeSpec + "-o qttmp-${CND_CONF}.mk nbproject/qt-${CND_CONF}.pro\n");
            bw.write("\tmv -f qttmp-${CND_CONF}.mk nbproject/qt-${CND_CONF}.mk\n");
            if (conf.getDevelopmentHost().getBuildPlatform() == 3) {
                bw.write("\t@sed -e 's:\\\\\\(.\\):/\\1:g' nbproject/qt-${CND_CONF}.mk >nbproject/qt-${CND_CONF}.tmp\n");
                bw.write("\t@mv -f nbproject/qt-${CND_CONF}.tmp nbproject/qt-${CND_CONF}.mk\n");
            }
            bw.write(10);
            bw.write("FORCE:\n\n");
        }
    }

    protected void writeBuildTargets(MakefileWriter makefileWriter, MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, BufferedWriter bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        if (compilerSet == null) {
            bw.write(".build-conf:\n");
            bw.write("\t@echo 'Tool collection " + conf.getCompilerSet().getCompilerSetName().getValue() + " was missing when this makefile was generated'\n");
            bw.write("\t@echo 'Please specify existing tool collection in project properties'\n");
            bw.write("\t@exit 1\n\n");
            return;
        }
        if (conf.isCompileConfiguration()) {
            makefileWriter.writeBuildTarget(projectDescriptor, conf, bw);
            if (conf.isLinkerConfiguration()) {
                makefileWriter.writeLinkTarget(projectDescriptor, conf, bw);
            }
            if (conf.isArchiverConfiguration()) {
                makefileWriter.writeArchiveTarget(projectDescriptor, conf, bw);
            }
            if (conf.isCompileConfiguration()) {
                makefileWriter.writeCompileTargets(projectDescriptor, conf, bw);
            }
        } else if (conf.isMakefileConfiguration()) {
            makefileWriter.writeMakefileTarget(projectDescriptor, conf, bw);
        } else if (conf.isQmakeConfiguration()) {
            makefileWriter.writeQTTarget(projectDescriptor, conf, bw);
        }
        makefileWriter.writeSubProjectBuildTargets(projectDescriptor, conf, bw);
    }

    protected void writeBuildTestTargets(MakefileWriter makefileWriter, MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, BufferedWriter bw) throws IOException {
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                bw.write(".build-test-conf:\n");
                bw.write("\t@echo 'Tool collection " + conf.getCompilerSet().getCompilerSetName().getValue() + " was missing when this makefile was generated'\n");
                bw.write("\t@echo 'Please specify existing tool collection in project properties'\n");
                bw.write("\t@exit 1\n\n");
                return;
            }
            if (conf.isCompileConfiguration()) {
                makefileWriter.writeBuildTestTarget(projectDescriptor, conf, bw);
                if (conf.isLinkerConfiguration()) {
                    makefileWriter.writeLinkTestTarget(projectDescriptor, conf, bw);
                }
                if (conf.isCompileConfiguration()) {
                    makefileWriter.writeCompileTestTargets(projectDescriptor, conf, bw);
                }
            }
        }
    }

    public static void writeQTTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = CppUtils.normalizeDriveLetter(compilerSet, ConfigurationMakefileWriter.getOutput(conf));
        bw.write("# Build Targets\n");
        bw.write(".build-conf: ${BUILD_SUBPROJECTS} nbproject/qt-${CND_CONF}.mk\n");
        bw.write("\t\"${MAKE}\" -f nbproject/qt-${CND_CONF}.mk " + output + "\n\n");
        bw.write("build/" + conf.getName() + "/%.o: nbproject/qt-" + conf.getName() + ".mk\n");
        bw.write("\t$(MAKE) -f nbproject/qt-" + conf.getName() + ".mk \"$@\"\n");
    }

    public static void writeBuildTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = CppUtils.normalizeDriveLetter(compilerSet, ConfigurationMakefileWriter.getOutput(conf));
        bw.write("# Build Targets\n");
        bw.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
        bw.write("\t\"${MAKE}\"  -f nbproject/Makefile-" + conf.getName() + ".mk " + output + "\n\n");
    }

    public static void writeBuildTestTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            bw.write("# Build Test Targets\n");
            bw.write(".build-tests-conf: .build-conf ${TESTFILES}\n");
        }
    }

    public static void writeLinkTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = CppUtils.normalizeDriveLetter(compilerSet, ConfigurationMakefileWriter.getOutput(conf));
        LinkerConfiguration linkerConfiguration = conf.getLinkerConfiguration();
        output = CppUtils.normalizeDriveLetter(compilerSet, output);
        String command = ConfigurationMakefileWriter.getLinkerTool(projectDescriptor, conf, conf.getLinkerConfiguration(), compilerSet);
        command = command + linkerConfiguration.getOptions() + " ";
        command = command + "${OBJECTFILES} ";
        command = command + "${LDLIBSOPTIONS} ";
        String[] additionalDependencies = linkerConfiguration.getAdditionalDependencies().getValues();
        for (int i = 0; i < additionalDependencies.length; ++i) {
            bw.write(output + ": " + additionalDependencies[i] + "\n\n");
        }
        for (LibraryItem lib : linkerConfiguration.getLibrariesConfiguration().getValue()) {
            String libPath = lib.getPath();
            if (libPath == null || libPath.length() <= 0) continue;
            bw.write(output + ": " + CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, libPath)) + "\n\n");
        }
        bw.write(output + ": ${OBJECTFILES}\n");
        String folders = CndPathUtilitities.getDirName((String)output);
        if (folders != null) {
            bw.write("\t${MKDIR} -p " + folders + "\n");
        }
        bw.write("\t" + command + "\n");
    }

    private static String getLinkerTool(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, LinkerConfiguration linkerConfiguration, CompilerSet compilerSet) {
        String getPreferredCompiler = compilerSet.getCompilerFlavor().getToolchainDescriptor().getLinker().getPreferredCompiler();
        if (linkerConfiguration.getTool().getModified()) {
            return linkerConfiguration.getTool().getValue() + " ";
        }
        if (getPreferredCompiler != null) {
            if ("c".equals(getPreferredCompiler)) {
                return "${LINK.c} ";
            }
            if ("cpp".equals(getPreferredCompiler)) {
                return "${LINK.cc} ";
            }
            if ("fortran".equals(getPreferredCompiler)) {
                return "${LINK.f} ";
            }
        }
        if (conf.hasCPPFiles(projectDescriptor)) {
            return "${LINK.cc} ";
        }
        if (conf.hasFortranFiles(projectDescriptor)) {
            return "${LINK.f} ";
        }
        return "${LINK.c} ";
    }

    public static void writeLinkTestTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (conf.isCompileConfiguration()) {
            List<Folder> tests = ConfigurationMakefileWriter.getTests(projectDescriptor);
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            if (compilerSet == null) {
                return;
            }
            if (!tests.isEmpty()) {
                for (Folder folder : tests) {
                    LinkerConfiguration testLinkerConfiguration = folder.getFolderConfiguration(conf).getLinkerConfiguration();
                    String output = testLinkerConfiguration.getOutputValue();
                    ArrayList<LinkerConfiguration> linkerConfigurations = new ArrayList<LinkerConfiguration>();
                    linkerConfigurations.add(testLinkerConfiguration);
                    for (Folder parentFolder = folder.getParent(); parentFolder != null; parentFolder = parentFolder.getParent()) {
                        LinkerConfiguration linkerConfiguration;
                        FolderConfiguration folderConfiguration = parentFolder.getFolderConfiguration(conf);
                        if (folderConfiguration == null || (linkerConfiguration = folderConfiguration.getLinkerConfiguration()) == null) continue;
                        linkerConfigurations.add(linkerConfiguration);
                    }
                    CompilerSet cs = conf.getCompilerSet().getCompilerSet();
                    output = CppUtils.normalizeDriveLetter(cs, output);
                    String command = ConfigurationMakefileWriter.getLinkerTool(projectDescriptor, conf, testLinkerConfiguration, compilerSet);
                    command = command + "-o " + output + " ";
                    command = command + "$^ ";
                    command = command + "${LDLIBSOPTIONS} ";
                    ArrayList<String> additionalDependencies = new ArrayList<String>();
                    for (LinkerConfiguration lc : linkerConfigurations) {
                        additionalDependencies.addAll(lc.getAdditionalDependencies().getValuesAsList());
                    }
                    for (String dep : additionalDependencies) {
                        bw.write(output + ": " + dep + "\n\n");
                    }
                    for (LinkerConfiguration lc : linkerConfigurations) {
                        String libraryItems = lc.getLibraryItems();
                        if (libraryItems == null || libraryItems.isEmpty()) continue;
                        command = command + libraryItems + " ";
                    }
                    String objectFiles = "";
                    Item[] items = folder.getAllItemsAsArray();
                    for (int k = 0; k < items.length; ++k) {
                        if (items[k].hasHeaderOrSourceExtension(false, false)) continue;
                        String file = CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[k].getPath()));
                        String objectFile = file.replaceFirst("\\..*", ".o");
                        objectFiles = objectFiles + "${TESTDIR}/" + objectFile + " ";
                    }
                    objectFiles = objectFiles + "${OBJECTFILES:%.o=%_nomain.o}";
                    bw.write(output + ": " + objectFiles + "\n");
                    String folders = CndPathUtilitities.getDirName((String)output);
                    bw.write("\t${MKDIR} -p " + folders + "\n");
                    bw.write("\t" + command + "\n\n");
                }
            }
        }
    }

    public static void writeArchiveTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        String output = CppUtils.normalizeDriveLetter(compilerSet, ConfigurationMakefileWriter.getOutput(conf));
        ArchiverConfiguration archiverConfiguration = conf.getArchiverConfiguration();
        String command = "${AR} ";
        command = command + archiverConfiguration.getOptions() + " ";
        command = command + "${OBJECTFILES} ";
        bw.write(output + ": " + "${OBJECTFILES}" + "\n");
        String folders = CndPathUtilitities.getDirName((String)output);
        if (folders != null) {
            bw.write("\t${MKDIR} -p " + folders + "\n");
        }
        bw.write("\t${RM} " + output + "\n");
        bw.write("\t" + command + "\n");
        if (archiverConfiguration.getRunRanlib().getValue()) {
            bw.write("\t" + archiverConfiguration.getRunRanlib().getOption() + " " + output + "\n");
        }
    }

    public static void writeCompileTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        Item[] items = projectDescriptor.getProjectItems();
        if (conf.isCompileConfiguration()) {
            String target = null;
            String folders = null;
            String file = null;
            String command = null;
            String comment = null;
            String additionalDep = null;
            for (int i = 0; i < items.length; ++i) {
                CompilerSet compilerSet;
                ItemConfiguration itemConfiguration;
                Folder folder = items[i].getFolder();
                if (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder() || (itemConfiguration = items[i].getItemConfiguration(conf)).getExcluded().getValue() || (compilerSet = conf.getCompilerSet().getCompilerSet()) == null) continue;
                boolean dMake = ConfigurationMakefileWriter.isDMake(compilerSet);
                file = CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath()));
                command = "";
                comment = null;
                additionalDep = null;
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
                    BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                    target = compilerConfiguration.getOutputFile(items[i], conf, false);
                    if (compiler != null && compiler.getDescriptor() != null) {
                        String fromLinker = "";
                        if (conf.getConfigurationType().getValue() == 2 && conf.getLinkerConfiguration().getPICOption().getValue()) {
                            fromLinker = " " + conf.getLinkerConfiguration().getPICOption(compilerSet);
                        }
                        command = command + compilerConfiguration.getOptions(compiler) + fromLinker + " ";
                        if (conf.getDependencyChecking().getValue() && compiler.getDependencyGenerationOption().length() > 0) {
                            command = "${RM} $@.d\n\t" + command + compiler.getDependencyGenerationOption() + " ";
                        }
                        if (items[i].hasHeaderOrSourceExtension(false, false)) {
                            String flags = compiler.getDescriptor().getPrecompiledHeaderFlags();
                            if (flags == null) {
                                command = "# command to precompile header ";
                                comment = "Current compiler does not support header precompilation";
                            } else {
                                command = command + compiler.getDescriptor().getPrecompiledHeaderFlags() + " ";
                            }
                        } else {
                            command = command + compiler.getDescriptor().getOutputObjectFileFlags() + target + " ";
                        }
                        command = command + CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath(true)));
                    }
                    additionalDep = compilerConfiguration.getAdditionalDependencies().getValue();
                } else if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
                    CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
                    if (!customToolConfiguration.getModified()) continue;
                    target = dMake ? customToolConfiguration.getOutputs().getValue(" + ") : customToolConfiguration.getOutputs().getValue();
                    command = customToolConfiguration.getCommandLine().getValue();
                    comment = customToolConfiguration.getDescription().getValue();
                    additionalDep = customToolConfiguration.getAdditionalDependencies().getValue();
                } else assert (false);
                folders = CndPathUtilitities.getDirName(target);
                bw.write("\n");
                bw.write(target + ": ");
                if (conf.getRebuildPropChanged().getValue()) {
                    bw.write("nbproject/Makefile-${CND_CONF}.mk ");
                }
                if (additionalDep != null) {
                    bw.write(file + " " + additionalDep + "\n");
                } else {
                    bw.write(file + "\n");
                }
                if (folders != null) {
                    bw.write("\t${MKDIR} -p " + folders + "\n");
                }
                if (comment != null) {
                    bw.write("\t@echo " + comment + "\n");
                }
                bw.write("\t" + command + "\n");
            }
        }
    }

    public static void writeCompileTestTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (conf.isCompileConfiguration()) {
            List<Folder> tests = ConfigurationMakefileWriter.getTests(projectDescriptor);
            if (!tests.isEmpty()) {
                for (Folder folder : tests) {
                    Item[] items = folder.getAllItemsAsArray();
                    String target = null;
                    String folders = null;
                    String file = null;
                    String command = null;
                    String comment = null;
                    String additionalDep = null;
                    for (int i = 0; i < items.length; ++i) {
                        CompilerSet compilerSet;
                        ItemConfiguration itemConfiguration = items[i].getItemConfiguration(conf);
                        if (itemConfiguration == null || itemConfiguration.getExcluded().getValue() || (compilerSet = conf.getCompilerSet().getCompilerSet()) == null) continue;
                        boolean dMake = ConfigurationMakefileWriter.isDMake(compilerSet);
                        file = CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath()));
                        command = "";
                        comment = null;
                        additionalDep = null;
                        if (itemConfiguration.isCompilerToolConfiguration()) {
                            AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
                            BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                            target = compilerConfiguration.getOutputFile(items[i], conf, false);
                            if (compiler != null && compiler.getDescriptor() != null) {
                                command = command + compilerConfiguration.getOptions(compiler) + " ";
                                if (conf.getDependencyChecking().getValue() && compiler.getDependencyGenerationOption().length() > 0) {
                                    command = "${RM} $@.d\n\t" + command + compiler.getDependencyGenerationOption() + " ";
                                }
                                if (items[i].hasHeaderOrSourceExtension(false, false)) {
                                    String flags = compiler.getDescriptor().getPrecompiledHeaderFlags();
                                    if (flags == null) {
                                        command = "# command to precompile header ";
                                        comment = "Current compiler does not support header precompilation";
                                    } else {
                                        command = command + compiler.getDescriptor().getPrecompiledHeaderFlags() + " ";
                                    }
                                } else {
                                    command = command + compiler.getDescriptor().getOutputObjectFileFlags() + target + " ";
                                }
                                command = command + CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath(true)));
                            }
                            additionalDep = compilerConfiguration.getAdditionalDependencies().getValue();
                        } else if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
                            CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
                            if (!customToolConfiguration.getModified()) continue;
                            target = dMake ? customToolConfiguration.getOutputs().getValue(" + ") : customToolConfiguration.getOutputs().getValue();
                            command = customToolConfiguration.getCommandLine().getValue();
                            comment = customToolConfiguration.getDescription().getValue();
                            additionalDep = customToolConfiguration.getAdditionalDependencies().getValue();
                        } else assert (false);
                        target = target.replace("${OBJECTDIR}", "${TESTDIR}");
                        command = command.replace("${OBJECTDIR}", "${TESTDIR}");
                        folders = CndPathUtilitities.getDirName((String)target);
                        bw.write("\n");
                        if (additionalDep != null) {
                            bw.write(target + ": " + file + " " + additionalDep + "\n");
                        } else {
                            bw.write(target + ": " + file + "\n");
                        }
                        if (folders != null) {
                            bw.write("\t${MKDIR} -p " + folders + "\n");
                        }
                        if (comment != null) {
                            bw.write("\t@echo " + comment + "\n");
                        }
                        bw.write("\t" + command + "\n\n");
                    }
                }
            }
            ConfigurationMakefileWriter.writeCompileTargetsWithoutMain(projectDescriptor, conf, bw);
        }
    }

    public static void writeCompileTargetsWithoutMain(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        Item[] items = projectDescriptor.getProjectItems();
        if (conf.isCompileConfiguration()) {
            String target = null;
            String folders = null;
            String file = null;
            String command = null;
            String comment = null;
            String additionalDep = null;
            for (int i = 0; i < items.length; ++i) {
                String nomainTarget;
                CompilerSet compilerSet;
                ItemConfiguration itemConfiguration;
                Folder folder = items[i].getFolder();
                if (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder() || (itemConfiguration = items[i].getItemConfiguration(conf)).getExcluded().getValue() || (compilerSet = conf.getCompilerSet().getCompilerSet()) == null) continue;
                boolean dMake = ConfigurationMakefileWriter.isDMake(compilerSet);
                file = CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath()));
                command = "";
                comment = null;
                additionalDep = null;
                String name = items[i].getName().replaceAll("\\..*", "");
                if (itemConfiguration.isCompilerToolConfiguration()) {
                    AbstractCompiler compiler = (AbstractCompiler)compilerSet.getTool((ToolKind)itemConfiguration.getTool());
                    BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                    target = compilerConfiguration.getOutputFile(items[i], conf, false);
                    nomainTarget = target.replace(name, name + "_nomain");
                    if (compiler != null && compiler.getDescriptor() != null) {
                        String fromLinker = "";
                        if (conf.getConfigurationType().getValue() == 2 && conf.getLinkerConfiguration().getPICOption().getValue()) {
                            fromLinker = " " + conf.getLinkerConfiguration().getPICOption(compilerSet);
                        }
                        command = command + compilerConfiguration.getOptions(compiler) + fromLinker + " -Dmain=__nomain ";
                        if (conf.getDependencyChecking().getValue() && compiler.getDependencyGenerationOption().length() > 0) {
                            command = "${RM} $@.d;\\\n\t    " + command + compiler.getDependencyGenerationOption() + " ";
                        }
                        if (items[i].hasHeaderOrSourceExtension(false, false)) {
                            String flags = compiler.getDescriptor().getPrecompiledHeaderFlags();
                            if (flags == null) {
                                command = "# command to precompile header ";
                                comment = "Current compiler does not support header precompilation";
                            } else {
                                command = command + compiler.getDescriptor().getPrecompiledHeaderFlags() + " ";
                            }
                        } else {
                            command = command + compiler.getDescriptor().getOutputObjectFileFlags() + nomainTarget + " ";
                        }
                        command = command + CndPathUtilitities.escapeOddCharacters((String)CppUtils.normalizeDriveLetter(compilerSet, items[i].getPath(true)));
                    }
                    additionalDep = compilerConfiguration.getAdditionalDependencies().getValue();
                } else if (itemConfiguration.getTool() == PredefinedToolKind.CustomTool) {
                    CustomToolConfiguration customToolConfiguration = itemConfiguration.getCustomToolConfiguration();
                    if (!customToolConfiguration.getModified()) continue;
                    target = dMake ? customToolConfiguration.getOutputs().getValue(" + ") : customToolConfiguration.getOutputs().getValue();
                    command = customToolConfiguration.getCommandLine().getValue();
                    comment = customToolConfiguration.getDescription().getValue();
                    additionalDep = customToolConfiguration.getAdditionalDependencies().getValue();
                } else assert (false);
                nomainTarget = target.replace(name, name + "_nomain");
                folders = CndPathUtilitities.getDirName((String)target);
                bw.write("\n");
                if (additionalDep != null) {
                    bw.write(nomainTarget + ": " + target + " " + file + " " + additionalDep + "\n");
                } else {
                    bw.write(nomainTarget + ": " + target + " " + file + "\n");
                }
                if (folders != null) {
                    bw.write("\t${MKDIR} -p " + folders + "\n");
                }
                if (comment != null) {
                    bw.write("\t@echo " + comment + "\n");
                }
                bw.write("\t@NMOUTPUT=`${NM} " + target + "`; \\\n");
                bw.write("\tif (echo \"$$NMOUTPUT\" | ${GREP} '|main$$') || \\\n");
                bw.write("\t   (echo \"$$NMOUTPUT\" | ${GREP} 'T main$$') || \\\n");
                bw.write("\t   (echo \"$$NMOUTPUT\" | ${GREP} 'T _main$$'); \\\n");
                bw.write("\tthen  \\\n");
                bw.write("\t    " + command + ";\\\n");
                bw.write("\telse  \\\n");
                bw.write("\t    ${CP} " + target + " " + nomainTarget + ";\\\n");
                bw.write("\tfi\n");
            }
            bw.write("\n");
        }
    }

    public static void writeRunTestTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (ConfigurationMakefileWriter.hasTests(projectDescriptor)) {
            CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
            bw.write("# Run Test Targets\n");
            bw.write(".test-conf:\n");
            bw.write("\t@if [ \"${TEST}\" = \"\" ]; \\\n");
            bw.write("\tthen  \\\n");
            for (Folder folder : ConfigurationMakefileWriter.getTests(projectDescriptor)) {
                String target = folder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                bw.write("\t    " + target + " || true; \\\n");
            }
            bw.write("\telse  \\\n");
            bw.write("\t    ./${TEST} || true; \\\n");
            bw.write("\tfi\n\n");
        }
    }

    public static void writeMakefileTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        MakefileConfiguration makefileConfiguration = conf.getMakefileConfiguration();
        String target = makefileConfiguration.getOutput().getValue();
        String cwd = makefileConfiguration.getBuildCommandWorkingDirValue();
        String command = makefileConfiguration.getBuildCommand().getValue();
        bw.write("# Build Targets\n");
        bw.write(".build-conf: ${BUILD_SUBPROJECTS}\n");
        bw.write("\tcd " + CndPathUtilitities.escapeOddCharacters((String)CndPathUtilitities.normalize((String)cwd)) + " && " + command + "\n");
    }

    public static void writeSubProjectBuildTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        bw.write("\n");
        bw.write("# Subprojects\n");
        bw.write(".build-subprojects:\n");
        LibrariesConfiguration librariesConfiguration = null;
        if (conf.isLinkerConfiguration()) {
            librariesConfiguration = conf.getLinkerConfiguration().getLibrariesConfiguration();
            for (LibraryItem item : librariesConfiguration.getValue()) {
                if (!(item instanceof LibraryItem.ProjectItem)) continue;
                LibraryItem projectItem = item;
                MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)projectItem).getMakeArtifact();
                String location = makeArtifact.getWorkingDirectory();
                if (!makeArtifact.getBuild()) continue;
                bw.write("\tcd " + CndPathUtilitities.escapeOddCharacters((String)CndPathUtilitities.normalize((String)location)) + " && " + makeArtifact.getBuildCommand() + "\n");
            }
        }
        for (LibraryItem item : conf.getRequiredProjectsConfiguration().getValue()) {
            MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)item).getMakeArtifact();
            String location = makeArtifact.getWorkingDirectory();
            if (!makeArtifact.getBuild()) continue;
            bw.write("\tcd " + CndPathUtilitities.escapeOddCharacters((String)CndPathUtilitities.normalize((String)location)) + " && " + makeArtifact.getBuildCommand() + "\n");
        }
        bw.write("\n");
    }

    private static void writeSubProjectCleanTargets(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        bw.write("\n");
        bw.write("# Subprojects\n");
        bw.write(".clean-subprojects:\n");
        LibrariesConfiguration librariesConfiguration = null;
        if (conf.isLinkerConfiguration()) {
            librariesConfiguration = conf.getLinkerConfiguration().getLibrariesConfiguration();
            for (LibraryItem item : librariesConfiguration.getValue()) {
                if (!(item instanceof LibraryItem.ProjectItem)) continue;
                LibraryItem projectItem = item;
                MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)projectItem).getMakeArtifact();
                String location = makeArtifact.getWorkingDirectory();
                if (!makeArtifact.getBuild()) continue;
                bw.write("\tcd " + CndPathUtilitities.escapeOddCharacters((String)CndPathUtilitities.normalize((String)location)) + " && " + makeArtifact.getCleanCommand() + "\n");
            }
        }
        for (LibraryItem item : conf.getRequiredProjectsConfiguration().getValue()) {
            MakeArtifact makeArtifact = ((LibraryItem.ProjectItem)item).getMakeArtifact();
            String location = makeArtifact.getWorkingDirectory();
            if (!makeArtifact.getBuild()) continue;
            bw.write("\tcd " + CndPathUtilitities.escapeOddCharacters((String)CndPathUtilitities.normalize((String)location)) + " && " + makeArtifact.getCleanCommand() + "\n");
        }
    }

    public static void writeCleanTarget(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        bw.write("# Clean Targets\n");
        bw.write(".clean-conf: ${CLEAN_SUBPROJECTS}");
        if (conf.isQmakeConfiguration()) {
            bw.write(" nbproject/qt-" + conf.getName() + ".mk");
        }
        bw.write(10);
        if (conf.isCompileConfiguration()) {
            bw.write("\t${RM} -r build/" + conf.getName() + "\n");
            bw.write("\t${RM} " + ConfigurationMakefileWriter.getOutput(conf) + "\n");
            if (conf.getCompilerSet().getCompilerSet() != null && conf.getCompilerSet().getCompilerSet().getCompilerFlavor().isSunStudioCompiler() && conf.hasCPPFiles(projectDescriptor)) {
                bw.write("\t${CCADMIN} -clean\n");
            }
            if (conf.hasFortranFiles(projectDescriptor)) {
                bw.write("\t${RM} *.mod\n");
            }
            Item[] items = projectDescriptor.getProjectItems();
            for (int i = 0; i < items.length; ++i) {
                ItemConfiguration itemConfiguration = items[i].getItemConfiguration(conf);
                if (itemConfiguration.getExcluded().getValue() || itemConfiguration.getTool() != PredefinedToolKind.CustomTool || !itemConfiguration.getCustomToolConfiguration().getModified()) continue;
                bw.write("\t${RM} " + itemConfiguration.getCustomToolConfiguration().getOutputs().getValue() + "\n");
            }
        } else if (conf.isMakefileConfiguration()) {
            MakefileConfiguration makefileConfiguration = conf.getMakefileConfiguration();
            String target = makefileConfiguration.getOutput().getValue();
            String cwd = makefileConfiguration.getBuildCommandWorkingDirValue();
            String command = makefileConfiguration.getCleanCommand().getValue();
            bw.write("\tcd " + CndPathUtilitities.escapeOddCharacters((String)CndPathUtilitities.normalize((String)cwd)) + " && " + command + "\n");
        } else if (conf.isQmakeConfiguration()) {
            bw.write("\t$(MAKE) -f nbproject/qt-" + conf.getName() + ".mk distclean\n");
        }
        ConfigurationMakefileWriter.writeSubProjectCleanTargets(projectDescriptor, conf, bw);
    }

    public static void writeDependencyChecking(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf, Writer bw) throws IOException {
        if (conf.getDependencyChecking().getValue() && !conf.isMakefileConfiguration() && !conf.isQmakeConfiguration() && conf.getCompilerSet().getCompilerSet() != null) {
            bw.write("\n");
            bw.write("# Enable dependency checking\n");
            bw.write(".dep.inc: .depcheck-impl\n");
            bw.write("\n");
            bw.write("include .dep.inc\n");
        }
    }

    private static String getOutput(MakeConfiguration conf) {
        String output = conf.getOutputValue();
        switch (conf.getDevelopmentHost().getBuildPlatform()) {
            case 3: {
                switch (conf.getConfigurationType().getValue()) {
                    case 1: 
                    case 4: {
                        output = ConfigurationMakefileWriter.mangleAppnameWin(output);
                    }
                }
            }
        }
        return conf.expandMacros(output);
    }

    private static String mangleAppnameWin(String original) {
        if (original.endsWith(".exe")) {
            return original;
        }
        return original + ".exe";
    }

    public static String getObjectDir(MakeConfiguration conf) {
        return "build/${CND_CONF}/${CND_PLATFORM}";
    }

    private static String getObjectFiles(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf) {
        Item[] items = projectDescriptor.getProjectItems();
        StringBuilder linkObjects = new StringBuilder();
        if (conf.isCompileConfiguration()) {
            for (int x = 0; x < items.length; ++x) {
                ItemConfiguration itemConfiguration;
                Folder folder = items[x].getFolder();
                if (folder.isTest() || folder.isTestLogicalFolder() || folder.isTestRootFolder() || (itemConfiguration = items[x].getItemConfiguration(conf)).getExcluded().getValue() || !itemConfiguration.isCompilerToolConfiguration() || items[x].hasHeaderOrSourceExtension(false, false)) continue;
                BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
                linkObjects.append(" \\\n\t");
                linkObjects.append(compilerConfiguration.getOutputFile(items[x], conf, false));
            }
        }
        return linkObjects.toString();
    }

    private static String getTestTargetFiles(MakeConfigurationDescriptor projectDescriptor, MakeConfiguration conf) {
        StringBuilder testTargets = new StringBuilder();
        if (conf.isCompileConfiguration()) {
            for (Folder folder : ConfigurationMakefileWriter.getTests(projectDescriptor)) {
                testTargets.append(" \\\n\t");
                String target = folder.getFolderConfiguration(conf).getLinkerConfiguration().getOutputValue();
                testTargets.append(target);
            }
        }
        return testTargets.toString();
    }

    private void writeMakefileVariables(MakeConfigurationDescriptor conf) {
        String outputFileName = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Makefile-variables.mk";
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(outputFileName);
        }
        catch (Exception e) {
            // empty catch block
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        try {
            this.writeMakefileVariablesBody(bw, conf);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void writeMakefileVariablesBody(BufferedWriter bw, MakeConfigurationDescriptor conf) throws IOException {
        bw.write("#\n");
        bw.write("# Generated - do not edit!\n");
        bw.write("#\n");
        bw.write("# NOCDDL\n");
        bw.write("#\n");
        bw.write("CND_BASEDIR=`pwd`\n");
        bw.write("CND_BUILDDIR=build\n");
        bw.write("CND_DISTDIR=dist\n");
        Configuration[] confs = this.projectDescriptor.getConfs().toArray();
        for (int i = 0; i < confs.length; ++i) {
            MakeConfiguration makeConf = (MakeConfiguration)confs[i];
            bw.write("# " + makeConf.getName() + " configuration");
            bw.write("\n");
            bw.write("CND_PLATFORM_" + makeConf.getName() + "=" + makeConf.getVariant());
            bw.write("\n");
            String outputPath = makeConf.expandMacros(makeConf.getOutputValue());
            String outputDir = CndPathUtilitities.getDirName((String)outputPath);
            if (outputDir == null) {
                outputDir = "";
            }
            String outputName = CndPathUtilitities.getBaseName((String)outputPath);
            bw.write("CND_ARTIFACT_DIR_" + makeConf.getName() + "=" + outputDir);
            bw.write("\n");
            bw.write("CND_ARTIFACT_NAME_" + makeConf.getName() + "=" + outputName);
            bw.write("\n");
            bw.write("CND_ARTIFACT_PATH_" + makeConf.getName() + "=" + outputPath);
            bw.write("\n");
            PackagerDescriptor packager = PackagerManager.getDefault().getPackager(makeConf.getPackagingConfiguration().getType().getValue());
            outputPath = makeConf.expandMacros(makeConf.getPackagingConfiguration().getOutputValue());
            if (!packager.isOutputAFolder()) {
                outputDir = CndPathUtilitities.getDirName((String)outputPath);
                if (outputDir == null) {
                    outputDir = "";
                }
                outputName = CndPathUtilitities.getBaseName((String)outputPath);
            } else {
                outputDir = outputPath;
                outputPath = "";
                outputName = "";
            }
            bw.write("CND_PACKAGE_DIR_" + makeConf.getName() + "=" + outputDir);
            bw.write("\n");
            bw.write("CND_PACKAGE_NAME_" + makeConf.getName() + "=" + outputName);
            bw.write("\n");
            bw.write("CND_PACKAGE_PATH_" + makeConf.getName() + "=" + outputPath);
            bw.write("\n");
        }
    }

    private void writePackagingScript(MakeConfiguration conf) {
        String outputFileName = this.projectDescriptor.getBaseDir() + '/' + "nbproject" + '/' + "Package-" + conf.getName() + ".bash";
        if (conf.getPackagingConfiguration().getFiles().getValue().isEmpty()) {
            return;
        }
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(conf.getPackagingConfiguration().getType().getValue());
        if (packager == null || packager instanceof DummyPackager) {
            return;
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(outputFileName);
        }
        catch (Exception e) {
            System.err.println("Cannot create FileOutputStream from " + outputFileName);
            e.printStackTrace(System.err);
            return;
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(os));
        try {
            this.writePackagingScriptBody(bw, conf);
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void writePackagingScriptBody(BufferedWriter bw, MakeConfiguration conf) throws IOException {
        String tmpDirName = "tmp-packaging";
        String tmpdir = ConfigurationMakefileWriter.getObjectDir(conf) + "/" + tmpDirName;
        PackagingConfiguration packagingConfiguration = conf.getPackagingConfiguration();
        String output = packagingConfiguration.getOutputValue();
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        bw.write("#!/bin/bash");
        if (conf.getPackagingConfiguration().getVerbose().getValue()) {
            bw.write(" -x");
        }
        bw.write("\n");
        bw.write("\n");
        bw.write("#\n");
        bw.write("# Generated - do not edit!\n");
        bw.write("#\n");
        bw.write("\n");
        bw.write("# Macros\n");
        bw.write("TOP=`pwd`\n");
        bw.write("CND_PLATFORM=" + conf.getVariant() + "\n");
        bw.write("CND_CONF=" + conf.getName() + "\n");
        bw.write("CND_DISTDIR=dist\n");
        bw.write("NBTMPDIR=" + tmpdir + "\n");
        bw.write("TMPDIRNAME=" + tmpDirName + "\n");
        String projectOutput = conf.getOutputValue();
        if (projectOutput == null || projectOutput.length() == 0) {
            projectOutput = "MissingOutputInProject";
        }
        bw.write("OUTPUT_PATH=" + projectOutput + "\n");
        bw.write("OUTPUT_BASENAME=" + CndPathUtilitities.getBaseName((String)projectOutput) + "\n");
        bw.write("PACKAGE_TOP_DIR=" + (packagingConfiguration.getTopDirValue().length() > 0 ? packagingConfiguration.getTopDirValue() + "/" : "") + "\n");
        bw.write("\n");
        bw.write("# Functions\n");
        bw.write("function checkReturnCode\n");
        bw.write("{\n");
        bw.write("    rc=$?\n");
        bw.write("    if [ $rc != 0 ]\n");
        bw.write("    then\n");
        bw.write("        exit $rc\n");
        bw.write("    fi\n");
        bw.write("}\n");
        bw.write("function makeDirectory\n");
        bw.write("# $1 directory path\n");
        bw.write("# $2 permission (optional)\n");
        bw.write("{\n");
        bw.write("    mkdir -p \"$1\"\n");
        bw.write("    checkReturnCode\n");
        bw.write("    if [ \"$2\" != \"\" ]\n");
        bw.write("    then\n");
        bw.write("      chmod $2 \"$1\"\n");
        bw.write("      checkReturnCode\n");
        bw.write("    fi\n");
        bw.write("}\n");
        bw.write("function copyFileToTmpDir\n");
        bw.write("# $1 from-file path\n");
        bw.write("# $2 to-file path\n");
        bw.write("# $3 permission\n");
        bw.write("{\n");
        bw.write("    cp \"$1\" \"$2\"\n");
        bw.write("    checkReturnCode\n");
        bw.write("    if [ \"$3\" != \"\" ]\n");
        bw.write("    then\n");
        bw.write("        chmod $3 \"$2\"\n");
        bw.write("        checkReturnCode\n");
        bw.write("    fi\n");
        bw.write("}\n");
        bw.write("\n");
        bw.write("# Setup\n");
        bw.write("cd \"${TOP}\"\n");
        if (packager.isOutputAFolder()) {
            bw.write("mkdir -p " + output + "\n");
        } else {
            bw.write("mkdir -p " + CndPathUtilitities.getDirName((String)output) + "\n");
        }
        bw.write("rm -rf ${NBTMPDIR}\n");
        bw.write("mkdir -p ${NBTMPDIR}\n");
        bw.write("\n");
        packager.getShellFileWriter().writeShellScript(bw, conf, packagingConfiguration);
        bw.write("# Cleanup\n");
        bw.write("cd \"${TOP}\"\n");
        bw.write("rm -rf ${NBTMPDIR}\n");
    }

    private static boolean hasTests(MakeConfigurationDescriptor projectDescriptor) {
        return !ConfigurationMakefileWriter.getTests(projectDescriptor).isEmpty();
    }

    private static List<Folder> getTests(MakeConfigurationDescriptor projectDescriptor) {
        Folder root = projectDescriptor.getLogicalFolders();
        Folder testRootFolder = null;
        for (Folder folder : root.getFolders()) {
            if (!folder.isTestRootFolder()) continue;
            testRootFolder = folder;
            break;
        }
        if (testRootFolder != null) {
            return testRootFolder.getAllTests();
        }
        return Collections.emptyList();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)s);
    }

    private static String getString(String s, String arg1) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)s, (Object)arg1);
    }

    private static String getString(String s, String arg1, String arg2) {
        return NbBundle.getMessage(ConfigurationMakefileWriter.class, (String)s, (Object)arg1, (Object)arg2);
    }
}

