/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObjectProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.spi.project.ProjectConfiguration;
import org.openide.util.NbBundle;

public abstract class Configuration
implements ProjectConfiguration {
    private String baseDir;
    private String name;
    private boolean defaultConfiguration;
    private PropertyChangeSupport pcs = null;
    private final Map<String, ConfigurationAuxObject> auxObjectsMap = Collections.synchronizedSortedMap(new TreeMap());
    private Configuration cloneOf;

    protected Configuration(String baseDir, String name) {
        this.baseDir = baseDir;
        this.name = name;
        this.defaultConfiguration = false;
        this.pcs = new PropertyChangeSupport(this);
        ConfigurationAuxObjectProvider[] auxObjectProviders = ConfigurationDescriptorProvider.getAuxObjectProviders();
        for (int i = 0; i < auxObjectProviders.length; ++i) {
            ConfigurationAuxObject pao = auxObjectProviders[i].factoryCreate(baseDir, this.pcs);
            pao.initialize();
            String id = pao.getId();
            if (this.auxObjectsMap.containsKey(id)) {
                System.err.println("Init duplicated ConfigurationAuxObject id=" + id);
            }
            this.auxObjectsMap.put(id, pao);
        }
    }

    public void setCloneOf(Configuration profile) {
        this.cloneOf = profile;
    }

    public Configuration getCloneOf() {
        return this.cloneOf;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public String getDisplayName() {
        return this.getName();
    }

    public boolean isDefault() {
        return this.defaultConfiguration;
    }

    public void setDefault(boolean b) {
        this.defaultConfiguration = b;
    }

    public String toString() {
        if (this.isDefault()) {
            return this.getDisplayName() + " " + Configuration.getString("ActiveTxt");
        }
        return this.getDisplayName();
    }

    public void addAuxObject(ConfigurationAuxObject pao) {
        String id = pao.getId();
        if (this.auxObjectsMap.containsKey(id)) {
            System.err.println("Add duplicated ConfigurationAuxObject id=" + id);
        }
        this.auxObjectsMap.put(id, pao);
    }

    public ConfigurationAuxObject removeAuxObject(ConfigurationAuxObject pao) {
        return this.auxObjectsMap.remove(pao.getId());
    }

    public ConfigurationAuxObject removeAuxObject(String id) {
        return this.auxObjectsMap.remove(id);
    }

    public ConfigurationAuxObject getAuxObject(String id) {
        return this.auxObjectsMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigurationAuxObject[] getAuxObjects() {
        ArrayList<ConfigurationAuxObject> list;
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            list = new ArrayList<ConfigurationAuxObject>(this.auxObjectsMap.values());
        }
        return list.toArray(new ConfigurationAuxObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAuxObjects(List<ConfigurationAuxObject> v) {
        Map<String, ConfigurationAuxObject> map = this.auxObjectsMap;
        synchronized (map) {
            this.auxObjectsMap.clear();
            for (ConfigurationAuxObject object : v) {
                this.auxObjectsMap.put(object.getId(), object);
            }
        }
    }

    public abstract Configuration cloneConf();

    public abstract void assign(Configuration var1);

    public abstract Configuration copy();

    public void cloneConf(Configuration clone) {
        clone.setDefault(this.isDefault());
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public RunProfile getProfile() {
        return (RunProfile)this.getAuxObject("runprofile");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(Configuration.class, (String)s);
    }
}

