/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DebuggerChooserConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.SelectExecutablePanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ProjectActionSupport {
    private static ProjectActionSupport instance;
    private final List<ProjectActionHandlerFactory> handlerFactories;
    private InputOutput mainTab = null;
    private InputOutput runTab = null;
    private HandleEvents mainTabHandler = null;
    private ArrayList<String> tabNames = new ArrayList();
    private final Object lock = new Object();

    private ProjectActionSupport() {
        this.handlerFactories = new ArrayList<ProjectActionHandlerFactory>(Lookup.getDefault().lookupAll(ProjectActionHandlerFactory.class));
    }

    public static synchronized ProjectActionSupport getInstance() {
        if (instance == null) {
            instance = new ProjectActionSupport();
        }
        return instance;
    }

    private static void refreshProjectFiles(Project project) {
        try {
            SourceGroup[] groups;
            HashSet<File> files = new HashSet<File>();
            FileObject projectFileObject = project.getProjectDirectory();
            File f = FileUtil.toFile((FileObject)projectFileObject);
            if (f != null) {
                files.add(f);
            }
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : groups = sources.getSourceGroups("generic")) {
                FileObject rootFolder = sourceGroup.getRootFolder();
                File file = FileUtil.toFile((FileObject)rootFolder);
                if (file == null) continue;
                files.add(file);
            }
            File[] array = files.toArray(new File[files.size()]);
            if (array.length > 0) {
                FileUtil.refreshFor((File[])array);
            }
            MakeLogicalViewProvider.refreshBrokenItems(project);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean canHandle(MakeConfiguration conf, ProjectActionEvent.Type type) {
        DebuggerChooserConfiguration chooser;
        CustomizerNode node;
        if (conf != null && (node = (chooser = conf.getDebuggerChooserConfiguration()).getNode()) instanceof ProjectActionHandlerFactory && ((ProjectActionHandlerFactory)((Object)node)).canHandle(type, conf)) {
            return true;
        }
        for (ProjectActionHandlerFactory factory : this.handlerFactories) {
            if (!factory.canHandle(type, conf)) continue;
            return true;
        }
        return false;
    }

    public void fireActionPerformed(ProjectActionEvent[] paes) {
        new HandleEvents(paes, null).go();
    }

    public void fireActionPerformed(ProjectActionEvent[] paes, ProjectActionHandler preferredHandler) {
        new HandleEvents(paes, preferredHandler).go();
    }

    private static String getString(String s) {
        return NbBundle.getBundle(ProjectActionSupport.class).getString(s);
    }

    private static String getString(String s, String arg) {
        return NbBundle.getMessage(ProjectActionSupport.class, (String)s, (Object)arg);
    }

    private static final class RerunAction
    extends AbstractAction {
        private HandleEvents handleEvents;

        public RerunAction(HandleEvents handleEvents) {
            this.handleEvents = handleEvents;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/rerun.png", (boolean)false));
            this.putValue("ShortDescription", ProjectActionSupport.getString("TargetExecutor.RerunAction.rerun"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            this.handleEvents.reRun();
        }
    }

    private static final class StopAction
    extends AbstractAction {
        private HandleEvents handleEvents;

        public StopAction(HandleEvents handleEvents) {
            this.handleEvents = handleEvents;
            this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/stop.png", (boolean)false));
            this.putValue("ShortDescription", ProjectActionSupport.getString("TargetExecutor.StopAction.stop"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.isEnabled()) {
                return;
            }
            this.setEnabled(false);
            if (this.handleEvents.getCurrentHandler() != null) {
                this.handleEvents.getCurrentHandler().cancel();
            }
        }
    }

    private final class HandleEvents
    implements ExecutionListener {
        private InputOutput ioTab = null;
        private InputOutput runIoTab = null;
        private final ProjectActionEvent[] paes;
        private String tabName;
        private String tabNameSeq;
        private int currentAction = 0;
        private StopAction sa = null;
        private RerunAction ra = null;
        private List<BuildActionsProvider.BuildAction> additional;
        private ProgressHandle progressHandle = null;
        private final ProjectActionHandler customHandler;
        private ProjectActionHandler currentHandler = null;
        private final boolean reuseTabs;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HandleEvents(ProjectActionEvent[] paes, ProjectActionHandler customHandler) {
            this.paes = paes;
            this.customHandler = customHandler;
            this.currentAction = 0;
            this.reuseTabs = MakeOptions.getInstance().getReuse();
            if (this.reuseTabs) {
                Object object = ProjectActionSupport.this.lock;
                synchronized (object) {
                    if (ProjectActionSupport.this.mainTabHandler == null) {
                        if (ProjectActionSupport.this.mainTab != null) {
                            ProjectActionSupport.this.mainTab.closeInputOutput();
                            ProjectActionSupport.this.mainTab = null;
                        }
                        if (ProjectActionSupport.this.runTab != null) {
                            ProjectActionSupport.this.runTab.closeInputOutput();
                            ProjectActionSupport.this.runTab = null;
                        }
                    }
                    this.tabNameSeq = this.tabName = this.getTabName(paes);
                    if (ProjectActionSupport.this.tabNames.contains(this.tabName)) {
                        int seq = 2;
                        while (true) {
                            this.tabNameSeq = this.tabName + " #" + seq;
                            if (!ProjectActionSupport.this.tabNames.contains(this.tabNameSeq)) break;
                            ++seq;
                        }
                    }
                    ProjectActionSupport.this.tabNames.add(this.tabNameSeq);
                    this.ioTab = this.getIOTab(this.tabNameSeq, true);
                    if (ProjectActionSupport.this.mainTabHandler == null) {
                        ProjectActionSupport.this.mainTab = this.ioTab;
                        ProjectActionSupport.this.mainTabHandler = this;
                    }
                }
            } else {
                this.tabNameSeq = this.tabName = this.getTabName(paes);
                this.ioTab = this.getIOTab(this.tabName, false);
            }
        }

        private Action[] getActions(String name) {
            ArrayList<Action> list = new ArrayList<Action>();
            if (this.sa == null) {
                this.sa = new StopAction(this);
            }
            if (this.ra == null) {
                this.ra = new RerunAction(this);
            }
            list.add(this.sa);
            list.add(this.ra);
            if (this.additional == null) {
                this.additional = BuildActionsProvider.getDefault().getActions(name, this.paes);
            }
            list.addAll(this.additional);
            return list.toArray(new Action[list.size()]);
        }

        private String getTabName(ProjectActionEvent[] paes) {
            MakeConfiguration conf;
            String projectName = ProjectUtils.getInformation((Project)paes[0].getProject()).getDisplayName();
            StringBuilder name = new StringBuilder(projectName);
            name.append(" (");
            for (int i = 0; i < paes.length; ++i) {
                if (i >= 2) {
                    name.append("...");
                    break;
                }
                name.append(paes[i].getActionName());
                if (i >= paes.length - 1) continue;
                name.append(", ");
            }
            name.append(")");
            if (paes.length > 0 && !(conf = paes[0].getConfiguration()).getDevelopmentHost().isLocalhost()) {
                String hkey = conf.getDevelopmentHost().getHostKey();
                name.append(" - ").append(hkey);
            }
            return name.toString();
        }

        private InputOutput getTab() {
            return this.ioTab;
        }

        private InputOutput getRunTab() {
            return this.runIoTab;
        }

        private ProgressHandle createProgressHandle() {
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.tabNameSeq, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    HandleEvents.this.sa.actionPerformed(null);
                    return true;
                }
            }, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HandleEvents.this.getTab().select();
                }
            });
            handle.setInitialDelay(0);
            return handle;
        }

        private ProgressHandle createProgressHandleNoCancel() {
            ProgressHandle handle = ProgressHandleFactory.createHandle((String)this.tabNameSeq, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HandleEvents.this.getTab().select();
                }
            });
            handle.setInitialDelay(0);
            return handle;
        }

        private InputOutput getIOTab(String name, boolean reuse) {
            InputOutput tab;
            Action[] actions = this.getActions(name);
            if (reuse) {
                tab = IOProvider.getDefault().getIO(name, false);
                tab.closeInputOutput();
            }
            tab = IOProvider.getDefault().getIO(name, actions);
            try {
                tab.getOut().reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.progressHandle = this.createProgressHandle();
            this.progressHandle.start();
            return tab;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InputOutput getRunIO(ProjectActionEvent pae, boolean reuse) {
            InputOutput io = null;
            String TERM_PROVIDER = "Terminal";
            IOProvider termProvider = IOProvider.get((String)"Terminal");
            if (termProvider != null) {
                String name = this.getTabName(new ProjectActionEvent[]{pae});
                Action[] actions = this.getActions(pae.getActionName());
                if (reuse) {
                    Object object = ProjectActionSupport.this.lock;
                    synchronized (object) {
                        io = this.runIoTab;
                        if (io == null) {
                            io = termProvider.getIO(name, false);
                            io.closeInputOutput();
                        }
                        this.runIoTab = io = termProvider.getIO(name, actions);
                        if (ProjectActionSupport.this.runTab == null && ProjectActionSupport.this.mainTabHandler == this) {
                            ProjectActionSupport.this.runTab = this.runIoTab;
                        }
                    }
                } else {
                    this.runIoTab = io = termProvider.getIO(name, actions);
                }
            }
            return io;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reRun() {
            this.currentAction = 0;
            this.getTab().closeInputOutput();
            Object object = ProjectActionSupport.this.lock;
            synchronized (object) {
                if (this.runIoTab != null) {
                    this.runIoTab.closeInputOutput();
                    this.runIoTab = null;
                }
                ProjectActionSupport.this.tabNames.add(this.tabNameSeq);
            }
            try {
                this.getTab().getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.progressHandle = this.createProgressHandle();
            this.progressHandle.start();
            if (SwingUtilities.isEventDispatchThread()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        HandleEvents.this.go();
                    }
                });
            } else {
                this.go();
            }
        }

        private void go() {
            LifecycleManager.getDefault().saveAll();
            this.currentHandler = null;
            this.sa.setEnabled(false);
            this.ra.setEnabled(false);
            if (this.currentAction >= this.paes.length) {
                return;
            }
            ProjectActionEvent pae = this.paes[this.currentAction];
            if (!this.checkProject(pae)) {
                this.progressHandle.finish();
                return;
            }
            if (!(pae.getType() != ProjectActionEvent.PredefinedType.RUN && pae.getType() != ProjectActionEvent.PredefinedType.DEBUG && pae.getType() != ProjectActionEvent.PredefinedType.DEBUG_LOAD_ONLY && pae.getType() != ProjectActionEvent.PredefinedType.DEBUG_STEPINTO && pae.getType() != ProjectActionEvent.PredefinedType.CHECK_EXECUTABLE && pae.getType() != ProjectActionEvent.PredefinedType.CUSTOM_ACTION || this.checkExecutable(pae) && pae.getType() != ProjectActionEvent.PredefinedType.CHECK_EXECUTABLE)) {
                this.progressHandle.finish();
                return;
            }
            InputOutput io = this.ioTab;
            int consoleType = pae.getProfile().getConsoleType().getValue();
            if (consoleType == 3 && (io = this.getRunIO(pae, this.reuseTabs)) == null) {
                io = this.ioTab;
            }
            if (pae.getType() == ProjectActionEvent.PredefinedType.CUSTOM_ACTION && this.customHandler != null) {
                this.initHandler(this.customHandler, pae, this.paes);
                this.customHandler.execute(io);
            } else {
                boolean foundFactory = false;
                for (ProjectActionHandlerFactory factory : ProjectActionSupport.this.handlerFactories) {
                    if (!factory.canHandle(pae.getType(), pae.getConfiguration())) continue;
                    ProjectActionHandler handler = this.currentHandler = factory.createHandler();
                    this.initHandler(handler, pae, this.paes);
                    handler.execute(io);
                    foundFactory = true;
                    break;
                }
                if (!foundFactory) {
                    this.progressHandle.finish();
                }
            }
        }

        private void initHandler(ProjectActionHandler handler, ProjectActionEvent pae, ProjectActionEvent[] paes) {
            handler.init(pae, paes);
            this.progressHandle.finish();
            this.progressHandle = handler.canCancel() ? this.createProgressHandle() : this.createProgressHandleNoCancel();
            this.progressHandle.start();
            this.sa.setEnabled(handler.canCancel());
            handler.addExecutionListener(this);
        }

        public ProjectActionHandler getCurrentHandler() {
            return this.currentHandler;
        }

        public void executionStarted(int pid) {
            if (this.additional != null) {
                for (BuildActionsProvider.BuildAction action : this.additional) {
                    action.setStep(this.currentAction);
                    action.executionStarted(pid);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionFinished(int rc) {
            ProjectActionEvent.Type type;
            if (this.additional != null) {
                for (BuildActionsProvider.BuildAction action : this.additional) {
                    ((ExecutionListener)action).executionFinished(rc);
                }
            }
            if ((type = this.paes[this.currentAction].getType()) == ProjectActionEvent.PredefinedType.BUILD || type == ProjectActionEvent.PredefinedType.CLEAN || type == ProjectActionEvent.PredefinedType.BUILD_TESTS) {
                ProjectActionSupport.refreshProjectFiles(this.paes[this.currentAction].getProject());
            }
            if (this.currentAction >= this.paes.length - 1 || rc != 0) {
                Object object = ProjectActionSupport.this.lock;
                synchronized (object) {
                    if (ProjectActionSupport.this.mainTabHandler == this) {
                        ProjectActionSupport.this.mainTabHandler = null;
                    }
                    ProjectActionSupport.this.tabNames.remove(this.tabNameSeq);
                }
                this.sa.setEnabled(false);
                this.ra.setEnabled(true);
                this.progressHandle.finish();
                return;
            }
            if (rc == 0) {
                ++this.currentAction;
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        HandleEvents.this.go();
                    }
                });
            }
        }

        private boolean checkProject(ProjectActionEvent pae) {
            FileObject nbproject;
            FileObject projectDirectory;
            Project project = pae.getProject();
            if (project != null && (CndUtils.isUnitTestMode() || OpenProjects.getDefault().isProjectOpen(project)) && (projectDirectory = project.getProjectDirectory()) != null && (nbproject = projectDirectory.getFileObject("nbproject")) != null) {
                File file = FileUtil.toFile((FileObject)nbproject);
                return file != null && file.exists();
            }
            return false;
        }

        private boolean checkExecutable(ProjectActionEvent pae) {
            String executable = pae.getExecutable();
            if (executable.length() == 0) {
                SelectExecutablePanel panel = new SelectExecutablePanel(pae.getConfiguration());
                DialogDescriptor descriptor = new DialogDescriptor((Object)panel, ProjectActionSupport.getString("SELECT_EXECUTABLE"));
                panel.setDialogDescriptor(descriptor);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                if (descriptor.getValue() == DialogDescriptor.OK_OPTION) {
                    MakeConfiguration makeConfiguration = pae.getConfiguration();
                    executable = panel.getExecutable();
                    executable = CndPathUtilitities.naturalize((String)executable);
                    executable = CndPathUtilitities.toRelativePath((String)makeConfiguration.getBaseDir(), (String)executable);
                    executable = CndPathUtilitities.normalize((String)executable);
                    makeConfiguration.getMakefileConfiguration().getOutput().setValue(executable);
                    ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)pae.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class);
                    if (pdp != null) {
                        pdp.getConfigurationDescriptor().setModified();
                    }
                    if (pae.getType() == ProjectActionEvent.PredefinedType.RUN) {
                        pae.setExecutable(executable);
                    } else {
                        pae.setExecutable(makeConfiguration.getMakefileConfiguration().getAbsOutput());
                    }
                } else {
                    return false;
                }
            }
            if (!CndPathUtilitities.isPathAbsolute((String)executable)) {
                String runDir = pae.getProfile().getRunDir();
                if (runDir == null || runDir.length() == 0) {
                    executable = CndPathUtilitities.toAbsolutePath((String)pae.getConfiguration().getBaseDir(), (String)executable);
                } else {
                    runDir = CndPathUtilitities.toAbsolutePath((String)pae.getConfiguration().getBaseDir(), (String)runDir);
                    executable = CndPathUtilitities.toAbsolutePath((String)runDir, (String)executable);
                }
                executable = CndPathUtilitities.normalize((String)executable);
            }
            if (CndPathUtilitities.isPathAbsolute((String)executable)) {
                MakeConfiguration conf = pae.getConfiguration();
                boolean ok = true;
                if (conf != null && !conf.getDevelopmentHost().isLocalhost()) {
                    CommandProvider cmd;
                    ExecutionEnvironment execEnv = conf.getDevelopmentHost().getExecutionEnvironment();
                    if (!pae.isFinalExecutable()) {
                        PathMap mapper = HostInfoProvider.getMapper((ExecutionEnvironment)execEnv);
                        executable = mapper.getRemotePath(executable, true);
                    }
                    if ((cmd = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class)) != null) {
                        ok = cmd.run(execEnv, "test", null, new String[]{"-x", executable, "-a", "-f", executable}) == 0;
                    }
                } else {
                    File file = new File(executable);
                    if (!file.exists()) {
                        file = new File(executable + ".exe");
                    }
                    if (!file.exists() || file.isDirectory()) {
                        ok = false;
                    }
                }
                if (!ok) {
                    String errormsg = ProjectActionSupport.getString("EXECUTABLE_DOESNT_EXISTS", executable);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)errormsg, 0));
                    return false;
                }
            }
            pae.setExecutable(executable);
            pae.setFinalExecutable();
            return true;
        }
    }
}

