/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api;

import java.util.ResourceBundle;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class ProjectActionEvent {
    private final Project project;
    private final Type type;
    private String executable;
    private final MakeConfiguration configuration;
    private final RunProfile profile;
    private final boolean wait;
    private final Lookup context;
    private boolean isFinalExecutable;
    private static ResourceBundle bundle;

    public ProjectActionEvent(Project project, Type type, String executable, MakeConfiguration configuration, RunProfile profile, boolean wait) {
        this(project, type, executable, configuration, profile, wait, Lookup.EMPTY);
    }

    public ProjectActionEvent(Project project, Type type, String executable, MakeConfiguration configuration, RunProfile profile, boolean wait, Lookup context) {
        this.project = project;
        this.type = type;
        this.executable = executable;
        this.configuration = configuration;
        this.profile = profile;
        this.wait = wait;
        this.context = context;
    }

    public Project getProject() {
        return this.project;
    }

    public final Lookup getContext() {
        return this.context;
    }

    public Type getType() {
        return this.type;
    }

    public String getActionName() {
        return this.type.getLocalizedName();
    }

    public String getExecutable() {
        return this.executable;
    }

    public MakeConfiguration getConfiguration() {
        return this.configuration;
    }

    public RunProfile getProfile() {
        if (this.profile != null) {
            return this.profile;
        }
        return this.configuration.getProfile();
    }

    public boolean getWait() {
        return this.wait;
    }

    void setExecutable(String executable) {
        this.executable = executable;
    }

    void setFinalExecutable() {
        this.isFinalExecutable = true;
    }

    boolean isFinalExecutable() {
        return this.isFinalExecutable;
    }

    public String toString() {
        return "PAE " + this.type + " " + this.getActionName() + " exec: " + this.getExecutable();
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ProjectActionEvent.class);
        }
        return bundle.getString(s);
    }

    public static enum PredefinedType implements Type
    {
        BUILD("Build"),
        CLEAN("Clean"),
        RUN("Run"),
        DEBUG("Debug"),
        DEBUG_STEPINTO("Debug"),
        DEBUG_LOAD_ONLY("Debug"),
        CHECK_EXECUTABLE("CheckExecutable"),
        CUSTOM_ACTION("Custom"),
        BUILD_TESTS("BuildTests"),
        TEST("Test");

        private final String localizedName;

        private PredefinedType(String resourceNamePrefix) {
            this.localizedName = ProjectActionEvent.getString(resourceNamePrefix + "ActionName");
        }

        @Override
        public String getLocalizedName() {
            return this.localizedName;
        }

        @Override
        public void setLocalizedName(String name) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Type {
        public int ordinal();

        public String name();

        public String getLocalizedName();

        public void setLocalizedName(String var1);
    }
}

