/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.disassembly.DisassemblyService;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.NbBundle;

public class ToggleBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private final Logger log = Logger.getLogger("cnd.breakpoint.annotations");

    public ToggleBreakpointActionProvider() {
        EditorContextBridge.getContext().addPropertyChangeListener(this);
    }

    public void doAction(Object o) {
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        int ln = EditorContextBridge.getContext().getCurrentLineNumber();
        String url = EditorContextBridge.getContext().getCurrentURL();
        if (url.trim().equals("")) {
            return;
        }
        CndBreakpoint lb = ToggleBreakpointActionProvider.findBreakpoint(url, ln);
        if (lb != null) {
            this.log.fine("ToggleBreakpointActionProvider.doAction: Removing breakpoint at " + lb.getPath() + ":" + lb.getLineNumber());
            d.removeBreakpoint((Breakpoint)lb);
            return;
        }
        DisassemblyService disProvider = EditorContextBridge.getCurrentDisassemblyService();
        if (disProvider != null && disProvider.isDis(url)) {
            lb = AddressBreakpoint.create(disProvider.getLineAddress(ln));
            lb.setPrintText(NbBundle.getBundle(ToggleBreakpointActionProvider.class).getString("CTL_Address_Breakpoint_Print_Text"));
            this.log.fine("ToggleBreakpointActionProvider.doAction: Adding disassembly breakpoint at " + lb.getPath() + ":" + lb.getLineNumber());
            d.addBreakpoint((Breakpoint)lb);
            return;
        }
        lb = LineBreakpoint.create(url, ln);
        this.log.fine("ToggleBreakpointActionProvider.doAction: Adding breakpoint at " + lb.getPath() + ":" + lb.getLineNumber());
        d.addBreakpoint((Breakpoint)lb);
    }

    static CndBreakpoint findBreakpoint(String url, int lineNumber) {
        Breakpoint[] breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints();
        DisassemblyService disProvider = EditorContextBridge.getCurrentDisassemblyService();
        boolean inDis = disProvider != null && disProvider.isDis(url);
        for (Breakpoint b : breakpoints) {
            AddressBreakpoint ab;
            if (b instanceof LineBreakpoint) {
                LineBreakpoint lb = (LineBreakpoint)b;
                if (!lb.getURL().equals(url) || lb.getLineNumber() != lineNumber) continue;
                return lb;
            }
            if (!inDis || !(b instanceof AddressBreakpoint) || disProvider.getBreakpointLine(ab = (AddressBreakpoint)b) != lineNumber) continue;
            return ab;
        }
        return null;
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        int lnum = EditorContextBridge.getContext().getCurrentLineNumber();
        String mimeType = EditorContextBridge.getContext().getCurrentMIMEType();
        boolean isValid = (MIMENames.isFortranOrHeaderOrCppOrC((String)mimeType) || mimeType.equals("text/x-asm")) && lnum > 0;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, isValid);
    }
}

