/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.asm.core.hyperlink;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.cnd.asm.core.assistance.GoToLabelAction;
import org.netbeans.modules.cnd.asm.core.dataobjects.AsmObjectUtilities;
import org.netbeans.modules.cnd.asm.model.AsmState;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.windows.TopComponent;

public class AsmHyperlinkProvider
implements HyperlinkProvider {
    private Document lastDocument;
    private int[] lastResult;
    private final GoToLabelAction labelResolver = new GoToLabelAction();

    public AsmHyperlinkProvider() {
        this.lastResult = new int[]{-1, -1, -1};
    }

    public boolean isHyperlinkPoint(Document doc, int offset) {
        int[] res;
        AsmState state = AsmObjectUtilities.getAccessor(doc).getState();
        this.lastDocument = doc;
        if (state != null && (res = this.labelResolver.computeLabel(state, offset))[0] != -1) {
            this.lastResult = res;
            return true;
        }
        return false;
    }

    public int[] getHyperlinkSpan(Document doc, int offset) {
        if (doc != this.lastDocument && !this.checkResult()) {
            return null;
        }
        return new int[]{this.lastResult[0], this.lastResult[1]};
    }

    public void performClickAction(Document doc, int offset) {
        if (doc != this.lastDocument || !this.checkResult()) {
            return;
        }
        DataObject ob = NbEditorUtilities.getDataObject((Document)doc);
        int position = this.lastResult[2];
        if (!this.openFileInEditor(ob)) {
            return;
        }
        EditorCookie ed = (EditorCookie)ob.getCookie(EditorCookie.class);
        if (ed != null) {
            try {
                ed.openDocument();
            }
            catch (IOException ex) {
                return;
            }
            JEditorPane pane = ed.getOpenedPanes()[0];
            pane.setCaretPosition(position);
            TopComponent tc = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, pane);
            if (tc != null) {
                tc.requestActive();
            }
        }
    }

    private boolean checkResult() {
        return this.lastResult[0] != -1 && this.lastResult[1] != -1 && this.lastResult[2] != -1;
    }

    private boolean openFileInEditor(DataObject ob) {
        EditCookie ck = (EditCookie)ob.getCookie(EditCookie.class);
        if (ck != null) {
            ck.edit();
            return true;
        }
        OpenCookie oc = (OpenCookie)ob.getCookie(OpenCookie.class);
        if (oc != null) {
            oc.open();
            return true;
        }
        return false;
    }
}

