/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.platform.installer;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.common.KeysAndValues;
import org.netbeans.modules.javacard.ri.platform.installer.DevicePropertiesPanel;
import org.netbeans.modules.javacard.ri.platform.installer.KeysAndValuesEditablePropsAdapter;
import org.netbeans.modules.javacard.ri.platform.installer.PlatformInfo;
import org.netbeans.modules.javacard.ri.platform.installer.PlatformPanel;
import org.netbeans.modules.javacard.ri.platform.installer.RIPlatformFactory;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.propdos.AntStyleResolvingProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class JavacardPlatformWizardIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor>,
ChangeListener {
    private FileObject baseDir;
    private DetectionPanel firstPanel;
    private PropertiesPanel secondPanel;
    private String displayName;
    private PlatformInfo info;
    private static final String PROP_DISPLAY_NAME = "platformDisplayName";
    private static final String PROP_INFO = "platformInfo";
    private int ix = 0;
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private boolean inChange;

    JavacardPlatformWizardIterator(FileObject baseDir) {
        this.baseDir = baseDir;
    }

    public Set instantiate() throws IOException {
        final Set[] result = new Set[1];
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(JavacardPlatformWizardIterator.class, (String)"PROGRESS_CREATING_PLATFORM"));
        final JDialog dlg = GuiUtils.createModalProgressDialog((ProgressHandle)handle, (boolean)false);
        final Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = JavacardPlatformWizardIterator.this.instantiate(handle);
                    dlg.setVisible(false);
                    dlg.dispose();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                RequestProcessor.getDefault().post(r);
            }
        });
        dlg.setVisible(true);
        return result[0] == null ? Collections.EMPTY_SET : result[0];
    }

    public Set instantiate(ProgressHandle h) throws IOException {
        EditableProperties deviceSettingsFromWizard = null;
        if (this.secondPanel != null && this.secondPanel.comp != null) {
            deviceSettingsFromWizard = new EditableProperties(true);
            this.secondPanel.comp.write(new KeysAndValuesEditablePropsAdapter(deviceSettingsFromWizard));
        }
        RIPlatformFactory f = new RIPlatformFactory(this.info, deviceSettingsFromWizard, this.baseDir, h, this.displayName);
        FileObject platformDef = f.createPlatform();
        DataObject dob = DataObject.find((FileObject)platformDef);
        HashSet<Object> result = new HashSet<Object>();
        result.add(dob.getLookup().lookup(JavacardPlatform.class));
        return result;
    }

    public void initialize(WizardDescriptor w) {
        w.putProperty(PROP_DISPLAY_NAME, (Object)this.displayName);
    }

    public void uninitialize(WizardDescriptor w) {
        String nm = (String)w.getProperty(PROP_DISPLAY_NAME);
        if (nm != null) {
            this.displayName = nm;
            if (this.firstPanel != null) {
                this.firstPanel.setDisplayName(nm);
            }
        }
        this.firstPanel = null;
        this.secondPanel = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        if (this.firstPanel == null && this.ix == 0) {
            this.firstPanel = new DetectionPanel();
            this.firstPanel.addChangeListener(this);
        }
        if (this.secondPanel == null && this.ix == 1) {
            this.secondPanel = new PropertiesPanel();
            this.secondPanel.addChangeListener(this);
        }
        return this.ix == 0 ? this.firstPanel : this.secondPanel;
    }

    public String name() {
        return NbBundle.getMessage(JavacardPlatformWizardIterator.class, (String)"MSG_DETECT_PLATFORM");
    }

    private boolean isRi() {
        return this.firstPanel == null ? true : this.firstPanel.isRi;
    }

    public boolean hasNext() {
        return this.isRi() ? this.ix == 0 : false;
    }

    public boolean hasPrevious() {
        return this.isRi() ? this.ix == 1 : false;
    }

    public void nextPanel() {
        this.ix = 1;
    }

    public void previousPanel() {
        this.ix = 0;
    }

    public void addChangeListener(ChangeListener arg0) {
        this.supp.addChangeListener(arg0);
    }

    public void removeChangeListener(ChangeListener arg0) {
        this.supp.removeChangeListener(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.inChange) {
            return;
        }
        this.inChange = true;
        try {
            this.supp.fireChange();
        }
        finally {
            this.inChange = false;
        }
    }

    void change() {
        this.stateChanged(null);
    }

    private final class PropertiesPanel
    implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
    ChangeListener {
        private final ChangeSupport supp = new ChangeSupport((Object)this);
        private DevicePropertiesPanel comp;
        boolean inStateChanged;

        private PropertiesPanel() {
        }

        public boolean isFinishPanel() {
            return true;
        }

        public Component getComponent() {
            if (this.comp == null) {
                this.comp = new DevicePropertiesPanel();
                this.comp.addChangeListener(this);
            }
            return this.comp;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(WizardDescriptor wiz) {
            AntStyleResolvingProperties a;
            this.getComponent();
            this.comp.setWizardDescriptor(wiz);
            PlatformInfo info = (PlatformInfo)wiz.getProperty(JavacardPlatformWizardIterator.PROP_INFO);
            EditableProperties prototypeValues = info.getDeviceDefaults();
            if (prototypeValues != null) {
                a = new AntStyleResolvingProperties(true);
                a.putAll((Map)prototypeValues);
                this.comp.read((KeysAndValues<?>)new KeysAndValues.PropertiesAdapter((Properties)a));
            }
            a = new AntStyleResolvingProperties(true);
            for (Map.Entry e : wiz.getProperties().entrySet()) {
                if (e.getKey() == null || e.getValue() == null) continue;
                a.put(e.getKey(), e.getValue());
            }
            this.comp.read((KeysAndValues<?>)new KeysAndValues.PropertiesAdapter((Properties)a));
        }

        public void storeSettings(WizardDescriptor wiz) {
            if (this.comp != null) {
                this.comp.write((KeysAndValues<?>)new KeysAndValues.WizardDescriptorAdapter(wiz));
            }
        }

        public boolean isValid() {
            return this.comp == null ? false : this.comp.isAllDataValid();
        }

        public void addChangeListener(ChangeListener arg0) {
            this.supp.addChangeListener(arg0);
        }

        public void removeChangeListener(ChangeListener arg0) {
            this.supp.removeChangeListener(arg0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            this.supp.fireChange();
            if (this.inStateChanged) {
                return;
            }
            this.inStateChanged = true;
            try {
                this.supp.fireChange();
            }
            finally {
                this.inStateChanged = false;
            }
        }
    }

    private final class DetectionPanel
    implements WizardDescriptor.FinishablePanel<WizardDescriptor>,
    ChangeListener,
    PropertyChangeListener {
        private PlatformPanel comp;
        boolean isRi = true;

        private DetectionPanel() {
        }

        private PlatformPanel createComponent() {
            if (this.comp == null) {
                this.comp = new PlatformPanel(JavacardPlatformWizardIterator.this.baseDir);
            }
            return this.comp;
        }

        public Component getComponent() {
            assert (EventQueue.isDispatchThread());
            if (this.comp == null) {
                this.comp = this.createComponent();
                this.comp.addChangeListener(JavacardPlatformWizardIterator.this);
                this.comp.addChangeListener(this);
                this.comp.addPropertyChangeListener(this);
            }
            String stepName = NbBundle.getMessage(JavacardPlatformWizardIterator.class, (String)"STEP_TITLE_VALIDATE_PLATFORM");
            if (this.isRi) {
                String nextStepName = NbBundle.getMessage(JavacardPlatformWizardIterator.class, (String)"STEP_TITLE_DEFINE_DEVICE");
                this.comp.putClientProperty("WizardPanel_contentData", new String[]{stepName, nextStepName});
            } else {
                this.comp.putClientProperty("WizardPanel_contentData", new String[]{stepName});
            }
            this.comp.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            this.comp.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            this.comp.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
            this.comp.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
            this.comp.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            return this.comp;
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(WizardDescriptor w) {
            JavacardPlatformWizardIterator.this.info = (PlatformInfo)w.getProperty(JavacardPlatformWizardIterator.PROP_INFO);
            boolean wasRi = this.isRi;
            if (JavacardPlatformWizardIterator.this.displayName == null) {
                JavacardPlatformWizardIterator.this.displayName = JavacardPlatformWizardIterator.this.info.getTitle();
                this.isRi = JavacardPlatformWizardIterator.this.info.isRi();
                if (wasRi != this.isRi) {
                    JavacardPlatformWizardIterator.this.change();
                }
            }
            if (JavacardPlatformWizardIterator.this.info != null) {
                JavacardPlatformWizardIterator.this.supp.fireChange();
            }
        }

        public void storeSettings(WizardDescriptor w) {
            w.putProperty(JavacardPlatformWizardIterator.PROP_INFO, (Object)this.comp.getPlatformInfo());
        }

        public boolean isValid() {
            return this.comp == null ? false : JavacardPlatformWizardIterator.this.info != null && !this.comp.isProblem();
        }

        public void addChangeListener(ChangeListener arg0) {
            JavacardPlatformWizardIterator.this.supp.addChangeListener(arg0);
        }

        public void removeChangeListener(ChangeListener arg0) {
            JavacardPlatformWizardIterator.this.supp.removeChangeListener(arg0);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JavacardPlatformWizardIterator.this.info = this.comp.getPlatformInfo();
            JavacardPlatformWizardIterator.this.supp.fireChange();
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JavacardPlatformWizardIterator.this.displayName = this.comp.getDisplayName();
        }

        private void setDisplayName(String nm) {
            if (this.comp != null) {
                this.comp.setDisplayName(nm);
            }
        }

        public boolean isFinishPanel() {
            return true;
        }
    }
}

