/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.analyzer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.vmd.api.analyzer.Analyzer;

public class AnalyzerPanel
extends JPanel {
    private static final Font LABEL_FONT = new Font("Dialog", 1, 16);
    private static final Color LABEL_COLOR = new Color(0x868686);
    private static final Color BORDER_COLOR = new Color(13355457);
    private static final Color GRADIENT_COLOR = new Color(0xD5D5D5);
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Insets INSETS = new Insets(10, 10, 10, 10);

    public AnalyzerPanel(Analyzer analyzer, JComponent visualRepresentation) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.insets = EMPTY_INSETS;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 18;
        Image image = analyzer.getIcon();
        JLabel label = new JLabel(analyzer.getDisplayName(), image != null ? new ImageIcon(image) : null, 0){

            @Override
            public void paint(Graphics g) {
                Graphics2D gr = (Graphics2D)g;
                gr.setPaint(new GradientPaint(0.0f, 0.0f, Color.WHITE, 0.0f, this.getHeight(), GRADIENT_COLOR));
                gr.fill(new Rectangle(this.getWidth(), this.getHeight()));
                super.paint(g);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 8;
                dimension.height += 8;
                return dimension;
            }
        };
        label.setBorder(null);
        label.setFont(LABEL_FONT);
        label.setToolTipText(analyzer.getToolTip());
        label.setBackground(null);
        label.setForeground(LABEL_COLOR);
        label.setOpaque(false);
        this.add((Component)label, constraints);
        JPanel separator = new JPanel();
        separator.setOpaque(true);
        separator.setBackground(BORDER_COLOR);
        separator.setPreferredSize(new Dimension(0, 1));
        this.add((Component)separator, constraints);
        constraints.insets = INSETS;
        this.add((Component)visualRepresentation, constraints);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D gr = (Graphics2D)g;
        Shape previousClip = gr.getClip();
        gr.clip(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth(), this.getHeight(), 8.0f, 8.0f));
        super.paint(g);
        gr.setClip(previousClip);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        Graphics2D gr = (Graphics2D)g;
        gr.setColor(BORDER_COLOR);
        gr.draw(new RoundRectangle2D.Float(0.0f, 0.0f, this.getWidth() - 1, this.getHeight() - 1, 8.0f, 8.0f));
    }
}

