/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.io.javame;

import java.awt.Dimension;
import java.util.HashMap;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.javame.DeviceListener;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;

public class MidpProjectPropertiesSupportImpl {
    private static final HashMap<DeviceListener, AntProjectListener> deviceListeners = new HashMap();

    static Dimension getDeviceScreenSizeFromProject(DataObjectContext context) {
        if (!(ProjectUtils.getProject((DataObjectContext)context) instanceof J2MEProject)) {
            return new Dimension();
        }
        return MidpProjectPropertiesSupportImpl.getDeviceScreenSizeFromProject((J2MEProject)ProjectUtils.getProject((DataObjectContext)context));
    }

    private static Dimension getDeviceScreenSizeFromProject(J2MEProject project) {
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        EditableProperties ep = helper.getProperties("nbproject/project.properties");
        ProjectConfigurationsHelper confs = project.getConfigurationHelper();
        String activeConfiguration = confs.getActiveConfiguration() != confs.getDefaultConfiguration() ? confs.getActiveConfiguration().getDisplayName() : null;
        String platformActive = MidpProjectPropertiesSupportImpl.evaluateProperty(ep, "platform.active", activeConfiguration);
        String deviceActive = MidpProjectPropertiesSupportImpl.evaluateProperty(ep, "platform.device", activeConfiguration);
        if (platformActive != null && deviceActive != null) {
            J2MEPlatform.Device[] devices;
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2me", null));
            J2MEPlatform platform = null;
            if (platforms != null) {
                for (JavaPlatform javaPlatform : platforms) {
                    if (!(javaPlatform instanceof J2MEPlatform) || !platformActive.equals(((J2MEPlatform)javaPlatform).getName())) continue;
                    platform = (J2MEPlatform)javaPlatform;
                    break;
                }
            }
            if (platform != null && (devices = platform.getDevices()) != null) {
                for (J2MEPlatform.Device device : devices) {
                    J2MEPlatform.Screen screen;
                    if (!deviceActive.equals(device.getName()) || (screen = device.getScreen()) == null) continue;
                    Integer height = screen.getHeight();
                    Integer width = screen.getWidth();
                    if (height == null || width == null) continue;
                    return new Dimension(width, height);
                }
            }
        }
        return null;
    }

    public static String evaluateProperty(EditableProperties ep, String propertyName, String configuration) {
        if (configuration == null) {
            return ep.getProperty(propertyName);
        }
        String value = ep.getProperty("configs." + configuration + "." + propertyName);
        return value != null ? value : MidpProjectPropertiesSupportImpl.evaluateProperty(ep, propertyName, null);
    }

    public static void addDeviceListener(DataObjectContext context, DeviceListener listener) {
        Project project = ProjectUtils.getProject((DataObjectContext)context);
        if (project == null) {
            return;
        }
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (helper == null) {
            return;
        }
        if (deviceListeners.containsKey(listener)) {
            Debug.warning((Object[])new Object[]{"DeviceListener already registered", listener});
        }
        DeviceAntProjectListener antListener = new DeviceAntProjectListener(listener);
        helper.addAntProjectListener((AntProjectListener)antListener);
        deviceListeners.put(listener, antListener);
    }

    public static void removeDeviceListener(DataObjectContext context, DeviceListener listener) {
        Project project = ProjectUtils.getProject((DataObjectContext)context);
        if (project == null) {
            return;
        }
        AntProjectHelper helper = (AntProjectHelper)project.getLookup().lookup(AntProjectHelper.class);
        if (helper == null) {
            return;
        }
        AntProjectListener antListener = deviceListeners.remove(listener);
        if (antListener != null) {
            helper.removeAntProjectListener(antListener);
        } else {
            Debug.warning((Object[])new Object[]{"DeviceListener not registered", listener});
        }
    }

    public static boolean isMobileProject(Project project) {
        return project instanceof J2MEProject;
    }

    public static String getActiveConfiguration(Project project) {
        ProjectConfigurationsHelper confs = (ProjectConfigurationsHelper)project.getLookup().lookup(ProjectConfigurationsHelper.class);
        return confs.getActiveConfiguration() != confs.getDefaultConfiguration() ? confs.getActiveConfiguration().getDisplayName() : null;
    }

    public static void setProperty(EditableProperties ep, String propertyName, String configuration, String propertyValue) {
        if (configuration == null) {
            ep.put(propertyName, propertyValue);
        } else {
            ep.put("configs." + configuration + "." + propertyName, propertyValue);
        }
    }

    private static class DeviceAntProjectListener
    implements AntProjectListener {
        private DeviceListener listener;

        public DeviceAntProjectListener(DeviceListener listener) {
            this.listener = listener;
        }

        public void configurationXmlChanged(AntProjectEvent ev) {
            this.listener.deviceChanged();
        }

        public void propertiesChanged(AntProjectEvent ev) {
            this.listener.deviceChanged();
        }
    }
}

