/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.beans.factory.support.AutowireUtils;
import org.springframework.beans.factory.support.BeanDefinitionValueResolver;
import org.springframework.beans.factory.support.InstantiationStrategy;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.JdkVersion;
import org.springframework.core.MethodParameter;
import org.springframework.util.MethodInvoker;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

class ConstructorResolver {
    private final AbstractBeanFactory beanFactory;
    private final AutowireCapableBeanFactory autowireFactory;
    private final InstantiationStrategy instantiationStrategy;
    private final TypeConverter typeConverter;

    public ConstructorResolver(AbstractBeanFactory beanFactory, AutowireCapableBeanFactory autowireFactory, InstantiationStrategy instantiationStrategy, TypeConverter typeConverter) {
        this.beanFactory = beanFactory;
        this.autowireFactory = autowireFactory;
        this.instantiationStrategy = instantiationStrategy;
        this.typeConverter = typeConverter;
    }

    protected BeanWrapper autowireConstructor(String beanName, RootBeanDefinition mbd, Constructor[] chosenCtors, Object[] explicitArgs) {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(bw);
        Constructor constructorToUse = null;
        Object[] argsToUse = null;
        if (explicitArgs != null) {
            argsToUse = explicitArgs;
        } else {
            constructorToUse = (Constructor)mbd.resolvedConstructorOrFactoryMethod;
            if (constructorToUse != null && (argsToUse = mbd.resolvedConstructorArguments) == null) {
                Class<?>[] paramTypes = constructorToUse.getParameterTypes();
                Object[] argsToResolve = mbd.preparedConstructorArguments;
                TypeConverter converter = this.typeConverter != null ? this.typeConverter : bw;
                BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, converter);
                argsToUse = new Object[argsToResolve.length];
                for (int i = 0; i < argsToResolve.length; ++i) {
                    Object argValue = argsToResolve[i];
                    MethodParameter methodParam = new MethodParameter(constructorToUse, i);
                    if (JdkVersion.isAtLeastJava15()) {
                        GenericTypeResolver.resolveParameterType(methodParam, constructorToUse.getDeclaringClass());
                    }
                    if (argValue instanceof AutowiredArgumentMarker) {
                        argValue = this.resolveAutowiredArgument(methodParam, beanName, null, converter);
                    } else if (argValue instanceof BeanMetadataElement) {
                        argValue = valueResolver.resolveValueIfNecessary("constructor argument", argValue);
                    }
                    argsToUse[i] = converter.convertIfNecessary(argValue, paramTypes[i], methodParam);
                }
            }
        }
        if (constructorToUse == null) {
            boolean autowiring = chosenCtors != null || mbd.getResolvedAutowireMode() == 3;
            ConstructorArgumentValues resolvedValues = null;
            int minNrOfArgs = 0;
            if (explicitArgs != null) {
                minNrOfArgs = explicitArgs.length;
            } else {
                ConstructorArgumentValues cargs = mbd.getConstructorArgumentValues();
                resolvedValues = new ConstructorArgumentValues();
                minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
            }
            Constructor[] candidates = chosenCtors != null ? chosenCtors : mbd.getBeanClass().getDeclaredConstructors();
            AutowireUtils.sortConstructors(candidates);
            int minTypeDiffWeight = Integer.MAX_VALUE;
            for (int i = 0; i < candidates.length; ++i) {
                ArgumentsHolder args;
                Class[] paramTypes;
                Constructor candidate;
                block25: {
                    candidate = candidates[i];
                    paramTypes = candidate.getParameterTypes();
                    if (constructorToUse != null && argsToUse.length > paramTypes.length) break;
                    if (paramTypes.length < minNrOfArgs) {
                        throw new BeanCreationException(mbd.getResourceDescription(), beanName, minNrOfArgs + " constructor arguments specified but no matching constructor found in bean '" + beanName + "' " + "(hint: specify index and/or type arguments for simple parameters to avoid type ambiguities)");
                    }
                    args = null;
                    LinkedList<UnsatisfiedDependencyException> causes = null;
                    if (resolvedValues != null) {
                        try {
                            args = this.createArgumentArray(beanName, mbd, resolvedValues, bw, paramTypes, candidate, autowiring);
                            break block25;
                        }
                        catch (UnsatisfiedDependencyException ex) {
                            if (this.beanFactory.logger.isTraceEnabled()) {
                                this.beanFactory.logger.trace((Object)("Ignoring constructor [" + candidate + "] of bean '" + beanName + "': " + ex));
                            }
                            if (i == candidates.length - 1 && constructorToUse == null) {
                                if (causes != null) {
                                    Iterator it = causes.iterator();
                                    while (it.hasNext()) {
                                        this.beanFactory.onSuppressedException((Exception)it.next());
                                    }
                                }
                                throw ex;
                            }
                            if (causes == null) {
                                causes = new LinkedList<UnsatisfiedDependencyException>();
                            }
                            causes.add(ex);
                            continue;
                        }
                    }
                    if (paramTypes.length != explicitArgs.length) continue;
                    args = new ArgumentsHolder(explicitArgs);
                }
                int typeDiffWeight = args.getTypeDifferenceWeight(paramTypes);
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                constructorToUse = candidate;
                argsToUse = args.arguments;
                minTypeDiffWeight = typeDiffWeight;
            }
            if (constructorToUse == null) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Could not resolve matching constructor");
            }
            if (explicitArgs == null) {
                mbd.resolvedConstructorOrFactoryMethod = constructorToUse;
            }
        }
        try {
            Object beanInstance = this.instantiationStrategy.instantiate(mbd, beanName, this.beanFactory, constructorToUse, argsToUse);
            bw.setWrappedInstance(beanInstance);
            return bw;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Instantiation of bean failed", ex);
        }
    }

    public BeanWrapper instantiateUsingFactoryMethod(String beanName, RootBeanDefinition mbd, Object[] explicitArgs) {
        BeanWrapperImpl bw = new BeanWrapperImpl();
        this.beanFactory.initBeanWrapper(bw);
        Class<?> factoryClass = null;
        Object factoryBean = null;
        boolean isStatic = true;
        String factoryBeanName = mbd.getFactoryBeanName();
        if (factoryBeanName != null) {
            if (factoryBeanName.equals(beanName)) {
                throw new BeanDefinitionStoreException(mbd.getResourceDescription(), beanName, "factory-bean reference points back to the same bean definition");
            }
            factoryBean = this.beanFactory.getBean(factoryBeanName);
            if (factoryBean == null) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "factory-bean '" + factoryBeanName + "' returned null");
            }
            factoryClass = factoryBean.getClass();
            isStatic = false;
        } else {
            factoryClass = mbd.getBeanClass();
        }
        Method factoryMethodToUse = null;
        Object[] argsToUse = null;
        if (explicitArgs != null) {
            argsToUse = explicitArgs;
        } else {
            factoryMethodToUse = (Method)mbd.resolvedConstructorOrFactoryMethod;
            if (factoryMethodToUse != null && (argsToUse = mbd.resolvedConstructorArguments) == null) {
                Class<?>[] paramTypes = factoryMethodToUse.getParameterTypes();
                Object[] argsToResolve = mbd.preparedConstructorArguments;
                TypeConverter converter = this.typeConverter != null ? this.typeConverter : bw;
                BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, converter);
                argsToUse = new Object[argsToResolve.length];
                for (int i = 0; i < argsToResolve.length; ++i) {
                    Object argValue = argsToResolve[i];
                    MethodParameter methodParam = new MethodParameter(factoryMethodToUse, i);
                    if (JdkVersion.isAtLeastJava15()) {
                        GenericTypeResolver.resolveParameterType(methodParam, factoryClass);
                    }
                    if (argValue instanceof AutowiredArgumentMarker) {
                        argValue = this.resolveAutowiredArgument(methodParam, beanName, null, converter);
                    } else if (argValue instanceof BeanMetadataElement) {
                        argValue = valueResolver.resolveValueIfNecessary("factory method argument", argValue);
                    }
                    argsToUse[i] = converter.convertIfNecessary(argValue, paramTypes[i], methodParam);
                }
            }
        }
        if (factoryMethodToUse == null) {
            Method[] candidates = ReflectionUtils.getAllDeclaredMethods(factoryClass);
            boolean autowiring = mbd.getResolvedAutowireMode() == 3;
            int minTypeDiffWeight = Integer.MAX_VALUE;
            ConstructorArgumentValues resolvedValues = null;
            int minNrOfArgs = 0;
            if (explicitArgs != null) {
                minNrOfArgs = explicitArgs.length;
            } else {
                ConstructorArgumentValues cargs = mbd.getConstructorArgumentValues();
                resolvedValues = new ConstructorArgumentValues();
                minNrOfArgs = this.resolveConstructorArguments(beanName, mbd, bw, cargs, resolvedValues);
            }
            LinkedList<UnsatisfiedDependencyException> causes = null;
            for (int i = 0; i < candidates.length; ++i) {
                ArgumentsHolder args;
                Class[] paramTypes;
                Method candidate;
                block30: {
                    candidate = candidates[i];
                    paramTypes = candidate.getParameterTypes();
                    if (Modifier.isStatic(candidate.getModifiers()) != isStatic || !candidate.getName().equals(mbd.getFactoryMethodName()) || paramTypes.length < minNrOfArgs) continue;
                    args = null;
                    if (resolvedValues != null) {
                        try {
                            args = this.createArgumentArray(beanName, mbd, resolvedValues, bw, paramTypes, candidate, autowiring);
                            break block30;
                        }
                        catch (UnsatisfiedDependencyException ex) {
                            if (this.beanFactory.logger.isTraceEnabled()) {
                                this.beanFactory.logger.trace((Object)("Ignoring factory method [" + candidate + "] of bean '" + beanName + "': " + ex));
                            }
                            if (i == candidates.length - 1 && factoryMethodToUse == null) {
                                if (causes != null) {
                                    Iterator it = causes.iterator();
                                    while (it.hasNext()) {
                                        this.beanFactory.onSuppressedException((Exception)it.next());
                                    }
                                }
                                throw ex;
                            }
                            if (causes == null) {
                                causes = new LinkedList<UnsatisfiedDependencyException>();
                            }
                            causes.add(ex);
                            continue;
                        }
                    }
                    if (paramTypes.length != explicitArgs.length) continue;
                    args = new ArgumentsHolder(explicitArgs);
                }
                int typeDiffWeight = args.getTypeDifferenceWeight(paramTypes);
                if (typeDiffWeight >= minTypeDiffWeight) continue;
                factoryMethodToUse = candidate;
                argsToUse = args.arguments;
                minTypeDiffWeight = typeDiffWeight;
            }
            if (factoryMethodToUse == null) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "No matching factory method found: " + (mbd.getFactoryBeanName() != null ? "factory bean '" + mbd.getFactoryBeanName() + "'; " : "") + "factory method '" + mbd.getFactoryMethodName() + "'");
            }
            if (Void.TYPE.equals(factoryMethodToUse.getReturnType())) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid factory method '" + mbd.getFactoryMethodName() + "': needs to have a non-void return type!");
            }
            if (explicitArgs == null) {
                mbd.resolvedConstructorOrFactoryMethod = factoryMethodToUse;
            }
        }
        try {
            Object beanInstance = this.instantiationStrategy.instantiate(mbd, beanName, this.beanFactory, factoryBean, factoryMethodToUse, argsToUse);
            if (beanInstance == null) {
                return null;
            }
            bw.setWrappedInstance(beanInstance);
            return bw;
        }
        catch (Throwable ex) {
            throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Instantiation of bean failed", ex);
        }
    }

    private int resolveConstructorArguments(String beanName, RootBeanDefinition mbd, BeanWrapper bw, ConstructorArgumentValues cargs, ConstructorArgumentValues resolvedValues) {
        TypeConverter converterToUse = this.typeConverter != null ? this.typeConverter : bw;
        BeanDefinitionValueResolver valueResolver = new BeanDefinitionValueResolver(this.beanFactory, beanName, mbd, converterToUse);
        int minNrOfArgs = cargs.getArgumentCount();
        Iterator it = cargs.getIndexedArgumentValues().entrySet().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder;
            Map.Entry entry = it.next();
            int index = (Integer)entry.getKey();
            if (index < 0) {
                throw new BeanCreationException(mbd.getResourceDescription(), beanName, "Invalid constructor argument index: " + index);
            }
            if (index > minNrOfArgs) {
                minNrOfArgs = index + 1;
            }
            if ((valueHolder = (ConstructorArgumentValues.ValueHolder)entry.getValue()).isConverted()) {
                resolvedValues.addIndexedArgumentValue(index, valueHolder);
                continue;
            }
            Object resolvedValue = valueResolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addIndexedArgumentValue(index, resolvedValueHolder);
        }
        it = cargs.getGenericArgumentValues().iterator();
        while (it.hasNext()) {
            ConstructorArgumentValues.ValueHolder valueHolder = (ConstructorArgumentValues.ValueHolder)((Object)it.next());
            if (valueHolder.isConverted()) {
                resolvedValues.addGenericArgumentValue(valueHolder);
                continue;
            }
            Object resolvedValue = valueResolver.resolveValueIfNecessary("constructor argument", valueHolder.getValue());
            ConstructorArgumentValues.ValueHolder resolvedValueHolder = new ConstructorArgumentValues.ValueHolder(resolvedValue, valueHolder.getType());
            resolvedValueHolder.setSource(valueHolder);
            resolvedValues.addGenericArgumentValue(resolvedValueHolder);
        }
        return minNrOfArgs;
    }

    private ArgumentsHolder createArgumentArray(String beanName, RootBeanDefinition mbd, ConstructorArgumentValues resolvedValues, BeanWrapper bw, Class[] paramTypes, Object methodOrCtor, boolean autowiring) throws UnsatisfiedDependencyException {
        String methodType = methodOrCtor instanceof Constructor ? "constructor" : "factory method";
        TypeConverter converter = this.typeConverter != null ? this.typeConverter : bw;
        ArgumentsHolder args = new ArgumentsHolder(paramTypes.length);
        HashSet<ConstructorArgumentValues.ValueHolder> usedValueHolders = new HashSet<ConstructorArgumentValues.ValueHolder>(paramTypes.length);
        LinkedHashSet autowiredBeanNames = new LinkedHashSet(4);
        boolean resolveNecessary = false;
        for (int paramIndex = 0; paramIndex < paramTypes.length; ++paramIndex) {
            Class paramType = paramTypes[paramIndex];
            ConstructorArgumentValues.ValueHolder valueHolder = resolvedValues.getArgumentValue(paramIndex, paramType, usedValueHolders);
            if (valueHolder == null && !autowiring) {
                valueHolder = resolvedValues.getGenericArgumentValue(null, usedValueHolders);
            }
            if (valueHolder != null) {
                usedValueHolders.add(valueHolder);
                args.rawArguments[paramIndex] = valueHolder.getValue();
                if (valueHolder.isConverted()) {
                    Object convertedValue;
                    args.arguments[paramIndex] = convertedValue = valueHolder.getConvertedValue();
                    args.preparedArguments[paramIndex] = convertedValue;
                    continue;
                }
                try {
                    Object convertedValue;
                    Object originalValue = valueHolder.getValue();
                    args.arguments[paramIndex] = convertedValue = converter.convertIfNecessary(originalValue, paramType, MethodParameter.forMethodOrConstructor(methodOrCtor, paramIndex));
                    ConstructorArgumentValues.ValueHolder sourceHolder = (ConstructorArgumentValues.ValueHolder)valueHolder.getSource();
                    Object sourceValue = sourceHolder.getValue();
                    if (originalValue == sourceValue || sourceValue instanceof TypedStringValue) {
                        sourceHolder.setConvertedValue(convertedValue);
                        args.preparedArguments[paramIndex] = convertedValue;
                        continue;
                    }
                    resolveNecessary = true;
                    args.preparedArguments[paramIndex] = sourceValue;
                    continue;
                }
                catch (TypeMismatchException ex) {
                    throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, paramIndex, paramType, "Could not convert " + methodType + " argument value of type [" + ObjectUtils.nullSafeClassName(valueHolder.getValue()) + "] to required type [" + paramType.getName() + "]: " + ex.getMessage());
                }
            }
            if (!autowiring) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, paramIndex, paramType, "Ambiguous " + methodType + " argument types - " + "did you specify the correct bean references as " + methodType + " arguments?");
            }
            try {
                Object autowiredArgument;
                MethodParameter param = MethodParameter.forMethodOrConstructor(methodOrCtor, paramIndex);
                args.rawArguments[paramIndex] = autowiredArgument = this.resolveAutowiredArgument(param, beanName, autowiredBeanNames, converter);
                args.arguments[paramIndex] = autowiredArgument;
                args.preparedArguments[paramIndex] = new AutowiredArgumentMarker();
                resolveNecessary = true;
                continue;
            }
            catch (BeansException ex) {
                throw new UnsatisfiedDependencyException(mbd.getResourceDescription(), beanName, paramIndex, paramType, ex);
            }
        }
        Iterator it = autowiredBeanNames.iterator();
        while (it.hasNext()) {
            String autowiredBeanName = (String)it.next();
            this.beanFactory.registerDependentBean(autowiredBeanName, beanName);
            if (!this.beanFactory.logger.isDebugEnabled()) continue;
            this.beanFactory.logger.debug((Object)("Autowiring by type from bean name '" + beanName + "' via " + methodType + " to bean named '" + autowiredBeanName + "'"));
        }
        if (resolveNecessary) {
            mbd.preparedConstructorArguments = args.preparedArguments;
        } else {
            mbd.resolvedConstructorArguments = args.arguments;
        }
        mbd.constructorArgumentsResolved = true;
        return args;
    }

    protected Object resolveAutowiredArgument(MethodParameter param, String beanName, Set autowiredBeanNames, TypeConverter typeConverter) {
        return this.autowireFactory.resolveDependency(new DependencyDescriptor(param, true), beanName, autowiredBeanNames, typeConverter);
    }

    private static class AutowiredArgumentMarker {
        private AutowiredArgumentMarker() {
        }
    }

    private static class ArgumentsHolder {
        public Object[] rawArguments;
        public Object[] arguments;
        public Object[] preparedArguments;

        public ArgumentsHolder(int size) {
            this.rawArguments = new Object[size];
            this.arguments = new Object[size];
            this.preparedArguments = new Object[size];
        }

        public ArgumentsHolder(Object[] args) {
            this.rawArguments = args;
            this.arguments = args;
            this.preparedArguments = args;
        }

        public int getTypeDifferenceWeight(Class[] paramTypes) {
            int typeDiffWeight = MethodInvoker.getTypeDifferenceWeight(paramTypes, this.arguments);
            int rawTypeDiffWeight = MethodInvoker.getTypeDifferenceWeight(paramTypes, this.rawArguments) - 1024;
            return rawTypeDiffWeight < typeDiffWeight ? rawTypeDiffWeight : typeDiffWeight;
        }
    }
}

