/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.db.dataview.meta.DBColumn;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.BinaryToStringConverter;
import org.netbeans.modules.db.dataview.util.DateType;
import org.netbeans.modules.db.dataview.util.TimeType;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class DBReadWriteHelper {
    private static final Logger mLogger = Logger.getLogger(DBReadWriteHelper.class.getName());

    public static Object readResultSet(ResultSet rs, DBColumn col, int index) throws SQLException {
        int colType = col.getJdbcType();
        if (colType == -7 && col.getPrecision() <= 1) {
            colType = 16;
        }
        switch (colType) {
            case 16: {
                boolean bdata = rs.getBoolean(index);
                if (rs.wasNull()) {
                    return null;
                }
                return bdata;
            }
            case 92: {
                Time tdata = rs.getTime(index);
                if (rs.wasNull()) {
                    return null;
                }
                return tdata;
            }
            case 91: {
                Date ddata = rs.getDate(index);
                if (rs.wasNull()) {
                    return null;
                }
                return ddata;
            }
            case -100: 
            case 93: {
                try {
                    Timestamp tsdata = rs.getTimestamp(index);
                    if (rs.wasNull()) {
                        return null;
                    }
                    return tsdata;
                }
                catch (SQLException sqe) {
                    if (sqe.getSQLState().equals("S1009")) {
                        return null;
                    }
                    throw sqe;
                }
            }
            case -5: {
                long ldata = rs.getLong(index);
                if (rs.wasNull()) {
                    return null;
                }
                return new Long(ldata);
            }
            case 8: {
                double fdata = rs.getDouble(index);
                if (rs.wasNull()) {
                    return null;
                }
                return new Double(fdata);
            }
            case 6: 
            case 7: {
                float rdata = rs.getFloat(index);
                if (rs.wasNull()) {
                    return null;
                }
                return new Float(rdata);
            }
            case 2: 
            case 3: {
                BigDecimal bddata = rs.getBigDecimal(index);
                if (rs.wasNull()) {
                    return null;
                }
                return bddata;
            }
            case 4: {
                int idata = rs.getInt(index);
                if (rs.wasNull()) {
                    return null;
                }
                return new Integer(idata);
            }
            case 5: {
                short sidata = rs.getShort(index);
                if (rs.wasNull()) {
                    return null;
                }
                return new Short(sidata);
            }
            case -6: {
                byte tidata = rs.getByte(index);
                if (rs.wasNull()) {
                    return null;
                }
                return new Byte(tidata);
            }
            case -16: 
            case -15: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                String sdata = rs.getString(index);
                if (rs.wasNull()) {
                    return null;
                }
                return sdata;
            }
            case -7: 
            case -4: 
            case -3: 
            case -2: {
                try {
                    byte[] bdata = rs.getBytes(index);
                    if (rs.wasNull()) {
                        return null;
                    }
                    Byte[] internal = new Byte[bdata.length];
                    for (int i = 0; i < bdata.length; ++i) {
                        internal[i] = new Byte(bdata[i]);
                    }
                    String bStr = BinaryToStringConverter.convertToString(internal, 2, true);
                    if (colType == -7 && col.getPrecision() != 0 && col.getPrecision() < bStr.length()) {
                        return bStr.substring(bStr.length() - col.getPrecision());
                    }
                    return bStr;
                }
                catch (SQLDataException x) {
                    try {
                        String sdata = rs.getString(index);
                        if (rs.wasNull()) {
                            return null;
                        }
                        return sdata;
                    }
                    catch (SQLException ex) {
                        throw x;
                    }
                }
            }
            case 2004: {
                Blob blob = rs.getBlob(index);
                if (rs.wasNull()) {
                    return null;
                }
                byte[] blobData = null;
                if (blob != null) {
                    blobData = blob.getBytes(1L, Math.min((int)blob.length(), 2000));
                }
                Byte[] internal = new Byte[blobData.length];
                for (int i = 0; i < blobData.length; ++i) {
                    internal[i] = new Byte(blobData[i]);
                }
                return BinaryToStringConverter.convertToString(internal, 16, false);
            }
            case 2005: 
            case 2011: {
                Clob clob = rs.getClob(index);
                if (rs.wasNull()) {
                    return null;
                }
                if (clob == null) break;
                return clob.getSubString(1L, Math.min((int)clob.length(), 2000));
            }
        }
        return rs.getObject(index);
    }

    public static void setAttributeValue(PreparedStatement ps, int index, int jdbcType, Object valueObj) throws DBException {
        Number numberObj = null;
        try {
            if (valueObj == null) {
                ps.setNull(index, jdbcType);
                return;
            }
            if (jdbcType == -7 && valueObj instanceof Boolean) {
                jdbcType = 16;
            }
            switch (jdbcType) {
                case 8: {
                    numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Double.valueOf(valueObj.toString());
                    ps.setDouble(index, numberObj.doubleValue());
                    break;
                }
                case 3: {
                    numberObj = valueObj instanceof Number ? (Number)valueObj : new BigDecimal(valueObj.toString());
                    ps.setDouble(index, numberObj.doubleValue());
                    break;
                }
                case -5: 
                case 2: {
                    BigDecimal bigDec = new BigDecimal(valueObj.toString());
                    ps.setBigDecimal(index, bigDec);
                    break;
                }
                case 6: 
                case 7: {
                    numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Float.valueOf(valueObj.toString());
                    ps.setFloat(index, numberObj.floatValue());
                    break;
                }
                case 4: {
                    numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Integer.valueOf(valueObj.toString());
                    ps.setInt(index, numberObj.intValue());
                    break;
                }
                case -6: 
                case 5: {
                    numberObj = valueObj instanceof Number ? (Number)((Number)valueObj) : (Number)Short.valueOf(valueObj.toString());
                    ps.setShort(index, numberObj.shortValue());
                    break;
                }
                case 93: {
                    ps.setTimestamp(index, TimestampType.convert(valueObj));
                    break;
                }
                case 91: {
                    ps.setDate(index, DateType.convert(valueObj));
                    break;
                }
                case 92: {
                    ps.setTime(index, TimeType.convert(valueObj));
                    break;
                }
                case -7: {
                    ps.setBytes(index, BinaryToStringConverter.convertBitStringToBytes(valueObj.toString()));
                    break;
                }
                case -3: 
                case -2: {
                    ps.setBytes(index, valueObj.toString().getBytes());
                    break;
                }
                case -4: 
                case 2004: {
                    byte[] byteval = valueObj.toString().getBytes();
                    ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream(byteval), byteval.length);
                    break;
                }
                case -16: 
                case -15: 
                case -9: 
                case -8: 
                case 1: 
                case 12: {
                    ps.setString(index, valueObj.toString());
                    break;
                }
                case -1: 
                case 2005: 
                case 2011: {
                    String charVal = valueObj.toString();
                    ps.setCharacterStream(index, (Reader)new StringReader(charVal), charVal.length());
                    break;
                }
                default: {
                    ps.setObject(index, valueObj, jdbcType);
                    break;
                }
            }
        }
        catch (Exception e) {
            mLogger.log(Level.SEVERE, "Invalid Data for" + jdbcType + "type -- ", e);
            throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_InvalidType", (Object)jdbcType, (Object)e));
        }
    }

    public static Object validate(Object valueObj, DBColumn col) throws DBException {
        int colType = col.getJdbcType();
        if (valueObj == null) {
            return null;
        }
        if (colType == -7 && col.getPrecision() <= 1) {
            colType = 16;
        }
        try {
            switch (colType) {
                case 16: {
                    if (valueObj instanceof Boolean) {
                        return valueObj;
                    }
                    String str = valueObj.toString();
                    if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("1")) {
                        return Boolean.TRUE;
                    }
                    if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("0")) {
                        return Boolean.FALSE;
                    }
                    throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_Boolean"));
                }
                case 93: {
                    return TimestampType.convert(valueObj);
                }
                case 91: {
                    return DateType.convert(valueObj);
                }
                case 92: {
                    return TimeType.convert(valueObj);
                }
                case -5: {
                    return valueObj instanceof Long ? valueObj : new Long(valueObj.toString());
                }
                case 8: {
                    return valueObj instanceof Double ? valueObj : new Double(valueObj.toString());
                }
                case 6: 
                case 7: {
                    return valueObj instanceof Float ? valueObj : new Float(valueObj.toString());
                }
                case 2: 
                case 3: {
                    return valueObj instanceof BigDecimal ? valueObj : new BigDecimal(valueObj.toString());
                }
                case 4: {
                    return valueObj instanceof Integer ? valueObj : new Integer(valueObj.toString());
                }
                case 5: {
                    return valueObj instanceof Short ? valueObj : new Short(valueObj.toString());
                }
                case -6: {
                    return valueObj instanceof Byte ? valueObj : new Byte(valueObj.toString());
                }
                case -15: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (col.getPrecision() > 0 && valueObj.toString().length() > col.getPrecision()) {
                        String colName = col.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_TooLarge", (Object)valueObj, (Object)colName));
                    }
                    return valueObj;
                }
                case -7: {
                    if (valueObj.toString().length() > col.getPrecision()) {
                        String colName = col.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_TooLarge", (Object)valueObj, (Object)colName));
                    }
                    if (valueObj.toString().trim().length() == 0) {
                        String colName = col.getQualifiedName(false);
                        throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_Validate_Invalid", (Object)valueObj, (Object)colName));
                    }
                    BinaryToStringConverter.convertBitStringToBytes(valueObj.toString());
                    return valueObj;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: 
                case 2005: {
                    char[] bytes = valueObj.toString().toCharArray();
                    Byte[] internal = new Byte[bytes.length];
                    for (int i = 0; i < bytes.length; ++i) {
                        internal[i] = new Byte((byte)bytes[i]);
                    }
                    return BinaryToStringConverter.convertToString(internal, 2, true);
                }
            }
            return valueObj;
        }
        catch (Exception e) {
            String type = col.getTypeName();
            String colName = col.getQualifiedName(false);
            int precision = col.getPrecision();
            throw new DBException(NbBundle.getMessage(DBReadWriteHelper.class, (String)"DBReadWriteHelper_ErrLog", (Object[])new Object[]{colName, type, precision, e.getLocalizedMessage()}));
        }
    }

    public static boolean isNullString(String str) {
        return str == null || str.trim().length() == 0;
    }
}

