/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.db.api.sql.execute.SQLScript;
import org.netbeans.modules.db.api.sql.execute.SQLScriptStatement;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;

public class SQLCompletionEnv {
    private final String statement;
    private final int statementOffset;
    private final int caretOffset;
    private final SubstitutionHandler substitutionHandler;
    private final TokenSequence<SQLTokenId> seq;

    public static SQLCompletionEnv forDocument(Document doc, int caretOffset) {
        String documentText = SQLCompletionEnv.getDocumentText(doc);
        if (documentText != null) {
            return SQLCompletionEnv.forScript(documentText, caretOffset);
        }
        return null;
    }

    public static SQLCompletionEnv forStatement(String statement, int caretOffset, SubstitutionHandler substitutionHandler) {
        return new SQLCompletionEnv(statement, 0, caretOffset, substitutionHandler);
    }

    static SQLCompletionEnv forScript(String script, int caretOffset) {
        return SQLCompletionEnv.forScript(script, caretOffset, 0);
    }

    static SQLCompletionEnv forScript(String script, int caretOffset, int scriptOffset) {
        SQLScriptStatement statement = SQLScript.create((String)script).getStatementAtOffset(caretOffset);
        if (statement != null) {
            return new SQLCompletionEnv(statement.getText(), statement.getStartOffset(), caretOffset - statement.getStartOffset(), new ScriptSubstitutionHandler(statement.getStartOffset() + scriptOffset));
        }
        return new SQLCompletionEnv("", 0, caretOffset, new ScriptSubstitutionHandler(scriptOffset));
    }

    private SQLCompletionEnv(String statement, int statementOffset, int caretOffset, SubstitutionHandler substitutionHandler) {
        this.statement = statement;
        this.statementOffset = statementOffset;
        this.caretOffset = caretOffset;
        this.substitutionHandler = substitutionHandler;
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)statement, SQLTokenId.language());
        this.seq = hi.tokenSequence(SQLTokenId.language());
    }

    public String getStatement() {
        return this.statement;
    }

    public int getStatementOffset() {
        return this.statementOffset;
    }

    public SubstitutionHandler getSubstitutionHandler() {
        return this.substitutionHandler;
    }

    public int getCaretOffset() {
        return this.caretOffset;
    }

    public TokenSequence<SQLTokenId> getTokenSequence() {
        return this.seq;
    }

    private static String getDocumentText(final Document doc) {
        final String[] result = new String[]{null};
        doc.render(new Runnable(){

            @Override
            public void run() {
                try {
                    result[0] = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        return result[0];
    }

    private static final class ScriptSubstitutionHandler
    implements SubstitutionHandler {
        private final int statementOffset;

        public ScriptSubstitutionHandler(int statementOffset) {
            this.statementOffset = statementOffset;
        }

        @Override
        public void substituteText(JTextComponent component, final int offset, final String text) {
            final int caretOffset = component.getSelectionEnd();
            final BaseDocument baseDoc = (BaseDocument)component.getDocument();
            baseDoc.runAtomicAsUser(new Runnable(){

                @Override
                public void run() {
                    int documentOffset = ScriptSubstitutionHandler.this.statementOffset + offset;
                    try {
                        baseDoc.remove(documentOffset, caretOffset - documentOffset);
                        baseDoc.insertString(documentOffset, text, null);
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

