/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.IntervalTimeInstance;
import com.sun.perseus.model.Time;
import java.util.Vector;

public final class TimeInterval {
    Time begin;
    Time end;
    Time lastDur;
    Vector beginDependents;
    Vector endDependents;

    TimeInterval(Time begin, Time end) {
        if (begin == null || end == null) {
            throw new NullPointerException();
        }
        this.setBegin(begin);
        this.setEnd(end);
    }

    void addDependent(IntervalTimeInstance timeInstance) {
        Vector<IntervalTimeInstance> dependents = this.beginDependents;
        if (!timeInstance.isBeginSync) {
            dependents = this.endDependents;
        }
        if (dependents == null) {
            dependents = new Vector<IntervalTimeInstance>(1);
            if (timeInstance.isBeginSync) {
                this.beginDependents = dependents;
            } else {
                this.endDependents = dependents;
            }
        }
        dependents.addElement(timeInstance);
    }

    void removeDependent(IntervalTimeInstance timeInstance) {
        Vector dependents = this.beginDependents;
        if (!timeInstance.isBeginSync) {
            dependents = this.endDependents;
        }
        if (dependents == null) {
            return;
        }
        dependents.removeElement(timeInstance);
    }

    void setBegin(Time newBegin) {
        if (!newBegin.isResolved()) {
            throw new IllegalArgumentException("" + newBegin);
        }
        this.begin = newBegin;
        if (this.beginDependents != null) {
            int n = this.beginDependents.size();
            for (int i = 0; i < n; ++i) {
                ((IntervalTimeInstance)this.beginDependents.elementAt(i)).onIntervalUpdate();
            }
        }
    }

    void setEnd(Time newEnd) {
        if (newEnd == null) {
            throw new NullPointerException();
        }
        this.end = newEnd;
        if (this.endDependents != null) {
            int n = this.endDependents.size();
            for (int i = 0; i < n; ++i) {
                ((IntervalTimeInstance)this.endDependents.elementAt(i)).onIntervalUpdate();
            }
        }
    }

    void prune() {
        IntervalTimeInstance iti;
        int i;
        int n = this.beginDependents != null ? this.beginDependents.size() : 0;
        for (i = n - 1; i >= 0; --i) {
            iti = (IntervalTimeInstance)this.beginDependents.elementAt(i);
            iti.timedElement.removeTimeInstance(iti);
            iti.dispose();
        }
        n = this.endDependents != null ? this.endDependents.size() : 0;
        for (i = n - 1; i >= 0; --i) {
            iti = (IntervalTimeInstance)this.endDependents.elementAt(i);
            iti.timedElement.removeTimeInstance(iti);
            iti.dispose();
        }
    }
}

