/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.builder.DefaultFontFace;
import com.sun.perseus.j2d.GraphicsProperties;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.j2d.TextProperties;
import com.sun.perseus.j2d.Transform;
import com.sun.perseus.j2d.ViewportProperties;
import com.sun.perseus.model.CompositeNode;
import com.sun.perseus.model.DefaultImageLoader;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.EventSupport;
import com.sun.perseus.model.FontFace;
import com.sun.perseus.model.GenericElementNode;
import com.sun.perseus.model.IDRef;
import com.sun.perseus.model.ImageLoader;
import com.sun.perseus.model.MediaElement;
import com.sun.perseus.model.Messages;
import com.sun.perseus.model.ModelEvent;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.SVG;
import com.sun.perseus.model.TextNode;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeContainerRootSupport;
import com.sun.perseus.model.TimedElementNode;
import com.sun.perseus.model.TraitAnim;
import com.sun.perseus.model.UpdateListener;
import com.sun.perseus.model.Viewport;
import com.sun.perseus.parser.ClockParser;
import com.sun.perseus.parser.ColorParser;
import com.sun.perseus.parser.LengthParser;
import com.sun.perseus.parser.NumberListParser;
import com.sun.perseus.parser.PathParser;
import com.sun.perseus.parser.TimeConditionParser;
import com.sun.perseus.parser.TransformListParser;
import com.sun.perseus.parser.UnicodeParser;
import com.sun.perseus.parser.ViewBoxParser;
import com.sun.perseus.util.RunnableQueue;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentNode
extends Viewport
implements Document {
    public static final float DEFAULT_PIXEL_MM_SIZE = 0.26458332f;
    protected float pxMMSize = 0.26458332f;
    protected float[] upt = new float[]{0.0f, 0.0f};
    protected Hashtable namespaceMap = new Hashtable();
    protected Hashtable unknownTraitsNS = null;
    protected final ClockParser clockParser = new ClockParser();
    protected final LengthParser lengthParser = new LengthParser();
    protected final TimeConditionParser timeConditionParser = new TimeConditionParser();
    protected NumberListParser numberListParser = new NumberListParser();
    protected TransformListParser transformListParser = new TransformListParser();
    protected final ColorParser colorParser = new ColorParser();
    protected final ViewBoxParser viewBoxParser = new ViewBoxParser();
    protected final PathParser pathParser = new PathParser();
    protected UnicodeParser unicodeParser = new UnicodeParser();
    protected ImageLoader imageLoader;
    protected FontFace defaultFontFace;
    protected DOMException delayedException;
    protected String defaultNamespaceURI = "http://www.w3.org/2000/svg";
    protected String docURI;
    protected FontFace[] initialFontFaces;
    protected Hashtable fontFaceDB = null;
    protected Vector activeTraitAnims = new Vector(0);
    protected Vector elementsToDiscard = new Vector(0);
    protected Vector activeMediaElements = new Vector(0);
    protected boolean playing;
    protected boolean applyAnimationsCalled = false;
    protected EventSupport eventSupport = new EventSupport();
    protected UpdateListener updateListener;
    protected RunnableQueue updateQueue;
    protected RunnableQueue.RunnableHandler runHandler;
    protected Hashtable idToElement = new Hashtable();
    protected Hashtable reservedIds = new Hashtable();
    protected Hashtable prefixes = new Hashtable();
    protected Hashtable namespaces = new Hashtable();
    protected TimeContainerRootSupport timeContainerRootSupport = new TimeContainerRootSupport();
    protected Hashtable unresolvedIDRefs = new Hashtable();
    protected Hashtable resolvedIDRefs = new Hashtable();
    protected Vector timedElementNodes = new Vector(0);
    protected ModelEvent engineEvent = null;
    protected Transform hitChunkTxf = new Transform(null);
    protected Transform bboxChunkTxf = new Transform(null);
    protected Transform paintChunkTxf = new Transform(null);
    protected Transform paintGlyphTxf = new Transform(null);
    protected Transform bboxGlyphTxf = new Transform(null);
    protected Transform hitGlyphTxf = new Transform(null);

    public DocumentNode() {
        this.ownerDocument = this;
        this.engineEvent = new ModelEvent("", this);
        this.canRenderState &= 0xFFFFF7FF;
        this.canRenderState &= 0xFFFFFFFE;
    }

    protected Object getInitialPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 1: {
                return GraphicsProperties.INITIAL_FILL;
            }
            case 0x200000: {
                return ViewportProperties.INITIAL_VIEWPORT_FILL;
            }
            case 2: {
                return GraphicsProperties.INITIAL_STROKE;
            }
            case 4: {
                return GraphicsProperties.INITIAL_COLOR;
            }
            case 256: {
                return GraphicsProperties.INITIAL_STROKE_DASH_ARRAY;
            }
            case 65536: {
                return TextNode.INITIAL_FONT_FAMILY;
            }
        }
        return null;
    }

    protected float getInitialFloatPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 16: {
                return 1.0f;
            }
            case 128: {
                return 4.0f;
            }
            case 512: {
                return 0.0f;
            }
            case 131072: {
                return 10.0f;
            }
            case 0x400000: {
                return 1.0f;
            }
        }
        return 0.0f;
    }

    protected int getInitialPackedPropertyState(int propertyIndex) {
        switch (propertyIndex) {
            case 8: {
                return 64;
            }
            case 32: {
                return 0;
            }
            case 64: {
                return 0;
            }
            case 1024: {
                return 1;
            }
            case 2048: {
                return 2;
            }
            case 4096: {
                return 25600;
            }
            case 8192: {
                return 0x640000;
            }
            case 16384: {
                return 200;
            }
            case 262144: {
                return 0;
            }
            case 524288: {
                return 0x6000000;
            }
            case 0x100000: {
                return 0x800000;
            }
        }
        return 0;
    }

    protected Object getPropertyState(int propertyIndex) {
        return this.getInitialPropertyState(propertyIndex);
    }

    protected float getFloatPropertyState(int propertyIndex) {
        return this.getInitialFloatPropertyState(propertyIndex);
    }

    protected int getPackedPropertyState(int propertyIndex) {
        return this.getInitialPackedPropertyState(propertyIndex);
    }

    public void paint(RenderGraphics rg) {
        if (this.canRenderState != 0) {
            return;
        }
        DocumentNode.paint(this.getFirstChildNode(), rg);
    }

    ModelEvent initEngineEvent(String type, ModelNode target) {
        ModelEvent engineEvent = new ModelEvent(type, target);
        engineEvent.type = type;
        engineEvent.target = target;
        engineEvent.currentTarget = null;
        engineEvent.anchor = null;
        engineEvent.stopPropagation = false;
        engineEvent.repeatCount = 0;
        engineEvent.keyChar = (char)65535;
        return engineEvent;
    }

    public final void setLoaded(boolean isLoaded) {
        super.setLoaded(isLoaded);
        if (isLoaded) {
            this.getImageLoader().documentLoaded(this);
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setPlaying(boolean isPlaying) {
        this.playing = isPlaying;
    }

    public void checkDelayedException() throws DOMException {
        if (this.delayedException != null) {
            throw this.delayedException;
        }
    }

    public DOMException getDelayedException() {
        return this.delayedException;
    }

    protected void setDelayedException(DOMException de) {
        this.delayedException = de;
    }

    public float getPixelMMSize() {
        return this.pxMMSize;
    }

    public void setPixelMMSize(float newPxMMSize) {
        this.pxMMSize = newPxMMSize;
    }

    boolean inDocumentTree() {
        return true;
    }

    public void resolveIDRef(IDRef idRef, String id) {
        ElementNode ref = (ElementNode)this.getElementById(id);
        if (ref != null) {
            idRef.resolveTo(ref);
            Vector<IDRef> idRefs = (Vector<IDRef>)this.resolvedIDRefs.get(id);
            if (idRefs == null) {
                idRefs = new Vector<IDRef>(1);
                this.resolvedIDRefs.put(id, idRefs);
            }
            idRefs.addElement(idRef);
        } else if (this.unresolvedIDRefs != null) {
            Vector<IDRef> idRefs = (Vector<IDRef>)this.unresolvedIDRefs.get(id);
            if (idRefs == null) {
                idRefs = new Vector<IDRef>(1);
                this.unresolvedIDRefs.put(id, idRefs);
            }
            idRefs.addElement(idRef);
        }
    }

    public void dispose() {
        this.clearLayouts();
    }

    public ImageLoader getImageLoader() {
        if (this.imageLoader == null) {
            this.imageLoader = new DefaultImageLoader();
        }
        return this.imageLoader;
    }

    public void setImageLoader(ImageLoader imageLoader) {
        this.imageLoader = imageLoader;
    }

    ModelNode getLastExpandedChild() {
        return null;
    }

    ModelNode getFirstExpandedChild() {
        return null;
    }

    public ModelNode getFirstComputedExpandedChild() {
        return null;
    }

    protected void unhookExpandedQuiet() {
    }

    public String getURIBase() {
        return this.docURI;
    }

    public void setDocumentURI(String docURI) {
        if (ElementNode.equal(docURI, this.docURI)) {
            return;
        }
        this.modifyingNode();
        this.docURI = docURI;
        this.modifiedNode();
    }

    public UpdateListener getUpdateListener() {
        if (this.parent == null || this.parent == this) {
            return this.updateListener;
        }
        return this.parent.getUpdateListener();
    }

    public RunnableQueue getUpdateQueue() {
        return this.updateQueue;
    }

    public RunnableQueue.RunnableHandler getRunnableHandler() {
        return this.runHandler;
    }

    public void setUpdateQueue(RunnableQueue updateQueue) {
        this.updateQueue = updateQueue;
    }

    public void setRunnableHandler(RunnableQueue.RunnableHandler runHandler) {
        this.runHandler = runHandler;
    }

    public void setUpdateListener(UpdateListener updateListener) {
        this.updateListener = updateListener;
    }

    public EventSupport getEventSupport() {
        return this.eventSupport;
    }

    public Element getElementById(String id) {
        return (ElementNode)this.idToElement.get(id);
    }

    Element getElementByIdAll(String id) {
        ElementNode n = (ElementNode)this.idToElement.get(id);
        if (n == null) {
            n = (ElementNode)this.reservedIds.get(id);
        }
        return n;
    }

    void addIdentifiedNode(ElementNode element) {
        Vector unresIdRefs;
        String id = element.getId();
        this.idToElement.put(id, element);
        if (this.unresolvedIDRefs != null && (unresIdRefs = (Vector)this.unresolvedIDRefs.get(id)) != null) {
            Vector<IDRef> resIdRefs = (Vector<IDRef>)this.resolvedIDRefs.get(id);
            if (resIdRefs == null) {
                resIdRefs = new Vector<IDRef>(1);
                this.resolvedIDRefs.put(id, resIdRefs);
            }
            int n = unresIdRefs.size();
            for (int i = 0; i < n; ++i) {
                IDRef idRef = (IDRef)unresIdRefs.elementAt(i);
                idRef.resolveTo(element);
                resIdRefs.addElement(idRef);
            }
            this.unresolvedIDRefs.remove(id);
        }
        this.reservedIds.remove(id);
    }

    void reserveId(ElementNode element) {
        this.reservedIds.put(element.getId(), element);
    }

    void removeIdentifiedNode(ElementNode element) {
        String id = element.getId();
        if (this.idToElement.get(id) == element) {
            this.idToElement.remove(id);
        }
    }

    public void invokeLater(Runnable r) {
        if (this.updateQueue == null) {
            r.run();
        } else {
            this.updateQueue.invokeLater(r, this.runHandler);
        }
    }

    public void invokeAndWait(Runnable r) throws InterruptedException {
        if (this.updateQueue == null) {
            r.run();
        } else {
            this.updateQueue.invokeAndWait(r, this.runHandler);
        }
    }

    public void safeInvokeAndWait(Runnable r) {
        if (this.updateQueue == null) {
            r.run();
        } else {
            this.updateQueue.safeInvokeAndWait(r, this.runHandler);
        }
    }

    protected FontFace.Match resolveFontFaces(TextProperties tp) {
        FontFace.Match firstMatch;
        if (this.defaultFontFace == null) {
            this.setDefaultFontFace(DefaultFontFace.getDefaultFontFace());
        }
        if (this.initialFontFaces == null) {
            this.setInitialFontFaces(DefaultFontFace.getInitialFontFaces());
        }
        if (this.fontFaceDB == null) {
            this.setFontFaceSetSilent(null);
        }
        Vector fontFamilyMatch = null;
        String[] fontFamily = tp.getFontFamily();
        int nff = 0;
        if (fontFamily != null) {
            nff = fontFamily.length;
        }
        FontFace.Match lastMatch = firstMatch = new FontFace.Match(this.defaultFontFace);
        for (int i = 0; i < nff; ++i) {
            fontFamilyMatch = (Vector)this.fontFaceDB.get(fontFamily[i]);
            lastMatch = this.matchFontFaces(fontFamilyMatch, lastMatch, tp);
        }
        return firstMatch;
    }

    protected FontFace.Match matchFontFaces(Vector fontFamily, FontFace.Match lastMatch, TextProperties tp) {
        if (fontFamily == null) {
            return lastMatch;
        }
        int n = fontFamily.size();
        int fontStyle = tp.getFontStyle();
        float fontSize = tp.getFontSize();
        int fontWeight = tp.getFontWeight();
        FontFace.Match match = null;
        FontFace.Match firstMatch = null;
        block0: for (int i = 0; i < n; ++i) {
            FontFace ff = (FontFace)fontFamily.elementAt(i);
            if ((ff.getFontStyles() & fontStyle) == 0 && (fontStyle != 4 || (ff.getFontStyles() & 2) == 0)) continue;
            if (ff.getFontSizes() == null) {
                match = new FontFace.Match(ff);
                match.distance = ff.fontWeightDistance(fontWeight);
                firstMatch = this.addMatch(firstMatch, match);
                continue;
            }
            float[] fs = ff.getFontSizes();
            for (int j = 0; j < fs.length; ++j) {
                if (fs[j] != fontSize) continue;
                match = new FontFace.Match(ff);
                match.distance = ff.fontWeightDistance(fontWeight);
                firstMatch = this.addMatch(firstMatch, match);
                continue block0;
            }
        }
        if (match == null) {
            return lastMatch;
        }
        if (lastMatch != null) {
            lastMatch.next = firstMatch;
        }
        while (match.next != null) {
            match = match.next;
        }
        return match;
    }

    protected FontFace.Match addMatch(FontFace.Match firstMatch, FontFace.Match newMatch) {
        if (firstMatch == null) {
            return newMatch;
        }
        FontFace.Match curMatch = firstMatch;
        FontFace.Match prevMatch = null;
        while (curMatch != null && curMatch.distance <= newMatch.distance) {
            prevMatch = curMatch;
            curMatch = curMatch.next;
        }
        if (curMatch == null) {
            prevMatch.next = newMatch;
            return firstMatch;
        }
        if (prevMatch == null) {
            newMatch.next = firstMatch;
            return newMatch;
        }
        prevMatch.next = newMatch;
        newMatch.next = curMatch;
        return firstMatch;
    }

    public void setDefaultFontFace(FontFace newDefaultFontFace) {
        if (newDefaultFontFace == null) {
            throw new IllegalArgumentException();
        }
        if (this.defaultFontFace == newDefaultFontFace) {
            return;
        }
        this.defaultFontFace = newDefaultFontFace;
        this.clearLayouts();
    }

    public void setInitialFontFaces(FontFace[] newInitialFontFaces) {
        if (newInitialFontFaces == null) {
            throw new IllegalArgumentException();
        }
        if (this.initialFontFaces == newInitialFontFaces) {
            return;
        }
        for (int i = 0; i < newInitialFontFaces.length; ++i) {
            if (newInitialFontFaces[i] != null) continue;
            throw new IllegalArgumentException();
        }
        this.initialFontFaces = newInitialFontFaces;
        this.clearLayouts();
    }

    public FontFace getDefaultFontFace() {
        return this.defaultFontFace;
    }

    public FontFace[] getInitialFontFaces() {
        return this.initialFontFaces;
    }

    public void setFontFaceSet(FontFace[] fontFaceSet) {
        this.setFontFaceSetSilent(fontFaceSet);
        this.clearLayouts();
    }

    protected void setFontFaceSetSilent(FontFace[] fontFaceSet) {
        this.fontFaceDB = new Hashtable();
        this.growFontFaceDB(this.fontFaceDB, fontFaceSet);
        this.growFontFaceDB(this.fontFaceDB, this.initialFontFaces);
    }

    public void addFontFace(FontFace fontFace) {
        if (this.fontFaceDB == null) {
            this.setFontFaceSetSilent(null);
        }
        this.growFontFaceDB(this.fontFaceDB, new FontFace[]{fontFace});
        this.clearLayouts();
    }

    protected void growFontFaceDB(Hashtable ffDB, FontFace[] fontFaceSet) {
        if (fontFaceSet == null) {
            return;
        }
        for (int i = 0; i < fontFaceSet.length; ++i) {
            FontFace ff = fontFaceSet[i];
            String[] fontFamilies = ff.getFontFamilies();
            if (fontFamilies == null) continue;
            for (int j = 0; j < fontFamilies.length; ++j) {
                Vector<FontFace> v = (Vector<FontFace>)ffDB.get(fontFamilies[j]);
                if (v == null) {
                    v = new Vector<FontFace>(1);
                    ffDB.put(fontFamilies[j], v);
                    v.addElement(ff);
                    continue;
                }
                if (v.contains(ff)) continue;
                v.addElement(ff);
            }
        }
    }

    public Time getCurrentTime() {
        return this.timeContainerRootSupport.lastSampleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyAnimations() {
        try {
            this.applyAnimationsCalled = true;
            int n = this.activeTraitAnims.size();
            for (int i = 0; i < n; ++i) {
                ((TraitAnim)this.activeTraitAnims.elementAt(i)).apply();
            }
            n = this.elementsToDiscard.size();
            for (int i = 0; i < n; ++i) {
                String discardedID;
                ElementNode targetElement = (ElementNode)this.elementsToDiscard.elementAt(i);
                if (!CompositeNode.isIdBranch(targetElement) && targetElement.getParentNode() != null) {
                    targetElement.getParentNode().removeChild(targetElement);
                }
                if ((discardedID = targetElement.getId()) == null) continue;
                this.resolvedIDRefs.remove(discardedID);
                this.idToElement.remove(discardedID);
            }
            this.elementsToDiscard.removeAllElements();
        }
        finally {
            this.applyAnimationsCalled = false;
        }
    }

    void applyMedia() {
        if (this.playing) {
            int n = this.activeMediaElements.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MediaElement)this.activeMediaElements.elementAt(i)).playMedia();
            }
        } else {
            int n = this.activeMediaElements.size();
            for (int i = n - 1; i >= 0; --i) {
                ((MediaElement)this.activeMediaElements.elementAt(i)).endMedia();
            }
        }
    }

    public void sample(Time currentTime) {
        this.timeContainerRootSupport.sample(currentTime);
    }

    public void incrementTime(float seconds) {
        if (seconds < 0.0f) {
            throw new IllegalArgumentException();
        }
        long lastSampleTime = this.timeContainerRootSupport.lastSampleTime.value;
        this.timeContainerRootSupport.sample(new Time(lastSampleTime + (long)(seconds * 1000.0f)));
    }

    public void initializeTimingEngine() {
        this.timeContainerRootSupport.initialize();
    }

    public void dump() {
        DocumentNode.dump(this, "", System.err);
    }

    static void dump(ModelNode n, String prefix, PrintStream out) {
        out.print(prefix + " " + n);
        if (n instanceof ElementNode) {
            ElementNode e = (ElementNode)n;
            String pfx = n.ownerDocument.toPrefix(e.getNamespaceURI(), e);
            if (pfx == null || pfx.length() == 0) {
                out.println(" <" + e.getLocalName() + ">");
            } else {
                out.println(" <" + pfx + ":" + e.getLocalName() + ">");
            }
        } else {
            out.println();
        }
        ModelNode child = n.getFirstChildNode();
        while (child != null) {
            DocumentNode.dump(child, prefix + "+-->", out);
            child = child.nextSibling;
        }
        child = n.getFirstExpandedChild();
        while (child != null) {
            DocumentNode.dump(child, prefix + "*~~>", out);
            child = child.nextSibling;
        }
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        if (namespaceURI == null || qualifiedName == null) {
            throw new NullPointerException();
        }
        String localName = qualifiedName;
        int pi = qualifiedName.indexOf(58);
        if (pi != -1) {
            localName = pi == localName.length() - 1 ? "" : qualifiedName.substring(pi + 1);
        }
        if (namespaceURI.length() == 0) {
            namespaceURI = this.defaultNamespaceURI;
        }
        Hashtable lmap = (Hashtable)this.namespaceMap.get(namespaceURI);
        ElementNode en = null;
        if (lmap != null && (en = (ElementNode)lmap.get(localName)) != null) {
            en = en.newInstance(this);
        }
        if (en == null) {
            this.checkNCName(localName);
            en = new GenericElementNode(namespaceURI, localName, this);
        }
        return en;
    }

    protected DOMException unsupportedTrait(String name) {
        return new DOMException(9, Messages.formatMessage("error.unsupported.trait", new String[]{name, null, this.getLocalName(), this.getNamespaceURI()}));
    }

    final void checkNCName(String name) throws DOMException {
        if (name == null || name.length() == 0) {
            throw this.unsupportedTrait(name);
        }
        char c = name.charAt(0);
        if (!DocumentNode.isLetter(c) && c != '_') {
            throw this.unsupportedTrait(name);
        }
        for (int i = 1; i < name.length(); ++i) {
            c = name.charAt(i);
            if (DocumentNode.isNCNameChar(c)) continue;
            throw this.unsupportedTrait(name);
        }
    }

    static final boolean isNCNameChar(char c) {
        return DocumentNode.isLetter(c) || Character.isDigit(c) || c == '.' || c == '-' || c == '_' || DocumentNode.isCombiningChar(c) || DocumentNode.isExtender(c);
    }

    static final boolean isExtender(int c) {
        return c == 183 || c == 720 || c == 721 || c == 903 || c == 1600 || c == 3654 || c == 3782 || c == 12293 || c >= 12337 && c <= 12341 || c >= 12445 && c <= 12446 || c >= 12540 && c <= 12542;
    }

    static final boolean isCombiningChar(int c) {
        return c >= 768 && c <= 837 || c >= 864 && c <= 865 || c >= 1155 && c <= 1158 || c >= 1425 && c <= 1441 || c >= 1443 && c <= 1465 || c >= 1467 && c <= 1469 || c == 1471 || c >= 1473 && c <= 1474 || c == 1476 || c >= 1611 && c <= 1618 || c == 1648 || c >= 1750 && c <= 1756 || c >= 1757 && c <= 1759 || c >= 1760 && c <= 1764 || c >= 1767 && c <= 1768 || c >= 1770 && c <= 1773 || c >= 2305 && c <= 2307 || c == 2364 || c >= 2366 && c <= 2380 || c == 2381 || c >= 2385 && c <= 2388 || c >= 2402 && c <= 2403 || c >= 2433 && c <= 2435 || c == 2492 || c == 2494 || c == 2495 || c >= 2496 && c <= 2500 || c >= 2503 && c <= 2504 || c >= 2507 && c <= 2509 || c == 2519 || c >= 2530 && c <= 2531 || c == 2562 || c == 2620 || c == 2622 || c == 2623 || c >= 2624 && c <= 2626 || c >= 2631 && c <= 2632 || c >= 2635 && c <= 2637 || c >= 2672 && c <= 2673 || c >= 2689 && c <= 2691 || c == 2748 || c >= 2750 && c <= 2757 || c >= 2759 && c <= 2761 || c >= 2763 && c <= 2765 || c >= 2817 && c <= 2819 || c == 2876 || c >= 2878 && c <= 2883 || c >= 2887 && c <= 2888 || c >= 2891 && c <= 2893 || c >= 2902 && c <= 2903 || c >= 2946 && c <= 2947 || c >= 3006 && c <= 3010 || c >= 3014 && c <= 3016 || c >= 3018 && c <= 3021 || c == 3031 || c >= 3073 && c <= 3075 || c >= 3134 && c <= 3140 || c >= 3142 && c <= 3144 || c >= 3146 && c <= 3149 || c >= 3157 && c <= 3158 || c >= 3202 && c <= 3203 || c >= 3262 && c <= 3268 || c >= 3270 && c <= 3272 || c >= 3274 && c <= 3277 || c >= 3285 && c <= 3286 || c >= 3330 && c <= 3331 || c >= 3390 && c <= 3395 || c >= 3398 && c <= 3400 || c >= 3402 && c <= 3405 || c == 3415 || c == 3633 || c >= 3636 && c <= 3642 || c >= 3655 && c <= 3662 || c == 3761 || c >= 3764 && c <= 3769 || c >= 3771 && c <= 3772 || c >= 3784 && c <= 3789 || c >= 3864 && c <= 3865 || c == 3893 || c == 3895 || c == 3897 || c == 3902 || c == 3903 || c >= 3953 && c <= 3972 || c >= 3974 && c <= 3979 || c >= 3984 && c <= 3989 || c == 3991 || c >= 3993 && c <= 4013 || c >= 4017 && c <= 4023 || c == 4025 || c >= 8400 && c <= 8412 || c == 8417 || c >= 12330 && c <= 12335 || c == 12441 || c == 12442;
    }

    static final boolean isLetter(int c) {
        return DocumentNode.isIdeographic(c) || DocumentNode.isBaseChar(c);
    }

    static final boolean isIdeographic(int c) {
        return c >= 19968 && c <= 40869 || c == 12295 || c >= 12321 && c <= 12329;
    }

    static final boolean isBaseChar(int c) {
        return c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 255 || c >= 256 && c <= 305 || c >= 308 && c <= 318 || c >= 321 && c <= 328 || c >= 330 && c <= 382 || c >= 384 && c <= 451 || c >= 461 && c <= 496 || c >= 500 && c <= 501 || c >= 506 && c <= 535 || c >= 592 && c <= 680 || c >= 699 && c <= 705 || c == 902 || c >= 904 && c <= 906 || c == 908 || c >= 910 && c <= 929 || c >= 931 && c <= 974 || c >= 976 && c <= 982 || c == 986 || c == 988 || c == 990 || c == 992 || c >= 994 && c <= 1011 || c >= 1025 && c <= 1036 || c >= 1038 && c <= 1103 || c >= 1105 && c <= 1116 || c >= 1118 && c <= 1153 || c >= 1168 && c <= 1220 || c >= 1223 && c <= 1224 || c >= 1227 && c <= 1228 || c >= 1232 && c <= 1259 || c >= 1262 && c <= 1269 || c >= 1272 && c <= 1273 || c >= 1329 && c <= 1366 || c == 1369 || c >= 1377 && c <= 1414 || c >= 1488 && c <= 1514 || c >= 1520 && c <= 1522 || c >= 1569 && c <= 1594 || c >= 1601 && c <= 1610 || c >= 1649 && c <= 1719 || c >= 1722 && c <= 1726 || c >= 1728 && c <= 1742 || c >= 1744 && c <= 1747 || c == 1749 || c >= 1765 && c <= 1766 || c >= 2309 && c <= 2361 || c == 2365 || c >= 2392 && c <= 2401 || c >= 2437 && c <= 2444 || c >= 2447 && c <= 2448 || c >= 2451 && c <= 2472 || c >= 2474 && c <= 2480 || c == 2482 || c >= 2486 && c <= 2489 || c >= 2524 && c <= 2525 || c >= 2527 && c <= 2529 || c >= 2544 && c <= 2545 || c >= 2565 && c <= 2570 || c >= 2575 && c <= 2576 || c >= 2579 && c <= 2600 || c >= 2602 && c <= 2608 || c >= 2610 && c <= 2611 || c >= 2613 && c <= 2614 || c >= 2616 && c <= 2617 || c >= 2649 && c <= 2652 || c == 2654 || c >= 2674 && c <= 2676 || c >= 2693 && c <= 2699 || c == 2701 || c >= 2703 && c <= 2705 || c >= 2707 && c <= 2728 || c >= 2730 && c <= 2736 || c >= 2738 && c <= 2739 || c >= 2741 && c <= 2745 || c == 2749 || c == 2784 || c >= 2821 && c <= 2828 || c >= 2831 && c <= 2832 || c >= 2835 && c <= 2856 || c >= 2858 && c <= 2864 || c >= 2866 && c <= 2867 || c >= 2870 && c <= 2873 || c == 2877 || c >= 2908 && c <= 2909 || c >= 2911 && c <= 2913 || c >= 2949 && c <= 2954 || c >= 2958 && c <= 2960 || c >= 2962 && c <= 2965 || c >= 2969 && c <= 2970 || c == 2972 || c >= 2974 && c <= 2975 || c >= 2979 && c <= 2980 || c >= 2984 && c <= 2986 || c >= 2990 && c <= 2997 || c >= 2999 && c <= 3001 || c >= 3077 && c <= 3084 || c >= 3086 && c <= 3088 || c >= 3090 && c <= 3112 || c >= 3114 && c <= 3123 || c >= 3125 && c <= 3129 || c >= 3168 && c <= 3169 || c >= 3205 && c <= 3212 || c >= 3214 && c <= 3216 || c >= 3218 && c <= 3240 || c >= 3242 && c <= 3251 || c >= 3253 && c <= 3257 || c == 3294 || c >= 3296 && c <= 3297 || c >= 3333 && c <= 3340 || c >= 3342 && c <= 3344 || c >= 3346 && c <= 3368 || c >= 3370 && c <= 3385 || c >= 3424 && c <= 3425 || c >= 3585 && c <= 3630 || c == 3632 || c >= 3634 && c <= 3635 || c >= 3648 && c <= 3653 || c >= 3713 && c <= 3714 || c == 3716 || c >= 3719 && c <= 3720 || c == 3722 || c == 3725 || c >= 3732 && c <= 3735 || c >= 3737 && c <= 3743 || c >= 3745 && c <= 3747 || c == 3749 || c == 3751 || c >= 3754 && c <= 3755 || c >= 3757 && c <= 3758 || c == 3760 || c >= 3762 && c <= 3763 || c == 3773 || c >= 3776 && c <= 3780 || c >= 3904 && c <= 3911 || c >= 3913 && c <= 3945 || c >= 4256 && c <= 4293 || c >= 4304 && c <= 4342 || c == 4352 || c >= 4354 && c <= 4355 || c >= 4357 && c <= 4359 || c == 4361 || c >= 4363 && c <= 4364 || c >= 4366 && c <= 4370 || c == 4412 || c == 4414 || c == 4416 || c == 4428 || c == 4430 || c == 4432 || c >= 4436 && c <= 4437 || c == 4441 || c >= 4447 && c <= 4449 || c == 4451 || c == 4453 || c == 4455 || c == 4457 || c >= 4461 && c <= 4462 || c >= 4466 && c <= 4467 || c == 4469 || c == 4510 || c == 4520 || c == 4523 || c >= 4526 && c <= 4527 || c >= 4535 && c <= 4536 || c == 4538 || c >= 4540 && c <= 4546 || c == 4587 || c == 4592 || c == 4601 || c >= 7680 && c <= 7835 || c >= 7840 && c <= 7929 || c >= 7936 && c <= 7957 || c >= 7960 && c <= 7965 || c >= 7968 && c <= 8005 || c >= 8008 && c <= 8013 || c >= 8016 && c <= 8023 || c == 8025 || c == 8027 || c == 8029 || c >= 8031 && c <= 8061 || c >= 8064 && c <= 8116 || c >= 8118 && c <= 8124 || c == 8126 || c >= 8130 && c <= 8132 || c >= 8134 && c <= 8140 || c >= 8144 && c <= 8147 || c >= 8150 && c <= 8155 || c >= 8160 && c <= 8172 || c >= 8178 && c <= 8180 || c >= 8182 && c <= 8188 || c == 8486 || c >= 8490 && c <= 8491 || c == 8494 || c >= 8576 && c <= 8578 || c >= 12353 && c <= 12436 || c >= 12449 && c <= 12538 || c >= 12549 && c <= 12588 || c >= 44032 && c <= 55203;
    }

    public void addPrototype(ElementNode prototypeElement) {
        String namespaceURI = prototypeElement.getNamespaceURI();
        Hashtable<String, ElementNode> lmap = (Hashtable<String, ElementNode>)this.namespaceMap.get(namespaceURI);
        if (lmap == null) {
            lmap = new Hashtable<String, ElementNode>();
            this.namespaceMap.put(namespaceURI, lmap);
        }
        lmap.put(prototypeElement.getLocalName(), prototypeElement);
    }

    public Element getDocumentElement() {
        return this.firstChild;
    }

    public Node adoptNode(Node source) throws DOMException {
        if (source == null) {
            throw new NullPointerException();
        }
        if (source instanceof Document) {
            throw new DOMException(9, Messages.formatMessage("error.adopting.document.element", null));
        }
        if (!(source instanceof ModelNode)) {
            return null;
        }
        ModelNode modelNode = (ModelNode)((Object)source);
        Node parent = (Node)((Object)modelNode.getParent());
        if (parent != null) {
            parent.removeChild((Node)((Object)modelNode));
        }
        modelNode.ownerDocument = this.ownerDocument;
        ModelNode child = modelNode.getFirstChildNode();
        while (child != null) {
            child.ownerDocument = this.ownerDocument;
            child = child.nextSibling;
        }
        return (Node)((Object)modelNode);
    }

    public Node adoptNode(Node source, boolean strict) throws DOMException {
        if (strict) {
            return this.adoptNode(source);
        }
        if (source == null) {
            throw new NullPointerException();
        }
        if (source instanceof Document) {
            throw new DOMException(9, Messages.formatMessage("error.adopting.document.element", null));
        }
        if (!(source instanceof ModelNode)) {
            return null;
        }
        ModelNode modelNode = (ModelNode)((Object)source);
        ModelNode parent = modelNode.getParent();
        if (parent != null) {
            parent.unhookQuiet(modelNode);
            ((CompositeNode)parent).removeChildQuiet((Node)((Object)modelNode));
        }
        DocumentNode oldDoc = modelNode.getOwnerDocument();
        ModelNode currNode = modelNode;
        String id = null;
        Vector unresVector = null;
        boolean needsChild = true;
        while (currNode != null) {
            if (currNode instanceof ElementNode) {
                ElementNode currElementNode = (ElementNode)currNode;
                id = currElementNode.getId();
                if (id != null) {
                    oldDoc.removeIdentifiedNode(currElementNode);
                    oldDoc.reservedIds.remove(currElementNode);
                    if (oldDoc.resolvedIDRefs != null) {
                        Vector resVector = (Vector)oldDoc.resolvedIDRefs.get(id);
                        oldDoc.resolvedIDRefs.remove(id);
                        if (resVector != null && oldDoc.unresolvedIDRefs != null) {
                            unresVector = (Vector)oldDoc.unresolvedIDRefs.get(id);
                            if (unresVector == null) {
                                unresVector = resVector;
                                oldDoc.unresolvedIDRefs.put(id, unresVector);
                            } else {
                                for (int i = 0; i < resVector.size(); ++i) {
                                    unresVector.add(resVector.elementAt(i));
                                }
                            }
                        }
                    }
                    this.reservedIds.put(id, currElementNode);
                }
                if (currNode instanceof IDRef) {
                    String idref = ((IDRef)((Object)currNode)).getIdRef();
                    if (oldDoc.unresolvedIDRefs != null && (unresVector = (Vector)oldDoc.unresolvedIDRefs.get(idref)) != null) {
                        unresVector.remove(currNode);
                    }
                    this.resolveIDRef((IDRef)((Object)currNode), idref);
                }
            }
            currNode.ownerDocument = this.ownerDocument;
            currNode = needsChild ? currNode.getFirstChildNode() : currNode.nextSibling;
            needsChild = false;
        }
        return (Node)((Object)modelNode);
    }

    public Node getParentNode() {
        return null;
    }

    protected boolean isRemoveChildSupported() {
        return false;
    }

    protected boolean isAllowedChild(ElementNode node) {
        return node instanceof SVG;
    }

    public void addNamespacePrefix(String prefix, String namespaceURI, ModelNode node) {
        if (prefix == null) {
            throw new NullPointerException();
        }
        Object[][] namespaceEntry = (Object[][])this.prefixes.get(prefix);
        if (namespaceEntry == null) {
            namespaceEntry = new Object[][]{{namespaceURI, node}};
        } else {
            Object[][] newNamespaceEntry = new Object[namespaceEntry.length + 1][];
            newNamespaceEntry[0] = new Object[]{namespaceURI, node};
            System.arraycopy(namespaceEntry, 0, newNamespaceEntry, 1, namespaceEntry.length);
            namespaceEntry = newNamespaceEntry;
        }
        this.prefixes.put(prefix, namespaceEntry);
        Object[][] prefixEntry = (Object[][])this.namespaces.get(namespaceURI);
        if (prefixEntry == null) {
            prefixEntry = new Object[][]{{prefix, node}};
        } else {
            Object[][] newPrefixEntry = new Object[prefixEntry.length + 1][];
            newPrefixEntry[0] = new Object[]{prefix, node};
            System.arraycopy(prefixEntry, 0, newPrefixEntry, 1, prefixEntry.length);
            prefixEntry = newPrefixEntry;
        }
        this.namespaces.put(namespaceURI, prefixEntry);
    }

    String toNamespace(String prefix, ModelNode node) {
        int i;
        Object[][] namespaceEntry = (Object[][])this.prefixes.get(prefix);
        if (namespaceEntry == null) {
            return null;
        }
        ModelNode cur = node;
        int n = namespaceEntry.length;
        while (cur != null && cur != this) {
            for (i = 0; i < n; ++i) {
                if (namespaceEntry[i][1] != cur) continue;
                return (String)namespaceEntry[i][0];
            }
            cur = cur.parent;
        }
        for (i = 0; i < n; ++i) {
            if (namespaceEntry[i][1] != this) continue;
            return (String)namespaceEntry[i][0];
        }
        return null;
    }

    public String toPrefix(String namespaceURI, Element node) {
        int i;
        Object[][] prefixEntry = (Object[][])this.namespaces.get(namespaceURI);
        if (prefixEntry == null) {
            return null;
        }
        ModelNode cur = (ElementNode)node;
        int n = prefixEntry.length;
        while (cur != null && cur != this) {
            for (i = 0; i < n; ++i) {
                if (prefixEntry[i][1] != cur) continue;
                return (String)prefixEntry[i][0];
            }
            cur = cur.parent;
        }
        for (i = 0; i < n; ++i) {
            if (prefixEntry[i][1] != this) continue;
            return (String)prefixEntry[i][0];
        }
        return null;
    }

    public void validate() throws DOMException {
        if (this.unresolvedIDRefs != null && this.unresolvedIDRefs.size() > 0) {
            Enumeration iter = this.unresolvedIDRefs.keys();
            StringBuffer buf = new StringBuffer();
            while (iter.hasMoreElements()) {
                buf.append('[');
                buf.append(iter.nextElement());
                buf.append(']');
            }
            String message = Messages.formatMessage(Messages.ERROR_UNRESOLVED_REFERENCES, new Object[]{buf.toString()});
            throw new DOMException(15, message);
        }
        this.unresolvedIDRefs = null;
        if (this.timedElementNodes != null) {
            int n = this.timedElementNodes.size();
            for (int i = 0; i < n; ++i) {
                TimedElementNode ten = (TimedElementNode)this.timedElementNodes.elementAt(i);
                if (ten.parent == null) continue;
                ten.validate();
            }
        }
        this.timedElementNodes = null;
    }

    void setUnknownTraitsNS(ElementNode element, String namespaceURI, String traitName, String value) {
        Hashtable<String, String> nsMap;
        Hashtable<String, Hashtable<String, String>> eltMap;
        if (this.unknownTraitsNS == null) {
            this.unknownTraitsNS = new Hashtable();
        }
        if ((eltMap = (Hashtable<String, Hashtable<String, String>>)this.unknownTraitsNS.get(element)) == null) {
            eltMap = new Hashtable<String, Hashtable<String, String>>();
            this.unknownTraitsNS.put(element, eltMap);
        }
        if ((nsMap = (Hashtable<String, String>)eltMap.get(namespaceURI)) == null) {
            nsMap = new Hashtable<String, String>();
            eltMap.put(namespaceURI, nsMap);
        }
        nsMap.put(traitName, value);
    }

    String getUnknownTraitsNS(ElementNode element, String namespaceURI, String traitName) {
        if (this.unknownTraitsNS == null) {
            return null;
        }
        Hashtable eltMap = (Hashtable)this.unknownTraitsNS.get(element);
        if (eltMap == null) {
            return null;
        }
        Hashtable nsMap = (Hashtable)eltMap.get(namespaceURI);
        if (nsMap == null) {
            return null;
        }
        return (String)nsMap.get(traitName);
    }
}

