/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Address10;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing10Metadata;
import org.netbeans.modules.websvc.wsitmodelext.addressing.Addressing10QName;
import org.netbeans.modules.websvc.wsitmodelext.mex.Metadata;
import org.netbeans.modules.websvc.wsitmodelext.mex.MetadataReference;
import org.netbeans.modules.websvc.wsitmodelext.mex.MetadataSection;
import org.netbeans.modules.websvc.wsitmodelext.mex.MexQName;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.RequestSecurityTokenTemplate;
import org.netbeans.modules.websvc.wsitmodelext.security.SecurityPolicyQName;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.EncryptedSupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.EncryptionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.EndorsingEncryptedSupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.EndorsingSupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.HashPassword;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.HttpsToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.InitiatorToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.IssuedToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.Issuer;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.KerberosToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RecipientToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.RelToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SamlToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecurityContextToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SignatureToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SignedEncryptedSupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SignedEndorsingEncryptedSupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SignedEndorsingSupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SignedSupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SupportingTokens;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.TransportToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.UsernameToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssGssKerberosV5ApReqToken11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssKerberosV5ApReqToken11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssSamlV10Token10;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssSamlV10Token11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssSamlV11Token10;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssSamlV11Token11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssSamlV20Token11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssUsernameToken10;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssUsernameToken11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509Pkcs7Token10;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509Pkcs7Token11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509PkiPathV1Token10;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509PkiPathV1Token11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509V1Token10;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509V1Token11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509V3Token10;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.WssX509V3Token11;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.X509Token;
import org.netbeans.modules.websvc.wsitmodelext.trust.KeySize;
import org.netbeans.modules.websvc.wsitmodelext.trust.KeyType;
import org.netbeans.modules.websvc.wsitmodelext.trust.TokenType;
import org.netbeans.modules.websvc.wsitmodelext.trust.TrustQName;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;

public class SecurityTokensModelHelper {
    public static final int SUPPORTING = 0;
    public static final int SIGNED_SUPPORTING = 1;
    public static final int ENDORSING = 2;
    public static final int SIGNED_ENDORSING = 3;
    public static final int ENCRYPTED = 4;
    public static final int SIGNED_ENCRYPTED = 5;
    public static final int ENDORSING_ENCRYPTED = 6;
    public static final int SIGNED_ENDORSING_ENCRYPTED = 7;
    public static final int NONE = 100;
    public static Class[] SUPPORTING_TOKENS = new Class[]{SupportingTokens.class, SignedSupportingTokens.class, EndorsingSupportingTokens.class, SignedEndorsingSupportingTokens.class, EncryptedSupportingTokens.class, SignedEncryptedSupportingTokens.class, EndorsingEncryptedSupportingTokens.class, SignedEndorsingEncryptedSupportingTokens.class};
    private static HashMap<ConfigVersion, SecurityTokensModelHelper> instances = new HashMap();
    private ConfigVersion configVersion = ConfigVersion.getDefault();

    private SecurityTokensModelHelper(ConfigVersion configVersion) {
        this.configVersion = configVersion;
    }

    public static final synchronized SecurityTokensModelHelper getInstance(ConfigVersion configVersion) {
        SecurityTokensModelHelper instance = instances.get(configVersion);
        if (instance == null) {
            instance = new SecurityTokensModelHelper(configVersion);
            instances.put(configVersion, instance);
        }
        return instance;
    }

    public static boolean isRequireClientCertificate(HttpsToken token) {
        return token.isRequireClientCertificate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRequireClientCertificate(HttpsToken token, boolean require) {
        WSDLModel model = token.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            token.setRequireClientCertificate(require);
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    public static String getTokenType(WSDLComponent tokenKind) {
        if (tokenKind != null) {
            WSDLComponent wc = null;
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, UsernameToken.class);
            if (wc != null) {
                return ComboConstants.USERNAME;
            }
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, X509Token.class);
            if (wc != null) {
                return ComboConstants.X509;
            }
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, SamlToken.class);
            if (wc != null) {
                return ComboConstants.SAML;
            }
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, RelToken.class);
            if (wc != null) {
                return ComboConstants.REL;
            }
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, KerberosToken.class);
            if (wc != null) {
                return ComboConstants.KERBEROS;
            }
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, SecurityContextToken.class);
            if (wc != null) {
                return ComboConstants.SECURITYCONTEXT;
            }
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, SecureConversationToken.class);
            if (wc != null) {
                return ComboConstants.SECURECONVERSATION;
            }
            wc = SecurityTokensModelHelper.getTokenElement(tokenKind, IssuedToken.class);
            if (wc != null) {
                return ComboConstants.ISSUED;
            }
        }
        return null;
    }

    public static WSDLComponent getTokenTypeElement(WSDLComponent tokenKind) {
        if (tokenKind == null) {
            return null;
        }
        WSDLComponent wc = null;
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, HttpsToken.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, UsernameToken.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, X509Token.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, SamlToken.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, RelToken.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, KerberosToken.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, SecurityContextToken.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, SecureConversationToken.class);
        if (wc != null) {
            return wc;
        }
        wc = SecurityTokensModelHelper.getTokenElement(tokenKind, IssuedToken.class);
        return wc;
    }

    public static boolean isHashPassword(WSDLComponent tokenType) {
        return tokenType instanceof UsernameToken && SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)tokenType, HashPassword.class);
    }

    public static String getTokenProfileVersion(WSDLComponent tokenType) {
        ExtensibilityElement e;
        if (tokenType instanceof UsernameToken) {
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)tokenType, WssUsernameToken10.class)) {
                return ComboConstants.WSS10;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled((ExtensibilityElement)tokenType, WssUsernameToken11.class)) {
                return ComboConstants.WSS11;
            }
        }
        if (tokenType instanceof SamlToken) {
            e = (ExtensibilityElement)tokenType;
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssSamlV10Token10.class)) {
                return ComboConstants.SAML_V1010;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssSamlV10Token11.class)) {
                return ComboConstants.SAML_V1011;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssSamlV11Token10.class)) {
                return ComboConstants.SAML_V1110;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssSamlV11Token11.class)) {
                return ComboConstants.SAML_V1111;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssSamlV20Token11.class)) {
                return ComboConstants.SAML_V2011;
            }
        }
        if (tokenType instanceof X509Token) {
            e = (ExtensibilityElement)tokenType;
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509V1Token10.class)) {
                return ComboConstants.X509_V110;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509V1Token11.class)) {
                return ComboConstants.X509_V111;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509V3Token10.class)) {
                return ComboConstants.X509_V310;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509V3Token11.class)) {
                return ComboConstants.X509_V311;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509Pkcs7Token10.class)) {
                return ComboConstants.X509_PKCS710;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509Pkcs7Token11.class)) {
                return ComboConstants.X509_PKCS711;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509PkiPathV1Token10.class)) {
                return ComboConstants.X509_PKIPATHV110;
            }
            if (SecurityPolicyModelHelper.isAttributeEnabled(e, WssX509PkiPathV1Token11.class)) {
                return ComboConstants.X509_PKIPATHV111;
            }
        }
        return "       ";
    }

    public static WSDLComponent getTokenElement(WSDLComponent e, Class tokenClass) {
        if (e == null) {
            return null;
        }
        List policies = e.getExtensibilityElements(Policy.class);
        if (policies != null && !policies.isEmpty()) {
            Policy p = (Policy)policies.get(0);
            return PolicyModelHelper.getTopLevelElement((WSDLComponent)p, tokenClass, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSDLComponent setTokenType(WSDLComponent secBinding, String tokenKindStr, String tokenTypeStr) {
        WSDLModel model = secBinding.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        WSDLComponent tokenType = null;
        WSDLComponent tokenKind = null;
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            Policy p = (Policy)pmh.createElement(secBinding, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            List tokenKinds = p.getExtensibilityElements();
            if (tokenKinds != null && !tokenKinds.isEmpty()) {
                for (ExtensibilityElement tkind : tokenKinds) {
                    if ("protection".equals(tokenKindStr) || ComboConstants.TRANSPORT.equals(tokenKindStr)) {
                        if (!(tkind instanceof SignatureToken) && !(tkind instanceof TransportToken) && !(tkind instanceof EncryptionToken) && !(tkind instanceof InitiatorToken) && !(tkind instanceof ProtectionToken) && !(tkind instanceof RecipientToken)) continue;
                        p.removeExtensibilityElement(tkind);
                        continue;
                    }
                    if ("encryption".equals(tokenKindStr)) {
                        if (tkind instanceof SignatureToken) continue;
                        p.removeExtensibilityElement(tkind);
                        continue;
                    }
                    if ("signature".equals(tokenKindStr)) {
                        if (tkind instanceof EncryptionToken) continue;
                        p.removeExtensibilityElement(tkind);
                        continue;
                    }
                    if ("initiator".equals(tokenKindStr)) {
                        if (tkind instanceof RecipientToken) continue;
                        p.removeExtensibilityElement(tkind);
                        continue;
                    }
                    if (!"recipient".equals(tokenKindStr) || tkind instanceof InitiatorToken) continue;
                    p.removeExtensibilityElement(tkind);
                }
            }
            if ("protection".equals(tokenKindStr)) {
                tokenKind = wcf.create((WSDLComponent)p, SecurityPolicyQName.PROTECTIONTOKEN.getQName(this.configVersion));
            }
            if ("signature".equals(tokenKindStr)) {
                tokenKind = wcf.create((WSDLComponent)p, SecurityPolicyQName.SIGNATURETOKEN.getQName(this.configVersion));
            }
            if ("encryption".equals(tokenKindStr)) {
                tokenKind = wcf.create((WSDLComponent)p, SecurityPolicyQName.ENCRYPTIONTOKEN.getQName(this.configVersion));
            }
            if ("initiator".equals(tokenKindStr)) {
                tokenKind = wcf.create((WSDLComponent)p, SecurityPolicyQName.INITIATORTOKEN.getQName(this.configVersion));
            }
            if ("recipient".equals(tokenKindStr)) {
                tokenKind = wcf.create((WSDLComponent)p, SecurityPolicyQName.RECIPIENTTOKEN.getQName(this.configVersion));
            }
            if (ComboConstants.TRANSPORT.equals(tokenKindStr)) {
                tokenKind = wcf.create((WSDLComponent)p, SecurityPolicyQName.TRANSPORTTOKEN.getQName(this.configVersion));
            }
            p.addExtensibilityElement((ExtensibilityElement)tokenKind);
            Policy pinner = (Policy)wcf.create(tokenKind, PolicyQName.POLICY.getQName(this.configVersion));
            tokenKind.addExtensibilityElement((ExtensibilityElement)pinner);
            SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(this.configVersion);
            if (ComboConstants.HTTPS.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.HTTPSTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                ((HttpsToken)tokenType).setRequireClientCertificate(false);
            }
            if (ComboConstants.X509.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.X509TOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                this.setTokenProfileVersion(tokenType, ComboConstants.X509_V310);
                SecurityPolicyModelHelper.getInstance(this.configVersion).enableRequireIssuerSerialReference(tokenType, true);
            }
            if (ComboConstants.SAML.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.SAMLTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                this.setTokenProfileVersion(tokenType, ComboConstants.SAML_V1110);
            }
            if (ComboConstants.KERBEROS.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.KERBEROSTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                this.setTokenProfileVersion(tokenType, ComboConstants.KERBEROS_KERBEROSGSS);
            }
            if (ComboConstants.ISSUED.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.ISSUEDTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                RequestSecurityTokenTemplate template = (RequestSecurityTokenTemplate)wcf.create(tokenType, SecurityPolicyQName.REQUESTSECURITYTOKENTEMPLATE.getQName(this.configVersion));
                tokenType.addExtensibilityElement((ExtensibilityElement)template);
                TokenType trustTokenType = (TokenType)wcf.create((WSDLComponent)template, TrustQName.TOKENTYPE.getQName(this.configVersion));
                template.addExtensibilityElement((ExtensibilityElement)trustTokenType);
                trustTokenType.setContent(ComboConstants.ISSUED_TOKENTYPE_SAML11_POLICYSTR);
                KeyType trustKeyType = (KeyType)wcf.create((WSDLComponent)template, TrustQName.KEYTYPE.getQName(this.configVersion));
                template.addExtensibilityElement((ExtensibilityElement)trustKeyType);
                String nsStart = TrustQName.getNamespaceUri((ConfigVersion)this.configVersion);
                trustKeyType.setContent(nsStart + ComboConstants.ISSUED_KEYTYPE_SYMMETRIC_POLICYSTR);
                KeySize trustKeySize = (KeySize)wcf.create((WSDLComponent)template, TrustQName.KEYSIZE.getQName(this.configVersion));
                template.addExtensibilityElement((ExtensibilityElement)trustKeySize);
                trustKeySize.setContent(ComboConstants.ISSUED_KEYSIZE_256);
                spmh.enableRequireInternalReference(tokenType, true);
            }
            if (ComboConstants.USERNAME.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.USERNAMETOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                this.setTokenProfileVersion(tokenType, ComboConstants.WSS10);
            }
            if (ComboConstants.REL.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.RELTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                spmh.enableRequireDerivedKeys(tokenType, true);
            }
            if (ComboConstants.SECURECONVERSATION.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.SECURECONVERSATIONTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                spmh.enableRequireDerivedKeys(tokenType, true);
            }
            if (ComboConstants.SECURITYCONTEXT.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.SECURITYCONTEXTTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                spmh.enableRequireDerivedKeys(tokenType, true);
            }
            if (ComboConstants.SPNEGOCONTEXT.equals(tokenTypeStr)) {
                tokenType = wcf.create((WSDLComponent)pinner, SecurityPolicyQName.SPNEGOCONTEXTTOKEN.getQName(this.configVersion));
                pinner.addExtensibilityElement((ExtensibilityElement)tokenType);
                spmh.enableRequireDerivedKeys(tokenType, true);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
        return tokenType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setTokenInclusionLevel(WSDLComponent tokenType, String incLevel) {
        WSDLModel model = tokenType.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            String nsStart;
            String levelStr = nsStart = SecurityPolicyQName.getNamespaceUri((ConfigVersion)this.configVersion);
            if (ComboConstants.NEVER.equals(incLevel)) {
                levelStr = levelStr + "/IncludeToken/Never";
            } else if (ComboConstants.ALWAYS.equals(incLevel)) {
                levelStr = levelStr + "/IncludeToken/Always";
            } else if (ComboConstants.ALWAYSRECIPIENT.equals(incLevel)) {
                levelStr = levelStr + "/IncludeToken/AlwaysToRecipient";
            } else if (ComboConstants.ONCE.equals(incLevel)) {
                levelStr = levelStr + "/IncludeToken/Once";
            }
            ((ExtensibilityElement)tokenType).setAnyAttribute(SecurityPolicyQName.INCLUDETOKENATTRIBUTE.getQName(this.configVersion), levelStr);
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHashPassword(WSDLComponent tokenType, boolean enable) {
        System.out.println("setHAshPassword" + tokenType + ", " + enable);
        WSDLModel model = tokenType.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            Policy p = (Policy)pmh.createElement(tokenType, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            List tokenAssertions = p.getExtensibilityElements();
            if (tokenType instanceof UsernameToken) {
                if (tokenAssertions != null && !tokenAssertions.isEmpty()) {
                    for (ExtensibilityElement e : tokenAssertions) {
                        if (!(e instanceof HashPassword)) continue;
                        p.removeExtensibilityElement(e);
                    }
                }
                if (enable) {
                    WSDLComponent wc = wcf.create((WSDLComponent)p, SecurityPolicyQName.HASHPASSWORD.getQName(this.configVersion));
                    p.addExtensibilityElement((ExtensibilityElement)wc);
                }
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTokenProfileVersion(WSDLComponent tokenType, String profileVersion) {
        WSDLModel model = tokenType.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            Policy p = (Policy)pmh.createElement(tokenType, PolicyQName.POLICY.getQName(this.configVersion), Policy.class, false);
            WSDLComponent profileVersionAssertion = null;
            List tokenAssertions = p.getExtensibilityElements();
            if (tokenType instanceof UsernameToken) {
                if (tokenAssertions != null && !tokenAssertions.isEmpty()) {
                    for (ExtensibilityElement e : tokenAssertions) {
                        if (!(e instanceof WssUsernameToken10) && !(e instanceof WssUsernameToken11)) continue;
                        p.removeExtensibilityElement(e);
                    }
                }
                if (ComboConstants.WSS10.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSUSERNAMETOKEN10.getQName(this.configVersion));
                }
                if (ComboConstants.WSS11.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSUSERNAMETOKEN11.getQName(this.configVersion));
                }
            }
            if (tokenType instanceof SamlToken) {
                if (tokenAssertions != null && !tokenAssertions.isEmpty()) {
                    for (ExtensibilityElement e : tokenAssertions) {
                        if (!(e instanceof WssSamlV10Token11) && !(e instanceof WssSamlV10Token10) && !(e instanceof WssSamlV11Token10) && !(e instanceof WssSamlV11Token11) && !(e instanceof WssSamlV20Token11)) continue;
                        p.removeExtensibilityElement(e);
                    }
                }
                if (ComboConstants.SAML_V1010.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSSAMLV10TOKEN10.getQName(this.configVersion));
                }
                if (ComboConstants.SAML_V1011.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSSAMLV10TOKEN11.getQName(this.configVersion));
                }
                if (ComboConstants.SAML_V1110.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSSAMLV11TOKEN10.getQName(this.configVersion));
                }
                if (ComboConstants.SAML_V1111.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSSAMLV11TOKEN11.getQName(this.configVersion));
                }
                if (ComboConstants.SAML_V2011.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSSAMLV20TOKEN11.getQName(this.configVersion));
                }
            }
            if (tokenType instanceof X509Token) {
                if (tokenAssertions != null && !tokenAssertions.isEmpty()) {
                    for (ExtensibilityElement e : tokenAssertions) {
                        if (!(e instanceof WssX509V1Token10) && !(e instanceof WssX509V3Token10) && !(e instanceof WssX509V1Token11) && !(e instanceof WssX509V3Token11) && !(e instanceof WssX509Pkcs7Token10) && !(e instanceof WssX509Pkcs7Token11) && !(e instanceof WssX509PkiPathV1Token10) && !(e instanceof WssX509PkiPathV1Token11)) continue;
                        p.removeExtensibilityElement(e);
                    }
                }
                if (ComboConstants.X509_V110.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509V1TOKEN10.getQName(this.configVersion));
                }
                if (ComboConstants.X509_V310.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509V3TOKEN10.getQName(this.configVersion));
                }
                if (ComboConstants.X509_V111.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509V1TOKEN11.getQName(this.configVersion));
                }
                if (ComboConstants.X509_V311.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509V3TOKEN11.getQName(this.configVersion));
                }
                if (ComboConstants.X509_PKCS710.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509PKCS7TOKEN10.getQName(this.configVersion));
                }
                if (ComboConstants.X509_PKCS711.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509PKCS7TOKEN11.getQName(this.configVersion));
                }
                if (ComboConstants.X509_PKIPATHV110.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509PKIPATHV1TOKEN10.getQName(this.configVersion));
                }
                if (ComboConstants.X509_PKIPATHV111.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSX509PKIPATHV1TOKEN11.getQName(this.configVersion));
                }
            }
            if (tokenType instanceof KerberosToken) {
                if (tokenAssertions != null && !tokenAssertions.isEmpty()) {
                    for (ExtensibilityElement e : tokenAssertions) {
                        if (!(e instanceof WssGssKerberosV5ApReqToken11) && !(e instanceof WssKerberosV5ApReqToken11)) continue;
                        p.removeExtensibilityElement(e);
                    }
                }
                if (ComboConstants.KERBEROS_KERBEROS.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSKERBEROSV5APREQTOKEN11.getQName(this.configVersion));
                }
                if (ComboConstants.KERBEROS_KERBEROSGSS.equals(profileVersion)) {
                    profileVersionAssertion = wcf.create((WSDLComponent)p, SecurityPolicyQName.WSSGSSKERBEROSV5APREQTOKEN11.getQName(this.configVersion));
                }
            }
            if (profileVersionAssertion != null) {
                p.addExtensibilityElement((ExtensibilityElement)profileVersionAssertion);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    public static List<WSDLComponent> getSupportingTokens(WSDLComponent c) {
        ArrayList<WSDLComponent> result = new ArrayList<WSDLComponent>(1);
        if (c == null) {
            return null;
        }
        WSDLComponent p = c;
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            p = PolicyModelHelper.getPolicyForElement(c);
        }
        if (p == null) {
            return null;
        }
        for (Class cl : SUPPORTING_TOKENS) {
            Object token = PolicyModelHelper.getTopLevelElement(p, cl, false);
            if (token == null) continue;
            result.add((WSDLComponent)token);
        }
        return result;
    }

    public static WSDLComponent getSupportingToken(WSDLComponent c, int supportingType) {
        if (c == null) {
            return null;
        }
        WSDLComponent p = c;
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            p = PolicyModelHelper.getPolicyForElement(c);
        }
        if (p == null) {
            return null;
        }
        return PolicyModelHelper.getTopLevelElement(p, SUPPORTING_TOKENS[supportingType], false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSupportingTokens(WSDLComponent c) {
        if (c == null) {
            return;
        }
        WSDLModel model = c.getModel();
        WSDLComponent p = c;
        if (c instanceof Binding || c instanceof BindingOperation || c instanceof BindingInput || c instanceof BindingOutput || c instanceof BindingFault) {
            p = PolicyModelHelper.getPolicyForElement(c);
        }
        if (p == null) {
            return;
        }
        ExtensibilityElement rem = null;
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            for (Class cl : SUPPORTING_TOKENS) {
                rem = (ExtensibilityElement)PolicyModelHelper.getTopLevelElement(p, cl, false);
                if (rem == null) continue;
                ((WSDLComponent)rem.getParent()).removeExtensibilityElement(rem);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSDLComponent setSupportingTokens(WSDLComponent c, String authToken, int supportingType) {
        if (c == null) {
            return null;
        }
        WSDLModel model = c.getModel();
        WSDLComponentFactory wcf = model.getFactory();
        WSDLComponent tokenType = null;
        WSDLComponent tokenKind = null;
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            for (int i = 0; i < SUPPORTING_TOKENS.length; ++i) {
                tokenKind = SecurityTokensModelHelper.getSupportingToken(c, i);
                if (tokenKind == null) continue;
                if ("       ".equals(authToken) || authToken == null) {
                    if (i == supportingType || supportingType == 100) {
                        ((WSDLComponent)tokenKind.getParent()).removeExtensibilityElement((ExtensibilityElement)tokenKind);
                    }
                    if (supportingType == 100) continue;
                    WSDLComponent wSDLComponent = null;
                    return wSDLComponent;
                }
                if (i != supportingType) continue;
                ((WSDLComponent)tokenKind.getParent()).removeExtensibilityElement((ExtensibilityElement)tokenKind);
            }
            if (supportingType == 100) {
                WSDLComponent i = null;
                return i;
            }
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            Object topLevel = null;
            topLevel = c instanceof Policy ? c : pmh.createPolicy(c, true);
            if (0 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.SUPPORTINGTOKENS.getQName(this.configVersion));
            }
            if (1 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.SIGNEDSUPPORTINGTOKENS.getQName(this.configVersion));
            }
            if (2 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.ENDORSINGSUPPORTINGTOKENS.getQName(this.configVersion));
            }
            if (3 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.SIGNEDENDORSINGSUPPORTINGTOKENS.getQName(this.configVersion));
            }
            if (4 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.ENCRYPTEDSUPPORTINGTOKENS.getQName(this.configVersion));
            }
            if (5 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.SIGNEDENCRYPTEDSUPPORTINGTOKENS.getQName(this.configVersion));
            }
            if (7 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.SIGNEDENDORSINGENCRYPTEDSUPPORTINGTOKENS.getQName(this.configVersion));
            }
            if (6 == supportingType) {
                tokenKind = wcf.create(topLevel, SecurityPolicyQName.ENDORSINGENCRYPTEDSUPPORTINGTOKENS.getQName(this.configVersion));
            }
            topLevel.addExtensibilityElement((ExtensibilityElement)tokenKind);
            if (ComboConstants.USERNAME.equals(authToken)) {
                tokenType = (WSDLComponent)pmh.createElement(tokenKind, SecurityPolicyQName.USERNAMETOKEN.getQName(this.configVersion), UsernameToken.class, true);
                this.setTokenProfileVersion(tokenType, ComboConstants.WSS10);
                this.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
            }
            if (ComboConstants.X509.equals(authToken)) {
                tokenType = (WSDLComponent)pmh.createElement(tokenKind, SecurityPolicyQName.X509TOKEN.getQName(this.configVersion), X509Token.class, true);
                this.setTokenProfileVersion(tokenType, ComboConstants.X509_V310);
                this.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
            }
            if (ComboConstants.SAML.equals(authToken)) {
                tokenType = (WSDLComponent)pmh.createElement(tokenKind, SecurityPolicyQName.SAMLTOKEN.getQName(this.configVersion), SamlToken.class, true);
                this.setTokenProfileVersion(tokenType, ComboConstants.SAML_V1110);
                this.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
            }
            if (ComboConstants.SECURECONVERSATION.equals(authToken)) {
                tokenType = (WSDLComponent)pmh.createElement(tokenKind, SecurityPolicyQName.SECURECONVERSATIONTOKEN.getQName(this.configVersion), SecureConversationToken.class, true);
                this.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
            }
            if (ComboConstants.ISSUED.equals(authToken)) {
                tokenType = (WSDLComponent)pmh.createElement(tokenKind, SecurityPolicyQName.ISSUEDTOKEN.getQName(this.configVersion), IssuedToken.class, true);
                this.setTokenInclusionLevel(tokenType, ComboConstants.ALWAYSRECIPIENT);
                RequestSecurityTokenTemplate template = (RequestSecurityTokenTemplate)wcf.create(tokenType, SecurityPolicyQName.REQUESTSECURITYTOKENTEMPLATE.getQName(this.configVersion));
                tokenType.addExtensibilityElement((ExtensibilityElement)template);
                TokenType trustTokenType = (TokenType)pmh.createElement((WSDLComponent)template, TrustQName.TOKENTYPE.getQName(this.configVersion), TokenType.class, false);
                trustTokenType.setContent(ComboConstants.ISSUED_TOKENTYPE_SAML11_POLICYSTR);
                KeyType trustKeyType = (KeyType)pmh.createElement((WSDLComponent)template, TrustQName.KEYTYPE.getQName(this.configVersion), KeyType.class, false);
                String nsStart = TrustQName.getNamespaceUri((ConfigVersion)this.configVersion);
                trustKeyType.setContent(nsStart + ComboConstants.ISSUED_KEYTYPE_SYMMETRIC_POLICYSTR);
                KeySize trustKeySize = (KeySize)pmh.createElement((WSDLComponent)template, TrustQName.KEYSIZE.getQName(this.configVersion), KeySize.class, false);
                trustKeySize.setContent(ComboConstants.ISSUED_KEYSIZE_256);
                SecurityPolicyModelHelper.getInstance(this.configVersion).enableRequireInternalReference(tokenType, true);
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
        return tokenType;
    }

    public static String getIssuedIssuerAddress(WSDLComponent tokenType) {
        Address10 a;
        Issuer issuer;
        List addrs;
        List issuerList;
        if (tokenType != null && (issuerList = tokenType.getExtensibilityElements(Issuer.class)) != null && !issuerList.isEmpty() && (addrs = (issuer = (Issuer)issuerList.get(0)).getExtensibilityElements(Address10.class)) != null && !addrs.isEmpty() && (a = (Address10)addrs.get(0)) != null) {
            return a.getAddress();
        }
        return null;
    }

    public static String getIssuedTokenType(WSDLComponent tokenType) {
        RequestSecurityTokenTemplate rst;
        TokenType tType;
        List rstList;
        if (tokenType != null && (rstList = tokenType.getExtensibilityElements(RequestSecurityTokenTemplate.class)) != null && !rstList.isEmpty() && (tType = (rst = (RequestSecurityTokenTemplate)rstList.get(0)).getTokenType()) != null) {
            String type = tType.getContent();
            if (ComboConstants.ISSUED_TOKENTYPE_SAML10_POLICYSTR.equals(type)) {
                return ComboConstants.ISSUED_TOKENTYPE_SAML10;
            }
            if (ComboConstants.ISSUED_TOKENTYPE_SAML11_POLICYSTR.equals(type)) {
                return ComboConstants.ISSUED_TOKENTYPE_SAML11;
            }
            if (ComboConstants.ISSUED_TOKENTYPE_SAML20_POLICYSTR.equals(type)) {
                return ComboConstants.ISSUED_TOKENTYPE_SAML20;
            }
        }
        return null;
    }

    public static String getIssuedKeyType(WSDLComponent tokenType) {
        String type;
        RequestSecurityTokenTemplate rst;
        KeyType kType;
        List rstList;
        if (tokenType != null && (rstList = tokenType.getExtensibilityElements(RequestSecurityTokenTemplate.class)) != null && !rstList.isEmpty() && (kType = (rst = (RequestSecurityTokenTemplate)rstList.get(0)).getKeyType()) != null && (type = kType.getContent()) != null) {
            if (type.endsWith(ComboConstants.ISSUED_KEYTYPE_PUBLIC_POLICYSTR)) {
                return ComboConstants.ISSUED_KEYTYPE_PUBLIC;
            }
            if (type.endsWith(ComboConstants.ISSUED_KEYTYPE_SYMMETRIC_POLICYSTR)) {
                return ComboConstants.ISSUED_KEYTYPE_SYMMETRIC;
            }
            if (type.endsWith(ComboConstants.ISSUED_KEYTYPE_NOPROOF_POLICYSTR) || type.endsWith(ComboConstants.ISSUED_KEYTYPE_NOPROOF13_POLICYSTR)) {
                return ComboConstants.ISSUED_KEYTYPE_NOPROOF;
            }
        }
        return null;
    }

    public static String getIssuedKeySize(WSDLComponent tokenType) {
        RequestSecurityTokenTemplate rst;
        KeySize kSize;
        List rstList;
        if (tokenType != null && (rstList = tokenType.getExtensibilityElements(RequestSecurityTokenTemplate.class)) != null && !rstList.isEmpty() && (kSize = (rst = (RequestSecurityTokenTemplate)rstList.get(0)).getKeySize()) != null) {
            return kSize.getContent();
        }
        return null;
    }

    public static String getIssuedIssuerMetadataAddress(WSDLComponent tokenType) {
        Address10 a;
        MetadataReference mr;
        MetadataSection ms;
        Metadata m;
        Addressing10Metadata amdata;
        List mdata;
        Issuer issuer;
        List amdatas;
        List issuerList;
        if (!(tokenType == null || (issuerList = tokenType.getExtensibilityElements(Issuer.class)) == null || issuerList.isEmpty() || (amdatas = (issuer = (Issuer)issuerList.get(0)).getExtensibilityElements(Addressing10Metadata.class)) == null || amdatas.isEmpty() || (mdata = (amdata = (Addressing10Metadata)amdatas.get(0)).getExtensibilityElements(Metadata.class)) == null || mdata.isEmpty() || (m = (Metadata)mdata.get(0)) == null || (ms = m.getMetadataSection()) == null || (mr = ms.getMetadataReference()) == null || (a = mr.getAddress()) == null)) {
            return a.getAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIssuedTokenAddressAttributes(WSDLComponent token, String address, String metaAddress) {
        WSDLModel model = token.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            Issuer i = (Issuer)pmh.createElement(token, SecurityPolicyQName.ISSUER.getQName(this.configVersion), Issuer.class, false);
            Address10 a = (Address10)pmh.createElement((WSDLComponent)i, Addressing10QName.ADDRESS.getQName(), Address10.class, false);
            a.setAddress(address);
            Addressing10Metadata am = (Addressing10Metadata)pmh.createElement((WSDLComponent)i, Addressing10QName.ADDRESSINGMETADATA.getQName(), Addressing10Metadata.class, false);
            Metadata m = (Metadata)pmh.createElement((WSDLComponent)am, MexQName.METADATA.getQName(), Metadata.class, false);
            MetadataSection ms = (MetadataSection)pmh.createElement((WSDLComponent)m, MexQName.METADATASECTION.getQName(), MetadataSection.class, false);
            MetadataReference mr = (MetadataReference)pmh.createElement((WSDLComponent)ms, MexQName.METADATAREFERENCE.getQName(), MetadataReference.class, false);
            Address10 ma = (Address10)pmh.createElement((WSDLComponent)mr, Addressing10QName.ADDRESS.getQName(), Address10.class, false);
            ma.setAddress(metaAddress);
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIssuedTokenRSTAttributes(WSDLComponent token, String tokenType, String keyType, String keySize) {
        WSDLModel model = token.getModel();
        boolean isTransaction = model.isIntransaction();
        if (!isTransaction) {
            model.startTransaction();
        }
        try {
            PolicyModelHelper pmh = PolicyModelHelper.getInstance(this.configVersion);
            RequestSecurityTokenTemplate rst = (RequestSecurityTokenTemplate)pmh.createElement(token, SecurityPolicyQName.REQUESTSECURITYTOKENTEMPLATE.getQName(this.configVersion), RequestSecurityTokenTemplate.class, false);
            TokenType t = (TokenType)pmh.createElement((WSDLComponent)rst, TrustQName.TOKENTYPE.getQName(this.configVersion), TokenType.class, false);
            if (tokenType.equals(ComboConstants.ISSUED_TOKENTYPE_SAML20)) {
                t.setContent(ComboConstants.ISSUED_TOKENTYPE_SAML20_POLICYSTR);
            }
            if (tokenType.equals(ComboConstants.ISSUED_TOKENTYPE_SAML11)) {
                t.setContent(ComboConstants.ISSUED_TOKENTYPE_SAML11_POLICYSTR);
            }
            if (tokenType.equals(ComboConstants.ISSUED_TOKENTYPE_SAML10)) {
                t.setContent(ComboConstants.ISSUED_TOKENTYPE_SAML10_POLICYSTR);
            }
            KeyType k = (KeyType)pmh.createElement((WSDLComponent)rst, TrustQName.KEYTYPE.getQName(this.configVersion), KeyType.class, false);
            String nsStart = TrustQName.getNamespaceUri((ConfigVersion)this.configVersion);
            if (keyType.equals(ComboConstants.ISSUED_KEYTYPE_PUBLIC)) {
                k.setContent(nsStart + ComboConstants.ISSUED_KEYTYPE_PUBLIC_POLICYSTR);
            }
            if (keyType.equals(ComboConstants.ISSUED_KEYTYPE_SYMMETRIC)) {
                k.setContent(nsStart + ComboConstants.ISSUED_KEYTYPE_SYMMETRIC_POLICYSTR);
            }
            if (keyType.equals(ComboConstants.ISSUED_KEYTYPE_NOPROOF)) {
                if (ConfigVersion.CONFIG_1_0 != this.configVersion) {
                    k.setContent(nsStart + ComboConstants.ISSUED_KEYTYPE_NOPROOF13_POLICYSTR);
                } else {
                    k.setContent(ComboConstants.ISSUED_KEYTYPE_NOPROOF_POLICYSTR);
                }
            }
            if (keySize != null) {
                KeySize s = (KeySize)pmh.createElement((WSDLComponent)rst, TrustQName.KEYSIZE.getQName(this.configVersion), KeySize.class, false);
                s.setContent(keySize);
            } else {
                List s = rst.getExtensibilityElements(KeySize.class);
                if (s != null && s.size() > 0) {
                    KeySize ks = (KeySize)s.get(0);
                    ((WSDLComponent)ks.getParent()).removeExtensibilityElement((ExtensibilityElement)ks);
                }
            }
        }
        finally {
            if (!isTransaction) {
                model.endTransaction();
            }
        }
    }
}

