/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.spi;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.openide.util.Lookup;

public class SecurityProfileRegistry {
    private static SecurityProfileRegistry instance;
    private Map<String, SecurityProfile> profiles = Collections.synchronizedMap(new HashMap());

    private SecurityProfileRegistry() {
    }

    public static SecurityProfileRegistry getDefault() {
        if (instance == null) {
            instance = new SecurityProfileRegistry();
            instance.populateRegistry();
        }
        return instance;
    }

    public SecurityProfile getProfile(String displayName) {
        return this.profiles.get(displayName);
    }

    public void register(SecurityProfile profile) {
        this.profiles.put(profile.getDisplayName(), profile);
    }

    public void unregister(SecurityProfile profile) {
        this.profiles.remove(profile.getDisplayName());
    }

    public void unregister(String profile) {
        this.profiles.remove(profile);
    }

    public Set<SecurityProfile> getSecurityProfiles() {
        TreeSet<SecurityProfile> set = new TreeSet<SecurityProfile>(new Comparator<SecurityProfile>(){

            @Override
            public int compare(SecurityProfile o1, SecurityProfile o2) {
                Integer i1 = o1.getId();
                Integer i2 = o2.getId();
                return i1.compareTo(i2);
            }
        });
        set.addAll(this.profiles.values());
        return Collections.unmodifiableSet(Collections.synchronizedSortedSet(set));
    }

    private final SecurityProfileRegistry populateRegistry() {
        SecurityProfileRegistry registry = SecurityProfileRegistry.getDefault();
        if (registry.getSecurityProfiles().isEmpty()) {
            Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(SecurityProfile.class));
            Collection profs = results.allInstances();
            for (SecurityProfile p : profs) {
                registry.register(p);
            }
        }
        return registry;
    }
}

