/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.attribute;

import javax.lang.model.element.Element;
import org.netbeans.modules.db.api.sql.SQLKeywords;
import org.netbeans.modules.j2ee.jpa.model.AttributeWrapper;
import org.netbeans.modules.j2ee.jpa.verification.JPAEntityAttributeCheck;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Rule;
import org.netbeans.modules.j2ee.persistence.dd.JavaPersistenceQLKeywords;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class ValidColumnName
extends JPAEntityAttributeCheck {
    @Override
    public ErrorDescription[] check(JPAProblemContext jPAProblemContext, AttributeWrapper attributeWrapper) {
        String string = attributeWrapper.getColumn().getName();
        Element element = attributeWrapper.getJavaElement();
        if (string.length() == 0) {
            return new ErrorDescription[]{Rule.createProblem(element, jPAProblemContext, NbBundle.getMessage(ValidColumnName.class, (String)"MSG_AttrInvalidPersistenceQLIdentifier", (Object)string))};
        }
        if (JavaPersistenceQLKeywords.isKeyword((String)string)) {
            return new ErrorDescription[]{Rule.createProblem(element, jPAProblemContext, NbBundle.getMessage(ValidColumnName.class, (String)"MSG_AttrNamedWithJavaPersistenceQLKeyword", (Object)string))};
        }
        if (SQLKeywords.isSQL99ReservedKeyword((String)string)) {
            return new ErrorDescription[]{Rule.createProblem(element, (ProblemContext)jPAProblemContext, NbBundle.getMessage(ValidColumnName.class, (String)"MSG_AttrNamedWithReservedSQLKeyword", (Object)string), Severity.WARNING)};
        }
        return null;
    }
}

