/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SecurityCustomizer
extends JPanel
implements DocumentListener,
FocusListener,
ActionListener {
    private ProjectCustomizer.Category cat;
    private final JComponent[] enableDisable;
    L l = new L();
    private JCProjectProperties props;
    private JPasswordField aliasPasswordField;
    private JLabel aliasPasswordLabel;
    private JButton browseButton;
    private JLabel jLabel1;
    private JTextField keystoreAliasField;
    private JLabel keystoreAliasLabel;
    private JTextField keystoreField;
    private JLabel keystoreLabel;
    private JPasswordField keystorePasswordField;
    private JLabel keystorePasswordLabel;
    private JCheckBox signButton;

    public SecurityCustomizer(JCProjectProperties props, ProjectCustomizer.Category cat) {
        this.props = props;
        this.initComponents();
        this.enableDisable = new JComponent[]{this.aliasPasswordLabel, this.aliasPasswordField, this.browseButton, this.keystorePasswordLabel, this.keystorePasswordField, this.keystoreAliasLabel, this.keystoreAliasField, this.keystoreField};
        this.cat = cat;
        this.keystoreField.setDocument(props.KEYSTORE_DOCUMENT);
        this.keystoreAliasField.setDocument(props.KEYSTORE_ALIAS_DOCUMENT);
        this.keystorePasswordField.setDocument(props.KEYSTORE_PASSWORD_DOCUMENT);
        this.aliasPasswordField.setDocument(props.KEYSTORE_ALIAS_PASSWORD_DOCUMENT);
        this.signButton.setModel(props.SIGN_JAR_BUTTON_MODEL);
        this.keystoreField.getDocument().addDocumentListener(this);
        this.keystoreField.addFocusListener(this);
        this.signButton.addActionListener(this.l);
        Mnemonics.setLocalizedText((AbstractButton)this.signButton, (String)this.signButton.getText());
        Mnemonics.setLocalizedText((JLabel)this.keystoreLabel, (String)this.keystoreLabel.getText());
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)this.browseButton.getText());
        this.l.actionPerformed(null);
        this.updateState();
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.BuildSecurityPanel");
        GuiUtils.prepareContainer((Container)this);
    }

    void updateState() {
        File f = new File(this.keystoreField.getText());
        if (this.signButton.isSelected()) {
            if (f.exists() && f.isFile() && f.canRead()) {
                this.cat.setValid(true);
                this.cat.setErrorMessage(null);
            } else {
                String msg = NbBundle.getMessage(SecurityCustomizer.class, (String)"MSG_BAD_FILE", (Object)this.keystoreField.getText());
                this.cat.setValid(!this.signButton.isSelected());
                this.cat.setErrorMessage(msg);
            }
        } else {
            this.cat.setValid(true);
            this.cat.setErrorMessage(null);
        }
    }

    private void change() {
        this.updateState();
    }

    private void initComponents() {
        this.signButton = new JCheckBox();
        this.keystoreLabel = new JLabel();
        this.keystoreField = new JTextField();
        this.browseButton = new JButton();
        this.keystorePasswordLabel = new JLabel();
        this.keystoreAliasLabel = new JLabel();
        this.keystoreAliasField = new JTextField();
        this.aliasPasswordLabel = new JLabel();
        this.aliasPasswordField = new JPasswordField();
        this.keystorePasswordField = new JPasswordField();
        this.jLabel1 = new JLabel();
        this.signButton.setSelected(true);
        this.signButton.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.signButton.text", (Object[])new Object[0]));
        this.keystoreLabel.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystoreLabel.text", (Object[])new Object[0]));
        this.keystoreField.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystoreField.text", (Object[])new Object[0]));
        this.browseButton.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.browseButton.text", (Object[])new Object[0]));
        this.browseButton.addActionListener(this);
        this.keystorePasswordLabel.setLabelFor(this.keystorePasswordField);
        this.keystorePasswordLabel.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystorePasswordLabel.text"));
        this.keystoreAliasLabel.setLabelFor(this.keystoreAliasField);
        this.keystoreAliasLabel.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystoreAliasLabel.text"));
        this.keystoreAliasField.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystoreAliasField.text"));
        this.keystoreAliasField.setToolTipText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystoreAliasField.toolTipText"));
        this.aliasPasswordLabel.setLabelFor(this.keystorePasswordField);
        this.aliasPasswordLabel.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.aliasPasswordLabel.text"));
        this.aliasPasswordField.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.aliasPasswordField.text"));
        this.aliasPasswordField.setToolTipText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.aliasPasswordField.toolTipText"));
        this.keystorePasswordField.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystorePasswordField.text"));
        this.keystorePasswordField.setToolTipText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.keystorePasswordField.toolTipText"));
        this.jLabel1.setText(NbBundle.getMessage(SecurityCustomizer.class, (String)"SecurityCustomizer.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1, -1, 645, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.signButton).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.keystoreLabel).add((Component)this.keystorePasswordLabel).add((Component)this.keystoreAliasLabel).add((Component)this.aliasPasswordLabel)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.keystorePasswordField, -1, 451, Short.MAX_VALUE).add((Component)this.aliasPasswordField, -1, 451, Short.MAX_VALUE).add((Component)this.keystoreAliasField, -1, 451, Short.MAX_VALUE).add((Component)this.keystoreField, -1, 451, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.browseButton))).addContainerGap()))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.signButton).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.keystoreLabel).add((Component)this.keystoreField, -2, -1, -2).add((Component)this.browseButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.keystorePasswordLabel).add((Component)this.keystorePasswordField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.keystoreAliasLabel).add((Component)this.keystoreAliasField, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.aliasPasswordLabel).add((Component)this.aliasPasswordField, -2, -1, -2)).add(18, 18, 18).add((Component)this.jLabel1, -1, 84, Short.MAX_VALUE).add(26, 26, 26)));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.browseButton) {
            this.browseButtonActionPerformed(evt);
        }
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File f;
        String curr = this.keystoreField.getText();
        File file = new File(curr).getParentFile();
        if (file == null) {
            file = FileUtil.toFile((FileObject)this.props.getProject().getProjectDirectory());
        }
        FileChooserBuilder b = new FileChooserBuilder(SecurityCustomizer.class).setTitle(NbBundle.getMessage(SecurityCustomizer.class, (String)"BROWSE_FOR_KEYSTORE")).setFilesOnly(true);
        if (file.exists() && file.isDirectory()) {
            b.setDefaultWorkingDirectory(file);
        }
        if ((f = b.showOpenDialog()) != null && !new File(curr).equals(f)) {
            this.keystoreField.setText(f.getAbsolutePath());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void focusGained(FocusEvent e) {
        ((JTextField)e.getComponent()).selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private class L
    implements ActionListener {
        private L() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean en = SecurityCustomizer.this.signButton.isSelected();
            for (JComponent jc : SecurityCustomizer.this.enableDisable) {
                jc.setEnabled(en);
            }
            SecurityCustomizer.this.updateState();
        }
    }
}

