/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.awt.event.WindowAdapter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.AntProjectCookie;
import org.apache.tools.ant.module.api.AntTargetExecutor;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

final class ProjectRenamer
extends WindowAdapter
implements AntProjectCookie,
Mutex.ExceptionAction<Void> {
    final String newName;
    private final AntProjectHelper antHelper;
    private final ProjectKind kind;

    ProjectRenamer(String newName, AntProjectHelper antHelper, ProjectKind kind) {
        this.newName = newName;
        this.antHelper = antHelper;
        this.kind = kind;
    }

    void doRename() {
        try {
            this.cleanTheProject();
            this.renameProjectMetadata();
            this.modifyBuildScriptProjectName();
            this.modifyProjectPropertiesProjectName();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private void cleanTheProject() throws IOException {
        AntTargetExecutor.Env env = new AntTargetExecutor.Env();
        AntTargetExecutor exe = AntTargetExecutor.createTargetExecutor((AntTargetExecutor.Env)env);
        exe.execute((AntProjectCookie)this, new String[]{"clean"});
    }

    private void renameProjectMetadata() throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)this);
        }
        catch (MutexException e) {
            IOException ioe = new IOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyBuildScriptProjectName() throws IOException {
        FileObject bs = this.getFileObject();
        if (bs == null) {
            throw new IOException("Build script missing at " + this.getFile().getAbsolutePath());
        }
        InputStream inStream = bs.getInputStream();
        Document nue = null;
        try {
            InputSource in = new InputSource(inStream);
            nue = XMLUtil.parse((InputSource)in, (boolean)false, (boolean)false, null, null);
            Element root = nue.getDocumentElement();
            this.iterDocument(root);
        }
        catch (SAXException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            inStream.close();
        }
        if (nue != null) {
            EditableProperties ep = this.antHelper.getProperties("nbproject/project.properties");
            String encoding = ep.getProperty("source.encoding");
            FileLock lock = bs.lock();
            OutputStream out = bs.getOutputStream(lock);
            try {
                XMLUtil.write((Document)nue, (OutputStream)out, (String)(encoding == null ? "UTF-8" : encoding));
            }
            finally {
                out.close();
                lock.releaseLock();
            }
        }
    }

    private void modifyProjectPropertiesProjectName() {
        EditableProperties props = this.antHelper.getProperties("nbproject/project.properties");
        props.setProperty("displayname", this.newName);
        this.antHelper.putProperties("nbproject/project.properties", props);
    }

    public Void run() throws Exception {
        Element nameEl;
        Element data = this.antHelper.getPrimaryConfigurationData(true);
        NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/javacard-project/3", "name");
        if (nl.getLength() == 1) {
            nameEl = (Element)nl.item(0);
            NodeList deadKids = nameEl.getChildNodes();
            while (deadKids.getLength() > 0) {
                nameEl.removeChild(deadKids.item(0));
            }
        } else {
            nameEl = data.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/javacard-project/3", "name");
            data.insertBefore(nameEl, data.getChildNodes().item(0));
        }
        nameEl.appendChild(data.getOwnerDocument().createTextNode(this.newName));
        this.antHelper.putPrimaryConfigurationData(data, true);
        EditableProperties props = this.antHelper.getProperties("nbproject/project.properties");
        props.setProperty("displayname", this.newName);
        this.antHelper.putProperties("nbproject/project.properties", props);
        return null;
    }

    private void iterDocument(Element root) {
        NodeList nl = root.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = nl.item(i);
            if (node.getNodeType() != 1 || !"project".equals(node.getNodeName())) continue;
            Element el = (Element)node;
            el.setAttribute("name", this.newName);
        }
    }

    public File getFile() {
        return this.antHelper.resolveFile("build.xml");
    }

    public FileObject getFileObject() {
        return FileUtil.toFileObject((File)FileUtil.normalizeFile((File)this.getFile()));
    }

    public Document getDocument() {
        return this.antHelper.getPrimaryConfigurationData(true).getOwnerDocument();
    }

    public Element getProjectElement() {
        return this.antHelper.getPrimaryConfigurationData(true);
    }

    public Throwable getParseException() {
        return null;
    }

    public void addChangeListener(ChangeListener arg0) {
    }

    public void removeChangeListener(ChangeListener arg0) {
    }
}

