/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javacard.JCUtil;
import org.netbeans.modules.javacard.api.RunMode;
import org.netbeans.modules.javacard.common.NodeRefresher;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.project.JCCustomizerProvider;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.project.customizer.ClassicAppletProjectProperties;
import org.netbeans.modules.javacard.spi.Card;
import org.netbeans.modules.javacard.spi.CardState;
import org.netbeans.modules.javacard.spi.JavacardPlatform;
import org.netbeans.modules.javacard.spi.capabilities.AntTarget;
import org.netbeans.modules.javacard.spi.capabilities.AntTargetInterceptor;
import org.netbeans.modules.javacard.spi.capabilities.CardInfo;
import org.netbeans.modules.javacard.spi.capabilities.DebugCapability;
import org.netbeans.modules.javacard.spi.capabilities.PortKind;
import org.netbeans.modules.javacard.spi.capabilities.PortProvider;
import org.netbeans.modules.javacard.spi.capabilities.StartCapability;
import org.netbeans.modules.javacard.spi.capabilities.StopCapability;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;

public class JCProjectActionProvider
implements ActionProvider {
    private static final String[] webOrExtAppSupportedActions = new String[]{"build", "clean", "run", "debug", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCCreate", "JCDelete", "JCUnload"};
    private static final String[] classicAppSupportedActions = new String[]{"build", "clean", "run", "debug", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCCreate", "JCDelete", "JCUnload", "JCGenProxy"};
    private static final String[] extLibSupportedActions = new String[]{"build", "clean", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCUnload"};
    private static final String[] classicLibSupportedActions = new String[]{"build", "clean", "rebuild", "delete", "copy", "move", "rename", "JCLoad", "JCUnload", "JCGenProxy"};
    private final Set<String> supportedActionsSet;
    private JCProject project;

    public JCProjectActionProvider(JCProject jCProject) {
        this.project = jCProject;
        this.supportedActionsSet = new HashSet<String>();
        this.supportedActionsSet.addAll(Arrays.asList(this.getSupportedActions()));
    }

    public String[] getSupportedActions() {
        String[] stringArray = null;
        stringArray = this.project.kind().isApplication() ? (this.project.kind().isClassic() ? classicAppSupportedActions : webOrExtAppSupportedActions) : (this.project.kind().isClassic() ? classicLibSupportedActions : extLibSupportedActions);
        return stringArray;
    }

    public void invokeAction(final String string, Lookup lookup) throws IllegalArgumentException {
        block21: {
            if ("delete".equals(string)) {
                FileObject fileObject = this.project.getProjectDirectory();
                DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
                if (fileObject.isValid()) {
                    try {
                        FileObject fileObject2 = fileObject.getFileObject("html");
                        if (fileObject2 != null) {
                            fileObject2.delete();
                        }
                        if ((fileObject2 = fileObject.getFileObject("scripts")) != null) {
                            fileObject2.delete();
                        }
                        if (fileObject.getChildren().length == 0) {
                            fileObject.delete();
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
                return;
            }
            if ("copy".equals(string)) {
                DefaultProjectOperations.performDefaultCopyOperation((Project)this.project);
                return;
            }
            if ("move".equals(string)) {
                DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
                return;
            }
            if ("rename".equals(string)) {
                DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
                return;
            }
            final boolean bl = "debug".equals(string) || "debug.single".equals(string) || "debug.stepinto".equals(string) || "debug.test.single".equals(string);
            Properties properties = new Properties();
            String[] stringArray = this.getTargetNames(string, lookup, properties);
            if (stringArray == null) {
                return;
            }
            if (stringArray.length == 0) {
                stringArray = null;
            }
            if (properties.keySet().size() == 0) {
                properties = null;
            }
            try {
                String[] stringArray2;
                boolean bl2;
                StartCapability startCapability;
                Card card;
                FileObject fileObject;
                block22: {
                    fileObject = JCUtil.findBuildXml(this.project);
                    if (fileObject == null || !fileObject.isValid()) {
                        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(JCProjectActionProvider.class, (String)"LBL_No_Build_XML_Found"), 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                        break block21;
                    }
                    card = this.project.getCard();
                    boolean bl3 = "JCCreate".equals(string) || "JCDelete".equals(string) || "JCLoad".equals(string) || "JCUnload".equals(string);
                    CardState cardState = card.getState();
                    CardInfo cardInfo = (CardInfo)card.getCapability(CardInfo.class);
                    if (!bl && (startCapability = (StartCapability)card.getCapability(StartCapability.class)) != null && bl3 && cardState.isNotRunning()) {
                        try {
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_STARTING_SERVER", (Object)(cardInfo == null ? card.toString() : cardInfo.getDisplayName())));
                            startCapability.start(bl ? RunMode.DEBUG : RunMode.RUN, (Project)this.project).await();
                        }
                        catch (InterruptedException interruptedException) {
                            if (card.getState().isRunning()) break block22;
                            String string2 = card.getCapability(CardInfo.class) == null ? card.toString() : ((CardInfo)card.getCapability(CardInfo.class)).getDisplayName();
                            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_WAIT_FAILED", (Object)string2));
                            return;
                        }
                    }
                }
                boolean bl4 = bl2 = (startCapability = (AntTargetInterceptor)card.getCapability(AntTargetInterceptor.class)) == null;
                if (!bl2) {
                    stringArray2 = AntTarget.forName((String)string);
                    bl2 = startCapability.onBeforeInvokeTarget((Project)this.project, (AntTarget)stringArray2, properties);
                }
                if (bl2) {
                    stringArray2 = stringArray;
                    final Properties properties2 = properties;
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                PropertyEvaluator propertyEvaluator;
                                String string2;
                                OnAntProcessFinishedListener onAntProcessFinishedListener = new OnAntProcessFinishedListener(JCProjectActionProvider.this.project.getPlatform(), card);
                                if (bl) {
                                    new DebugProxyProcessLauncher(onAntProcessFinishedListener).run();
                                }
                                ExecutorTask executorTask = ActionUtils.runTarget((FileObject)fileObject, (String[])stringArray2, (Properties)properties2);
                                executorTask.addTaskListener((TaskListener)onAntProcessFinishedListener);
                                if ("JCGenProxy".equals(string) && !Boolean.valueOf(string2 = (propertyEvaluator = JCProjectActionProvider.this.project.evaluator()).evaluate("{use.my.proxies}")).booleanValue()) {
                                    executorTask.addTaskListener((TaskListener)new EnsureUseProxiesSetAfterProxyGeneration(JCProjectActionProvider.this.project));
                                }
                                executorTask.getInputOutput().select();
                            }
                            catch (IOException iOException) {
                                Exceptions.printStackTrace((Throwable)iOException);
                            }
                        }
                    });
                }
            }
            catch (Exception exception) {
                Exceptions.printStackTrace((Throwable)exception);
            }
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) throws IllegalArgumentException {
        if (!this.supportedActionsSet.contains(string)) {
            throw new IllegalArgumentException("Command not supported by Java Card project: " + string);
        }
        boolean bl = "debug".equals(string) || "debug.single".equals(string) || "debug.stepinto".equals(string) || "debug.test.single".equals(string);
        JavacardPlatform javacardPlatform = this.project.getPlatform();
        Card card = this.project.getCard();
        if (this.actionRequiresValidPlatform(string)) {
            boolean bl2;
            boolean bl3 = bl2 = javacardPlatform != null && javacardPlatform.isValid() && card != null && card.isValid();
            if (bl) {
                bl2 &= card.getCapability(DebugCapability.class) != null;
            }
            return bl2;
        }
        return true;
    }

    private boolean actionRequiresValidPlatform(String string) {
        return "build".equals(string) || "debug".equals(string) || "debug.single".equals(string) || "debug.stepinto".equals(string) || "debug.test.single".equals(string) || "run".equals(string) || "run.single".equals(string) || "test".equals(string) || "test.single".equals(string) || "JCCreate".equals(string) || "JCDelete".equals(string) || "JCGenProxy".equals(string) || "JCLoad".equals(string) || "JCUnload".equals(string);
    }

    public String[] getTargetNames(String string, Lookup lookup, Properties properties) {
        Card card;
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("clean".equals(string)) {
            arrayList.add("clean");
        } else if ("build".equals(string)) {
            arrayList.add("build");
        } else if ("rebuild".equals(string)) {
            arrayList.add("clean");
            arrayList.add("build");
        } else if ("debug".equals(string)) {
            arrayList.add("run-for-debug");
        } else if ("run".equals(string)) {
            Object object;
            card = this.project.getCard();
            if (card == null) {
                return new String[0];
            }
            StopCapability stopCapability = (StopCapability)card.getCapability(StopCapability.class);
            if (stopCapability != null && card.getState() == CardState.RUNNING_IN_DEBUG_MODE) {
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_STOPPING_SERVER"));
                object = stopCapability.stop();
                if (object != null) {
                    try {
                        object.await(30000L, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        Exceptions.printStackTrace((Throwable)interruptedException);
                    }
                }
            }
            if ((object = (StartCapability)card.getCapability(StartCapability.class)) != null && card.getState().isNotRunning()) {
                Condition condition = object.start(RunMode.RUN, (Project)this.project);
                assert (condition != null);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_WAIT_FOR_SERVER"));
                try {
                    condition.await(30000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            arrayList.add("run");
        } else if ("JCLoad".equals(string)) {
            arrayList.add("build");
            arrayList.add("load-bundle");
        } else if (this.project.kind().isApplication() && "JCCreate".equals(string)) {
            arrayList.add("create-instance");
        } else if (this.project.kind().isApplication() && "JCDelete".equals(string)) {
            arrayList.add("delete-instance");
        } else if ("JCUnload".equals(string)) {
            arrayList.add("unload-bundle");
        } else if ("JCGenProxy".equals(string)) {
            arrayList.add("generate-sio-proxies");
            properties.setProperty("use.my.proxies", Boolean.TRUE.toString());
            properties.setProperty("src.proxies.dir", "proxies");
        }
        card = arrayList.toArray(new String[arrayList.size()]);
        return card;
    }

    class OnAntProcessFinishedListener
    implements TaskListener,
    PropertyChangeListener {
        private final JavacardPlatform platform;
        private final Card card;
        private JPDADebugger debugger;
        private volatile boolean finished;

        OnAntProcessFinishedListener(JavacardPlatform javacardPlatform, Card card) {
            this.platform = javacardPlatform;
            this.card = card;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setDebuggerSession(JPDADebugger jPDADebugger) {
            OnAntProcessFinishedListener onAntProcessFinishedListener = this;
            synchronized (onAntProcessFinishedListener) {
                this.debugger = jPDADebugger;
            }
            if (!this.finished) {
                jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            StopCapability stopCapability;
            String string = propertyChangeEvent.getPropertyName();
            String string2 = String.valueOf(propertyChangeEvent.getNewValue());
            if ("state".equals(string) && "4".equals(string2) && this.card.isValid() && this.card.getState().isRunning() && (stopCapability = (StopCapability)this.card.getCapability(StopCapability.class)) != null) {
                stopCapability.stop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopListeningToDebugger() {
            JPDADebugger jPDADebugger;
            OnAntProcessFinishedListener onAntProcessFinishedListener = this;
            synchronized (onAntProcessFinishedListener) {
                jPDADebugger = this.debugger;
            }
            if (jPDADebugger != null) {
                jPDADebugger.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        public void taskFinished(Task task) {
            this.finished = true;
            this.stopListeningToDebugger();
            String string = this.platform.getSystemName();
            CardInfo cardInfo = (CardInfo)this.card.getCapability(CardInfo.class);
            String string2 = cardInfo == null ? this.card.toString() : cardInfo.getSystemId();
            DataObject dataObject = Utils.findDeviceForPlatform((String)string, (String)string2);
            if (dataObject.isValid()) {
                NodeRefresher nodeRefresher;
                NodeRefresher nodeRefresher2 = nodeRefresher = dataObject == null ? null : (NodeRefresher)dataObject.getLookup().lookup(NodeRefresher.class);
                if (nodeRefresher != null) {
                    nodeRefresher.refreshNode();
                }
            }
        }
    }

    static final class EnsureUseProxiesSetAfterProxyGeneration
    implements TaskListener {
        private final JCProject project;

        EnsureUseProxiesSetAfterProxyGeneration(JCProject jCProject) {
            this.project = jCProject;
            assert (jCProject.kind().isClassic());
        }

        public void taskFinished(Task task) {
            JCCustomizerProvider jCCustomizerProvider = (JCCustomizerProvider)this.project.getLookup().lookup(JCCustomizerProvider.class);
            Parameters.notNull((CharSequence)"prov", (Object)jCCustomizerProvider);
            JCProjectProperties jCProjectProperties = JCCustomizerProvider.createProjectProperties(this.project.kind(), this.project, this.project.evaluator(), this.project.getAntProjectHelper());
            if (jCProjectProperties instanceof ClassicAppletProjectProperties) {
                ClassicAppletProjectProperties classicAppletProjectProperties = (ClassicAppletProjectProperties)jCProjectProperties;
                classicAppletProjectProperties.setUseMyProxies(true);
                classicAppletProjectProperties.storeProperties();
            }
        }
    }

    private final class DebugProxyProcessLauncher
    implements Runnable {
        private final OnAntProcessFinishedListener tl;

        DebugProxyProcessLauncher(OnAntProcessFinishedListener onAntProcessFinishedListener) {
            this.tl = onAntProcessFinishedListener;
        }

        @Override
        public void run() {
            Card card = JCProjectActionProvider.this.project.getCard();
            String string = "[NO_HOST]";
            int n = -1;
            try {
                Condition condition;
                StartCapability startCapability;
                StopCapability stopCapability = (StopCapability)card.getCapability(StopCapability.class);
                if (card.getState().isRunning() && stopCapability != null) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_STOPPING_SERVER"));
                    stopCapability.stop().await();
                }
                if ((startCapability = (StartCapability)card.getCapability(StartCapability.class)) != null) {
                    condition = startCapability.start(RunMode.DEBUG, (Project)JCProjectActionProvider.this.project);
                    assert (condition != null);
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_WAIT_FOR_SERVER"));
                    condition.await(30000L, TimeUnit.MILLISECONDS);
                }
                if (card.getCapability(DebugCapability.class) != null && card.getCapability(PortProvider.class) != null) {
                    NotifyDescriptor.Message message;
                    condition = (PortProvider)card.getCapability(PortProvider.class);
                    n = condition.getPort(PortKind.DEBUG_RUNTIME_TO_IDE_PROXY);
                    string = condition.getHost();
                    String string2 = null;
                    string2 = this.waitForPort(string, n);
                    if (string2 != null) {
                        message = new NotifyDescriptor.Message((Object)string2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                    }
                    message = JPDADebugger.attach((String)string, (int)n, (Object[])new Object[]{card.getSystemId() + " - [Debugger]", "SocketAttach", "dt_socket"});
                    this.tl.setDebuggerSession((JPDADebugger)message);
                }
            }
            catch (DebuggerStartException debuggerStartException) {
                if (debuggerStartException.getCause() instanceof ConnectException) {
                    StopCapability stopCapability = (StopCapability)card.getCapability(StopCapability.class);
                    if (stopCapability != null) {
                        try {
                            stopCapability.stop().await();
                        }
                        catch (InterruptedException interruptedException) {
                            Exceptions.printStackTrace((Throwable)interruptedException);
                        }
                    }
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(JCProjectActionProvider.class, (String)"MSG_DEBUG_PORT_TIMEOUT", (Object)string, (Object)n));
                }
                Exceptions.printStackTrace((Throwable)debuggerStartException);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
        }

        private String waitForPort(String string, int n) {
            try {
                Thread.sleep(7000L);
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            return null;
        }
    }
}

