/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.sun;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformDetector;
import org.netbeans.modules.j2me.cdc.platform.spi.CDCPlatformUtil;
import org.netbeans.modules.j2me.cdc.platform.system.ExternalProcessing;
import org.openide.filesystems.FileObject;
import org.openide.util.io.ReaderInputStream;

public final class JmeSdkCdcDetector
extends CDCPlatformDetector {
    private static String PLATFORM_TYPE = "cdc-hi";

    public String getPlatformName() {
        return "CDC Platform";
    }

    public String getPlatformType() {
        return PLATFORM_TYPE;
    }

    public boolean accept(FileObject dir) {
        FileObject tool1 = CDCPlatformUtil.findTool((String)"bin", (String)"emulator.exe", Collections.singleton(dir));
        FileObject tool1a = CDCPlatformUtil.findTool((String)"bin", (String)"emulator", Collections.singleton(dir));
        FileObject tool2 = CDCPlatformUtil.findTool((String)"runtimes/cdc-hi/bin", (String)"cvm.exe", Collections.singleton(dir));
        FileObject tool2a = CDCPlatformUtil.findTool((String)"runtimes/cdc-hi/bin", (String)"cvm", Collections.singleton(dir));
        boolean result = null != tool1 && null != tool2 || null != tool1a && null != tool2a;
        return result;
    }

    public CDCPlatform detectPlatform(FileObject dir) throws IOException {
        assert (dir != null);
        String versionOutput = this.getEmulatorResult(dir, "-version");
        String[] versionLines = versionOutput.split("\n");
        String platformName = "CDC " + versionLines[0];
        ArrayList<FileObject> jdocsAsFO = new ArrayList<FileObject>();
        FileObject javadocBase = dir.getFileObject("docs/api/cdc-1.1");
        if (javadocBase != null) {
            this.findJavaDoc(javadocBase, jdocsAsFO);
        }
        ArrayList jdocsAsURL = new ArrayList(jdocsAsFO.size());
        for (FileObject fileObject : jdocsAsFO) {
        }
        String ueiResultS = this.getEmulatorResult(dir, "-Xquery");
        Properties ueiResult = new Properties();
        StringReader ueiStringReader = new StringReader(ueiResultS);
        ReaderInputStream ueiInputStream = new ReaderInputStream((Reader)ueiStringReader);
        ueiResult.load((InputStream)ueiInputStream);
        ueiInputStream.close();
        String dispName = platformName;
        String antName = "Java_ME_SDK_CDC";
        String platformType = PLATFORM_TYPE;
        String classVersion = "1.3";
        List<URL> installFolders = Collections.singletonList(dir.getURL());
        List sources = Collections.emptyList();
        CDCDevice[] devices = this.getJavaMeSdkDevices(ueiResult);
        boolean fatJar = true;
        CDCPlatform result = new CDCPlatform(dispName, "Java_ME_SDK_CDC", platformType, "1.3", installFolders, sources, jdocsAsURL, devices, true);
        return result;
    }

    private void addDevice(Properties p, String deviceName, List<CDCDevice> devices) {
        String configuration = p.getProperty(deviceName + ".version.configuration");
        if (!configuration.startsWith("CDC")) {
            return;
        }
        String profilesS = p.getProperty(deviceName + ".version.profile");
        String[] profileNames = profilesS.split(",");
        CDCDevice.CDCProfile[] profiles = new CDCDevice.CDCProfile[profileNames.length];
        for (int i = 0; i < profileNames.length; ++i) {
            String profileName = profileNames[i];
            profiles[i] = this.parseProfile(p, deviceName, profileName);
        }
        String description = p.getProperty(deviceName + ".descriptor");
        CDCDevice.Screen[] screens = this.addScreens(p, deviceName);
        CDCDevice device = new CDCDevice(deviceName, description, profiles, screens);
        devices.add(device);
    }

    private CDCDevice.Screen[] addScreens(Properties p, String deviceName) {
        CDCDevice.Screen screen;
        CDCDevice.Screen[] result = new CDCDevice.Screen[1];
        String width = p.getProperty(deviceName + "screen.width");
        String height = p.getProperty(deviceName + "screen.height");
        String bitDepth = p.getProperty(deviceName + "screen.bitDepth");
        String color = p.getProperty(deviceName + "screen.isColor");
        String touch = p.getProperty(deviceName + "screen.isTouch");
        String main = p.getProperty(deviceName + "screen.isMain", "true");
        result[0] = screen = new CDCDevice.Screen(width, height, bitDepth, color, touch, main);
        return result;
    }

    private String descriptionOfAProfile(String profileName) {
        if (profileName.startsWith("PBP-")) {
            return profileName.replace("PBP-", "Personal basis profile ");
        }
        if (profileName.startsWith("PP-")) {
            return profileName.replace("PP-", "Personal profile ");
        }
        return profileName;
    }

    private void findJavaDoc(FileObject folder, List<FileObject> folders) {
        FileObject[] fileObjects;
        if (folder == null) {
            return;
        }
        for (FileObject fo : fileObjects = folder.getChildren()) {
            if (!fo.isData() || !"index".equals(fo.getName())) continue;
            folders.add(fo.getParent());
        }
        for (FileObject fo : fileObjects) {
            if (!fo.isFolder() || folders.contains(fo.getParent())) continue;
            this.findJavaDoc(fo, folders);
        }
    }

    private CDCDevice[] getJavaMeSdkDevices(Properties p) {
        String deviceNamesAsString = p.getProperty("device.list");
        String[] deviceNames = deviceNamesAsString.split(",");
        ArrayList<CDCDevice> devices = new ArrayList<CDCDevice>(deviceNames.length);
        for (String deviceName : deviceNames) {
            this.addDevice(p, deviceName, devices);
        }
        return devices.toArray(new CDCDevice[devices.size()]);
    }

    private String getEmulatorResult(FileObject dir, String parameter) throws IOException {
        FileObject binDir = dir.getFileObject("bin");
        FileObject emulatorExe = binDir.getFileObject("emulator.exe");
        if (null == emulatorExe) {
            emulatorExe = binDir.getFileObject("emulator");
        }
        return ExternalProcessing.callExternal(emulatorExe, dir, parameter);
    }

    private CDCDevice.CDCProfile parseProfile(Properties p, String deviceName, String profileName) {
        String bootClassPath;
        String version = profileName.split("-")[1];
        HashMap<String, String> executionModes = new HashMap<String, String>();
        executionModes.put(CDCPlatform.PROP_EXEC_MAIN, "");
        String runClassPath = bootClassPath = p.getProperty(deviceName + ".bootclasspath").replace(',', File.pathSeparatorChar);
        boolean isDefault = true;
        String profileDescription = this.descriptionOfAProfile(profileName);
        return new CDCDevice.CDCProfile(profileName, profileDescription, version, executionModes, bootClassPath, runClassPath, isDefault);
    }
}

