/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.felix.framework.BundleImpl;

class GetEntryPathsEnumeration
implements Enumeration {
    private final BundleImpl m_bundle;
    private final Enumeration m_enumeration;
    private final String m_path;
    private Object m_next = null;

    public GetEntryPathsEnumeration(BundleImpl bundle, String path) {
        this.m_bundle = bundle;
        this.m_enumeration = this.m_bundle.getCurrentModule().getContent().getEntries();
        if (path == null) {
            throw new IllegalArgumentException("The path for findEntries() cannot be null.");
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        if (path.length() > 0 && path.charAt(path.length() - 1) != '/') {
            path = path + "/";
        }
        this.m_path = path;
        this.m_next = this.findNext();
    }

    public synchronized boolean hasMoreElements() {
        return this.m_next != null;
    }

    public synchronized Object nextElement() {
        if (this.m_next == null) {
            throw new NoSuchElementException("No more entry paths.");
        }
        Object last = this.m_next;
        this.m_next = this.findNext();
        return last;
    }

    private Object findNext() {
        while (this.m_enumeration.hasMoreElements()) {
            int idx;
            String entryName = (String)this.m_enumeration.nextElement();
            if (entryName.equals(this.m_path) || !entryName.startsWith(this.m_path) || (idx = entryName.indexOf(47, this.m_path.length())) >= 0 && idx != entryName.length() - 1) continue;
            return entryName;
        }
        return null;
    }
}

