/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.common;

import java.awt.datatransfer.Transferable;
import java.util.Collections;
import org.netbeans.modules.vmd.api.model.ComponentProducer;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.common.AcceptPresenter;
import org.netbeans.modules.vmd.api.model.common.AcceptSuggestion;
import org.netbeans.modules.vmd.api.model.common.DefaultDataFlavor;

public final class AcceptSupport {
    private AcceptSupport() {
    }

    public static boolean isAcceptable(DesignComponent component, Transferable transferable, AcceptSuggestion suggestion) {
        if (component == null || transferable == null) {
            return false;
        }
        ComponentProducer producer = DefaultDataFlavor.decodeFromDataFlavors(component.getDocument(), transferable);
        for (AcceptPresenter presenter : component.getPresenters(AcceptPresenter.class)) {
            switch (presenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (producer == null || !presenter.isAcceptable(producer, suggestion)) break;
                    return true;
                }
                case TRANSFERABLE: {
                    if (!presenter.isAcceptable(transferable, suggestion)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static ComponentProducer.Result accept(DesignComponent component, Transferable transferable, AcceptSuggestion suggestion) {
        if (component == null || transferable == null) {
            return null;
        }
        ComponentProducer producer = DefaultDataFlavor.decodeFromDataFlavors(component.getDocument(), transferable);
        for (AcceptPresenter presenter : component.getPresenters(AcceptPresenter.class)) {
            switch (presenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (producer == null || !presenter.isAcceptable(producer, suggestion)) break;
                    return presenter.accept(producer, suggestion);
                }
                case TRANSFERABLE: {
                    if (!presenter.isAcceptable(transferable, suggestion)) break;
                    return presenter.accept(transferable, suggestion);
                }
            }
        }
        return null;
    }

    public static boolean isAcceptable(DesignComponent component, ComponentProducer producer, AcceptSuggestion suggestion) {
        if (component == null || producer == null) {
            return false;
        }
        for (AcceptPresenter presenter : component.getPresenters(AcceptPresenter.class)) {
            switch (presenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (!presenter.isAcceptable(producer, suggestion)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static ComponentProducer.Result accept(DesignComponent component, ComponentProducer producer, AcceptSuggestion suggestion) {
        if (component == null || producer == null) {
            return null;
        }
        for (AcceptPresenter presenter : component.getPresenters(AcceptPresenter.class)) {
            switch (presenter.getKind()) {
                case COMPONENT_PRODUCER: {
                    if (!presenter.isAcceptable(producer, suggestion)) break;
                    return presenter.accept(producer, suggestion);
                }
            }
        }
        return null;
    }

    public static void selectComponentProducerResult(ComponentProducer.Result result) {
        DesignComponent component;
        DesignComponent designComponent = component = result != null ? result.getMainComponent() : null;
        if (component != null) {
            component.getDocument().setSelectedComponents("accept", Collections.singleton(component));
        }
    }
}

