/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.openide.util.Exceptions;

public class PreviewPreferences
extends AbstractPreferences {
    private Map<String, Object> map = new HashMap<String, Object>();
    private final CodeStyle.Language language;
    private final String styleId;

    public PreviewPreferences(Preferences master, CodeStyle.Language language, String styleId) {
        super(null, "");
        this.language = language;
        this.styleId = styleId;
        try {
            for (String key : master.keys()) {
                Object o = EditorOptions.getDefault(language, styleId, key);
                if (o instanceof Boolean) {
                    this.putBoolean(key, master.getBoolean(key, (Boolean)o));
                    continue;
                }
                if (o instanceof Integer) {
                    this.putInt(key, master.getInt(key, (Integer)o));
                    continue;
                }
                if (!(o instanceof String)) continue;
                this.map.put(key, master.get(key, o.toString()));
            }
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public void makeAllKeys(PreviewPreferences master) {
        for (String key : EditorOptions.keys()) {
            Object v;
            if (this.map.containsKey(key)) continue;
            Object o = EditorOptions.getDefault(this.language, this.styleId, key);
            if (o instanceof Boolean) {
                v = master.getBoolean(key, (Boolean)EditorOptions.getDefault(this.language, master.getStyleId(), key));
                this.putBoolean(key, (Boolean)v);
                continue;
            }
            if (o instanceof Integer) {
                v = master.getInt(key, (Integer)EditorOptions.getDefault(this.language, master.getStyleId(), key));
                this.putInt(key, (Integer)v);
                continue;
            }
            if (!(o instanceof String)) continue;
            v = master.get(key, (String)EditorOptions.getDefault(this.language, master.getStyleId(), key));
            this.map.put(key, v);
        }
    }

    public CodeStyle.Language getLanguage() {
        return this.language;
    }

    public String getStyleId() {
        return this.styleId;
    }

    @Override
    protected void putSpi(String key, String value) {
        this.map.put(key, value);
    }

    @Override
    protected String getSpi(String key) {
        return (String)this.map.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.map.remove(key);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        String[] array = new String[this.map.keySet().size()];
        return this.map.keySet().toArray(array);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

