/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.options;

import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.options.EditorOptions;
import org.netbeans.modules.cnd.editor.options.PreviewPreferences;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;

public class IntNodeProp
extends PropertySupport<Integer> {
    private final CodeStyle.Language language;
    private final String optionID;
    private PreviewPreferences preferences;
    private int state;

    public IntNodeProp(CodeStyle.Language language, PreviewPreferences preferences, String optionID) {
        super(optionID, Integer.class, IntNodeProp.getString("LBL_" + optionID), IntNodeProp.getString("HINT_" + optionID), true, true);
        this.language = language;
        this.optionID = optionID;
        this.preferences = preferences;
        this.init();
    }

    public IntNodeProp(CodeStyle.Language language, PreviewPreferences preferences, String optionID, int state) {
        super(optionID, Integer.class, IntNodeProp.getString("LBL_" + optionID), IntNodeProp.getString("HINT_" + optionID), true, false);
        this.language = language;
        this.optionID = optionID;
        this.preferences = preferences;
        this.state = state;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(IntNodeProp.class, (String)key);
    }

    private void init() {
        this.state = this.getPreferences().getInt(this.optionID, this.getDefault());
    }

    private int getDefault() {
        return (Integer)EditorOptions.getDefault(this.getPreferences().getLanguage(), this.getPreferences().getStyleId(), this.optionID);
    }

    private PreviewPreferences getPreferences() {
        return this.preferences;
    }

    public String getHtmlDisplayName() {
        if (!this.isDefaultValue()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public Integer getValue() {
        return this.state;
    }

    public void setValue(Integer v) {
        this.state = v;
        this.getPreferences().putInt(this.optionID, this.state);
    }

    public void restoreDefaultValue() {
        this.setValue(this.getDefault());
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.getDefault() == this.getValue().intValue();
    }
}

