/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutOperations;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;

class LayoutAligner
implements LayoutConstants {
    private LayoutDesigner designer;
    private LayoutModel layoutModel;
    private LayoutOperations operations;

    LayoutAligner(LayoutDesigner designer, LayoutModel layoutModel, LayoutOperations operations) {
        this.designer = designer;
        this.layoutModel = layoutModel;
        this.operations = operations;
    }

    void alignIntervals(LayoutInterval[] intervals, boolean closed, int dimension, int alignment) {
        LayoutInterval parParent = LayoutInterval.getCommonParent(intervals);
        if (parParent.isSequential()) {
            parParent = parParent.getParent();
        }
        this.markByAlignAttributes(parParent, intervals);
        LinkedList<LayoutInterval> removedSeqs = new LinkedList<LayoutInterval>();
        parParent = this.splitByAlignAttrs(parParent, removedSeqs, alignment, closed, dimension, false);
        List gapsToResize = this.transferToParallelParent(intervals, parParent, alignment, closed);
        LayoutInterval returnPar = LayoutInterval.getFirstParent(parParent, 103);
        this.returnRemovedIntervals(returnPar == null ? parParent : returnPar, removedSeqs, dimension);
        if (alignment != 2) {
            LayoutInterval interval;
            HashMap<LayoutInterval, LayoutInterval> leadingMap = new HashMap<LayoutInterval, LayoutInterval>();
            HashMap<LayoutInterval, LayoutInterval> trailingMap = new HashMap<LayoutInterval, LayoutInterval>();
            for (int i = 0; i < intervals.length; ++i) {
                LayoutInterval interval2 = intervals[i];
                LayoutInterval parent = interval2.getParent();
                if (parent == parParent) {
                    parent = interval2;
                }
                LayoutInterval leading = (LayoutInterval)leadingMap.get(parent);
                LayoutInterval trailing = (LayoutInterval)trailingMap.get(parent);
                if (leading == null || parent.indexOf(leading) > parent.indexOf(interval2)) {
                    leadingMap.put(parent, interval2);
                }
                if (trailing != null && parent.indexOf(trailing) >= parent.indexOf(interval2)) continue;
                trailingMap.put(parent, interval2);
            }
            LayoutInterval[] leadingIntervals = new LayoutInterval[leadingMap.size()];
            LayoutInterval[] trailingIntervals = new LayoutInterval[trailingMap.size()];
            Iterator<Object> iter = leadingMap.values().iterator();
            int counter = 0;
            while (iter.hasNext()) {
                interval = (LayoutInterval)iter.next();
                leadingIntervals[counter++] = interval;
            }
            iter = trailingMap.values().iterator();
            counter = 0;
            while (iter.hasNext()) {
                interval = (LayoutInterval)iter.next();
                trailingIntervals[counter++] = interval;
            }
            if (closed) {
                this.align(leadingIntervals, trailingIntervals, true, dimension, alignment);
            } else {
                LayoutInterval[] itervalsToAlign = alignment == 0 ? leadingIntervals : trailingIntervals;
                this.align(itervalsToAlign, null, false, dimension, alignment);
            }
            for (LayoutInterval gap : gapsToResize) {
                this.designer.setIntervalResizing(gap, true);
            }
        }
        this.designer.destroyGroupIfRedundant(parParent, null);
    }

    private void markByAlignAttributes(LayoutInterval parParent, LayoutInterval[] intervals) {
        this.layoutModel.changeIntervalAttribute(parParent, 64, true);
        this.layoutModel.changeIntervalAttribute(parParent, 128, true);
        for (int i = 0; i < intervals.length; ++i) {
            LayoutInterval interval = intervals[i];
            while (interval != parParent) {
                LayoutInterval parent = interval.getParent();
                this.layoutModel.changeIntervalAttribute(interval, 64, true);
                this.layoutModel.changeIntervalAttribute(interval, 128, true);
                if (parent.isSequential()) {
                    int index = parent.indexOf(interval);
                    for (int j = 0; j < parent.getSubIntervalCount(); ++j) {
                        if (j < index) {
                            this.markByAlignAttribute(parent.getSubInterval(j), 64);
                            continue;
                        }
                        if (j <= index) continue;
                        this.markByAlignAttribute(parent.getSubInterval(j), 128);
                    }
                }
                interval = parent;
            }
        }
    }

    private void markByAlignAttribute(LayoutInterval interval, int attr) {
        this.layoutModel.changeIntervalAttribute(interval, attr, true);
        if (interval.isGroup()) {
            Iterator<LayoutInterval> iter = interval.getSubIntervals();
            while (iter.hasNext()) {
                this.markByAlignAttribute(iter.next(), attr);
            }
        }
    }

    private LayoutInterval splitByAlignAttrs(LayoutInterval interval, List<LayoutInterval> removedSeqs, int alignment, boolean closed, int dimension, boolean optimize) {
        if (interval.isGroup()) {
            for (int i = interval.getSubIntervalCount() - 1; i >= 0; --i) {
                LayoutInterval subInterval = interval.getSubInterval(i);
                this.splitByAlignAttrs(subInterval, removedSeqs, alignment, closed, dimension, true);
            }
            if (interval.isParallel() && interval.hasAttribute(64) && interval.hasAttribute(128)) {
                int index;
                LayoutInterval prePar = new LayoutInterval(103);
                this.layoutModel.changeIntervalAttribute(prePar, 64, true);
                LayoutInterval midPar = new LayoutInterval(103);
                this.layoutModel.changeIntervalAttribute(midPar, 64, true);
                this.layoutModel.changeIntervalAttribute(midPar, 128, true);
                LayoutInterval postPar = new LayoutInterval(103);
                this.layoutModel.changeIntervalAttribute(postPar, 128, true);
                int minMid = Short.MAX_VALUE;
                int maxMid = Short.MIN_VALUE;
                int maxPre = Short.MIN_VALUE;
                int minPost = Short.MAX_VALUE;
                int maxMidWidth = 0;
                Iterator<LayoutInterval> iter = interval.getSubIntervals();
                while (iter.hasNext()) {
                    LayoutInterval subInterval = iter.next();
                    boolean preSub = subInterval.hasAttribute(64);
                    boolean postSub = subInterval.hasAttribute(128);
                    LayoutInterval trailingPre = null;
                    LayoutInterval leadingMid = null;
                    LayoutInterval trailingMid = null;
                    LayoutInterval leadingPost = null;
                    if (subInterval.isSequential() && preSub && postSub) {
                        Iterator<LayoutInterval> subIter = subInterval.getSubIntervals();
                        while (subIter.hasNext()) {
                            LayoutInterval subSubInterval = subIter.next();
                            boolean preSubSub = subSubInterval.hasAttribute(64);
                            boolean postSubSub = subSubInterval.hasAttribute(128);
                            if (preSubSub) {
                                if (postSubSub) {
                                    if (leadingMid == null) {
                                        leadingMid = subSubInterval;
                                    }
                                    trailingMid = subSubInterval;
                                    continue;
                                }
                                if (subSubInterval.isEmptySpace() && subSubInterval.getPreferredSize() != -1) continue;
                                trailingPre = subSubInterval;
                                continue;
                            }
                            if (!postSubSub || leadingPost != null || subSubInterval.isEmptySpace() && subSubInterval.getPreferredSize() != -1) continue;
                            leadingPost = subSubInterval;
                        }
                    } else if (preSub) {
                        if (postSub) {
                            leadingMid = subInterval;
                            trailingMid = subInterval;
                        } else {
                            trailingPre = subInterval;
                        }
                    } else if (postSub) {
                        leadingPost = subInterval;
                    }
                    if (trailingPre != null) {
                        maxPre = Math.max(maxPre, this.getPosition(trailingPre, dimension, 1));
                    }
                    if (leadingMid != null) {
                        int midLeading = this.getPosition(leadingMid, dimension, 0);
                        int midTrailing = this.getPosition(trailingMid, dimension, 1);
                        int width = midTrailing - midLeading;
                        minMid = Math.min(minMid, midLeading);
                        maxMid = Math.max(maxMid, midTrailing);
                        maxMidWidth = Math.max(maxMidWidth, width);
                    }
                    if (leadingPost == null) continue;
                    minPost = Math.min(minPost, this.getPosition(leadingPost, dimension, 0));
                }
                for (int i = interval.getSubIntervalCount() - 1; i >= 0; --i) {
                    LayoutInterval subInterval = interval.getSubInterval(i);
                    this.layoutModel.removeInterval(subInterval);
                    if (subInterval.isSequential()) {
                        int delta;
                        int bias;
                        boolean post;
                        boolean pre;
                        int j;
                        if (!subInterval.hasAttribute(64) && !subInterval.hasAttribute(128)) {
                            removedSeqs.add(subInterval);
                            continue;
                        }
                        LayoutInterval preSeq = new LayoutInterval(102);
                        this.layoutModel.changeIntervalAttribute(preSeq, 64, true);
                        LayoutInterval midSeq = new LayoutInterval(102);
                        this.layoutModel.changeIntervalAttribute(midSeq, 64, true);
                        this.layoutModel.changeIntervalAttribute(midSeq, 128, true);
                        LayoutInterval postSeq = new LayoutInterval(102);
                        this.layoutModel.changeIntervalAttribute(postSeq, 128, true);
                        int[] leading = new int[subInterval.getSubIntervalCount()];
                        int[] trailing = new int[leading.length];
                        for (int j2 = 0; j2 < subInterval.getSubIntervalCount(); ++j2) {
                            LayoutInterval subSubInterval = subInterval.getSubInterval(j2);
                            leading[j2] = this.getPosition(subSubInterval, dimension, 0);
                            trailing[j2] = this.getPosition(subSubInterval, dimension, 1);
                        }
                        LayoutInterval lastPre = null;
                        LayoutInterval lastPreGap = null;
                        LayoutInterval firstPostGap = null;
                        LayoutInterval firstMid = null;
                        LayoutInterval lastMid = null;
                        LayoutInterval firstPost = null;
                        for (j = 0; j < subInterval.getSubIntervalCount(); ++j) {
                            LayoutInterval subSubInterval = subInterval.getSubInterval(j);
                            pre = subSubInterval.hasAttribute(64);
                            post = subSubInterval.hasAttribute(128);
                            if (pre && !post) {
                                lastPreGap = subSubInterval;
                            }
                            if (post && !pre && firstPostGap == null) {
                                firstPostGap = subSubInterval;
                            }
                            if (!pre || !post) continue;
                            if (firstMid == null) {
                                firstMid = subSubInterval;
                            }
                            lastMid = subSubInterval;
                        }
                        firstPost = firstPostGap;
                        lastPre = lastPreGap;
                        if (firstPostGap != null && !firstPostGap.isEmptySpace()) {
                            firstPostGap = null;
                        }
                        if (lastPreGap != null && !lastPreGap.isEmptySpace()) {
                            lastPreGap = null;
                        }
                        if (alignment == 0) {
                            int shift;
                            bias = Math.max(0, maxPre - minMid);
                            int n = shift = LayoutInterval.getEffectiveAlignment(firstMid) == 0 ? bias : 0;
                            if (lastPreGap != null) {
                                delta = this.shortenGap(lastPreGap, this.getPosition(firstMid, dimension, 0) - minMid - shift);
                                int n2 = subInterval.indexOf(lastPreGap);
                                trailing[n2] = trailing[n2] - delta;
                            }
                            int n3 = shift = LayoutInterval.getEffectiveAlignment(lastMid) == 0 ? bias : 0;
                            if (firstPostGap != null) {
                                delta = this.shortenGap(firstPostGap, maxMidWidth - (this.getPosition(lastMid, dimension, 1) - minMid) + shift);
                                int n4 = subInterval.indexOf(firstPostGap);
                                leading[n4] = leading[n4] + delta;
                            }
                        }
                        if (alignment == 1) {
                            int shift;
                            bias = Math.max(0, maxMid - minPost);
                            int n = shift = LayoutInterval.getEffectiveAlignment(lastMid) == 1 ? bias : 0;
                            if (firstPostGap != null) {
                                delta = this.shortenGap(firstPostGap, maxMid - this.getPosition(lastMid, dimension, 1) - shift);
                                int n5 = subInterval.indexOf(firstPostGap);
                                leading[n5] = leading[n5] + delta;
                            }
                            int n6 = shift = LayoutInterval.getEffectiveAlignment(firstMid) == 1 ? bias : 0;
                            if (lastPreGap != null) {
                                delta = this.shortenGap(lastPreGap, maxMidWidth - (maxMid - this.getPosition(firstMid, dimension, 0)) + shift);
                                int n7 = subInterval.indexOf(lastPreGap);
                                trailing[n7] = trailing[n7] - delta;
                            }
                        }
                        this.setAlignmentAccordingEffectiveAlignment(preSeq, lastPre);
                        this.setAlignmentAccordingEffectiveAlignment(midSeq, firstMid);
                        this.setAlignmentAccordingEffectiveAlignment(postSeq, firstPost);
                        for (j = subInterval.getSubIntervalCount() - 1; j >= 0; --j) {
                            LayoutInterval subSubInterval = subInterval.getSubInterval(j);
                            pre = subSubInterval.hasAttribute(64);
                            post = subSubInterval.hasAttribute(128);
                            assert (pre || post);
                            LayoutInterval seqToInsertInto = pre && !post && (alignment == 0 || closed) ? preSeq : (post && !pre && (alignment == 1 || closed) ? postSeq : midSeq);
                            this.expandCurrentSpace(seqToInsertInto, dimension, leading[j], trailing[j]);
                            this.layoutModel.removeInterval(subSubInterval);
                            this.layoutModel.addInterval(subSubInterval, seqToInsertInto, 0);
                        }
                        this.putGroupToGroup(preSeq, prePar, 0);
                        this.putGroupToGroup(midSeq, midPar, 0);
                        this.putGroupToGroup(postSeq, postPar, 0);
                        continue;
                    }
                    boolean pre = subInterval.hasAttribute(64);
                    boolean post = subInterval.hasAttribute(128);
                    if (!pre && !post) {
                        removedSeqs.add(subInterval);
                        continue;
                    }
                    if (pre && !post && (alignment == 0 || closed)) {
                        this.layoutModel.addInterval(subInterval, prePar, 0);
                        prePar.getCurrentSpace().expand(subInterval.getCurrentSpace());
                        continue;
                    }
                    if (post && !pre && (alignment == 1 || closed)) {
                        this.layoutModel.addInterval(subInterval, postPar, 0);
                        postPar.getCurrentSpace().expand(subInterval.getCurrentSpace());
                        continue;
                    }
                    this.layoutModel.addInterval(subInterval, midPar, 0);
                    midPar.getCurrentSpace().expand(subInterval.getCurrentSpace());
                }
                LayoutInterval parent = interval.getParent();
                if (parent != null) {
                    index = this.layoutModel.removeInterval(interval);
                } else {
                    parent = interval;
                    index = 0;
                }
                if (!parent.isSequential()) {
                    LayoutInterval seq = new LayoutInterval(102);
                    this.layoutModel.changeIntervalAttribute(seq, 64, true);
                    this.layoutModel.changeIntervalAttribute(seq, 128, true);
                    this.layoutModel.addInterval(seq, parent, index);
                    index = 0;
                    parent = seq;
                }
                this.putGroupToGroup(postPar, parent, index);
                interval = this.putGroupToGroup(midPar, parent, index, optimize);
                this.putGroupToGroup(prePar, parent, index);
            }
        }
        return interval;
    }

    private LayoutInterval putGroupToGroup(LayoutInterval groupToInsert, LayoutInterval group, int index) {
        return this.putGroupToGroup(groupToInsert, group, index, true);
    }

    private LayoutInterval putGroupToGroup(LayoutInterval groupToInsert, LayoutInterval group, int index, boolean optimize) {
        int i;
        if (groupToInsert.isParallel()) {
            LayoutInterval emptySpace = null;
            for (i = groupToInsert.getSubIntervalCount() - 1; i >= 0; --i) {
                LayoutInterval interval = groupToInsert.getSubInterval(i);
                if (!interval.isEmptySpace()) continue;
                emptySpace = interval;
                this.layoutModel.removeInterval(interval);
            }
            if (groupToInsert.getSubIntervalCount() == 0 && emptySpace != null) {
                this.layoutModel.addInterval(emptySpace, groupToInsert, 0);
            }
        }
        if (groupToInsert.getSubIntervalCount() > 0) {
            LayoutRegion region = groupToInsert.getCurrentSpace();
            while (optimize && groupToInsert.getSubIntervalCount() == 1) {
                LayoutInterval interval = groupToInsert.getSubInterval(0);
                this.layoutModel.removeInterval(interval);
                this.layoutModel.setIntervalAlignment(interval, groupToInsert.getAlignment());
                groupToInsert = interval;
            }
            if (optimize && groupToInsert.isSequential() && group.isSequential()) {
                for (i = groupToInsert.getSubIntervalCount() - 1; i >= 0; --i) {
                    LayoutInterval subInterval = groupToInsert.getSubInterval(i);
                    this.layoutModel.removeInterval(subInterval);
                    this.layoutModel.addInterval(subInterval, group, index);
                }
                groupToInsert = null;
            } else {
                this.layoutModel.addInterval(groupToInsert, group, index);
            }
            group.getCurrentSpace().expand(region);
        }
        return groupToInsert;
    }

    private void expandCurrentSpace(LayoutInterval interval, int dimension, int leading, int trailing) {
        LayoutRegion region = new LayoutRegion();
        region.positions[dimension][0] = leading;
        region.positions[dimension][1] = trailing;
        interval.getCurrentSpace().expand(region, dimension);
    }

    private int getPosition(LayoutInterval interval, int dimension, int alignment) {
        if (interval.isEmptySpace()) {
            LayoutInterval parent = interval.getParent();
            assert (parent.isSequential() && (alignment == 0 || alignment == 1));
            int index = parent.indexOf(interval);
            if (alignment == 0) {
                return index > 0 ? parent.getSubInterval((int)(index - 1)).getCurrentSpace().positions[dimension][1] : parent.getCurrentSpace().positions[dimension][0];
            }
            return index + 1 < parent.getSubIntervalCount() ? parent.getSubInterval((int)(index + 1)).getCurrentSpace().positions[dimension][0] : parent.getCurrentSpace().positions[dimension][1];
        }
        return interval.getCurrentSpace().positions[dimension][alignment];
    }

    /*
     * WARNING - void declaration
     */
    private List transferToParallelParent(LayoutInterval[] intervals, LayoutInterval parParent, int alignment, boolean closed) {
        Iterator iter;
        LayoutComponent temp = intervals[0].getComponent();
        int dimension = temp.getLayoutInterval(0) == intervals[0] ? 0 : 1;
        int leadingPosition = Short.MAX_VALUE;
        int trailingPosition = 0;
        int targetEffAlignment = -1;
        for (int i = 0; i < intervals.length; ++i) {
            LayoutInterval interval = intervals[i];
            assert (interval.isComponent());
            LayoutRegion region = interval.getCurrentSpace();
            int leading = region.positions[dimension][0];
            int trailing = region.positions[dimension][1];
            leadingPosition = Math.min(leading, leadingPosition);
            trailingPosition = Math.max(trailing, trailingPosition);
            int effAlignment = LayoutInterval.getEffectiveAlignment(interval);
            if (effAlignment != 0 && effAlignment != 1 || targetEffAlignment != -1 && effAlignment != alignment) continue;
            targetEffAlignment = effAlignment;
        }
        boolean resizable = false;
        boolean leadingGaps = true;
        boolean trailingGaps = true;
        LinkedList gapsToResize = new LinkedList();
        LayoutInterval[] firstIntervals = new LayoutInterval[intervals.length];
        LayoutInterval[] lastIntervals = new LayoutInterval[intervals.length];
        List<LayoutInterval> intervalList = Arrays.asList(intervals);
        LinkedList<LinkedList<LayoutInterval>> newSequences = new LinkedList<LinkedList<LayoutInterval>>();
        HashMap<LayoutInterval, Integer> gapSizes = new HashMap<LayoutInterval, Integer>();
        for (int i = 0; i < intervals.length; ++i) {
            LayoutInterval layoutInterval = intervals[i];
            List<LayoutInterval> transferedComponents = this.transferedComponents(intervals, i, parParent);
            LayoutInterval firstInterval = null;
            LayoutInterval lastInterval = null;
            for (int j = transferedComponents.size() - 1; j >= 0; --j) {
                LayoutInterval trInterval = transferedComponents.get(j);
                if (intervalList.contains(trInterval)) {
                    firstInterval = trInterval;
                    if (lastInterval != null) continue;
                    lastInterval = trInterval;
                    continue;
                }
                if (alignment != 2) continue;
                transferedComponents.remove(trInterval);
            }
            firstIntervals[i] = firstInterval;
            lastIntervals[i] = lastInterval;
            LinkedList<LayoutInterval> newSequenceList = new LinkedList<LayoutInterval>();
            newSequences.add(newSequenceList);
            boolean sequenceResizable = false;
            LinkedList<LayoutInterval> sequenceGapsToResize = new LinkedList<LayoutInterval>();
            Iterator<LayoutInterval> iter2 = transferedComponents.iterator();
            LayoutRegion parentRegion = parParent.getCurrentSpace();
            LayoutInterval leadingInterval = iter2.next();
            LayoutRegion leadingRegion = leadingInterval.getCurrentSpace();
            if (alignment == 1 && !closed) {
                LayoutInterval gap;
                int preGap = leadingRegion.positions[dimension][0] - parentRegion.positions[dimension][0];
                LayoutInterval gapInterval = LayoutInterval.getNeighbor(leadingInterval, 102, 0);
                boolean bl = leadingGaps = leadingGaps && preGap != 0;
                if (gapInterval != null && gapInterval.isEmptySpace() && parParent.isParentOf(gapInterval) && LayoutInterval.getIntervalCurrentSize(gapInterval, dimension) == preGap) {
                    gap = this.cloneGap(gapInterval);
                    newSequenceList.add(gap);
                    gapSizes.put(gap, new Integer(preGap));
                    if (alignment == 1) {
                        sequenceResizable = sequenceResizable || LayoutInterval.canResize(gap);
                    }
                } else {
                    this.maybeAddGap(newSequenceList, preGap, true);
                    if (preGap != 0 && alignment == 1 && leadingInterval == firstInterval) {
                        gap = (LayoutInterval)newSequenceList.get(newSequenceList.size() - 1);
                        if (LayoutInterval.getEffectiveAlignment(leadingInterval) == 1) {
                            this.layoutModel.setIntervalSize(gap, -2, preGap, -2);
                            sequenceGapsToResize.add(gap);
                        }
                    }
                }
            }
            boolean afterDefiningInterval = false;
            newSequenceList.add(leadingInterval);
            while (iter2.hasNext()) {
                LayoutInterval gap;
                LayoutInterval neighbor;
                if (leadingInterval == layoutInterval) {
                    afterDefiningInterval = true;
                }
                LayoutInterval trailingInterval = iter2.next();
                if (alignment == 1 && (!afterDefiningInterval || leadingInterval == layoutInterval) || alignment == 0 && afterDefiningInterval) {
                    sequenceResizable = sequenceResizable || LayoutInterval.canResize(leadingInterval);
                }
                LayoutRegion trailingRegion = trailingInterval.getCurrentSpace();
                LayoutInterval gapInterval = LayoutInterval.getNeighbor(leadingInterval, 102, 1);
                int gapSize = trailingRegion.positions[dimension][0] - leadingRegion.positions[dimension][1];
                boolean gapFound = false;
                if (gapInterval.isEmptySpace() && (neighbor = LayoutInterval.getNeighbor(gapInterval, 102, 1)) == trailingInterval) {
                    gapFound = true;
                    LayoutInterval gap2 = this.cloneGap(gapInterval);
                    newSequenceList.add(gap2);
                    gapSizes.put(gap2, new Integer(gapSize));
                    if (alignment == 1 && !afterDefiningInterval || alignment == 0 && afterDefiningInterval) {
                        boolean bl = sequenceResizable = sequenceResizable || LayoutInterval.canResize(gap2);
                    }
                }
                if (!gapFound) {
                    this.maybeAddGap(newSequenceList, gapSize, alignment == 2);
                }
                if ((leadingInterval == lastInterval && alignment == 0 && LayoutInterval.getEffectiveAlignment(trailingInterval) == 1 || trailingInterval == firstInterval && alignment == 1 && LayoutInterval.getEffectiveAlignment(leadingInterval) == 0) && !LayoutInterval.canResize(gap = (LayoutInterval)newSequenceList.get(newSequenceList.size() - 1))) {
                    sequenceGapsToResize.add(gap);
                }
                newSequenceList.add(trailingInterval);
                leadingInterval = trailingInterval;
                leadingRegion = trailingRegion;
            }
            if (alignment == 0 || alignment == 1 && leadingInterval == lastInterval) {
                boolean bl = sequenceResizable = sequenceResizable || LayoutInterval.canResize(leadingInterval);
            }
            if (alignment == 0 && !closed) {
                int postGap = parentRegion.positions[dimension][1] - leadingRegion.positions[dimension][1];
                trailingGaps = trailingGaps && postGap != 0;
                LayoutInterval gapInterval = LayoutInterval.getNeighbor(leadingInterval, 102, 1);
                if (gapInterval != null && gapInterval.isEmptySpace() && parParent.isParentOf(gapInterval) && LayoutInterval.getIntervalCurrentSize(gapInterval, dimension) == postGap) {
                    LayoutInterval gap = this.cloneGap(gapInterval);
                    newSequenceList.add(gap);
                    gapSizes.put(gap, new Integer(postGap));
                    if (alignment == 0) {
                        sequenceResizable = sequenceResizable || LayoutInterval.canResize(gap);
                    }
                } else {
                    this.maybeAddGap(newSequenceList, postGap, true);
                }
            }
            boolean bl = resizable = resizable || sequenceResizable;
            if (sequenceResizable) continue;
            gapsToResize.addAll(sequenceGapsToResize);
        }
        if (alignment != 2) {
            void var22_30;
            Iterator listIter = newSequences.iterator();
            boolean bl = false;
            while (var22_30 < intervals.length) {
                List newSequenceList = (List)listIter.next();
                iter = newSequenceList.iterator();
                LayoutInterval gapCandidate = null;
                while (iter.hasNext()) {
                    LayoutInterval interval = (LayoutInterval)iter.next();
                    if (interval == firstIntervals[var22_30] && alignment == 0 || interval == lastIntervals[var22_30] && alignment == 1) {
                        LayoutRegion region = interval.getCurrentSpace();
                        int diff = 0;
                        if (alignment == 1) {
                            if (!iter.hasNext()) break;
                            gapCandidate = (LayoutInterval)iter.next();
                            diff = trailingPosition - region.positions[dimension][1];
                        } else {
                            diff = region.positions[dimension][0] - leadingPosition;
                        }
                        if (gapCandidate == null || !gapCandidate.isEmptySpace()) break;
                        if (!leadingGaps && alignment == 0 && newSequenceList.indexOf(gapCandidate) == 0 || !trailingGaps && alignment == 1 && !iter.hasNext()) {
                            newSequenceList.remove(gapCandidate);
                            break;
                        }
                        Integer size = (Integer)gapSizes.get(gapCandidate);
                        int minSize = gapCandidate.getMinimumSize();
                        int prefSize = gapCandidate.getPreferredSize();
                        int maxSize = gapCandidate.getMaximumSize();
                        if (diff > 0) {
                            if (size != null) {
                                int actualSize = size;
                                diff += prefSize - actualSize;
                            }
                            if (minSize >= 0) {
                                int n = minSize = minSize - diff > 0 ? minSize - diff : -1;
                            }
                            if (prefSize >= 0) {
                                int n = prefSize = prefSize - diff > 0 ? prefSize - diff : -1;
                            }
                            if (maxSize >= 0 && maxSize != Short.MAX_VALUE) {
                                int n = maxSize = maxSize - diff > 0 ? maxSize - diff : -2;
                            }
                        }
                        if (targetEffAlignment == alignment && maxSize == Short.MAX_VALUE) {
                            maxSize = -2;
                        }
                        this.layoutModel.setIntervalSize(gapCandidate, minSize, prefSize, maxSize);
                        break;
                    }
                    gapCandidate = interval;
                }
                ++var22_30;
            }
        }
        for (List list : newSequences) {
            LayoutInterval compInterval;
            LayoutInterval newSequence = new LayoutInterval(102);
            if (alignment == 2) {
                newSequence.setAlignment(2);
            }
            iter = list.iterator();
            int sequenceAlignment = -1;
            while (iter.hasNext()) {
                compInterval = (LayoutInterval)iter.next();
                if (compInterval.isComponent()) {
                    if (sequenceAlignment == -1) {
                        sequenceAlignment = LayoutInterval.getEffectiveAlignment(compInterval);
                    }
                    this.designer.takeOutInterval(compInterval, parParent);
                    this.layoutModel.setIntervalAlignment(compInterval, -1);
                }
                this.layoutModel.addInterval(compInterval, newSequence, -1);
            }
            if (alignment != 2 && !LayoutInterval.wantResize(newSequence)) {
                newSequence.setAlignment(sequenceAlignment);
            }
            if (list.size() == 1) {
                compInterval = (LayoutInterval)list.get(0);
                this.layoutModel.removeInterval(compInterval);
                if (newSequence.getAlignment() != -1) {
                    this.layoutModel.setIntervalAlignment(compInterval, newSequence.getAlignment());
                }
                newSequence = compInterval;
            }
            this.layoutModel.addInterval(newSequence, parParent, -1);
        }
        if (alignment == 2) {
            this.layoutModel.setGroupAlignment(parParent, alignment);
        }
        if (gapsToResize.size() > 0 && !resizable && alignment != 2) {
            this.operations.suppressGroupResizing(parParent);
            for (LayoutInterval gap : gapsToResize) {
                this.layoutModel.changeIntervalAttribute(gap, 2, false);
                this.layoutModel.changeIntervalAttribute(gap, 1, true);
            }
        }
        return gapsToResize;
    }

    private List<LayoutInterval> transferedComponents(LayoutInterval[] intervals, int index, LayoutInterval parParent) {
        LayoutInterval interval = intervals[index];
        LayoutInterval oppInterval = this.oppositeComponentInterval(interval);
        LinkedList<LayoutInterval> transferedComponents = new LinkedList<LayoutInterval>();
        LinkedList<LayoutInterval> components = new LinkedList<LayoutInterval>();
        this.componentsInGroup(parParent, components);
        for (LayoutInterval candidate : components) {
            LayoutInterval oppCandidate = this.oppositeComponentInterval(candidate);
            if (!LayoutAligner.alignedIntervals(oppInterval, oppCandidate, 3) && !LayoutAligner.alignedIntervals(oppInterval, oppCandidate, 0) && !LayoutAligner.alignedIntervals(oppInterval, oppCandidate, 1) && !LayoutAligner.alignedIntervals(oppInterval, oppCandidate, 2) || !parParent.isParentOf(candidate)) continue;
            transferedComponents.add(candidate);
        }
        if (!transferedComponents.contains(interval)) {
            transferedComponents.add(interval);
        }
        Collections.sort(transferedComponents, new Comparator<LayoutInterval>(){

            @Override
            public int compare(LayoutInterval interval1, LayoutInterval interval2) {
                LayoutComponent comp = interval1.getComponent();
                int dimension = comp.getLayoutInterval(1) == interval1 ? 1 : 0;
                LayoutRegion region1 = interval1.getCurrentSpace();
                LayoutRegion region2 = interval2.getCurrentSpace();
                int value1 = region1.positions[dimension][0];
                int value2 = region2.positions[dimension][0];
                return value1 - value2;
            }
        });
        return transferedComponents;
    }

    private void componentsInGroup(LayoutInterval group, Collection<LayoutInterval> components) {
        Iterator<LayoutInterval> iter = group.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval interval = iter.next();
            if (interval.isGroup()) {
                this.componentsInGroup(interval, components);
                continue;
            }
            if (!interval.isComponent() || components.contains(interval)) continue;
            components.add(interval);
        }
    }

    private boolean align(LayoutInterval[] leadingInts, LayoutInterval[] trailingInts, boolean closed, int dimension, int alignment) {
        LayoutInterval commonSeq;
        LayoutInterval group;
        boolean remainder;
        LayoutInterval commonGroup = null;
        LayoutInterval[] intervals = leadingInts;
        for (int i = 0; i < intervals.length; ++i) {
            LayoutInterval interval = intervals[i];
            LayoutInterval parent = interval.getParent();
            if (!parent.isParallel()) {
                parent = parent.getParent();
                assert (parent.isParallel());
            }
            if (commonGroup == null || parent != commonGroup && parent.isParentOf(commonGroup)) {
                commonGroup = parent;
                continue;
            }
            assert (parent == commonGroup || commonGroup.isParentOf(parent));
        }
        LinkedList<LayoutInterval> aligned = new LinkedList<LayoutInterval>();
        LinkedList<List> restLeading = new LinkedList<List>();
        LinkedList<List> restTrailing = new LinkedList<List>();
        int mainEffectiveAlign = -1;
        int originalCount = commonGroup.getSubIntervalCount();
        for (int i = 0; i < intervals.length; ++i) {
            LayoutInterval parParent;
            LayoutInterval interval = intervals[i];
            LayoutInterval parent = interval.getParent();
            LayoutInterval layoutInterval = parParent = parent.isParallel() ? parent : parent.getParent();
            if (parParent != commonGroup) {
                if ((interval = LayoutAligner.getAlignSubstitute(interval, commonGroup, alignment)) == null) {
                    return false;
                }
                parent = interval.getParent();
            }
            if (parent.isSequential()) {
                mainEffectiveAlign = LayoutInterval.getEffectiveAlignment(interval);
                int extractCount = this.operations.extract(interval, closed ? trailingInts[i] : interval, alignment, closed, restLeading, restTrailing);
                if (extractCount == 1) {
                    this.layoutModel.removeInterval(parent);
                    aligned.add(interval);
                    continue;
                }
                aligned.add(parent);
                continue;
            }
            aligned.add(interval);
        }
        boolean bl = remainder = !restLeading.isEmpty() || !restTrailing.isEmpty();
        if (!remainder && mainEffectiveAlign == alignment || aligned.size() == originalCount && commonGroup.getParent() != null) {
            group = commonGroup;
            if (remainder) {
                LayoutInterval groupParent = group.getParent();
                if (groupParent.isSequential()) {
                    commonSeq = groupParent;
                } else {
                    int index = this.layoutModel.removeInterval(group);
                    commonSeq = new LayoutInterval(102);
                    commonSeq.setAlignment(group.getAlignment());
                    this.layoutModel.addInterval(commonSeq, groupParent, index);
                    this.layoutModel.setIntervalAlignment(group, -1);
                    this.layoutModel.addInterval(group, commonSeq, -1);
                }
            } else {
                commonSeq = null;
            }
        } else {
            group = new LayoutInterval(103);
            if (remainder) {
                commonSeq = new LayoutInterval(102);
                commonSeq.add(group, -1);
                this.layoutModel.addInterval(commonSeq, commonGroup, -1);
            } else {
                commonSeq = null;
                this.layoutModel.addInterval(group, commonGroup, -1);
            }
            this.layoutModel.setGroupAlignment(group, alignment);
        }
        for (LayoutInterval interval : aligned) {
            if (interval.getParent() != group) {
                this.layoutModel.removeInterval(interval);
                this.operations.addContent(interval, group, -1);
            }
            this.layoutModel.setIntervalAlignment(interval, alignment);
        }
        if (!restLeading.isEmpty()) {
            this.designer.createRemainderGroup(restLeading, commonSeq, commonSeq.indexOf(group), 0, mainEffectiveAlign, dimension);
        }
        if (!restTrailing.isEmpty()) {
            this.designer.createRemainderGroup(restTrailing, commonSeq, commonSeq.indexOf(group), 1, mainEffectiveAlign, dimension);
        }
        return true;
    }

    private LayoutInterval cloneGap(LayoutInterval interval) {
        assert (interval.isEmptySpace());
        LayoutInterval gap = new LayoutInterval(101);
        gap.setMinimumSize(interval.getMinimumSize());
        gap.setPreferredSize(interval.getPreferredSize());
        gap.setMaximumSize(interval.getMaximumSize());
        return gap;
    }

    private void maybeAddGap(List<LayoutInterval> list, int size, boolean forceSize) {
        if (size > 0) {
            LayoutInterval gapInterval = new LayoutInterval(101);
            if (forceSize) {
                this.layoutModel.setIntervalSize(gapInterval, size, size, size);
            }
            list.add(gapInterval);
        }
    }

    private static boolean compatibleGroupAlignment(int groupAlign, int align) {
        return groupAlign == align || (groupAlign == 0 || groupAlign == 1) && (align == 0 || align == 1 || align == -1);
    }

    private static boolean alignedIntervals(LayoutInterval interval1, LayoutInterval interval2, int alignment) {
        LayoutInterval otherInterval;
        LayoutInterval commonParent;
        if (interval1.isParentOf(interval2)) {
            commonParent = interval1;
            otherInterval = interval2;
        } else if (interval2.isParentOf(interval1)) {
            commonParent = interval2;
            otherInterval = interval1;
        } else {
            commonParent = interval1.getParent();
            while (commonParent != null) {
                if (!LayoutAligner.hasAlignmentInParent(interval1, alignment)) {
                    return false;
                }
                if (commonParent.isParentOf(interval2)) break;
                interval1 = commonParent;
                commonParent = interval1.getParent();
            }
            if (commonParent == null) {
                return false;
            }
            otherInterval = interval2;
        }
        do {
            if (LayoutAligner.hasAlignmentInParent(otherInterval, alignment)) continue;
            return false;
        } while ((otherInterval = otherInterval.getParent()) != commonParent);
        return true;
    }

    private static boolean hasAlignmentInParent(LayoutInterval interval, int alignment) {
        LayoutInterval parent = interval.getParent();
        if (parent.isSequential()) {
            if (alignment == 0) {
                return parent.getSubInterval(0) == interval;
            }
            if (alignment == 1) {
                return parent.getSubInterval(parent.getSubIntervalCount() - 1) == interval;
            }
            return false;
        }
        assert (interval.getAlignment() != alignment || LayoutAligner.compatibleGroupAlignment(parent.getGroupAlignment(), alignment));
        return interval.getAlignment() == alignment || LayoutInterval.wantResize(interval);
    }

    private static LayoutInterval getAlignSubstitute(LayoutInterval toAlignWith, LayoutInterval commonParParent, int alignment) {
        assert (alignment == 0 || alignment == 1);
        while (toAlignWith != null && LayoutInterval.getFirstParent(toAlignWith, 103) != commonParParent) {
            if (LayoutInterval.isAlignedAtBorder(toAlignWith, alignment)) {
                toAlignWith = toAlignWith.getParent();
                continue;
            }
            return null;
        }
        return toAlignWith;
    }

    private LayoutInterval oppositeComponentInterval(LayoutInterval interval) {
        assert (interval.isComponent());
        LayoutComponent component = interval.getComponent();
        int oppDimension = component.getLayoutInterval(0) == interval ? 1 : 0;
        return component.getLayoutInterval(oppDimension);
    }

    private int shortenGap(LayoutInterval gap, int delta) {
        assert (gap.isEmptySpace());
        int prefSize = gap.getPreferredSize();
        if (prefSize == -1) {
            return 0;
        }
        int newPref = prefSize - delta;
        int n = newPref = newPref > 0 ? newPref : -1;
        if (LayoutInterval.canResize(gap)) {
            this.layoutModel.setIntervalSize(gap, -1, newPref, Short.MAX_VALUE);
        } else {
            this.layoutModel.setIntervalSize(gap, -2, newPref, -2);
        }
        return prefSize > delta ? delta : prefSize;
    }

    private void returnRemovedIntervals(LayoutInterval parParent, List removed, int dimension) {
        LayoutRegion parRegion = parParent.getCurrentSpace();
        for (LayoutInterval interval : removed) {
            LayoutInterval gap;
            LayoutInterval last;
            LayoutInterval first;
            LayoutRegion region = interval.getCurrentSpace();
            int pre = Math.max(0, region.positions[dimension][0] - parRegion.positions[dimension][0]);
            int post = Math.max(0, parRegion.positions[dimension][1] - region.positions[dimension][1]);
            if (!(pre == 0 && post == 0 || interval.isSequential())) {
                LayoutInterval seq = new LayoutInterval(102);
                if (interval.getAlignment() != 3) {
                    this.layoutModel.setIntervalAlignment(seq, interval.getAlignment());
                }
                this.layoutModel.setIntervalAlignment(interval, -1);
                this.layoutModel.addInterval(interval, seq, -1);
                interval = seq;
            }
            if (pre != 0 && (first = interval.getSubInterval(0)).isEmptySpace()) {
                this.layoutModel.removeInterval(first);
                region = interval.getSubInterval(0).getCurrentSpace();
                pre = Math.max(0, region.positions[dimension][0] - parRegion.positions[dimension][0]);
            }
            if (post != 0 && (last = interval.getSubInterval(interval.getSubIntervalCount() - 1)).isEmptySpace()) {
                this.layoutModel.removeInterval(last);
                region = interval.getSubInterval(interval.getSubIntervalCount() - 1).getCurrentSpace();
                post = Math.max(0, parRegion.positions[dimension][1] - region.positions[dimension][1]);
            }
            if (pre != 0) {
                gap = new LayoutInterval(101);
                gap.setSize(pre);
                if (interval.getAlignment() == 1) {
                    this.designer.setIntervalResizing(gap, true);
                }
                this.layoutModel.addInterval(gap, interval, 0);
            }
            if (post != 0) {
                gap = new LayoutInterval(101);
                gap.setSize(post);
                if (interval.getAlignment() == 0) {
                    this.designer.setIntervalResizing(gap, true);
                }
                this.layoutModel.addInterval(gap, interval, -1);
            }
            this.layoutModel.addInterval(interval, parParent, -1);
        }
    }

    private void setAlignmentAccordingEffectiveAlignment(LayoutInterval aligned, LayoutInterval interval) {
        if (interval == null) {
            return;
        }
        int alignment = LayoutInterval.getEffectiveAlignment(interval);
        if (alignment == 0 || alignment == 1) {
            this.layoutModel.setIntervalAlignment(aligned, alignment);
        }
    }
}

