/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.TreeModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.form.editors2.TreeModelEditor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class TreeModelCustomizer
extends JPanel {
    private TreeModelEditor propEditor;
    private JLabel label;
    private JScrollPane scrollPane1;
    private JScrollPane scrollPane2;
    private JSplitPane splitPane;
    private JTextArea textArea;
    private JTree tree;
    private JLabel warningLabel;

    public TreeModelCustomizer(TreeModelEditor propEditor) {
        this.propEditor = propEditor;
        this.initComponents();
        String code = propEditor.getCodeValue();
        if (code == null) {
            String defaultModel = "JTree\n colors\n  blue\n  violet\n  red\n  yellow\n sports\n  basketball\n  soccer\n  football\n  hockey\n food\n  hot dogs\n  pizza\n  ravioli\n  bananas";
            this.textArea.setText(defaultModel);
            this.expandTree();
        }
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                TreeModelCustomizer.this.updateTree();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TreeModelCustomizer.this.updateTree();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TreeModelCustomizer.this.updateTree();
            }
        });
        if (code != null) {
            this.textArea.setText(code);
            this.updateTree();
        }
    }

    private void updateTree() {
        String txt = this.textArea.getText();
        int tabSize = this.textArea.getTabSize();
        StringBuilder sb = new StringBuilder(tabSize);
        for (int i = 0; i < tabSize; ++i) {
            sb.append(" ");
        }
        txt = txt.replace("\t", sb.toString());
        TreeModel model = this.propEditor.createTreeModel(txt);
        this.tree.setModel(model);
        this.expandTree();
        this.propEditor.setValue(model);
    }

    private void expandTree() {
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.scrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.scrollPane2 = new JScrollPane();
        this.tree = new JTree();
        this.label = new JLabel();
        this.warningLabel = new JLabel();
        this.splitPane.setDividerLocation(150);
        this.scrollPane1.setViewportView(this.textArea);
        this.textArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeModelCustomizer.class, (String)"ACSD_TreeModelEditor_TextArea"));
        this.splitPane.setLeftComponent(this.scrollPane1);
        this.scrollPane2.setViewportView(this.tree);
        this.tree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeModelCustomizer.class, (String)"ACSD_TreeModelEditor_Tree"));
        this.splitPane.setRightComponent(this.scrollPane2);
        this.label.setLabelFor(this.textArea);
        Mnemonics.setLocalizedText((JLabel)this.label, (String)NbBundle.getMessage(TreeModelCustomizer.class, (String)"TreeModelCustomizer.label.text"));
        this.warningLabel.setLabelFor(this.tree);
        Mnemonics.setLocalizedText((JLabel)this.warningLabel, (String)NbBundle.getMessage(TreeModelCustomizer.class, (String)"TreeModelCustomizer.warningLabel.text"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.label, -1, 380, Short.MAX_VALUE).add((Component)this.splitPane, -1, 380, Short.MAX_VALUE).add((Component)this.warningLabel, -1, 380, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.label).addPreferredGap(0).add((Component)this.splitPane, -1, 40, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.warningLabel).addContainerGap()));
    }
}

