/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors2;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormCodeAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.PersistenceObjectRegistry;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADConnectionPropertyEditor;
import org.netbeans.modules.form.RADProperty;
import org.netbeans.modules.form.ResourceSupport;
import org.netbeans.modules.form.ResourceValue;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TableColumnModelEditor
extends PropertyEditorSupport
implements NamedPropertyEditor,
FormCodeAwareEditor,
XMLPropertyEditor {
    private RADProperty property;
    private static final String XML_TABLE_COLUMN_MODEL = "TableColumnModel";
    private static final String ATTR_SELECTION_MODEL = "selectionModel";
    private static final String XML_COLUMN = "Column";
    private static final String ATTR_RESIZABLE = "resizable";
    private static final String ATTR_WIDTH_MIN = "minWidth";
    private static final String ATTR_WIDTH_PREF = "prefWidth";
    private static final String ATTR_WIDTH_MAX = "maxWidth";
    private static final String XML_TITLE = "Title";
    private static final String XML_EDITOR = "Editor";
    private static final String XML_RENDERER = "Renderer";
    private static final String ATTR_PROP_EDITOR = "editor";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_RESOURCE_KEY = "resourceKey";
    private static final String ATTR_NO_RESOURCE = "noResource";

    @Override
    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"TableColumnModelEditor");
    }

    @Override
    public void setContext(FormModel formModel, FormProperty formProperty) {
        this.property = (RADProperty)formProperty;
    }

    @Override
    public void updateFormVersionLevel() {
        this.property.getPropertyContext().getFormModel().raiseVersionLevel(FormModel.FormVersion.NB60, FormModel.FormVersion.NB60);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        JLabel jLabel = new JLabel(NbBundle.getMessage(this.getClass(), (String)"TableColumnModelEditor_Customizer"));
        jLabel.setHorizontalAlignment(0);
        return jLabel;
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = NbBundle.getMessage(TableColumnModelEditor.class, (String)"TableColumnModelEditor_TableColumnModel");
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString(string, rectangle.x, rectangle.y + (rectangle.height - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
    }

    @Override
    public String getSourceCode() {
        Object object;
        RADComponent rADComponent = this.property.getRADComponent();
        CodeVariable codeVariable = rADComponent.getCodeExpression().getVariable();
        String string = codeVariable == null ? null : codeVariable.getName();
        String string2 = this.property.getPropertyDescriptor().getReadMethod().getName();
        String string3 = string2 + "()";
        if (string != null) {
            string3 = string + '.' + string3;
        }
        if ((object = this.getValue()) instanceof FormTableColumnModel) {
            FormTableColumnModel formTableColumnModel = (FormTableColumnModel)object;
            StringBuilder stringBuilder = new StringBuilder();
            int n = formTableColumnModel.getSelectionModel();
            if (n > 0) {
                stringBuilder.append(string3).append(".getSelectionModel().setSelectionMode(javax.swing.ListSelectionModel.");
                switch (n) {
                    case 1: {
                        stringBuilder.append("SINGLE_SELECTION");
                        break;
                    }
                    case 2: {
                        stringBuilder.append("SINGLE_INTERVAL_SELECTION");
                        break;
                    }
                    case 3: {
                        stringBuilder.append("MULTIPLE_INTERVAL_SELECTION");
                    }
                }
                stringBuilder.append(");\n");
            }
            List<FormTableColumn> list = formTableColumnModel.getColumns();
            for (int i = 0; i < list.size(); ++i) {
                FormProperty formProperty;
                FormTableColumn formTableColumn = list.get(i);
                String string4 = string3 + ".getColumn(" + i + ")";
                if (!formTableColumn.isResizable()) {
                    stringBuilder.append(string4).append(".setResizable(").append(Boolean.toString(formTableColumn.isResizable())).append(");\n");
                }
                if (formTableColumn.getMinWidth() != -1) {
                    stringBuilder.append(string4).append(".setMinWidth(").append(Integer.toString(formTableColumn.getMinWidth())).append(");\n");
                }
                if (formTableColumn.getPrefWidth() != -1) {
                    stringBuilder.append(string4).append(".setPreferredWidth(").append(Integer.toString(formTableColumn.getPrefWidth())).append(");\n");
                }
                if (formTableColumn.getMaxWidth() != -1) {
                    stringBuilder.append(string4).append(".setMaxWidth(").append(Integer.toString(formTableColumn.getMaxWidth())).append(");\n");
                }
                if ((formProperty = formTableColumn.getTitle()).isChanged()) {
                    stringBuilder.append(string4).append(".setHeaderValue(").append(formProperty.getJavaInitializationString()).append(");\n");
                }
                if ((formProperty = formTableColumn.getEditor()).isChanged()) {
                    stringBuilder.append(string4).append(".setCellEditor(").append(formProperty.getJavaInitializationString()).append(");\n");
                }
                if (!(formProperty = formTableColumn.getRenderer()).isChanged()) continue;
                stringBuilder.append(string4).append(".setCellRenderer(").append(formProperty.getJavaInitializationString()).append(");\n");
            }
            return stringBuilder.length() == 0 ? null : stringBuilder.toString();
        }
        return null;
    }

    public void readFromXML(Node node) throws IOException {
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem(ATTR_SELECTION_MODEL).getNodeValue();
        int n = Integer.parseInt(string);
        FormTableColumnModel formTableColumnModel = new FormTableColumnModel(this.property);
        formTableColumnModel.setSelectionModel(n);
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!XML_COLUMN.equals(node2.getNodeName())) continue;
            FormTableColumn formTableColumn = new FormTableColumn(this.property, formTableColumnModel.getColumns().size());
            NamedNodeMap namedNodeMap2 = node2.getAttributes();
            String string2 = namedNodeMap2.getNamedItem(ATTR_RESIZABLE).getNodeValue();
            String string3 = namedNodeMap2.getNamedItem(ATTR_WIDTH_MIN).getNodeValue();
            String string4 = namedNodeMap2.getNamedItem(ATTR_WIDTH_PREF).getNodeValue();
            String string5 = namedNodeMap2.getNamedItem(ATTR_WIDTH_MAX).getNodeValue();
            boolean bl = Boolean.parseBoolean(string2);
            int n2 = Integer.parseInt(string3);
            int n3 = Integer.parseInt(string4);
            int n4 = Integer.parseInt(string5);
            formTableColumn.setResizable(bl);
            formTableColumn.setMinWidth(n2);
            formTableColumn.setPrefWidth(n3);
            formTableColumn.setMaxWidth(n4);
            NodeList nodeList2 = node2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node3 = nodeList2.item(j);
                String string6 = node3.getNodeName();
                if (XML_TITLE.equals(string6)) {
                    this.loadProperty(formTableColumn.getTitle(), node3);
                    continue;
                }
                if (XML_EDITOR.equals(string6)) {
                    this.loadProperty(formTableColumn.getEditor(), node3);
                    continue;
                }
                if (!XML_RENDERER.equals(string6)) continue;
                this.loadProperty(formTableColumn.getRenderer(), node3);
            }
            formTableColumnModel.getColumns().add(formTableColumn);
        }
        this.setValue(formTableColumnModel);
    }

    private void loadProperty(FormProperty formProperty, Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(ATTR_VALUE);
        Node node3 = namedNodeMap.getNamedItem(ATTR_NO_RESOURCE);
        Node node4 = namedNodeMap.getNamedItem(ATTR_RESOURCE_KEY);
        FormModel formModel = formProperty.getPropertyContext().getFormModel();
        try {
            if (node4 != null) {
                String string = node4.getNodeValue();
                ResourceValue resourceValue = ResourceSupport.findResource(formModel, string, formProperty.getValueType());
                formProperty.setValue(resourceValue);
            } else if (node2 != null) {
                formProperty.setValue(node2.getNodeValue());
            } else {
                NodeList nodeList = node.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node5 = nodeList.item(i);
                    if (node5.getNodeType() != 1) continue;
                    String string = namedNodeMap.getNamedItem(ATTR_PROP_EDITOR).getNodeValue();
                    RADConnectionPropertyEditor rADConnectionPropertyEditor = null;
                    if (string.equals(RADConnectionPropertyEditor.class.getName())) {
                        rADConnectionPropertyEditor = new RADConnectionPropertyEditor(formProperty.getValueType());
                        ((FormAwareEditor)rADConnectionPropertyEditor).setContext(formModel, formProperty);
                    } else {
                        Class clazz = PersistenceObjectRegistry.loadClass(string, FormEditor.getFormDataObject(formModel).getFormFile());
                        Object t = clazz.newInstance();
                        if (t instanceof XMLPropertyEditor) {
                            rADConnectionPropertyEditor = (XMLPropertyEditor)t;
                            if (t instanceof FormAwareEditor) {
                                ((FormAwareEditor)t).setContext(formModel, formProperty);
                            }
                        }
                    }
                    if (rADConnectionPropertyEditor == null) break;
                    rADConnectionPropertyEditor.readFromXML(node5);
                    formProperty.setValue(new FormProperty.ValueWithEditor(rADConnectionPropertyEditor.getValue(), rADConnectionPropertyEditor));
                    break;
                }
            }
            if (node3 != null && Boolean.parseBoolean(node3.getNodeValue())) {
                ResourceSupport.setExcludedProperty(formProperty, true);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
        }
    }

    public Node storeToXML(Document document) {
        Object object = this.getValue();
        Element element = null;
        if (object instanceof FormTableColumnModel) {
            FormTableColumnModel formTableColumnModel = (FormTableColumnModel)object;
            element = document.createElement(XML_TABLE_COLUMN_MODEL);
            element.setAttribute(ATTR_SELECTION_MODEL, Integer.toString(formTableColumnModel.getSelectionModel()));
            for (FormTableColumn formTableColumn : formTableColumnModel.getColumns()) {
                Element element2 = document.createElement(XML_COLUMN);
                element2.setAttribute(ATTR_RESIZABLE, Boolean.toString(formTableColumn.isResizable()));
                element2.setAttribute(ATTR_WIDTH_MIN, Integer.toString(formTableColumn.getMinWidth()));
                element2.setAttribute(ATTR_WIDTH_PREF, Integer.toString(formTableColumn.getPrefWidth()));
                element2.setAttribute(ATTR_WIDTH_MAX, Integer.toString(formTableColumn.getMaxWidth()));
                Element element3 = document.createElement(XML_TITLE);
                Element element4 = document.createElement(XML_EDITOR);
                Element element5 = document.createElement(XML_RENDERER);
                this.storeProperty(document, element3, formTableColumn.getTitle());
                this.storeProperty(document, element4, formTableColumn.getEditor());
                this.storeProperty(document, element5, formTableColumn.getRenderer());
                element2.appendChild(element3);
                element2.appendChild(element4);
                element2.appendChild(element5);
                element.appendChild(element2);
            }
        }
        return element;
    }

    private void storeProperty(Document document, Element element, FormProperty formProperty) {
        boolean bl;
        if (formProperty.isChanged()) {
            PropertyEditor propertyEditor = formProperty.getCurrentEditor();
            if (propertyEditor instanceof XMLPropertyEditor) {
                try {
                    propertyEditor.setValue(formProperty.getValue());
                    element.setAttribute(ATTR_PROP_EDITOR, propertyEditor.getClass().getName());
                    Node node = ((XMLPropertyEditor)propertyEditor).storeToXML(document);
                    if (node != null) {
                        element.appendChild(node);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, illegalAccessException.getMessage(), illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, invocationTargetException.getMessage(), invocationTargetException);
                }
            } else {
                try {
                    Object object = formProperty.getValue();
                    String string = null;
                    if (object instanceof ResourceValue) {
                        string = ((ResourceValue)object).getKey();
                    } else if (object instanceof String) {
                        element.setAttribute(ATTR_VALUE, (String)object);
                    } else {
                        System.err.println("Unable to store " + (Object)((Object)formProperty));
                    }
                    if (string != null) {
                        element.setAttribute(ATTR_RESOURCE_KEY, string);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, illegalAccessException.getMessage(), illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, invocationTargetException.getMessage(), invocationTargetException);
                }
            }
        }
        boolean bl2 = bl = ResourceSupport.isResourceableProperty(formProperty) && ResourceSupport.isExcludedProperty(formProperty);
        if (bl) {
            element.setAttribute(ATTR_NO_RESOURCE, Boolean.TRUE.toString());
        }
    }

    static class Property
    extends FormProperty {
        private Object value;

        Property(RADProperty rADProperty, String string, Class clazz, String string2, String string3) {
            super(new FormPropertyContext.SubProperty(rADProperty), string, clazz, string2, string3);
            rADProperty.getRADComponent().setPropertyListener(this);
        }

        @Override
        public Object getTargetValue() throws IllegalAccessException, InvocationTargetException {
            return this.value;
        }

        @Override
        public void setTargetValue(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.value = object;
        }
    }

    public static class FormTableColumn {
        private int index;
        private int minWidth;
        private int prefWidth;
        private int maxWidth;
        private boolean resizable;
        private Property title;
        private Property editor;
        private Property renderer;

        public FormTableColumn(RADProperty rADProperty, int n) {
            this.index = n;
            this.minWidth = -1;
            this.prefWidth = -1;
            this.maxWidth = -1;
            this.resizable = true;
            this.title = new Property(rADProperty, "title" + n, String.class, null, null);
            this.editor = new Property(rADProperty, TableColumnModelEditor.ATTR_PROP_EDITOR + n, TableCellEditor.class, null, null);
            this.renderer = new Property(rADProperty, "renderer" + n, TableCellRenderer.class, null, null);
        }

        public int getIndex() {
            return this.index;
        }

        public int getMinWidth() {
            return this.minWidth;
        }

        public void setMinWidth(int n) {
            this.minWidth = n;
        }

        public int getPrefWidth() {
            return this.prefWidth;
        }

        public void setPrefWidth(int n) {
            this.prefWidth = n;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public void setMaxWidth(int n) {
            this.maxWidth = n;
        }

        public boolean isResizable() {
            return this.resizable;
        }

        public void setResizable(boolean bl) {
            this.resizable = bl;
        }

        public FormProperty getTitle() {
            return this.title;
        }

        public FormProperty getEditor() {
            return this.editor;
        }

        public FormProperty getRenderer() {
            return this.renderer;
        }
    }

    public static class FormTableColumnModel
    extends FormDesignValueAdapter {
        private FormProperty property;
        private int selectionModel;
        private List<FormTableColumn> columns;
        private TableColumn defaultColumn;

        public FormTableColumnModel(FormProperty formProperty) {
            this.property = formProperty;
            this.columns = new LinkedList<FormTableColumn>();
        }

        public void setSelectionModel(int n) {
            this.selectionModel = n;
        }

        public int getSelectionModel() {
            return this.selectionModel;
        }

        public List<FormTableColumn> getColumns() {
            return this.columns;
        }

        @Override
        public Object getDesignValue() {
            Object object = null;
            try {
                object = this.property.getTargetValue();
                if (object instanceof TableColumnModel) {
                    TableColumnModel tableColumnModel = (TableColumnModel)object;
                    this.designValue(tableColumnModel);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, illegalAccessException.getMessage(), illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, invocationTargetException.getMessage(), invocationTargetException);
            }
            return object;
        }

        @Override
        public Object getDesignValue(Object object) {
            TableColumnModel tableColumnModel = null;
            if (object instanceof JTable) {
                tableColumnModel = ((JTable)object).getColumnModel();
                this.designValue(tableColumnModel);
            }
            return tableColumnModel;
        }

        private void designValue(TableColumnModel tableColumnModel) {
            int n = this.getSelectionModel();
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    tableColumnModel.getSelectionModel().setSelectionMode(0);
                    break;
                }
                case 2: {
                    tableColumnModel.getSelectionModel().setSelectionMode(1);
                    break;
                }
                case 3: {
                    tableColumnModel.getSelectionModel().setSelectionMode(2);
                }
            }
            for (int i = 0; i < this.columns.size() && i < tableColumnModel.getColumnCount(); ++i) {
                Object object;
                FormTableColumn formTableColumn = this.columns.get(i);
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                tableColumn.setResizable(formTableColumn.isResizable());
                int n2 = formTableColumn.getMinWidth() == -1 ? this.defaultColumn().getMinWidth() : formTableColumn.getMinWidth();
                tableColumn.setMinWidth(n2);
                n2 = formTableColumn.getPrefWidth() == -1 ? this.defaultColumn().getPreferredWidth() : formTableColumn.getPrefWidth();
                tableColumn.setPreferredWidth(n2);
                n2 = formTableColumn.getMaxWidth() == -1 ? this.defaultColumn().getMaxWidth() : formTableColumn.getMaxWidth();
                tableColumn.setMaxWidth(n2);
                FormProperty formProperty = formTableColumn.getTitle();
                try {
                    if (formProperty.isChanged()) {
                        tableColumn.setHeaderValue(formProperty.getRealValue());
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
                formProperty = formTableColumn.getEditor();
                try {
                    if (formProperty.isChanged() && (object = formProperty.getRealValue()) instanceof TableCellEditor) {
                        tableColumn.setCellEditor((TableCellEditor)object);
                    }
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
                formProperty = formTableColumn.getRenderer();
                try {
                    if (!formProperty.isChanged() || !((object = formProperty.getRealValue()) instanceof TableCellRenderer)) continue;
                    tableColumn.setCellRenderer((TableCellRenderer)object);
                    continue;
                }
                catch (Exception exception) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getMessage(), exception);
                }
            }
        }

        private TableColumn defaultColumn() {
            if (this.defaultColumn == null) {
                this.defaultColumn = new TableColumn();
            }
            return this.defaultColumn;
        }
    }
}

