/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.swing.text.BadLocationException;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormEditorSupport;
import org.netbeans.modules.form.FormRefactoringUpdate;
import org.netbeans.modules.form.JavaCodeGenerator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class RADComponentRenameRefactoringSupport {
    static void renameComponent(RADComponent rADComponent, String string) {
        int n = rADComponent.getCodeExpression().getVariable().getType();
        if ((n & 0x3000) == 4096) {
            FormRefactoringUpdate.renameComponentInCustomCode(rADComponent, string);
            rADComponent.setName(string);
        } else {
            boolean bl = (n & 7) == 2;
            FormDataObject formDataObject = FormEditor.getFormDataObject(rADComponent.getFormModel());
            JavaSource javaSource = JavaSource.forFileObject((FileObject)formDataObject.getPrimaryFile());
            MemberVisitor memberVisitor = new MemberVisitor(rADComponent.getName(), bl);
            try {
                javaSource.runUserActionTask((Task)memberVisitor, true);
                if (bl) {
                    boolean bl2 = RADComponentRenameRefactoringSupport.renameOutOfGuardedCode((GuardedDocument)memberVisitor.info.getDocument(), memberVisitor.usagesPositions, rADComponent.getName(), string);
                    FormRefactoringUpdate.renameComponentInCustomCode(rADComponent, string);
                    rADComponent.setName(string);
                    if (bl2) {
                        ((JavaCodeGenerator)FormEditor.getCodeGenerator(rADComponent.getFormModel())).regenerateVariables();
                    }
                } else {
                    RADComponentRenameRefactoringSupport.doRenameRefactoring(formDataObject, string, memberVisitor.getHandle());
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(RADComponentRenameRefactoringSupport.class.getName()).log(Level.SEVERE, iOException.getMessage(), iOException);
            }
        }
    }

    private static boolean renameOutOfGuardedCode(final GuardedDocument guardedDocument, final List<Integer> list, final String string, final String string2) throws IOException {
        if (list == null || list.isEmpty()) {
            return false;
        }
        final boolean[] blArray = new boolean[]{false};
        guardedDocument.runAtomic(new Runnable(){

            @Override
            public void run() {
                int n = 0;
                int n2 = string.length();
                try {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        int n3 = (Integer)iterator.next();
                        if ((guardedDocument.getGuardedBlockChain().compareBlock(n3 += n, n3 + n2) & 1) != 0) continue;
                        guardedDocument.remove(n3, n2);
                        guardedDocument.insertString(n3, string2, null);
                        n += string2.length() - n2;
                        blArray[0] = true;
                    }
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(RADComponentRenameRefactoringSupport.class.getName()).log(Level.INFO, badLocationException.getMessage(), badLocationException);
                }
            }
        });
        return blArray[0];
    }

    private static void doRenameRefactoring(FormDataObject formDataObject, String string, TreePathHandle treePathHandle) throws IOException {
        if (treePathHandle == null) {
            return;
        }
        FormEditorSupport formEditorSupport = formDataObject.getFormEditorSupport();
        if (formEditorSupport.isModified()) {
            formEditorSupport.saveDocument();
        }
        Lookup lookup = Lookups.singleton((Object)treePathHandle);
        RefactoringSession refactoringSession = RefactoringSession.create((String)"Change variable name");
        RenameRefactoring renameRefactoring = new RenameRefactoring(lookup);
        Problem problem = renameRefactoring.preCheck();
        if (problem != null && problem.isFatal()) {
            Logger.getLogger("global").log(Level.WARNING, "There were problems trying to perform the refactoring.");
        }
        Problem problem2 = null;
        if (!(problem != null && problem.isFatal() || RADComponentRenameRefactoringSupport.emptyOrWhite(string))) {
            renameRefactoring.setNewName(string);
            problem2 = renameRefactoring.prepare(refactoringSession);
        }
        if (!(problem2 != null && problem2.isFatal() || RADComponentRenameRefactoringSupport.emptyOrWhite(string))) {
            refactoringSession.doRefactoring(true);
        }
    }

    private static boolean emptyOrWhite(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().length() < 0;
    }

    private static class MemberVisitor
    extends TreePathScanner<Void, Void>
    implements CancellableTask<CompilationController> {
        private CompilationInfo info;
        private String member = null;
        private TreePathHandle handle = null;
        boolean findUsages;
        private Element variableElement;
        private List<Integer> usagesPositions;

        public TreePathHandle getHandle() {
            return this.handle;
        }

        public void setHandle(TreePathHandle treePathHandle) {
            this.handle = treePathHandle;
        }

        public MemberVisitor(String string, boolean bl) {
            this.member = string;
            this.findUsages = bl;
        }

        @Override
        public Void visitClass(ClassTree classTree, Void void_) {
            if (this.variableElement == null) {
                List<? extends Tree> list = classTree.getMembers();
                for (Tree tree : list) {
                    String string;
                    TreePath treePath;
                    Trees trees;
                    Element element;
                    if (tree.getKind() != Tree.Kind.VARIABLE || (element = (trees = this.info.getTrees()).getElement(treePath = new TreePath(this.getCurrentPath(), tree))) == null || !(string = element.getSimpleName().toString()).equals(this.member)) continue;
                    this.handle = TreePathHandle.create((TreePath)treePath, (CompilationInfo)this.info);
                    this.variableElement = element;
                    if (!this.findUsages) continue;
                    this.usagesPositions = new ArrayList<Integer>();
                }
            }
            if (this.findUsages) {
                super.visitClass(classTree, void_);
            }
            return null;
        }

        @Override
        public Void visitIdentifier(IdentifierTree identifierTree, Void void_) {
            if (this.findUsages) {
                Element element = this.info.getTrees().getElement(this.getCurrentPath());
                if (this.variableElement != null && ((Object)this.variableElement).equals(element)) {
                    int n = (int)this.info.getTrees().getSourcePositions().getStartPosition(this.info.getCompilationUnit(), identifierTree);
                    this.usagesPositions.add(n);
                }
            }
            return (Void)super.visitIdentifier(identifierTree, void_);
        }

        public void cancel() {
        }

        public void run(CompilationController compilationController) throws IOException {
            this.info = compilationController;
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            this.scan(compilationController.getCompilationUnit(), null);
        }
    }
}

