/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.editor.grid.ResourceImageEditor;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditor;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.EditorManager;
import org.netbeans.modules.vmd.game.model.EditorManagerListener;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayer;

public class MainView
implements GlobalRepositoryListener,
EditorManager {
    public static final boolean DEBUG = false;
    EventListenerList listenerList = new EventListenerList();
    private GlobalRepository gameDesign;
    private Editable currentEditable;
    private JPanel rootPanel;
    private JSplitPane mainSplit;
    private JSplitPane previewExplorerSplit;
    private JPanel mainEditorPanel;
    Map<Editable, JSplitPane> splits = new HashMap<Editable, JSplitPane>();

    public MainView(GlobalRepository globalRepository) {
        this.gameDesign = globalRepository;
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new BorderLayout());
        this.rootPanel.setBackground(Color.WHITE);
        this.mainEditorPanel = new JPanel();
        this.mainEditorPanel.setBorder(null);
        this.mainEditorPanel.setBackground(Color.WHITE);
    }

    private void initLayout() {
        this.mainEditorPanel.setLayout(new BorderLayout());
        this.mainSplit = new JSplitPane(1, false, this.previewExplorerSplit, this.mainEditorPanel);
        this.mainSplit.setDividerLocation(230);
        this.mainSplit.setDividerSize(5);
        this.mainSplit.setOneTouchExpandable(false);
        this.mainSplit.setResizeWeight(0.0);
        this.rootPanel.add((Component)this.mainEditorPanel, "Center");
    }

    public void paintTileChanged(Tile tile) {
        if (tile == null) {
            return;
        }
        Editable editable = this.currentEditable;
        if (editable == null) {
            return;
        }
        JComponent jComponent = editable.getEditor();
        if (jComponent instanceof TiledLayerEditor) {
            TiledLayerEditor tiledLayerEditor = (TiledLayerEditor)jComponent;
            tiledLayerEditor.setPaintTile(tile);
        }
    }

    @Override
    public void sceneAdded(Scene scene, int n) {
        this.requestEditing(scene);
    }

    @Override
    public void sceneRemoved(Scene scene, int n) {
        this.requestEditing(this.gameDesign);
    }

    @Override
    public void tiledLayerAdded(TiledLayer tiledLayer, int n) {
        this.requestEditing(tiledLayer);
    }

    @Override
    public void tiledLayerRemoved(TiledLayer tiledLayer, int n) {
        this.requestEditing(this.gameDesign);
    }

    @Override
    public void spriteAdded(Sprite sprite, int n) {
        if (this.rootPanel.isShowing()) {
            this.requestEditing(sprite);
        }
    }

    @Override
    public void spriteRemoved(Sprite sprite, int n) {
        this.requestEditing(this.gameDesign);
    }

    @Override
    public void imageResourceAdded(ImageResource imageResource) {
    }

    @Override
    public void requestEditing(Editable editable) {
        if (this.currentEditable == editable) {
            return;
        }
        this.currentEditable = editable;
        Editable.ImageResourceInfo imageResourceInfo = this.currentEditable.getImageResourceInfo();
        JComponent jComponent = this.currentEditable.getEditor();
        this.mainEditorPanel.removeAll();
        if (imageResourceInfo != null) {
            JSplitPane jSplitPane = this.splits.get(this.currentEditable);
            if (jSplitPane == null) {
                jSplitPane = new JSplitPane(0, false);
                jSplitPane.setDividerLocation(400);
                jSplitPane.setResizeWeight(1.0);
                jSplitPane.setOneTouchExpandable(false);
                jSplitPane.setDividerSize(5);
                jSplitPane.setTopComponent(jComponent);
                ResourceImageEditor resourceImageEditor = new ResourceImageEditor();
                resourceImageEditor.setImageResourceInfo(imageResourceInfo);
                jSplitPane.setBottomComponent(resourceImageEditor);
                jSplitPane.setOneTouchExpandable(false);
                jSplitPane.setDividerSize(5);
                this.splits.put(this.currentEditable, jSplitPane);
            }
            this.mainEditorPanel.add(jSplitPane);
        } else {
            this.mainEditorPanel.add(jComponent);
        }
        this.mainEditorPanel.repaint();
        this.mainEditorPanel.validate();
        this.fireEditingChanged(this.currentEditable);
    }

    private void fireEditingChanged(Editable editable) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != EditorManagerListener.class) continue;
            ((EditorManagerListener)objectArray[i + 1]).editing(editable);
        }
    }

    public void requestPreview(Previewable previewable) {
        JComponent jComponent = previewable.getPreview();
        if (jComponent != null) {
            return;
        }
    }

    public void closeEditor(Editable editable) {
        if (this.currentEditable == editable) {
            SwingUtilities.invokeLater(new EditorDisposer());
        }
    }

    public static void center(JFrame jFrame) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point point = graphicsEnvironment.getCenterPoint();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        int n = Math.min(jFrame.getWidth(), rectangle.width);
        int n2 = Math.min(jFrame.getHeight(), rectangle.height);
        int n3 = point.x - n / 2;
        int n4 = point.y - n2 / 2;
        jFrame.setBounds(n3, n4, n, n2);
        if (n == rectangle.width && n2 == rectangle.height) {
            jFrame.setExtendedState(6);
        }
        jFrame.validate();
    }

    public JComponent getRootComponent() {
        return this.rootPanel;
    }

    @Override
    public void addEditorManagerListener(EditorManagerListener editorManagerListener) {
        this.listenerList.add(EditorManagerListener.class, editorManagerListener);
    }

    @Override
    public void removeEditorManagerListener(EditorManagerListener editorManagerListener) {
        this.listenerList.remove(EditorManagerListener.class, editorManagerListener);
    }

    public Editable getCurrentEditable() {
        return this.currentEditable;
    }

    private class EditorDisposer
    implements Runnable {
        private EditorDisposer() {
        }

        @Override
        public void run() {
            MainView.this.currentEditable = null;
            MainView.this.mainEditorPanel.removeAll();
            MainView.this.mainEditorPanel.repaint();
            MainView.this.mainEditorPanel.validate();
        }
    }
}

