/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.xref.impl;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.xref.impl.ObjectReferenceImpl;
import org.openide.util.CharSequences;

public class ReferenceSupportImpl {
    public CsmReference createObjectReference(CsmOffsetable obj) {
        return this.createObjectReference((CsmObject)obj, obj);
    }

    public CsmReference createObjectReference(CsmObject target, CsmOffsetable owner) {
        int start = this.getStartRefenceOffset(owner);
        int end = this.getEndReferenceOffset(owner);
        CsmUID<CsmObject> targetUID = target != null ? this.getUID(target) : null;
        CsmUID<CsmOffsetable> ownerUID = this.getUID(owner);
        CsmUID<CsmFile> fileUID = this.getUID(owner.getContainingFile());
        CsmReferenceKind kind = this.getObjectKind(target, (CsmObject)owner);
        return new ObjectReferenceImpl(targetUID, ownerUID, fileUID, kind, start, end);
    }

    private CsmReferenceKind getObjectKind(CsmObject target, CsmObject owner) {
        CsmReferenceKind kind = CsmReferenceKind.UNKNOWN;
        if (target == null && CsmKindUtilities.isInclude((CsmObject)owner)) {
            kind = CsmReferenceKind.DIRECT_USAGE;
        } else if (CsmKindUtilities.isFile((CsmObject)target)) {
            kind = CsmReferenceKind.DIRECT_USAGE;
        } else if (target != null) {
            if (owner != null && !owner.equals(target)) {
                CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)target, (boolean)true);
                CsmObject targetDecl = decDef[0];
                CsmObject targetDef = decDef[1];
                kind = CsmReferenceKind.DIRECT_USAGE;
                if (owner.equals(targetDef)) {
                    kind = CsmReferenceKind.DEFINITION;
                } else if (this.sameDeclaration(owner, targetDecl)) {
                    kind = CsmReferenceKind.DECLARATION;
                }
            } else {
                kind = CsmReferenceKind.DECLARATION;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)target) || CsmKindUtilities.isVariableDefinition((CsmObject)target)) {
                    kind = CsmReferenceKind.DEFINITION;
                }
            }
        }
        return kind;
    }

    private int getStartRefenceOffset(CsmOffsetable obj) {
        return obj.getStartOffset();
    }

    private int getEndReferenceOffset(CsmOffsetable obj) {
        int end = obj.getEndOffset();
        if (CsmKindUtilities.isClass((CsmObject)obj)) {
            end = ((CsmClass)obj).getLeftBracketOffset();
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)obj) && ((CsmFunctionDefinition)obj).getBody() != null) {
            end = ((CsmFunctionDefinition)obj).getBody().getStartOffset();
        }
        return end;
    }

    public <T extends CsmObject> CsmUID<T> getUID(T element) {
        return UIDs.get(element);
    }

    private boolean sameDeclaration(CsmObject checkDecl, CsmObject targetDecl) {
        if (checkDecl.equals(targetDecl)) {
            return true;
        }
        if (CsmKindUtilities.isQualified((CsmObject)checkDecl) && CsmKindUtilities.isQualified((CsmObject)targetDecl)) {
            CharSequence fqnTarget;
            CharSequence fqnCheck = ((CsmQualifiedNamedElement)checkDecl).getQualifiedName();
            if (fqnCheck.equals(fqnTarget = ((CsmQualifiedNamedElement)targetDecl).getQualifiedName())) {
                return true;
            }
            String strFqn = ((Object)fqnCheck).toString().trim();
            if (strFqn.endsWith("const")) {
                int cutConstInd = strFqn.lastIndexOf("const");
                assert (cutConstInd >= 0);
                fqnCheck = CharSequences.create((CharSequence)strFqn.substring(cutConstInd));
            }
            return fqnCheck.equals(fqnTarget);
        }
        return false;
    }
}

