/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.screen.display;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Map;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;

public class ScreenFileObjectListener
implements FileChangeListener {
    private WeakReference<DesignComponent> component;
    private WeakReference<DesignComponent> imageComponent;
    private String propertyName;

    public ScreenFileObjectListener(DesignComponent designComponent, DesignComponent designComponent2, String string) {
        assert (designComponent != null);
        assert (designComponent2 != null);
        this.component = new WeakReference<DesignComponent>(designComponent);
        this.imageComponent = new WeakReference<DesignComponent>(designComponent2);
        this.propertyName = string;
    }

    public void fileFolderCreated(FileEvent fileEvent) {
    }

    public void fileDataCreated(FileEvent fileEvent) {
    }

    public void fileChanged(FileEvent fileEvent) {
        this.changeResourcePath(fileEvent.getFile());
        this.reload();
    }

    public void fileDeleted(FileEvent fileEvent) {
        this.changeResourcePath(fileEvent.getFile());
        this.reload();
        fileEvent.getFile().removeFileChangeListener((FileChangeListener)this);
    }

    public void fileRenamed(FileRenameEvent fileRenameEvent) {
        this.changeResourcePath(fileRenameEvent.getFile());
        this.reload();
    }

    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
        this.changeResourcePath(fileAttributeEvent.getFile());
        this.reload();
    }

    private ScreenDeviceInfo getScreenDeviceInfo() {
        if (this.component == null || this.component.get() == null) {
            return null;
        }
        DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        if (designDocument == null) {
            return null;
        }
        ScreenDeviceInfoPresenter screenDeviceInfoPresenter = (ScreenDeviceInfoPresenter)designDocument.getRootComponent().getPresenter(ScreenDeviceInfoPresenter.class);
        if (screenDeviceInfoPresenter != null) {
            return screenDeviceInfoPresenter.getScreenDeviceInfo();
        }
        return null;
    }

    private void reload() {
        if (this.component == null || this.component.get() == null) {
            return;
        }
        DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        designDocument.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                ScreenDeviceInfo screenDeviceInfo = ScreenFileObjectListener.this.getScreenDeviceInfo();
                if (screenDeviceInfo != null) {
                    ScreenDisplayPresenter screenDisplayPresenter = (ScreenDisplayPresenter)((DesignComponent)ScreenFileObjectListener.this.component.get()).getPresenter(ScreenDisplayPresenter.class);
                    screenDisplayPresenter.reload(screenDeviceInfo);
                }
            }
        });
    }

    private void changeResourcePath(FileObject fileObject) {
        if (this.component == null || this.component.get() == null || ((DesignComponent)this.component.get()).getDocument() == null) {
            return;
        }
        Map<FileObject, String> map = MidpProjectSupport.getAllFilesForProjectByExt(((DesignComponent)this.component.get()).getDocument(), Arrays.asList(fileObject.getExt()));
        final String string = map.get(fileObject);
        if (this.component == null || this.component.get() == null) {
            return;
        }
        DesignDocument designDocument = ((DesignComponent)this.component.get()).getDocument();
        designDocument.getTransactionManager().writeAccess(new Runnable(){

            @Override
            public void run() {
                if (ScreenFileObjectListener.this.propertyName != null && string != null) {
                    ((DesignComponent)ScreenFileObjectListener.this.imageComponent.get()).writeProperty(ScreenFileObjectListener.this.propertyName, MidpTypes.createStringValue(string));
                } else if (ScreenFileObjectListener.this.propertyName != null) {
                    ((DesignComponent)ScreenFileObjectListener.this.imageComponent.get()).writeProperty(ScreenFileObjectListener.this.propertyName, PropertyValue.createNull());
                }
            }
        });
    }
}

