/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.items.ItemCD;
import org.netbeans.modules.vmd.midp.propertyeditors.PropertyEditorNumber;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorPreferredSize
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final String UNLOCKED_TEXT = NbBundle.getMessage(PropertyEditorPreferredSize.class, (String)"LBL_PREF_SIZE_UNLOCKED_TXT");
    private static final String UNLOCKED_NUM_TEXT = String.valueOf(ItemCD.UNLOCKED_VALUE.getPrimitiveValue());
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private String label;
    private TypeID parentTypeID;

    public static PropertyEditorPreferredSize createInstance(String string, String string2) {
        return new PropertyEditorPreferredSize(string, string2, null);
    }

    public static PropertyEditorPreferredSize createInstance(String string, String string2, TypeID typeID) {
        return new PropertyEditorPreferredSize(string, string2, typeID);
    }

    private PropertyEditorPreferredSize(String string, String string2, TypeID typeID) {
        super(string2);
        this.label = string;
        this.parentTypeID = typeID;
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.initComponents();
            this.initElements(Collections.singleton(this));
        }
        return super.getCustomEditor();
    }

    @Override
    public void cleanUp(DesignComponent designComponent) {
        super.cleanUp(designComponent);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
            this.customEditor = null;
        }
        this.label = null;
        this.radioButton = null;
        this.parentTypeID = null;
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.radioButton.getAccessibleContext().setAccessibleName(this.radioButton.getText());
        this.radioButton.getAccessibleContext().setAccessibleDescription(this.radioButton.getText());
        this.customEditor = new CustomEditor();
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    @Override
    public boolean isInitiallySelected() {
        return true;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        Object object = ((PropertyValue)super.getValue()).getPrimitiveValue();
        Object object2 = ItemCD.UNLOCKED_VALUE.getPrimitiveValue();
        if (object2.equals(object)) {
            return UNLOCKED_TEXT;
        }
        return String.valueOf(object);
    }

    @Override
    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue propertyValue) {
        if (this.isCurrentValueANull() || propertyValue == null) {
            this.customEditor.unsetUnlocked(true);
        } else if (ItemCD.UNLOCKED_VALUE.getPrimitiveValue().equals(propertyValue.getPrimitiveValue())) {
            this.customEditor.setUnlocked(true);
        } else {
            this.customEditor.unsetUnlocked(true);
            this.customEditor.setText(String.valueOf(propertyValue.getPrimitiveValue()));
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        if (string.length() > 0) {
            if (UNLOCKED_TEXT.equals(string) || UNLOCKED_NUM_TEXT.equals(string)) {
                super.setValue((Object)ItemCD.UNLOCKED_VALUE);
                return;
            }
            int n = 0;
            try {
                string = string.replaceAll("[^0-9\\-]+", "");
                n = Integer.parseInt(string) <= 0 ? 0 : Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            super.setValue((Object)MidpTypes.createIntegerValue(n));
        }
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    @Override
    public Boolean canEditAsText() {
        if (!this.isCurrentValueAUserCodeType()) {
            PropertyValue propertyValue = (PropertyValue)super.getValue();
            if (propertyValue == null) {
                return false;
            }
            Object object = ItemCD.UNLOCKED_VALUE.getPrimitiveValue();
            return !object.equals(propertyValue.getPrimitiveValue());
        }
        return false;
    }

    @Override
    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            final DesignComponent[] designComponentArray = new DesignComponent[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    designComponentArray[0] = designComponent.getParentComponent();
                }
            });
            if (designComponentArray[0] != null && this.parentTypeID.equals((Object)designComponentArray[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener,
    FocusListener {
        private JTextField textField;
        private JCheckBox unlockedCheckBox;

        public CustomEditor() {
            PropertyEditorPreferredSize.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        void cleanUp() {
            if (this.textField != null && this.textField.getDocument() != null) {
                this.textField.getDocument().removeDocumentListener(this);
            }
            this.textField = null;
            this.unlockedCheckBox.removeActionListener(this);
            this.unlockedCheckBox = null;
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.unlockedCheckBox = new JCheckBox();
            this.unlockedCheckBox.addActionListener(this);
            this.unlockedCheckBox.addFocusListener(this);
            Mnemonics.setLocalizedText((AbstractButton)this.unlockedCheckBox, (String)NbBundle.getMessage(PropertyEditorPreferredSize.class, (String)"LBL_PREF_SIZE_UNLOCKED"));
            this.unlockedCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorPreferredSize.class, (String)"ACSN_PREF_SIZE_UNLOCKED"));
            this.unlockedCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorPreferredSize.class, (String)"ACSD_PREF_SIZE_UNLOCKED"));
            this.add((Component)this.unlockedCheckBox, "North");
            this.textField = new JTextField();
            this.textField.getAccessibleContext().setAccessibleName(PropertyEditorPreferredSize.this.radioButton.getAccessibleContext().getAccessibleName());
            this.textField.getAccessibleContext().setAccessibleDescription(PropertyEditorPreferredSize.this.radioButton.getAccessibleContext().getAccessibleDescription());
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.add((Component)this.textField, "South");
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void setUnlocked(boolean bl) {
            this.setText(UNLOCKED_NUM_TEXT);
            this.textField.setEditable(false);
            if (bl) {
                this.unlockedCheckBox.setSelected(true);
            }
        }

        public void unsetUnlocked(boolean bl) {
            this.setText(null);
            this.textField.setEditable(true);
            if (bl) {
                this.unlockedCheckBox.setSelected(false);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.unlockedCheckBox.isSelected()) {
                this.setUnlocked(false);
                PropertyEditorPreferredSize.this.clearErrorStatus();
            } else {
                this.unsetUnlocked(false);
                this.checkNumberStatus();
            }
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorPreferredSize.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorPreferredSize.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void checkNumberStatus() {
            if (!PropertyEditorPreferredSize.this.radioButton.isSelected()) {
                PropertyEditorPreferredSize.this.clearErrorStatus();
                return;
            }
            if (!Pattern.matches("[\\d\\-]+", this.textField.getText())) {
                PropertyEditorPreferredSize.this.displayWarning(PropertyEditorNumber.NON_DIGITS_TEXT);
            } else {
                PropertyEditorPreferredSize.this.clearErrorStatus();
            }
            try {
                int n = Integer.valueOf(this.textField.getText());
                if (n < 0 && !this.unlockedCheckBox.isSelected()) {
                    PropertyEditorPreferredSize.this.displayWarning(NbBundle.getMessage(PropertyEditorPreferredSize.class, (String)"MSG_POSITIVE_CHARS"));
                } else {
                    PropertyEditorPreferredSize.this.clearErrorStatus();
                }
            }
            catch (NumberFormatException numberFormatException) {
                PropertyEditorPreferredSize.this.displayWarning(PropertyEditorNumber.NON_DIGITS_TEXT);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == this.textField || focusEvent.getSource() == this.unlockedCheckBox) {
                PropertyEditorPreferredSize.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
            if (focusEvent.getSource() == PropertyEditorPreferredSize.this.radioButton) {
                this.checkNumberStatus();
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            PropertyEditorPreferredSize.this.clearErrorStatus();
        }
    }
}

