/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.BooleanInplaceEditor;
import org.netbeans.modules.vmd.midp.propertyeditors.MidpPropertyEditorSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.util.NbBundle;

public class PropertyEditorBooleanUC
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private static final PropertyValue TRUE_VALUE = MidpTypes.createBooleanValue(true);
    private static final PropertyValue FALSE_VALUE = MidpTypes.createBooleanValue(false);
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private BooleanInplaceEditor inplaceEditor;
    private boolean supportsCustomEditor;
    private TypeID parentTypeID;
    private String rbLabel;

    private PropertyEditorBooleanUC(boolean supportsCustomEditor, TypeID parentTypeID, String rbLabel) {
        super(NbBundle.getMessage(PropertyEditorBooleanUC.class, (String)"LBL_VALUE_BOOLEAN_UCLABEL"));
        this.supportsCustomEditor = supportsCustomEditor;
        this.parentTypeID = parentTypeID;
        this.rbLabel = rbLabel;
    }

    public static PropertyEditorBooleanUC createInstance() {
        return new PropertyEditorBooleanUC(false, null, null);
    }

    public static PropertyEditorBooleanUC createInstance(String rbLabel) {
        return new PropertyEditorBooleanUC(true, null, rbLabel);
    }

    public static PropertyEditorBooleanUC createInstance(TypeID parentTypeID, String rbLabel) {
        return new PropertyEditorBooleanUC(true, parentTypeID, rbLabel);
    }

    @Override
    public void cleanUp(DesignComponent component) {
        super.cleanUp(component);
        if (this.customEditor != null) {
            this.customEditor.cleanUp();
        }
        this.customEditor = null;
        this.radioButton = null;
        if (this.inplaceEditor != null) {
            this.inplaceEditor.cleanUp();
        }
        this.parentTypeID = null;
    }

    public InplaceEditor getInplaceEditor() {
        if (this.inplaceEditor == null) {
            this.inplaceEditor = new BooleanInplaceEditor(this);
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            Boolean value = (Boolean)propertyValue.getPrimitiveValue();
            JCheckBox checkBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (value != null) {
                checkBox.setSelected(value);
            }
            checkBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JCheckBox checkBox = (JCheckBox)PropertyEditorBooleanUC.this.inplaceEditor.getComponent();
                    boolean currentState = checkBox.isSelected();
                    PropertyEditorBooleanUC.this.setValue(MidpTypes.createBooleanValue(currentState));
                    PropertyEditorBooleanUC.this.invokeSaveToModel();
                }
            });
        } else {
            PropertyValue propertyValue = (PropertyValue)this.getValue();
            Boolean value = (Boolean)propertyValue.getPrimitiveValue();
            JCheckBox checkBox = (JCheckBox)this.inplaceEditor.getComponent();
            if (value != null && !value.booleanValue()) {
                checkBox.setSelected(false);
            } else if (value != null && value.booleanValue()) {
                checkBox.setSelected(true);
            } else {
                return super.getInplaceEditor();
            }
        }
        return this.inplaceEditor;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        JComponent _component = this.inplaceEditor.getComponent();
        _component.setSize(box.width, box.height);
        _component.doLayout();
        _component.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        Graphics g = gfx.create(box.x, box.y, box.width, box.height);
        _component.setOpaque(false);
        _component.paint(g);
        g.dispose();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return this.supportsCustomEditor ? super.supportsCustomEditor() : false;
    }

    @Override
    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    @Override
    public JRadioButton getRadioButton() {
        if (this.radioButton == null) {
            this.radioButton = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)NbBundle.getMessage(PropertyEditorBooleanUC.class, (String)"LBL_VALUE_BOOLEAN"));
            this.radioButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PropertyEditorBooleanUC.class, (String)"ACSN_VALUE_BOOLEAN"));
            this.radioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PropertyEditorBooleanUC.class, (String)"ACSD_VALUE_BOOLEAN"));
        }
        return this.radioButton;
    }

    public boolean isPaintable() {
        PropertyValue propertyValue = (PropertyValue)this.getValue();
        return propertyValue.getKind() == PropertyValue.Kind.VALUE;
    }

    @Override
    public boolean isVerticallyResizable() {
        return false;
    }

    @Override
    public boolean isInitiallySelected() {
        return false;
    }

    @Override
    public String getAsText() {
        if (this.isCurrentValueAUserCodeType()) {
            return USER_CODE_TEXT;
        }
        if (this.isCurrentValueANull()) {
            return "false";
        }
        return MidpTypes.getBoolean((PropertyValue)super.getValue()) ? "true" : "false";
    }

    @Override
    public void setTextForPropertyValue(String text) {
        this.saveValue(text);
    }

    @Override
    public String getTextForPropertyValue() {
        return null;
    }

    @Override
    public void updateState(PropertyValue value) {
        this.customEditor.setValue(value);
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String text) {
        super.setValue((Object)("false".equals(text) ? FALSE_VALUE : TRUE_VALUE));
    }

    @Override
    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
            if ("true".equals(this.customEditor.getText())) {
                this.updateInplaceEditorComponent(true);
            } else {
                this.updateInplaceEditorComponent(false);
            }
        }
    }

    @Override
    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return MidpPropertyEditorSupport.singleSelectionEditAsTextOnly();
    }

    public Object getDefaultValue() {
        PropertyValue value = (PropertyValue)super.getDefaultValue();
        if (value.getKind() == PropertyValue.Kind.VALUE && value.getPrimitiveValue() instanceof Boolean) {
            this.updateInplaceEditorComponent((Boolean)value.getPrimitiveValue());
        }
        return super.getDefaultValue();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent _component = (DesignComponent)this.component.get();
            final DesignComponent[] parent = new DesignComponent[1];
            _component.getDocument().getTransactionManager().readAccess(new Runnable(){

                @Override
                public void run() {
                    parent[0] = _component.getParentComponent();
                }
            });
            if (parent[0] != null && this.parentTypeID.equals((Object)parent[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private void updateInplaceEditorComponent(boolean selected) {
        JCheckBox ic = (JCheckBox)this.inplaceEditor.getComponent();
        ic.setSelected(selected);
    }

    @Override
    public Component getCustomEditor() {
        if (this.customEditor == null) {
            this.customEditor = new CustomEditor();
            this.initElements(Collections.singleton(this));
            super.getCustomEditor();
        }
        if (this.getValue() instanceof PropertyValue) {
            this.customEditor.setValue((PropertyValue)this.getValue());
        }
        return super.getCustomEditor();
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener {
        private JCheckBox checkBox;

        public CustomEditor() {
            this.initComponents();
        }

        void cleanUp() {
            if (this.checkBox != null) {
                this.checkBox.removeActionListener(this);
                this.checkBox = null;
            }
            this.removeAll();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.checkBox = new JCheckBox();
            if (PropertyEditorBooleanUC.this.rbLabel != null) {
                Mnemonics.setLocalizedText((AbstractButton)this.checkBox, (String)PropertyEditorBooleanUC.this.rbLabel);
                this.checkBox.getAccessibleContext().setAccessibleName(this.checkBox.getText());
                this.checkBox.getAccessibleContext().setAccessibleDescription(this.checkBox.getText());
            }
            this.checkBox.addActionListener(this);
            this.add((Component)this.checkBox, "Center");
        }

        public void setValue(PropertyValue value) {
            this.checkBox.setSelected(value != null && value.getPrimitiveValue() != null && MidpTypes.getBoolean(value));
        }

        public String getText() {
            return this.checkBox.isSelected() ? "true" : "false";
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            PropertyEditorBooleanUC.this.radioButton.setSelected(true);
        }
    }
}

