/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.palette.wizard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.ComponentDescriptor;
import org.netbeans.modules.vmd.api.model.ComponentSerializationSupport;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.PaletteDescriptor;
import org.netbeans.modules.vmd.api.model.PresenterSerializer;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.TypeDescriptor;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpProjectSupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.general.ClassCD;
import org.netbeans.modules.vmd.midp.serialization.MidpAddImportPresenterSerializer;
import org.netbeans.modules.vmd.midp.serialization.MidpPropertyPresenterSerializer;
import org.netbeans.modules.vmd.midp.serialization.MidpSetterPresenterSerializer;
import org.netbeans.modules.vmd.midp.serialization.MidpTypesConvertor;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class ComponentInstaller {
    public static void install(final Map<String, Item> map, final List<Item> list) {
        ComponentSerializationSupport.runUnderDescriptorRegistryWriteAccess((String)"vmd-midp", (Runnable)new Runnable(){

            @Override
            public void run() {
                ComponentInstaller.installCore(map, list);
            }
        });
        ComponentSerializationSupport.refreshDescriptorRegistry((String)"vmd-midp");
    }

    private static void installCore(Map<String, Item> map, List<Item> list) {
        HashMap<String, Item> hashMap = new HashMap<String, Item>();
        for (Item item : list) {
            ComponentInstaller.recursiveAdd(hashMap, map, item);
        }
        for (Item item : hashMap.values()) {
            ComponentSerializationSupport.serialize((String)"vmd-midp", (TypeDescriptor)item.getTypeDescriptor(), (PaletteDescriptor)item.getPaletteDescriptor(), item.getProperties(), item.getPresenters());
        }
    }

    private static void recursiveAdd(HashMap<String, Item> hashMap, Map<String, Item> map, Item item) {
        if (item == null) {
            return;
        }
        if (hashMap.containsKey(item.getFQN())) {
            return;
        }
        hashMap.put(item.getFQN(), item);
        ComponentInstaller.recursiveAdd(hashMap, map, map.get(item.getSuperFQN()));
    }

    public static Map<String, Item> search(final Project project) {
        final Object[] objectArray = new Object[1];
        ComponentSerializationSupport.runUnderDescriptorRegistryReadAccess((String)"vmd-midp", (Runnable)new Runnable(){

            @Override
            public void run() {
                objectArray[0] = ComponentInstaller.searchCore(project);
            }
        });
        return (Map)objectArray[0];
    }

    public static Map<String, Item> searchCore(Project project) {
        final ClasspathInfo classpathInfo = MidpProjectSupport.getClasspathInfo(project);
        if (classpathInfo == null) {
            return Collections.emptyMap();
        }
        final SourceGroup sourceGroup = MidpProjectSupport.getSourceGroup(project);
        final Set set = classpathInfo.getClassIndex().getDeclaredTypes("", ClassIndex.NameKind.PREFIX, EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        final Map<String, ComponentDescriptor> map = ComponentInstaller.resolveRegistryMap(project);
        final HashMap<String, Item> hashMap = new HashMap<String, Item>();
        try {
            JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])new FileObject[0]).runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    Object object;
                    HashSet<TypeElement> hashSet = new HashSet<TypeElement>();
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object = (ElementHandle)iterator.next();
                        TypeElement typeElement = (TypeElement)object.resolve((CompilationInfo)compilationController);
                        if (typeElement == null || typeElement.getKind() != ElementKind.CLASS) continue;
                        hashSet.add(typeElement);
                    }
                    while ((iterator = hashSet.iterator()).hasNext()) {
                        object = (TypeElement)iterator.next();
                        ComponentInstaller.search((TypeElement)object, hashSet, map, classpathInfo, sourceGroup, hashMap);
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return hashMap;
    }

    private static Map<String, ComponentDescriptor> resolveRegistryMap(Project project) {
        final DescriptorRegistry descriptorRegistry = DescriptorRegistry.getDescriptorRegistry((String)"vmd-midp", (String)ProjectUtils.getProjectID((Project)project));
        final HashMap<String, ComponentDescriptor> hashMap = new HashMap<String, ComponentDescriptor>();
        descriptorRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                for (ComponentDescriptor componentDescriptor : descriptorRegistry.getComponentDescriptors()) {
                    TypeID typeID = componentDescriptor.getTypeDescriptor().getThisType();
                    String string = typeID.getString();
                    if (!ComponentInstaller.checkForJavaIdentifierCompliant(string) || !descriptorRegistry.isInHierarchy(ClassCD.TYPEID, typeID) || ClassCD.TYPEID.equals((Object)typeID)) continue;
                    hashMap.put(string, componentDescriptor);
                }
            }
        });
        return hashMap;
    }

    private static boolean search(TypeElement typeElement, Set<TypeElement> set, Map<String, ComponentDescriptor> map, ClasspathInfo classpathInfo, SourceGroup sourceGroup, Map<String, Item> map2) {
        if (typeElement == null) {
            return false;
        }
        set.remove(typeElement);
        if (typeElement.getKind() != ElementKind.CLASS) {
            return false;
        }
        Name name = typeElement.getQualifiedName();
        if (name == null) {
            return false;
        }
        String string = name.toString();
        ComponentDescriptor componentDescriptor = map.get(string);
        if (componentDescriptor != null) {
            return true;
        }
        Item item = map2.get(string);
        if (item != null) {
            return true;
        }
        TypeElement typeElement2 = ComponentInstaller.getSuperElement(typeElement);
        if (typeElement2 == null) {
            return false;
        }
        if (!ComponentInstaller.search(typeElement2, set, map, classpathInfo, sourceGroup, map2)) {
            return false;
        }
        String string2 = typeElement2.getQualifiedName().toString();
        if (!map.containsKey(string2) && !map2.containsKey(string2)) {
            return false;
        }
        boolean bl = typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean bl2 = typeElement.getModifiers().contains((Object)Modifier.FINAL);
        FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)typeElement), (ClasspathInfo)classpathInfo);
        boolean bl3 = fileObject != null && sourceGroup != null && FileUtil.isParentOf((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
        item = new Item(string2, string, bl, bl2, bl3);
        item.addPresenter(new MidpAddImportPresenterSerializer());
        ComponentInstaller.inspectElement(item, typeElement);
        map2.put(string, item);
        return true;
    }

    private static boolean inspectElement(Item item, TypeElement typeElement) {
        String string = typeElement.getQualifiedName().toString();
        boolean bl = false;
        int n = 1;
        for (Element element : typeElement.getEnclosedElements()) {
            String string2;
            PropertyDescriptor propertyDescriptor;
            Object object;
            ExecutableElement executableElement;
            if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            if (element.getKind() == ElementKind.CONSTRUCTOR) {
                executableElement = (ExecutableElement)element;
                object = new ArrayList();
                int n2 = 1;
                for (VariableElement variableElement : executableElement.getParameters()) {
                    propertyDescriptor = MidpTypesConvertor.createPropertyDescriptorForParameter(string + "#" + n + "#" + n2, true, variableElement);
                    item.addProperty(propertyDescriptor);
                    ((ArrayList)object).add(propertyDescriptor.getName());
                    string2 = NbBundle.getMessage(ComponentInstaller.class, (String)"NAME_ConstructorParam", (Object[])new Object[]{variableElement.getSimpleName(), n, n2, string});
                    item.addPresenter(new MidpPropertyPresenterSerializer(string2, propertyDescriptor));
                    ++n2;
                }
                item.addPresenter(new MidpSetterPresenterSerializer(null, (List<String>)object));
                continue;
            }
            if (element.getKind() != ElementKind.METHOD || !((String)(object = (executableElement = (ExecutableElement)element).getSimpleName().toString())).startsWith("set") || ((String)object).length() < 4 || !Character.isUpperCase(((String)object).charAt(3))) continue;
            ArrayList<String> arrayList = new ArrayList<String>();
            List<? extends VariableElement> list = executableElement.getParameters();
            if (list.size() != 1) continue;
            VariableElement variableElement = (VariableElement)list.iterator().next();
            propertyDescriptor = MidpTypesConvertor.createPropertyDescriptorForParameter(string + "#" + (String)object, false, variableElement);
            item.addProperty(propertyDescriptor);
            arrayList.add(propertyDescriptor.getName());
            string2 = NbBundle.getMessage(ComponentInstaller.class, (String)"NAME_SetterParam", (Object)variableElement.getSimpleName(), (Object)object, (Object)string);
            item.addPresenter(new MidpPropertyPresenterSerializer(string2, propertyDescriptor));
            item.addPresenter(new MidpSetterPresenterSerializer((String)object, arrayList));
        }
        return bl;
    }

    private static TypeElement getSuperElement(TypeElement typeElement) {
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() != TypeKind.DECLARED) {
            return null;
        }
        return (TypeElement)((DeclaredType)typeMirror).asElement();
    }

    private static boolean checkForJavaIdentifierCompliant(String string) {
        if (string == null || string.length() < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        boolean bl = false;
        for (int i = 1; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isJavaIdentifierPart(c)) {
                bl = false;
                continue;
            }
            if (c != '.') {
                return false;
            }
            if (bl) {
                return false;
            }
            bl = true;
        }
        return !bl;
    }

    public static class Item {
        private TypeDescriptor typeDescriptor;
        private PaletteDescriptor paletteDescriptor;
        private String superFQN;
        private String fqn;
        private boolean inSource;
        private ArrayList<PropertyDescriptor> properties = new ArrayList();
        private ArrayList<PresenterSerializer> presenters = new ArrayList();

        public Item(String string, String string2, boolean bl, boolean bl2, boolean bl3) {
            this.superFQN = string;
            this.fqn = string2;
            this.inSource = bl3;
            TypeID typeID = new TypeID(TypeID.Kind.COMPONENT, string2);
            this.typeDescriptor = new TypeDescriptor(new TypeID(TypeID.Kind.COMPONENT, string), typeID, !bl, !bl2);
            this.paletteDescriptor = new PaletteDescriptor("custom", MidpTypes.getSimpleClassName(typeID), string2, "org/netbeans/modules/vmd/midp/resources/components/custom_component_16.png", "org/netbeans/modules/vmd/midp/resources/components/custom_component_32.png");
        }

        public String getSuperFQN() {
            return this.superFQN;
        }

        public String getFQN() {
            return this.fqn;
        }

        public boolean isInSource() {
            return this.inSource;
        }

        public TypeDescriptor getTypeDescriptor() {
            return this.typeDescriptor;
        }

        public PaletteDescriptor getPaletteDescriptor() {
            return this.paletteDescriptor;
        }

        public List<PropertyDescriptor> getProperties() {
            return this.properties;
        }

        public List<PresenterSerializer> getPresenters() {
            return this.presenters;
        }

        public void addPresenter(PresenterSerializer presenterSerializer) {
            this.presenters.add(presenterSerializer);
        }

        public void addProperty(PropertyDescriptor propertyDescriptor) {
            this.properties.add(propertyDescriptor);
        }
    }
}

