/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.PropertyValueSupport;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.api.model.common.DocumentSupport;
import org.netbeans.modules.vmd.midp.components.MidpArraySupport;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.categories.CommandsCategoryCD;
import org.netbeans.modules.vmd.midp.components.categories.ControllersCategoryCD;
import org.netbeans.modules.vmd.midp.components.commands.CommandCD;
import org.netbeans.modules.vmd.midp.components.handlers.EventHandlerCD;
import org.netbeans.modules.vmd.midp.components.sources.CommandEventSourceCD;
import org.netbeans.modules.vmd.midp.components.sources.ItemCommandEventSourceCD;
import org.netbeans.modules.vmd.midp.general.AbstractEventHandlerCreatorPresenter;

public final class MidpDocumentSupport {
    public static final String PROJECT_TYPE_MIDP = "vmd-midp";
    public static final Comparator<DesignComponent> COMPONENT_DISPLAY_NAME_COMPARATOR = new Comparator<DesignComponent>(){

        @Override
        public int compare(DesignComponent designComponent, DesignComponent designComponent2) {
            String string = (String)designComponent.readProperty("instanceName").getPrimitiveValue();
            String string2 = (String)designComponent2.readProperty("instanceName").getPrimitiveValue();
            if (string == null) {
                return -1;
            }
            if (string2 == null) {
                return 1;
            }
            return string.compareTo(string2);
        }
    };

    public static DesignComponent getCategoryComponent(DesignDocument designDocument, TypeID typeID) {
        List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)designDocument.getRootComponent(), (TypeID)typeID);
        if (list.size() == 0 && designDocument.getTransactionManager().isWriteAccess()) {
            DesignComponent designComponent = designDocument.createComponent(typeID);
            designDocument.getRootComponent().addComponent(designComponent);
            return designComponent;
        }
        assert (list.size() == 1);
        return (DesignComponent)list.get(0);
    }

    public static DesignComponent getSingletonCommand(DesignDocument designDocument, TypeID typeID) {
        DesignComponent designComponent = MidpDocumentSupport.getCategoryComponent(designDocument, CommandsCategoryCD.TYPEID);
        assert (designComponent != null);
        List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)designComponent, (TypeID)typeID);
        if (list.size() == 1) {
            return (DesignComponent)list.get(0);
        }
        if (list.size() == 0) {
            DesignComponent designComponent2 = designDocument.createComponent(typeID);
            designComponent.addComponent(designComponent2);
            return designComponent2;
        }
        throw new IllegalStateException("Component " + typeID + " should be singelton per document");
    }

    public static DesignComponent attachCommandToDisplayable(DesignComponent designComponent, DesignComponent designComponent2) {
        DesignComponent designComponent3 = designComponent.getDocument().createComponent(CommandEventSourceCD.TYPEID);
        MidpDocumentSupport.addEventSource(designComponent, "commands", designComponent3);
        designComponent3.writeProperty("displayable", PropertyValue.createComponentReference((DesignComponent)designComponent));
        designComponent3.writeProperty("command", PropertyValue.createComponentReference((DesignComponent)designComponent2));
        return designComponent3;
    }

    public static DesignComponent attachCommandToItem(DesignComponent designComponent, DesignComponent designComponent2) {
        DesignComponent designComponent3 = designComponent2.getDocument().createComponent(ItemCommandEventSourceCD.TYPEID);
        designComponent3.writeProperty("command", PropertyValue.createComponentReference((DesignComponent)designComponent2));
        designComponent3.writeProperty("item", PropertyValue.createComponentReference((DesignComponent)designComponent));
        MidpArraySupport.append(designComponent, "commands", designComponent3);
        designComponent.addComponent(designComponent3);
        return designComponent3;
    }

    public static void addEventSource(DesignComponent designComponent, String string, DesignComponent designComponent2) {
        designComponent.addComponent(designComponent2);
        PropertyValue propertyValue = designComponent.readProperty(string);
        propertyValue = PropertyValueSupport.addArrayValue((PropertyValue)propertyValue, (PropertyValue)PropertyValue.createComponentReference((DesignComponent)designComponent2));
        designComponent.writeProperty(string, propertyValue);
    }

    public static boolean isCreatableEventHandlerTo(DesignComponent designComponent) {
        return designComponent == null || designComponent.getPresenter(AbstractEventHandlerCreatorPresenter.class) != null;
    }

    public static DesignComponent updateEventHandlerFromTarget(DesignComponent designComponent, DesignComponent designComponent2) {
        assert (designComponent2 == null || !designComponent2.getDocument().getDescriptorRegistry().isInHierarchy(EventHandlerCD.TYPEID, designComponent2.getType()));
        DesignComponent designComponent3 = designComponent.readProperty("eventHandler").getComponent();
        AbstractEventHandlerCreatorPresenter abstractEventHandlerCreatorPresenter = designComponent2 != null ? (AbstractEventHandlerCreatorPresenter)designComponent2.getPresenter(AbstractEventHandlerCreatorPresenter.class) : null;
        DesignComponent designComponent4 = abstractEventHandlerCreatorPresenter != null ? abstractEventHandlerCreatorPresenter.createReuseEventHandler(designComponent, designComponent3, designComponent2) : null;
        return MidpDocumentSupport.updateEventHandlerWithNew(designComponent, designComponent4);
    }

    public static DesignComponent updateEventHandlerWithNew(DesignComponent designComponent, DesignComponent designComponent2) {
        assert (designComponent2 == null || designComponent2.getDocument().getDescriptorRegistry().isInHierarchy(EventHandlerCD.TYPEID, designComponent2.getType()));
        DesignComponent designComponent3 = designComponent.readProperty("eventHandler").getComponent();
        if (designComponent3 == designComponent2) {
            return designComponent3;
        }
        if (designComponent3 != null) {
            designComponent3.writeProperty("eventSource", PropertyValue.createNull());
            designComponent3.removeFromParentComponent();
        }
        if (designComponent2 != null) {
            designComponent.addComponent(designComponent2);
            designComponent.writeProperty("eventHandler", PropertyValue.createComponentReference((DesignComponent)designComponent2));
            designComponent2.writeProperty("eventSource", PropertyValue.createComponentReference((DesignComponent)designComponent));
        } else {
            designComponent.writeProperty("eventHandler", PropertyValue.createNull());
        }
        return designComponent2;
    }

    public static void updateEventHandlerWithAlert(DesignComponent designComponent, DesignComponent designComponent2) {
        if (designComponent2 != null) {
            designComponent.writeProperty("alert", PropertyValue.createComponentReference((DesignComponent)designComponent2));
        } else {
            designComponent.writeProperty("alert", PropertyValue.createNull());
        }
    }

    public static void updateSwitchDisplayableEventHandler(DesignComponent designComponent, DesignComponent designComponent2, DesignComponent designComponent3) {
        designComponent.writeProperty("displayable", PropertyValue.createComponentReference((DesignComponent)designComponent3));
        MidpDocumentSupport.updateEventHandlerWithAlert(designComponent, designComponent2);
    }

    public static String createDisplayNameFromTypeID(TypeID typeID) {
        String string = typeID.getString();
        int n = string.lastIndexOf(46);
        return n >= 0 ? string.substring(n + 1) : string;
    }

    public static Collection<DesignComponent> getAvailableCommandsForComponent(DesignComponent designComponent) {
        Collection collection = MidpDocumentSupport.getCategoryComponent(designComponent.getDocument(), CommandsCategoryCD.TYPEID).getComponents();
        DescriptorRegistry descriptorRegistry = designComponent.getDocument().getDescriptorRegistry();
        ArrayList<PropertyValue> arrayList = null;
        HashSet<DesignComponent> hashSet = null;
        for (PropertyValue propertyValue : designComponent.readProperty("commands").getArray()) {
            DesignComponent designComponent2 = propertyValue.getComponent();
            if (designComponent2 == null) continue;
            if (hashSet == null) {
                hashSet = new HashSet<DesignComponent>();
            }
            hashSet.add(designComponent2.readProperty("command").getComponent());
        }
        for (PropertyValue propertyValue : collection) {
            if (hashSet != null && hashSet.contains(propertyValue) || !descriptorRegistry.isInHierarchy(CommandCD.TYPEID, propertyValue.getType()) || !((Boolean)propertyValue.readProperty("ordinary").getPrimitiveValue()).booleanValue()) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<PropertyValue>();
            }
            arrayList.add(propertyValue);
        }
        if (arrayList != null) {
            Collections.sort(arrayList, COMPONENT_DISPLAY_NAME_COMPARATOR);
        }
        return arrayList;
    }

    public static DesignComponent getCommandListener(DesignDocument designDocument, TypeID typeID) {
        DesignComponent designComponent = MidpDocumentSupport.getCategoryComponent(designDocument, ControllersCategoryCD.TYPEID);
        List list = DocumentSupport.gatherSubComponentsOfType((DesignComponent)designComponent, (TypeID)typeID);
        if (list.isEmpty()) {
            DesignComponent designComponent2 = designDocument.createComponent(typeID);
            designComponent.addComponent(designComponent2);
            return designComponent2;
        }
        assert (list.size() == 1);
        return (DesignComponent)list.get(0);
    }

    public static int getMidpVersion(DesignDocument designDocument) {
        PropertyValue propertyValue = designDocument.getRootComponent().readProperty("version");
        return propertyValue.getKind() == PropertyValue.Kind.VALUE && "MIDP-2.0".equals(MidpTypes.getString(propertyValue)) ? 2 : 1;
    }
}

