/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.codegen;

import java.util.List;
import org.netbeans.modules.vmd.api.codegen.CodeReferencePresenter;
import org.netbeans.modules.vmd.api.codegen.CodeSupport;
import org.netbeans.modules.vmd.api.codegen.CodeWriter;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;

public class MidpCodeSupport {
    public static void generateCodeForPropertyValue(CodeWriter writer, PropertyValue value) {
        switch (value.getKind()) {
            case ARRAY: {
                int a;
                TypeID type = value.getType();
                int dimension = type.getDimension();
                boolean newLines = dimension > 1;
                List array = value.getArray();
                writer.write("new " + MidpTypes.getOptimalizedFQNClassName(type));
                for (a = 0; a < dimension; ++a) {
                    writer.write("[]");
                }
                writer.write(" {");
                if (array.size() > 0) {
                    writer.write(newLines ? "\n" : " ");
                }
                for (a = 0; a < array.size(); ++a) {
                    if (a > 0) {
                        writer.write(newLines ? ",\n" : ", ");
                    }
                    PropertyValue propertyValue = (PropertyValue)array.get(a);
                    MidpCodeSupport.generateCodeForPropertyValue(writer, propertyValue);
                }
                writer.write(newLines ? "}" : " }");
                break;
            }
            case ENUM: {
                MidpCodeSupport.generateEnumTypes(writer, value);
                break;
            }
            case NULL: {
                writer.write("null");
                break;
            }
            case REFERENCE: {
                writer.write(CodeReferencePresenter.generateAccessCode((DesignComponent)value.getComponent()));
                break;
            }
            case USERCODE: {
                writer.write(value.getUserCode());
                break;
            }
            case VALUE: {
                MidpCodeSupport.generatePrimitiveTypes(writer, value);
                break;
            }
            default: {
                throw Debug.illegalState((Object[])new Object[0]);
            }
        }
    }

    private static void generatePrimitiveTypes(CodeWriter writer, PropertyValue value) {
        TypeID type = value.getType();
        if (MidpTypes.TYPEID_INT.equals((Object)type)) {
            writer.write(value.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_LONG.equals((Object)type)) {
            writer.write(value.getPrimitiveValue().toString() + "l");
        } else if (MidpTypes.TYPEID_CHAR.equals((Object)type)) {
            writer.write(Integer.toString(((Character)value.getPrimitiveValue()).charValue()));
        } else if (MidpTypes.TYPEID_BYTE.equals((Object)type)) {
            writer.write(value.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_SHORT.equals((Object)type)) {
            writer.write(value.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_FLOAT.equals((Object)type)) {
            writer.write(value.getPrimitiveValue().toString() + "f");
        } else if (MidpTypes.TYPEID_DOUBLE.equals((Object)type)) {
            writer.write(value.getPrimitiveValue().toString());
        } else if (MidpTypes.TYPEID_BOOLEAN.equals((Object)type)) {
            writer.write((Boolean)value.getPrimitiveValue() != false ? "true" : "false");
        } else if (MidpTypes.TYPEID_JAVA_LANG_STRING.equals((Object)type)) {
            writer.write("\"" + CodeSupport.encryptStringToJavaCode((String)value.getPrimitiveValue().toString()) + "\"");
        } else if (MidpTypes.TYPEID_JAVA_CODE.equals((Object)type)) {
            writer.write(value.getPrimitiveValue().toString());
        }
    }

    private static void generateEnumTypes(CodeWriter writer, PropertyValue value) {
        TypeID type = value.getType();
        if (MidpTypes.TYPEID_ALERT_TYPE.equals((Object)type)) {
            writer.write("AlertType." + value.getPrimitiveValue().toString());
        }
    }
}

