/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax.completion;

import java.net.URL;
import java.util.List;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspUtils;
import org.netbeans.modules.web.core.syntax.completion.ELFunctions;
import org.netbeans.modules.web.core.syntax.completion.ELImplicitObjects;
import org.netbeans.modules.web.core.syntax.completion.JspELExpression;
import org.netbeans.modules.web.core.syntax.completion.api.ElCompletionItem;
import org.netbeans.modules.web.core.syntax.completion.api.JspCompletionItem;
import org.netbeans.modules.web.core.syntax.spi.ELImplicitObject;
import org.netbeans.modules.web.jsps.parserapi.PageInfo;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.util.Exceptions;

public class ElCompletionProvider
implements CompletionProvider {
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        int offset;
        Document doc = component.getDocument();
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        return this.isAfterElDelimiter((TokenHierarchy<Document>)th, offset = component.getCaretPosition()) || this.checkElCompletionOpen((TokenHierarchy<Document>)th, offset) ? 3 : 0;
    }

    private boolean isAfterElDelimiter(TokenHierarchy<Document> th, int offset) {
        TokenSequence ts = th.tokenSequence();
        if (ts == null) {
            return false;
        }
        int diff = ts.move(offset);
        if (ts.moveNext()) {
            CharSequence image = ts.token().text();
            if (diff == 2 && (image.charAt(0) == '$' || image.charAt(0) == '#') && image.charAt(1) == '{') {
                return true;
            }
        }
        return false;
    }

    private boolean checkElCompletionOpen(TokenHierarchy<Document> th, int offset) {
        List tsl = th.embeddedTokenSequences(offset, true);
        for (TokenSequence ts : tsl) {
            if (ts.language() != ELTokenId.language()) continue;
            ts.move(offset);
            if (!ts.movePrevious() || ts.token().id() != ELTokenId.DOT) break;
            return true;
        }
        return false;
    }

    public CompletionTask createTask(int type, JTextComponent component) {
        if ((type & 1 & 9) != 0) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        if (type == 2) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new DocQuery(null), component);
        }
        return null;
    }

    public static abstract class AbstractQuery
    extends AsyncCompletionQuery {
        protected void query(CompletionResultSet resultSet, Document doc, int caretOffset) {
            this.doQuery(resultSet, doc, caretOffset);
            resultSet.finish();
        }

        abstract void doQuery(CompletionResultSet var1, Document var2, int var3);

        protected void queryEL(CompletionResultSet result, JTextComponent component, int offset) {
            try {
                BaseDocument doc = (BaseDocument)component.getDocument();
                JspSyntaxSupport sup = JspSyntaxSupport.get((Document)doc);
                boolean queryingJsp = JspUtils.isJspDocument((Document)doc);
                JspELExpression elExpr = new JspELExpression(sup, offset);
                int parseType = elExpr.parse();
                int anchor = offset - elExpr.getReplace().length();
                result.setAnchorOffset(anchor);
                switch (parseType) {
                    case 1: {
                        for (ELImplicitObject implOb : ELImplicitObjects.getELImplicitObjects(elExpr.getReplace(), elExpr)) {
                            result.addItem((CompletionItem)ElCompletionItem.createELImplicitObject(implOb.getName(), anchor, implOb.getType()));
                        }
                        if (!queryingJsp) break;
                        PageInfo.BeanData[] beans = sup.getBeanData();
                        if (beans != null) {
                            for (int i = 0; i < beans.length; ++i) {
                                if (!beans[i].getId().startsWith(elExpr.getReplace())) continue;
                                result.addItem((CompletionItem)ElCompletionItem.createELBean(beans[i].getId(), anchor, beans[i].getClassName()));
                            }
                        }
                        List<ELFunctions.Function> functions = ELFunctions.getFunctions(sup, elExpr.getReplace());
                        for (ELFunctions.Function fun : functions) {
                            result.addItem((CompletionItem)ElCompletionItem.createELFunction(fun.getName(), offset - elExpr.getReplace().length(), fun.getReturnType(), fun.getPrefix(), fun.getParameters()));
                        }
                        break;
                    }
                    case 2: 
                    case 3: {
                        List<CompletionItem> items = elExpr.getPropertyCompletionItems(elExpr.getObjectClass(), anchor);
                        result.addAllItems(items);
                    }
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class DocItem
    implements CompletionDocumentation {
        private JspCompletionItem ri;

        public DocItem(JspCompletionItem ri) {
            this.ri = ri;
        }

        public String getText() {
            return this.ri.getHelp();
        }

        public URL getURL() {
            return this.ri.getHelpURL();
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    public static class DocQuery
    extends AbstractQuery {
        private JTextComponent component;
        private JspCompletionItem item;

        public DocQuery(JspCompletionItem item) {
            this.item = item;
        }

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            if (this.item != null) {
                if (this.item.hasHelp()) {
                    resultSet.setDocumentation((CompletionDocumentation)new DocItem(this.item));
                }
            } else {
                this.queryEL(resultSet, this.component, caretOffset);
            }
        }
    }

    public static class Query
    extends AbstractQuery {
        private JTextComponent component;

        protected void prepareQuery(JTextComponent component) {
            this.component = component;
        }

        @Override
        protected void doQuery(CompletionResultSet resultSet, Document doc, int caretOffset) {
            this.queryEL(resultSet, this.component, caretOffset);
        }
    }
}

