/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.editor.codegen;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Scope;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.Dialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.editor.java.Utilities;
import org.netbeans.modules.java.editor.codegen.ConstructorGenerator;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.editor.codegen.ui.DelegatePanel;
import org.netbeans.modules.java.editor.codegen.ui.ElementNode;
import org.netbeans.spi.editor.codegen.CodeGenerator;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class DelegateMethodGenerator
implements CodeGenerator {
    private static final String ERROR = "<error>";
    private JTextComponent component;
    private ElementNode.Description description;
    private static Logger log = Logger.getLogger(DelegateMethodGenerator.class.getName());

    private DelegateMethodGenerator(JTextComponent jTextComponent, ElementNode.Description description) {
        this.component = jTextComponent;
        this.description = description;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(DelegateMethodGenerator.class, (String)"LBL_delegate_method");
    }

    public void invoke() {
        final DelegatePanel delegatePanel = new DelegatePanel(this.component, this.description);
        DialogDescriptor dialogDescriptor = GeneratorUtils.createDialogDescriptor(delegatePanel, NbBundle.getMessage(ConstructorGenerator.class, (String)"LBL_generate_delegate"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == dialogDescriptor.getDefaultValue()) {
            JavaSource javaSource = JavaSource.forDocument((Document)this.component.getDocument());
            ElementHandle<? extends Element> elementHandle = delegatePanel.getDelegateField();
            if (elementHandle != null && elementHandle.getKind() == ElementKind.CLASS) {
                return;
            }
            if (javaSource != null) {
                try {
                    final int n = this.component.getCaretPosition();
                    ModificationResult modificationResult = javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

                        public void run(WorkingCopy workingCopy) throws IOException {
                            workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                            TreePath treePath = workingCopy.getTreeUtilities().pathFor(n);
                            treePath = Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath);
                            int n2 = GeneratorUtils.findClassMemberIndex(workingCopy, (ClassTree)treePath.getLeaf(), n);
                            ElementHandle<? extends Element> elementHandle = delegatePanel.getDelegateField();
                            VariableElement variableElement = elementHandle != null ? (VariableElement)elementHandle.resolve((CompilationInfo)workingCopy) : null;
                            ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
                            for (ElementHandle<? extends Element> elementHandle2 : delegatePanel.getDelegateMethods()) {
                                arrayList.add((ExecutableElement)elementHandle2.resolve((CompilationInfo)workingCopy));
                            }
                            DelegateMethodGenerator.generateDelegatingMethods(workingCopy, treePath, variableElement, arrayList, n2);
                        }
                    });
                    GeneratorUtils.guardedCommit(this.component, modificationResult);
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
        }
    }

    public static ElementNode.Description getAvailableMethods(JTextComponent jTextComponent, final ElementHandle<? extends Element> elementHandle) {
        JavaSource javaSource;
        if (elementHandle.getKind().isField() && (javaSource = JavaSource.forDocument((Document)jTextComponent.getDocument())) != null) {
            final int n = jTextComponent.getCaretPosition();
            final ElementNode.Description[] descriptionArray = new ElementNode.Description[1];
            final AtomicBoolean atomicBoolean = new AtomicBoolean();
            ProgressUtils.runOffEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                            public void run(CompilationController compilationController) throws IOException {
                                JavaSource.Phase phase;
                                if (compilationController.getPhase().compareTo((Enum)JavaSource.Phase.RESOLVED) < 0 && (phase = compilationController.toPhase(JavaSource.Phase.RESOLVED)).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                                    if (log.isLoggable(Level.SEVERE)) {
                                        log.log(Level.SEVERE, "Cannot reach required phase. Leaving without action.");
                                    }
                                    return;
                                }
                                if (atomicBoolean.get()) {
                                    return;
                                }
                                descriptionArray[0] = DelegateMethodGenerator.getAvailableMethods((CompilationInfo)compilationController, n, (ElementHandle<? extends Element>)elementHandle);
                            }
                        }, true);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }, (String)NbBundle.getMessage(DelegateMethodGenerator.class, (String)"LBL_Get_Available_Methods"), (AtomicBoolean)atomicBoolean, (boolean)false);
            return descriptionArray[0];
        }
        return null;
    }

    static List<ElementNode.Description> computeUsableFieldsDescriptions(CompilationInfo compilationInfo, TreePath treePath) {
        Object object;
        TypeElement typeElement;
        Elements elements = compilationInfo.getElements();
        TypeElement typeElement2 = (TypeElement)compilationInfo.getTrees().getElement(treePath);
        if (typeElement2 == null || !typeElement2.getKind().isClass()) {
            return Collections.emptyList();
        }
        Trees trees = compilationInfo.getTrees();
        LinkedHashMap<Element, ArrayList<ElementNode.Description>> linkedHashMap = new LinkedHashMap<Element, ArrayList<ElementNode.Description>>();
        for (Scope scope = trees.getScope(treePath); scope != null && (typeElement = scope.getEnclosingClass()) != null; scope = scope.getEnclosingScope()) {
            object = (DeclaredType)typeElement.asType();
            for (VariableElement object2 : ElementFilter.fieldsIn(elements.getAllMembers(typeElement))) {
                if (ERROR.contentEquals(object2.getSimpleName()) || object2.asType().getKind().isPrimitive() || !trees.isAccessible(scope, object2, (DeclaredType)object)) continue;
                ArrayList<ElementNode.Description> arrayList = (ArrayList<ElementNode.Description>)linkedHashMap.get(object2.getEnclosingElement());
                if (arrayList == null) {
                    arrayList = new ArrayList<ElementNode.Description>();
                    linkedHashMap.put(object2.getEnclosingElement(), arrayList);
                }
                arrayList.add(ElementNode.Description.create(object2, null, false, false));
            }
        }
        object = new ArrayList();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    static ElementNode.Description getAvailableMethods(CompilationInfo compilationInfo, int n, ElementHandle<? extends Element> elementHandle) {
        VariableElement variableElement = (VariableElement)elementHandle.resolve(compilationInfo);
        assert (variableElement != null);
        if (variableElement.asType().getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)variableElement.asType();
            Trees trees = compilationInfo.getTrees();
            Scope scope = compilationInfo.getTreeUtilities().scopeFor(n);
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (ExecutableElement object : ElementFilter.methodsIn(compilationInfo.getElements().getAllMembers((TypeElement)declaredType.asElement()))) {
                void var10_11;
                if (!trees.isAccessible(scope, object, declaredType)) continue;
                List list = (List)linkedHashMap.get(object.getEnclosingElement());
                if (list == null) {
                    ArrayList arrayList = new ArrayList();
                    linkedHashMap.put(object.getEnclosingElement(), arrayList);
                }
                var10_11.add(ElementNode.Description.create(object, null, true, false));
            }
            ArrayList arrayList = new ArrayList();
            for (Map.Entry entry : linkedHashMap.entrySet()) {
                arrayList.add(ElementNode.Description.create((Element)entry.getKey(), (List)entry.getValue(), false, false));
            }
            if (!arrayList.isEmpty()) {
                Collections.reverse(arrayList);
            }
            return ElementNode.Description.create(arrayList);
        }
        return null;
    }

    static void generateDelegatingMethods(WorkingCopy workingCopy, TreePath treePath, VariableElement variableElement, Iterable<? extends ExecutableElement> iterable, int n) {
        assert (treePath.getLeaf().getKind() == Tree.Kind.CLASS);
        TypeElement typeElement = (TypeElement)workingCopy.getTrees().getElement(treePath);
        if (typeElement != null) {
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            ClassTree classTree = (ClassTree)treePath.getLeaf();
            for (ExecutableElement executableElement : iterable) {
                classTree = treeMaker.insertClassMember(classTree, n, (Tree)DelegateMethodGenerator.createDelegatingMethod(workingCopy, variableElement, executableElement, (DeclaredType)typeElement.asType()));
            }
            workingCopy.rewrite(treePath.getLeaf(), (Tree)classTree);
        }
    }

    private static MethodTree createDelegatingMethod(WorkingCopy workingCopy, VariableElement variableElement, ExecutableElement executableElement, DeclaredType declaredType) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        boolean bl = false;
        String string = variableElement.getSimpleName().toString();
        for (VariableElement object2 : executableElement.getParameters()) {
            if (!string.equals(object2.getSimpleName().toString())) continue;
            bl = true;
            break;
        }
        ArrayList arrayList = new ArrayList();
        for (VariableElement variableElement2 : executableElement.getParameters()) {
            arrayList.add(treeMaker.Identifier((CharSequence)variableElement2.getSimpleName()));
        }
        IdentifierTree identifierTree = bl ? treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"this"), (CharSequence)variableElement.getSimpleName()) : treeMaker.Identifier((CharSequence)variableElement.getSimpleName());
        MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)identifierTree, (CharSequence)executableElement.getSimpleName()), (List)arrayList);
        StatementTree statementTree = executableElement.getReturnType().getKind() == TypeKind.VOID ? treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree) : treeMaker.Return((ExpressionTree)methodInvocationTree);
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(statementTree), false);
        MethodTree methodTree = GeneratorUtilities.get((WorkingCopy)workingCopy).createMethod((DeclaredType)variableElement.asType(), executableElement);
        return treeMaker.Method(methodTree.getModifiers(), (CharSequence)methodTree.getName(), methodTree.getReturnType(), methodTree.getTypeParameters(), methodTree.getParameters(), methodTree.getThrows(), blockTree, (ExpressionTree)methodTree.getDefaultValue());
    }

    public static class Factory
    implements CodeGenerator.Factory {
        public List<? extends CodeGenerator> create(Lookup lookup) {
            ArrayList<DelegateMethodGenerator> arrayList = new ArrayList<DelegateMethodGenerator>();
            JTextComponent jTextComponent = (JTextComponent)lookup.lookup(JTextComponent.class);
            CompilationController compilationController = (CompilationController)lookup.lookup(CompilationController.class);
            TreePath treePath = (TreePath)lookup.lookup(TreePath.class);
            TreePath treePath2 = treePath = treePath != null ? Utilities.getPathElementOfKind(Tree.Kind.CLASS, treePath) : null;
            if (jTextComponent == null || compilationController == null || treePath == null) {
                return arrayList;
            }
            try {
                compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            }
            catch (IOException iOException) {
                return arrayList;
            }
            List<ElementNode.Description> list = DelegateMethodGenerator.computeUsableFieldsDescriptions((CompilationInfo)compilationController, treePath);
            if (!list.isEmpty()) {
                Collections.reverse(list);
                arrayList.add(new DelegateMethodGenerator(jTextComponent, ElementNode.Description.create(list)));
            }
            return arrayList;
        }
    }
}

