/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.glassfish.common.EnableComet;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InstanceCustomizer
extends JPanel {
    private GlassfishModule commonSupport;
    private boolean cometEnabledChanged = false;
    private boolean monitorEnabledChanged = false;
    private boolean jdbcDriverDeployEnabledChanged = false;
    private boolean sessionEnabledChanged = false;
    private boolean startDerbyChanged = false;
    private JCheckBox cometCheckBox;
    private JCheckBox enableSessionsCheckBox;
    private JCheckBox jdbcDriverDeployCheckBox;
    private JLabel labelDomainName;
    private JLabel labelDomainsFolder;
    private JLabel labelLocation;
    private JCheckBox monitorCheckBox;
    private JCheckBox startDerby;
    private JTextField textDomainName;
    private JTextField textDomainsFolder;
    private JTextField textLocation;

    public InstanceCustomizer(GlassfishModule commonSupport) {
        this.commonSupport = commonSupport;
        this.initComponents();
    }

    private void initFields() {
        Map<String, String> ip = this.commonSupport.getInstanceProperties();
        this.textLocation.setText(ip.get("host") + ":" + ip.get("httpportnumber"));
        this.textDomainsFolder.setText(ip.get("domainsfolder"));
        this.textDomainName.setText(ip.get("domainname"));
        String cometFlag = ip.get("v3.grizzly.cometSupport");
        if (cometFlag == null) {
            cometFlag = System.getProperty("v3.grizzly.cometSupport");
        }
        boolean cometEnabled = Boolean.parseBoolean(cometFlag);
        this.cometCheckBox.setSelected(cometEnabled);
        String monitorFlag = ip.get("httpMonitorOn");
        boolean monitorEnabled = Boolean.parseBoolean(monitorFlag);
        this.monitorCheckBox.setSelected(monitorEnabled);
        String driverDeployFlag = ip.get("driverDeployOn");
        boolean driverDeployEnabled = Boolean.parseBoolean(driverDeployFlag);
        this.jdbcDriverDeployCheckBox.setSelected(driverDeployEnabled);
        String sessionFlag = ip.get("preserveSessionsOn");
        boolean sessionEnabled = Boolean.parseBoolean(sessionFlag);
        this.enableSessionsCheckBox.setSelected(sessionEnabled);
        String derbyFlag = ip.get("derbyStartOn");
        boolean derbyEnabled = Boolean.parseBoolean(derbyFlag);
        this.startDerby.setSelected(derbyEnabled);
        boolean isLocalDomain = ip.get("domainsfolder") != null;
        this.cometCheckBox.setEnabled(isLocalDomain);
        this.monitorCheckBox.setEnabled(isLocalDomain);
        this.jdbcDriverDeployCheckBox.setEnabled(isLocalDomain);
        this.startDerby.setEnabled(isLocalDomain);
    }

    private void persistFields() {
        if (this.cometEnabledChanged) {
            String cometEnabled = Boolean.toString(this.cometCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("v3.grizzly.cometSupport", cometEnabled, true);
            RequestProcessor.getDefault().post((Runnable)new EnableComet(this.commonSupport));
        }
        if (this.monitorEnabledChanged) {
            String monitorEnabled = Boolean.toString(this.monitorCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("httpMonitorOn", monitorEnabled, true);
        }
        if (this.jdbcDriverDeployEnabledChanged) {
            String driverDeployEnabled = Boolean.toString(this.jdbcDriverDeployCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("driverDeployOn", driverDeployEnabled, true);
        }
        if (this.sessionEnabledChanged) {
            String sessionsEnabled = Boolean.toString(this.enableSessionsCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("preserveSessionsOn", sessionsEnabled, true);
        }
        if (this.startDerbyChanged) {
            String derbyEnabled = Boolean.toString(this.startDerby.isSelected());
            this.commonSupport.setEnvironmentProperty("derbyStartOn", derbyEnabled, true);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.labelLocation = new JLabel();
        this.textLocation = new JTextField();
        this.labelDomainsFolder = new JLabel();
        this.textDomainsFolder = new JTextField();
        this.labelDomainName = new JLabel();
        this.textDomainName = new JTextField();
        this.cometCheckBox = new JCheckBox();
        this.monitorCheckBox = new JCheckBox();
        this.jdbcDriverDeployCheckBox = new JCheckBox();
        this.enableSessionsCheckBox = new JCheckBox();
        this.startDerby = new JCheckBox();
        this.setName(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_Common"));
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_Location"));
        this.textLocation.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.labelDomainsFolder, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_DomainsFolder"));
        this.textDomainsFolder.setEditable(false);
        Mnemonics.setLocalizedText((JLabel)this.labelDomainName, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_DomainName"));
        this.textDomainName.setEditable(false);
        this.cometCheckBox.setText(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableCometSupport"));
        this.cometCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.cometCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.monitorCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableHttpMonitor"));
        this.monitorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.monitorCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jdbcDriverDeployCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableJDBCDiverDeployment"));
        this.jdbcDriverDeployCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.jdbcDriverDeployCheckBoxActionPerformed(evt);
            }
        });
        this.enableSessionsCheckBox.setText(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_PreserverSessions"));
        this.enableSessionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.enableSessionsCheckBoxActionPerformed(evt);
            }
        });
        this.startDerby.setText(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_START_DERBY"));
        this.startDerby.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.startDerby(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.startDerby).add((Component)this.jdbcDriverDeployCheckBox).add((Component)this.monitorCheckBox).add((Component)this.cometCheckBox, -1, 392, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.labelLocation).add((Component)this.labelDomainsFolder).add((Component)this.labelDomainName)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.textLocation, -1, 291, Short.MAX_VALUE).add((Component)this.textDomainsFolder, -1, 291, Short.MAX_VALUE).add((Component)this.textDomainName, -1, 291, Short.MAX_VALUE))).add((Component)this.enableSessionsCheckBox)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labelLocation).add((Component)this.textLocation, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labelDomainsFolder).add((Component)this.textDomainsFolder, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.labelDomainName).add((Component)this.textDomainName, -2, -1, -2)).addPreferredGap(1).add((Component)this.cometCheckBox).addPreferredGap(0).add((Component)this.monitorCheckBox).addPreferredGap(0).add((Component)this.jdbcDriverDeployCheckBox).addPreferredGap(0).add((Component)this.enableSessionsCheckBox).addPreferredGap(0).add((Component)this.startDerby).addContainerGap(13, Short.MAX_VALUE)));
    }

    private void cometCheckBoxActionPerformed(ActionEvent evt) {
        this.cometEnabledChanged = true;
    }

    private void monitorCheckBoxActionPerformed(ActionEvent evt) {
        this.monitorEnabledChanged = true;
        if (this.monitorCheckBox.isSelected()) {
            NotifyDescriptor dd = new NotifyDescriptor((Object)NbBundle.getMessage(this.getClass(), (String)"TXT_WARNING_HTTP_MONITOR_ON"), NbBundle.getMessage(this.getClass(), (String)"TITLE_WARNING_HTTP_MONITOR_ON"), -1, 2, null, null);
            if (DialogDisplayer.getDefault().notify(dd).equals(NotifyDescriptor.CANCEL_OPTION)) {
                this.monitorCheckBox.setSelected(false);
                this.monitorEnabledChanged = false;
            }
        } else {
            NotifyDescriptor dd = new NotifyDescriptor((Object)NbBundle.getMessage(this.getClass(), (String)"TXT_WARNING_HTTP_MONITOR_OFF"), NbBundle.getMessage(this.getClass(), (String)"TITLE_WARNING_HTTP_MONITOR_OFF"), -1, 2, null, null);
            if (DialogDisplayer.getDefault().notify(dd).equals(NotifyDescriptor.CANCEL_OPTION)) {
                this.monitorCheckBox.setSelected(true);
                this.monitorEnabledChanged = false;
            }
        }
    }

    private void jdbcDriverDeployCheckBoxActionPerformed(ActionEvent evt) {
        this.jdbcDriverDeployEnabledChanged = true;
    }

    private void enableSessionsCheckBoxActionPerformed(ActionEvent evt) {
        this.sessionEnabledChanged = true;
    }

    private void startDerby(ActionEvent evt) {
        this.startDerbyChanged = true;
    }
}

